import { API_BASE_URL, API_TOKEN, ENDPOINTS, buildApiUrl } from './apiConfig';
/**
 * Fetch abandoned cart list from GetGabs API
 * @param {Object} options - API request options
 * @param {number} options.page - Page number (default: 1)
 * @param {number} options.perPageData - Items per page (default: 20)
 * @returns {Promise<Object>} API response with abandoned cart list data
 */
export const fetchAbandonedCartTriggerList = async (options = {}) => {
  const { 
    page = 1,
    perPageData = 20,
    TriggerCategory=1,
  } = options;

  try {
    const url = new URL(buildApiUrl(`${ENDPOINTS.ABANDONED_CART.BASE}/${ENDPOINTS.ABANDONED_CART.GET_ABANDONED_CART_LIST}`));
    url.searchParams.append('page', page.toString());
    url.searchParams.append('perPageData', perPageData.toString());
    url.searchParams.append('TriggerCategory', TriggerCategory.toString());
    url.searchParams.append('token', API_TOKEN);

    const response = await fetch(url.toString(), {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
      },
    });

    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }

    const data = await response.json();
    return data;
  } catch (error) {
    console.error('Error fetching abandoned cart list:', error);
    throw error;
  }
};

/**
 * Fetch abandoned cart list from GetGabs API
 * @param {Object} options - API request options
 * @param {number} options.page - Page number (default: 1)
 * @param {number} options.perPageData - Items per page (default: 20)
 * @returns {Promise<Object>} API response with abandoned cart list data
 */
export const fetchAbandonedList = async (options = {}) => {
  const { 
    page = 1,
    perPageData = 20,
    
  } = options;

  try {
    const url = new URL(buildApiUrl(`${ENDPOINTS.ABANDONED_LIST.BASE}/${ENDPOINTS.ABANDONED_LIST.GET_ABANDONED_LIST}`));
    url.searchParams.append('page', page.toString());
    url.searchParams.append('perPageData', perPageData.toString());
    url.searchParams.append('token', API_TOKEN);

    const response = await fetch(url.toString(), {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
      },
    });

    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }

    const data = await response.json();
    return data;
  } catch (error) {
    console.error('Error fetching abandoned cart list:', error);
    throw error;
  }
};

export const createAbandonedCartTrigger = async (createAbandonedCartTriggerPayload) => {   
  try {
    const url = `http://app.getgabs.com/partners/template/notification/saveTrigger`;
    const response = await fetch(url, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
        'Authorization': `Bearer ${API_TOKEN}`,
        'X-Requested-With': 'XMLHttpRequest',

      },
      body: JSON.stringify(createAbandonedCartTriggerPayload)
    });
    const maybeJson = await response.json().catch(() => null);

    if (!response.ok) {
      const message = (maybeJson && (maybeJson.message || maybeJson.error)) || `HTTP ${response.status}`;
      throw new Error(message);
    }

    const data = maybeJson ?? {};
    const success = data?.status === true || data?.success === true || data?.status === 'success';
    if (!success) {
      throw new Error(data?.message || 'Create abandoned cart trigger failed');
    }

    console.log('create abandoned cart trigger', data);
    return data;
  } catch (error) {
    console.error('Error creating abandoned cart trigger:', error);
    throw error;
  }
};