import { Link, Outlet, useLoaderData, useRouteError } from "@remix-run/react";
import { boundary } from "@shopify/shopify-app-remix/server";
import { AppProvider } from "@shopify/shopify-app-remix/react";
import { NavMenu } from "@shopify/app-bridge-react";
import polarisStyles from "@shopify/polaris/build/esm/styles.css?url";
import { authenticate } from "../shopify.server";
import RouteProtection from "../components/RouteProtection";
import { useEffect } from "react";
import { initializeUserData } from "../utils/apiConfig";

export const links = () => [{ rel: "stylesheet", href: polarisStyles }];

export const loader = async ({ request }) => {
  const { session } = await authenticate.admin(request);

  return { 
    apiKey: process.env.SHOPIFY_API_KEY || "",
    shop: session.shop
  };
};

export default function App() {
  const { apiKey, shop } = useLoaderData();

  // Initialize user data when app loads
  useEffect(() => {
    if (shop) {
      initializeUserData(shop);
    }
  }, [shop]);

  return (
    <AppProvider isEmbeddedApp apiKey={apiKey}>
      <NavMenu>
        <Link to="/app" rel="home">
          Home
        </Link>
        <Link to="/app/products">Products list</Link>
        <Link to="/app/abandoned-cart-list">Abandoned Cart List</Link>
        <Link to="/app/auto-triggers">Auto triggers</Link>
        <Link to="/app/templates">Templates</Link>
        <Link to="/app/broadcast">Broadcast</Link>
        <Link to="/app/contact-list">Contact List</Link>
        <Link to="/app/chats">Chats</Link>
        <Link to="/app/create-chat-widget">Create Chat Widget</Link>
        <Link to="/app/manage-whatsapp-profile">Manage WhatsApp Profile</Link>
        <Link to="/app/pricing-plan">Pricing & Plan</Link>
      </NavMenu>
      <RouteProtection>
        <Outlet />
      </RouteProtection>
    </AppProvider>
  );
}

export function ErrorBoundary() {
  return boundary.error(useRouteError());
}

export const headers = (headersArgs) => {
  return boundary.headers(headersArgs);
};
