import {
  Page,
  Text,
  InlineStack,
  Icon,
  LegacyCard,
  Button,
  Grid,
  BlockStack,
  Banner,
} from '@shopify/polaris';
import { 
  PlusIcon, 
  CartIcon, 
  OrderIcon, 
  ChatIcon,
  ArrowRightIcon
} from '@shopify/polaris-icons';
import React from 'react';
import { useCallback } from 'react';
import { useNavigate } from '@remix-run/react';

function AutoTriggersIndexPage() {
  const navigate = useNavigate();

  const handleCreateTrigger = useCallback(() => {
    navigate('/app/auto-triggers/create-abandoned-cart');
  }, [navigate]);

  const triggerTypes = [
    {
      title: 'Abandoned Cart Recovery',
      description: 'Recover lost sales by sending automated messages to customers who abandon their shopping carts.',
      icon: CartIcon,
      route: '/app/auto-triggers/abandoned-cart',
      createRoute: '/app/auto-triggers/create-abandoned-cart',
      stats: '3 triggers configured',
      color: 'warning'
    },
    {
      title: 'Order Confirmation',
      description: 'Keep customers informed with automated order confirmations, shipping updates, and delivery notifications.',
      icon: OrderIcon,
      route: '/app/auto-triggers/order-confirmation',
      createRoute: '/app/auto-triggers/create-order-confirmation',
      stats: '3 triggers configured',
      color: 'success'
    },
    {
      title: 'Auto Reply',
      description: 'Provide instant responses to customer inquiries based on keywords and common questions.',
      icon: ChatIcon,
      route: '/app/auto-triggers/auto-reply',
      createRoute: '/app/auto-triggers/create-auto-reply',
      stats: '3 triggers configured',
      color: 'info'
    }
  ];

  return (
    <Page
      title="Auto Triggers"
      subtitle="Setup automated WhatsApp messages based on customer behavior and keywords"
      fullWidth
   
    >
      <BlockStack gap="600">
        <LegacyCard sectioned>
          <BlockStack gap="400">
            <Banner status="info">
              Select the type of automated trigger you want to manage. Each trigger type serves different customer engagement purposes.
            </Banner>
            
          </BlockStack>
        </LegacyCard>

        <Grid>
          {triggerTypes.map((triggerType) => (
            <Grid.Cell key={triggerType.title} columnSpan={{ xs: 6, sm: 3, md: 3, lg: 4, xl: 4 }}>
              <LegacyCard>
                <LegacyCard.Section>
                  <BlockStack gap="400">
                    <InlineStack align="left">
                        
                      <Icon source={triggerType.icon} tone={triggerType.color} />
                      
                    </InlineStack>
                    
                    <BlockStack gap="200">
                      <Text variant="headingSm" fontWeight="semibold">
                        {triggerType.title}
                      </Text>
                      <Text variant="bodyMd" color="subdued">
                        {triggerType.description}
                      </Text>
                    </BlockStack>

                    <InlineStack align="right">
                      
                      <Button
                        onClick={() => navigate(triggerType.route)}
                        icon={ArrowRightIcon}
                        iconAlignment="end"
                        variant="primary"
                      >
                        Manage Triggers
                      </Button>
                    </InlineStack>
                  </BlockStack>
                </LegacyCard.Section>
              </LegacyCard>
            </Grid.Cell>
          ))}
        </Grid>

        <LegacyCard sectioned>
          <BlockStack gap="400">
            <Text variant="headingMd">Getting Started</Text>
            <BlockStack gap="200">
              <Text variant="bodyMd">
                • <strong>Abandoned Cart Recovery:</strong> Set up triggers to send reminders when customers leave items in their cart
              </Text>
              <Text variant="bodyMd">
                • <strong>Order Confirmation:</strong> Automatically notify customers about order status changes
              </Text>
              <Text variant="bodyMd">
                • <strong>Auto Reply:</strong> Create keyword-based responses for common customer inquiries
              </Text>
            </BlockStack>
          </BlockStack>
        </LegacyCard>
      </BlockStack>
    </Page>
  );
}

export default AutoTriggersIndexPage;
