import { useEffect, useRef, useState, useCallback } from 'react';
import { io } from 'socket.io-client';

export function useSocket(userInfo) {
  const socketRef = useRef(null);
  const [isConnected, setIsConnected] = useState(false);
  const [connectionError, setConnectionError] = useState(null);

  useEffect(() => {
    if (!userInfo) return;

    
    socketRef.current = io('https://app.getgabs.com:56000', {
      transports: ['websocket', 'polling', 'flashsocket'],
      autoConnect: true
    });

    const socket = socketRef.current;

   
    socket.on('connect', () => {
      console.log('GetGabs Socket connected');
      setIsConnected(true);
      setConnectionError(null);
    });

    socket.on('disconnect', () => {
      console.log('GetGabs Socket disconnected');
      setIsConnected(false);
    });

    socket.on('connect_error', (error) => {
      console.error('GetGabs Socket connection error:', error);
      setConnectionError(error.message);
      setIsConnected(false);
    });

    
    socket.on('welcome', (data) => {
      console.log('GetGabs welcome received:', data);
      
      socket.emit("connectchannel", userInfo);
    });


    return () => {
      if (socket) {
        socket.disconnect();
      }
    };
  }, [userInfo]);

  
  const addEventListener = useCallback((event, handler) => {
    if (socketRef.current) {
      socketRef.current.on(event, handler);
    }
  }, []);

  const removeEventListener = useCallback((event, handler) => {
    if (socketRef.current) {
      socketRef.current.off(event, handler);
    }
  }, []);

  return {
    socket: socketRef.current,
    isConnected,
    connectionError,
    addEventListener,
    removeEventListener
  };
}
