import { useEffect } from 'react';
import { useLocation, useNavigate } from '@remix-run/react';
import { isRouteAccessible, getRedirectUrl } from '../utils/planProtection';

/**
 * Route Protection Component
 * Redirects users to pricing plan if they don't have access to the current route
 */
export default function RouteProtection({ children }) {
  const location = useLocation();
  const navigate = useNavigate();

  useEffect(() => {
    const checkRouteAccess = () => {
      const hasAccess = isRouteAccessible(location.pathname);
      
      if (!hasAccess) {
        // Redirect to pricing plan page
        navigate(getRedirectUrl(), { replace: true });
      }
    };

    checkRouteAccess();
  }, [location.pathname, navigate]);

  // Always render children - the redirect will happen if needed
  return children;
}
