var _a;
import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { PassThrough } from "stream";
import { renderToPipeableStream } from "react-dom/server";
import { RemixServer, Meta, Links, Outlet, ScrollRestoration, Scripts, useLoaderData, useActionData, Form, useLocation, useNavigate, Link, useRouteError, useParams, useSearchParams } from "@remix-run/react";
import { createReadableStreamFromReadable, redirect } from "@remix-run/node";
import { isbot } from "isbot";
import "@shopify/shopify-app-remix/adapters/node";
import { shopifyApp, AppDistribution, ApiVersion, LoginErrorType, boundary } from "@shopify/shopify-app-remix/server";
import { PrismaSessionStorage } from "@shopify/shopify-app-session-storage-prisma";
import { PrismaClient } from "@prisma/client";
import { useState, useEffect, useRef, useCallback, useMemo } from "react";
import { AppProvider, Page, Card, FormLayout, Text, TextField, Button, BlockStack, Icon, Popover, Box, Scrollable, InlineStack, Divider, EmptyState, Tooltip, Grid, Select, ButtonGroup, Autocomplete, Modal, Layout, Spinner, Banner, DropZone, Thumbnail, useSetIndexFiltersMode, useIndexResourceState, IndexTable, Badge, LegacyCard, IndexFilters, Pagination, TextContainer, RangeSlider, Checkbox, Tag, Combobox, Listbox, ChoiceList, RadioButton, DatePicker, Tabs, Link as Link$1, List, VideoThumbnail, Avatar, ActionList } from "@shopify/polaris";
import { AppProvider as AppProvider$1 } from "@shopify/shopify-app-remix/react";
import { NavMenu, TitleBar } from "@shopify/app-bridge-react";
import { LinkIcon, PhoneIcon, UndoIcon, ImageIcon, ViewIcon, RefreshIcon, CalendarIcon, ClockIcon, DeleteIcon, PlusIcon, CartIcon, OrderIcon, ChatIcon, ArrowRightIcon, EditIcon, ArrowLeftIcon, ExportIcon, InfoIcon, CheckIcon, ThemeTemplateIcon, SlideshowIcon, StoreIcon, NoteIcon, CashDollarIcon, ProfileIcon, ChatReferralIcon, DomainNewIcon, PersonSegmentIcon, AlertTriangleIcon, SearchIcon, PlayCircleIcon, MenuVerticalIcon, FileIcon, AttachmentIcon } from "@shopify/polaris-icons";
import { io } from "socket.io-client";
if (process.env.NODE_ENV !== "production") {
  if (!global.prismaGlobal) {
    global.prismaGlobal = new PrismaClient();
  }
}
const prisma = global.prismaGlobal ?? new PrismaClient();
const shopify = shopifyApp({
  apiKey: process.env.SHOPIFY_API_KEY,
  apiSecretKey: process.env.SHOPIFY_API_SECRET || "",
  apiVersion: ApiVersion.January25,
  scopes: (_a = process.env.SCOPES) == null ? void 0 : _a.split(","),
  appUrl: process.env.SHOPIFY_APP_URL || "",
  authPathPrefix: "/auth",
  sessionStorage: new PrismaSessionStorage(prisma),
  distribution: AppDistribution.AppStore,
  future: {
    unstable_newEmbeddedAuthStrategy: true,
    removeRest: true
  },
  ...process.env.SHOP_CUSTOM_DOMAIN ? { customShopDomains: [process.env.SHOP_CUSTOM_DOMAIN] } : {}
});
ApiVersion.January25;
const addDocumentResponseHeaders = shopify.addDocumentResponseHeaders;
const authenticate = shopify.authenticate;
shopify.unauthenticated;
const login = shopify.login;
shopify.registerWebhooks;
shopify.sessionStorage;
const streamTimeout = 5e3;
async function handleRequest(request, responseStatusCode, responseHeaders, remixContext) {
  addDocumentResponseHeaders(request, responseHeaders);
  const userAgent = request.headers.get("user-agent");
  const callbackName = isbot(userAgent ?? "") ? "onAllReady" : "onShellReady";
  return new Promise((resolve, reject) => {
    const { pipe, abort } = renderToPipeableStream(
      /* @__PURE__ */ jsx(RemixServer, { context: remixContext, url: request.url }),
      {
        [callbackName]: () => {
          const body = new PassThrough();
          const stream = createReadableStreamFromReadable(body);
          responseHeaders.set("Content-Type", "text/html");
          resolve(
            new Response(stream, {
              headers: responseHeaders,
              status: responseStatusCode
            })
          );
          pipe(body);
        },
        onShellError(error) {
          reject(error);
        },
        onError(error) {
          responseStatusCode = 500;
          console.error(error);
        }
      }
    );
    setTimeout(abort, streamTimeout + 1e3);
  });
}
const entryServer = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: handleRequest,
  streamTimeout
}, Symbol.toStringTag, { value: "Module" }));
function App$2() {
  return /* @__PURE__ */ jsxs("html", { children: [
    /* @__PURE__ */ jsxs("head", { children: [
      /* @__PURE__ */ jsx("meta", { charSet: "utf-8" }),
      /* @__PURE__ */ jsx("meta", { name: "viewport", content: "width=device-width,initial-scale=1" }),
      /* @__PURE__ */ jsx("link", { rel: "preconnect", href: "https://cdn.shopify.com/" }),
      /* @__PURE__ */ jsx(
        "link",
        {
          rel: "stylesheet",
          href: "https://cdn.shopify.com/static/fonts/inter/v4/styles.css"
        }
      ),
      /* @__PURE__ */ jsx(Meta, {}),
      /* @__PURE__ */ jsx(Links, {})
    ] }),
    /* @__PURE__ */ jsxs("body", { children: [
      /* @__PURE__ */ jsx(Outlet, {}),
      /* @__PURE__ */ jsx(ScrollRestoration, {}),
      /* @__PURE__ */ jsx(Scripts, {})
    ] })
  ] });
}
const route0 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: App$2
}, Symbol.toStringTag, { value: "Module" }));
const action$2 = async ({ request }) => {
  const { payload, session, topic, shop } = await authenticate.webhook(request);
  console.log(`Received ${topic} webhook for ${shop}`);
  const current = payload.current;
  if (session) {
    await prisma.session.update({
      where: {
        id: session.id
      },
      data: {
        scope: current.toString()
      }
    });
  }
  return new Response();
};
const route1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  action: action$2
}, Symbol.toStringTag, { value: "Module" }));
const action$1 = async ({ request }) => {
  const { shop, session, topic } = await authenticate.webhook(request);
  console.log(`Received ${topic} webhook for ${shop}`);
  if (session) {
    await prisma.session.deleteMany({ where: { shop } });
  }
  return new Response();
};
const route2 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  action: action$1
}, Symbol.toStringTag, { value: "Module" }));
const Polaris = /* @__PURE__ */ JSON.parse('{"ActionMenu":{"Actions":{"moreActions":"More actions"},"RollupActions":{"rollupButton":"View actions"}},"ActionList":{"SearchField":{"clearButtonLabel":"Clear","search":"Search","placeholder":"Search actions"}},"Avatar":{"label":"Avatar","labelWithInitials":"Avatar with initials {initials}"},"Autocomplete":{"spinnerAccessibilityLabel":"Loading","ellipsis":"{content}…"},"Badge":{"PROGRESS_LABELS":{"incomplete":"Incomplete","partiallyComplete":"Partially complete","complete":"Complete"},"TONE_LABELS":{"info":"Info","success":"Success","warning":"Warning","critical":"Critical","attention":"Attention","new":"New","readOnly":"Read-only","enabled":"Enabled"},"progressAndTone":"{toneLabel} {progressLabel}"},"Banner":{"dismissButton":"Dismiss notification"},"Button":{"spinnerAccessibilityLabel":"Loading"},"Common":{"checkbox":"checkbox","undo":"Undo","cancel":"Cancel","clear":"Clear","close":"Close","submit":"Submit","more":"More"},"ContextualSaveBar":{"save":"Save","discard":"Discard"},"DataTable":{"sortAccessibilityLabel":"sort {direction} by","navAccessibilityLabel":"Scroll table {direction} one column","totalsRowHeading":"Totals","totalRowHeading":"Total"},"DatePicker":{"previousMonth":"Show previous month, {previousMonthName} {showPreviousYear}","nextMonth":"Show next month, {nextMonth} {nextYear}","today":"Today ","start":"Start of range","end":"End of range","months":{"january":"January","february":"February","march":"March","april":"April","may":"May","june":"June","july":"July","august":"August","september":"September","october":"October","november":"November","december":"December"},"days":{"monday":"Monday","tuesday":"Tuesday","wednesday":"Wednesday","thursday":"Thursday","friday":"Friday","saturday":"Saturday","sunday":"Sunday"},"daysAbbreviated":{"monday":"Mo","tuesday":"Tu","wednesday":"We","thursday":"Th","friday":"Fr","saturday":"Sa","sunday":"Su"}},"DiscardConfirmationModal":{"title":"Discard all unsaved changes","message":"If you discard changes, you’ll delete any edits you made since you last saved.","primaryAction":"Discard changes","secondaryAction":"Continue editing"},"DropZone":{"single":{"overlayTextFile":"Drop file to upload","overlayTextImage":"Drop image to upload","overlayTextVideo":"Drop video to upload","actionTitleFile":"Add file","actionTitleImage":"Add image","actionTitleVideo":"Add video","actionHintFile":"or drop file to upload","actionHintImage":"or drop image to upload","actionHintVideo":"or drop video to upload","labelFile":"Upload file","labelImage":"Upload image","labelVideo":"Upload video"},"allowMultiple":{"overlayTextFile":"Drop files to upload","overlayTextImage":"Drop images to upload","overlayTextVideo":"Drop videos to upload","actionTitleFile":"Add files","actionTitleImage":"Add images","actionTitleVideo":"Add videos","actionHintFile":"or drop files to upload","actionHintImage":"or drop images to upload","actionHintVideo":"or drop videos to upload","labelFile":"Upload files","labelImage":"Upload images","labelVideo":"Upload videos"},"errorOverlayTextFile":"File type is not valid","errorOverlayTextImage":"Image type is not valid","errorOverlayTextVideo":"Video type is not valid"},"EmptySearchResult":{"altText":"Empty search results"},"Frame":{"skipToContent":"Skip to content","navigationLabel":"Navigation","Navigation":{"closeMobileNavigationLabel":"Close navigation"}},"FullscreenBar":{"back":"Back","accessibilityLabel":"Exit fullscreen mode"},"Filters":{"moreFilters":"More filters","moreFiltersWithCount":"More filters ({count})","filter":"Filter {resourceName}","noFiltersApplied":"No filters applied","cancel":"Cancel","done":"Done","clearAllFilters":"Clear all filters","clear":"Clear","clearLabel":"Clear {filterName}","addFilter":"Add filter","clearFilters":"Clear all","searchInView":"in:{viewName}"},"FilterPill":{"clear":"Clear","unsavedChanges":"Unsaved changes - {label}"},"IndexFilters":{"searchFilterTooltip":"Search and filter","searchFilterTooltipWithShortcut":"Search and filter (F)","searchFilterAccessibilityLabel":"Search and filter results","sort":"Sort your results","addView":"Add a new view","newView":"Custom search","SortButton":{"ariaLabel":"Sort the results","tooltip":"Sort","title":"Sort by","sorting":{"asc":"Ascending","desc":"Descending","az":"A-Z","za":"Z-A"}},"EditColumnsButton":{"tooltip":"Edit columns","accessibilityLabel":"Customize table column order and visibility"},"UpdateButtons":{"cancel":"Cancel","update":"Update","save":"Save","saveAs":"Save as","modal":{"title":"Save view as","label":"Name","sameName":"A view with this name already exists. Please choose a different name.","save":"Save","cancel":"Cancel"}}},"IndexProvider":{"defaultItemSingular":"Item","defaultItemPlural":"Items","allItemsSelected":"All {itemsLength}+ {resourceNamePlural} are selected","selected":"{selectedItemsCount} selected","a11yCheckboxDeselectAllSingle":"Deselect {resourceNameSingular}","a11yCheckboxSelectAllSingle":"Select {resourceNameSingular}","a11yCheckboxDeselectAllMultiple":"Deselect all {itemsLength} {resourceNamePlural}","a11yCheckboxSelectAllMultiple":"Select all {itemsLength} {resourceNamePlural}"},"IndexTable":{"emptySearchTitle":"No {resourceNamePlural} found","emptySearchDescription":"Try changing the filters or search term","onboardingBadgeText":"New","resourceLoadingAccessibilityLabel":"Loading {resourceNamePlural}…","selectAllLabel":"Select all {resourceNamePlural}","selected":"{selectedItemsCount} selected","undo":"Undo","selectAllItems":"Select all {itemsLength}+ {resourceNamePlural}","selectItem":"Select {resourceName}","selectButtonText":"Select","sortAccessibilityLabel":"sort {direction} by"},"Loading":{"label":"Page loading bar"},"Modal":{"iFrameTitle":"body markup","modalWarning":"These required properties are missing from Modal: {missingProps}"},"Page":{"Header":{"rollupActionsLabel":"View actions for {title}","pageReadyAccessibilityLabel":"{title}. This page is ready"}},"Pagination":{"previous":"Previous","next":"Next","pagination":"Pagination"},"ProgressBar":{"negativeWarningMessage":"Values passed to the progress prop shouldn’t be negative. Resetting {progress} to 0.","exceedWarningMessage":"Values passed to the progress prop shouldn’t exceed 100. Setting {progress} to 100."},"ResourceList":{"sortingLabel":"Sort by","defaultItemSingular":"item","defaultItemPlural":"items","showing":"Showing {itemsCount} {resource}","showingTotalCount":"Showing {itemsCount} of {totalItemsCount} {resource}","loading":"Loading {resource}","selected":"{selectedItemsCount} selected","allItemsSelected":"All {itemsLength}+ {resourceNamePlural} in your store are selected","allFilteredItemsSelected":"All {itemsLength}+ {resourceNamePlural} in this filter are selected","selectAllItems":"Select all {itemsLength}+ {resourceNamePlural} in your store","selectAllFilteredItems":"Select all {itemsLength}+ {resourceNamePlural} in this filter","emptySearchResultTitle":"No {resourceNamePlural} found","emptySearchResultDescription":"Try changing the filters or search term","selectButtonText":"Select","a11yCheckboxDeselectAllSingle":"Deselect {resourceNameSingular}","a11yCheckboxSelectAllSingle":"Select {resourceNameSingular}","a11yCheckboxDeselectAllMultiple":"Deselect all {itemsLength} {resourceNamePlural}","a11yCheckboxSelectAllMultiple":"Select all {itemsLength} {resourceNamePlural}","Item":{"actionsDropdownLabel":"Actions for {accessibilityLabel}","actionsDropdown":"Actions dropdown","viewItem":"View details for {itemName}"},"BulkActions":{"actionsActivatorLabel":"Actions","moreActionsActivatorLabel":"More actions"}},"SkeletonPage":{"loadingLabel":"Page loading"},"Tabs":{"newViewAccessibilityLabel":"Create new view","newViewTooltip":"Create view","toggleTabsLabel":"More views","Tab":{"rename":"Rename view","duplicate":"Duplicate view","edit":"Edit view","editColumns":"Edit columns","delete":"Delete view","copy":"Copy of {name}","deleteModal":{"title":"Delete view?","description":"This can’t be undone. {viewName} view will no longer be available in your admin.","cancel":"Cancel","delete":"Delete view"}},"RenameModal":{"title":"Rename view","label":"Name","cancel":"Cancel","create":"Save","errors":{"sameName":"A view with this name already exists. Please choose a different name."}},"DuplicateModal":{"title":"Duplicate view","label":"Name","cancel":"Cancel","create":"Create view","errors":{"sameName":"A view with this name already exists. Please choose a different name."}},"CreateViewModal":{"title":"Create new view","label":"Name","cancel":"Cancel","create":"Create view","errors":{"sameName":"A view with this name already exists. Please choose a different name."}}},"Tag":{"ariaLabel":"Remove {children}"},"TextField":{"characterCount":"{count} characters","characterCountWithMaxLength":"{count} of {limit} characters used"},"TooltipOverlay":{"accessibilityLabel":"Tooltip: {label}"},"TopBar":{"toggleMenuLabel":"Toggle menu","SearchField":{"clearButtonLabel":"Clear","search":"Search"}},"MediaCard":{"dismissButton":"Dismiss","popoverButton":"Actions"},"VideoThumbnail":{"playButtonA11yLabel":{"default":"Play video","defaultWithDuration":"Play video of length {duration}","duration":{"hours":{"other":{"only":"{hourCount} hours","andMinutes":"{hourCount} hours and {minuteCount} minutes","andMinute":"{hourCount} hours and {minuteCount} minute","minutesAndSeconds":"{hourCount} hours, {minuteCount} minutes, and {secondCount} seconds","minutesAndSecond":"{hourCount} hours, {minuteCount} minutes, and {secondCount} second","minuteAndSeconds":"{hourCount} hours, {minuteCount} minute, and {secondCount} seconds","minuteAndSecond":"{hourCount} hours, {minuteCount} minute, and {secondCount} second","andSeconds":"{hourCount} hours and {secondCount} seconds","andSecond":"{hourCount} hours and {secondCount} second"},"one":{"only":"{hourCount} hour","andMinutes":"{hourCount} hour and {minuteCount} minutes","andMinute":"{hourCount} hour and {minuteCount} minute","minutesAndSeconds":"{hourCount} hour, {minuteCount} minutes, and {secondCount} seconds","minutesAndSecond":"{hourCount} hour, {minuteCount} minutes, and {secondCount} second","minuteAndSeconds":"{hourCount} hour, {minuteCount} minute, and {secondCount} seconds","minuteAndSecond":"{hourCount} hour, {minuteCount} minute, and {secondCount} second","andSeconds":"{hourCount} hour and {secondCount} seconds","andSecond":"{hourCount} hour and {secondCount} second"}},"minutes":{"other":{"only":"{minuteCount} minutes","andSeconds":"{minuteCount} minutes and {secondCount} seconds","andSecond":"{minuteCount} minutes and {secondCount} second"},"one":{"only":"{minuteCount} minute","andSeconds":"{minuteCount} minute and {secondCount} seconds","andSecond":"{minuteCount} minute and {secondCount} second"}},"seconds":{"other":"{secondCount} seconds","one":"{secondCount} second"}}}}}');
const polarisTranslations = {
  Polaris
};
const polarisStyles = "/assets/styles-BeiPL2RV.css";
function loginErrorMessage(loginErrors) {
  if ((loginErrors == null ? void 0 : loginErrors.shop) === LoginErrorType.MissingShop) {
    return { shop: "Please enter your shop domain to log in" };
  } else if ((loginErrors == null ? void 0 : loginErrors.shop) === LoginErrorType.InvalidShop) {
    return { shop: "Please enter a valid shop domain to log in" };
  }
  return {};
}
const links$1 = () => [{ rel: "stylesheet", href: polarisStyles }];
const loader$6 = async ({ request }) => {
  const errors = loginErrorMessage(await login(request));
  return { errors, polarisTranslations };
};
const action = async ({ request }) => {
  const errors = loginErrorMessage(await login(request));
  return {
    errors
  };
};
function Auth() {
  const loaderData = useLoaderData();
  const actionData = useActionData();
  const [shop, setShop] = useState("");
  const { errors } = actionData || loaderData;
  return /* @__PURE__ */ jsx(AppProvider, { i18n: loaderData.polarisTranslations, children: /* @__PURE__ */ jsx(Page, { children: /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsx(Form, { method: "post", children: /* @__PURE__ */ jsxs(FormLayout, { children: [
    /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Log in" }),
    /* @__PURE__ */ jsx(
      TextField,
      {
        type: "text",
        name: "shop",
        label: "Shop domain",
        helpText: "example.myshopify.com",
        value: shop,
        onChange: setShop,
        autoComplete: "on",
        error: errors.shop
      }
    ),
    /* @__PURE__ */ jsx(Button, { submit: true, children: "Log in" })
  ] }) }) }) }) });
}
const route3 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  action,
  default: Auth,
  links: links$1,
  loader: loader$6
}, Symbol.toStringTag, { value: "Module" }));
const loader$5 = async ({ request }) => {
  await authenticate.admin(request);
  return null;
};
const route4 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  loader: loader$5
}, Symbol.toStringTag, { value: "Module" }));
const index = "_index_1hqgz_1";
const heading = "_heading_1hqgz_21";
const text = "_text_1hqgz_23";
const content = "_content_1hqgz_43";
const form = "_form_1hqgz_53";
const label = "_label_1hqgz_69";
const input = "_input_1hqgz_85";
const button = "_button_1hqgz_93";
const list = "_list_1hqgz_101";
const styles = {
  index,
  heading,
  text,
  content,
  form,
  label,
  input,
  button,
  list
};
const loader$4 = async ({ request }) => {
  const url = new URL(request.url);
  if (url.searchParams.get("shop")) {
    throw redirect(`/app?${url.searchParams.toString()}`);
  }
  return { showForm: Boolean(login) };
};
function App$1() {
  const { showForm } = useLoaderData();
  return /* @__PURE__ */ jsx("div", { className: styles.index, children: /* @__PURE__ */ jsxs("div", { className: styles.content, children: [
    /* @__PURE__ */ jsx("h1", { className: styles.heading, children: "A short heading about [your app]" }),
    /* @__PURE__ */ jsx("p", { className: styles.text, children: "A tagline about [your app] that describes your value proposition." }),
    showForm && /* @__PURE__ */ jsxs(Form, { className: styles.form, method: "post", action: "/auth/login", children: [
      /* @__PURE__ */ jsxs("label", { className: styles.label, children: [
        /* @__PURE__ */ jsx("span", { children: "Shop domain" }),
        /* @__PURE__ */ jsx("input", { className: styles.input, type: "text", name: "shop" }),
        /* @__PURE__ */ jsx("span", { children: "e.g: my-shop-domain.myshopify.com" })
      ] }),
      /* @__PURE__ */ jsx("button", { className: styles.button, type: "submit", children: "Log in" })
    ] }),
    /* @__PURE__ */ jsxs("ul", { className: styles.list, children: [
      /* @__PURE__ */ jsxs("li", { children: [
        /* @__PURE__ */ jsx("strong", { children: "Product feature" }),
        ". Some detail about your feature and its benefit to your customer."
      ] }),
      /* @__PURE__ */ jsxs("li", { children: [
        /* @__PURE__ */ jsx("strong", { children: "Product feature" }),
        ". Some detail about your feature and its benefit to your customer."
      ] }),
      /* @__PURE__ */ jsxs("li", { children: [
        /* @__PURE__ */ jsx("strong", { children: "Product feature" }),
        ". Some detail about your feature and its benefit to your customer."
      ] })
    ] })
  ] }) });
}
const route5 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: App$1,
  loader: loader$4
}, Symbol.toStringTag, { value: "Module" }));
const API_BASE_URL = "https://app.getgabs.com";
const ENDPOINTS = {
  CHAT: {
    BASE: "/partners/managechat/chat",
    CUSTOMER_LIST: "fetch-customer-list",
    CUSTOMER_CHAT: "fetch-customer-chat"
  },
  TEMPLATE: {
    BASE: "/partners/template",
    GET_TEMPLATES: "getcustomtemplateinfos"
  },
  STATIC_CONTACT_LIST: {
    BASE: "/partners/broadcast",
    GET_STATIC_CONTACT_LIST: "contactlist"
  },
  STATIC_CONTACT_LIST_CONTACTS: {
    BASE: "/partners/broadcast",
    GET_STATIC_CONTACT_LIST_CONTACTS: "contactcustomerlist"
  },
  BROADCAST: {
    BASE: "/partners/broadcast",
    GET_BROADCAST_LIST: "campaignlists"
  },
  AUTOREPLY: {
    BASE: "/partners/automation/autoreply",
    GET_AUTOREPLY_LIST: "fetchautoreplies"
  },
  PRODUCT: {
    BASE: "/partners/shopify/Products",
    GET_PRODUCT_LIST: "fetchList"
  },
  CATEGORY: {
    BASE: "/partners/shopify/Category",
    GET_CATEGORY_LIST: "fetchList"
  },
  ABANDONED_CART: {
    BASE: "/partners/shopify/AutoTrigger",
    GET_ABANDONED_CART_LIST: "fetchList"
  },
  ORDER_CONFIRMATION: {
    BASE: "/partners/shopify/AutoTrigger",
    GET_ORDER_CONFIRMATION_LIST: "fetchList"
  },
  ABANDONED_LIST: {
    BASE: "/partners/shopify/Abandoned",
    GET_ABANDONED_LIST: "fetchList"
  }
};
const buildApiUrl = (endpoint) => {
  return `${API_BASE_URL}${endpoint}`;
};
const fetchUserData = async (shopName) => {
  try {
    const myHeaders = new Headers();
    myHeaders.append("Content-Type", "application/json");
    const raw = JSON.stringify({
      "ShopName": shopName
    });
    const requestOptions = {
      method: "POST",
      headers: myHeaders,
      body: raw,
      redirect: "follow"
    };
    const response = await fetch("https://app.getgabs.com/partners/shopify/login", requestOptions);
    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }
    const result = await response.text();
    const userData = JSON.parse(result);
    saveUserDataToStorage(userData);
    return userData;
  } catch (error) {
    console.error("Error fetching user data:", error);
    throw error;
  }
};
const saveUserDataToStorage = (userData) => {
  try {
    localStorage.setItem("getgabs_user_data", JSON.stringify(userData));
    localStorage.setItem("getgabs_user_data_timestamp", Date.now().toString());
  } catch (error) {
    console.error("Error saving user data to localStorage:", error);
  }
};
const getUserDataFromStorage = () => {
  try {
    const userData = localStorage.getItem("getgabs_user_data");
    return userData ? JSON.parse(userData) : null;
  } catch (error) {
    console.error("Error getting user data from localStorage:", error);
    return null;
  }
};
const isUserDataValid = (maxAgeHours = 24) => {
  try {
    const userData = getUserDataFromStorage();
    const timestamp = localStorage.getItem("getgabs_user_data_timestamp");
    if (!userData || !timestamp) {
      return false;
    }
    const dataAge = Date.now() - parseInt(timestamp);
    const maxAge = maxAgeHours * 60 * 60 * 1e3;
    return dataAge < maxAge;
  } catch (error) {
    console.error("Error checking user data validity:", error);
    return false;
  }
};
const initializeUserData = async (shopName, maxAgeHours = 24) => {
  try {
    console.log("Initializing user data for shop:", shopName);
    if (isUserDataValid(maxAgeHours)) {
      const cachedData = getUserDataFromStorage();
      console.log("Using cached user data:", cachedData);
      return cachedData;
    }
    console.log("No valid cached data found. Fetching fresh user data...");
    const userData = await fetchUserData(shopName);
    console.log("Fresh user data fetched and saved:", userData);
    return userData;
  } catch (error) {
    console.error("Error initializing user data:", error);
    const fallbackData = getUserDataFromStorage();
    if (fallbackData) {
      console.log("Using expired cached data as fallback:", fallbackData);
      return fallbackData;
    }
    console.log("No user data available");
    return null;
  }
};
const mapAccessValueTypeToPlan = (accessValueType) => {
  const planMapping = {
    0: "Non",
    1: "Basic Monthly",
    11: "Basic Annually",
    2: "Pro Monthly",
    22: "Pro Annually",
    4: "Plus Monthly",
    44: "Plus Annually"
  };
  return planMapping[accessValueType] || "Unknown";
};
const getAccountDetails = () => {
  try {
    const userData = localStorage.getItem("getgabs_user_data");
    if (userData) {
      const parsedData = JSON.parse(userData);
      if (!parsedData.userAllInfo) {
        console.warn("userAllInfo not found in parsed data");
        return "";
      }
      const hasWhatsAppDetails = Array.isArray(parsedData.userAllInfo.whasappaccountdetails) && parsedData.userAllInfo.whasappaccountdetails.length > 0;
      const whatsappDetails = hasWhatsAppDetails ? parsedData.userAllInfo.whasappaccountdetails[0] : null;
      const useraccountdetails = {
        "id": parsedData.userAllInfo.id,
        "role": parsedData.userAllInfo.role,
        "isplanpurchased": parsedData.userAllInfo.access_value_type > 0,
        "planName": mapAccessValueTypeToPlan(parsedData.userAllInfo.access_value_type),
        "isAccountConnected": hasWhatsAppDetails,
        "businesName": (whatsappDetails == null ? void 0 : whatsappDetails.verified_name) || parsedData.userAllInfo.name,
        "username": parsedData.userAllInfo.username,
        "connectedWhatsappNumber": (whatsappDetails == null ? void 0 : whatsappDetails.display_phone_number) || "+1xxx xxx xxx",
        "accouuntQualityRating": (whatsappDetails == null ? void 0 : whatsappDetails.quality_rating) || "please connect whatsapp number",
        "currentMessageLimit": (whatsappDetails == null ? void 0 : whatsappDetails.current_limit) || "check limit",
        "user_privilage": parsedData.userAllInfo.user_privilage,
        "admin_id": parsedData.userAllInfo.admin_id,
        "api_key": parsedData.userAllInfo.api_key
      };
      return useraccountdetails;
    }
    return "";
  } catch (error) {
    console.error("Error getting user info for socket from localStorage:", error);
    return "";
  }
};
const getAPIToken = () => {
  try {
    const userData = localStorage.getItem("getgabs_user_data");
    if (userData) {
      const parsedData = JSON.parse(userData);
      return parsedData.access_token || "";
    }
    return "";
  } catch (error) {
    console.error("Error getting access_token from localStorage:", error);
    return "";
  }
};
const getAutoReplyToken = () => {
  try {
    const userData = localStorage.getItem("getgabs_user_data");
    if (userData) {
      const parsedData = JSON.parse(userData);
      return parsedData.userAllInfo.shopify_access_token || "";
    }
    return "";
  } catch (error) {
    console.error("Error getting shopify access_token from localStorage:", error);
    return "";
  }
};
const getUserInfo = () => {
  try {
    const userData = localStorage.getItem("getgabs_user_data");
    if (userData) {
      const parsedData = JSON.parse(userData);
      const userInfo2 = {
        "role": parsedData.userAllInfo.role,
        "id": parsedData.userAllInfo.id,
        "user_privilage": parsedData.userAllInfo.user_privilage,
        "admin_id": parsedData.userAllInfo.admin_id
      };
      return userInfo2;
    }
    return "";
  } catch (error) {
    console.error("Error getting user info for socket from localStorage:", error);
    return "";
  }
};
const API_TOKEN = getAPIToken();
const userInfo = getUserInfo();
const autoReplyToken = getAutoReplyToken();
const accountDetails = getAccountDetails();
console.log("apitoken from apiConfig", API_TOKEN);
console.log("userInfo from apiConfig", userInfo);
console.log("autoReplyToken from apiConfig", autoReplyToken);
console.log("accountDetails from apiConfig", accountDetails);
let planDetails = {
  planPurchaseStatus: accountDetails.isplanpurchased,
  planTaken: accountDetails.planName,
  isConnected: accountDetails.isAccountConnected
};
function isPlanPurchased() {
  return planDetails.planPurchaseStatus;
}
function isAccountConnected() {
  return planDetails.isConnected;
}
function getPlanName() {
  return planDetails.planTaken;
}
function getFormattedPlanName() {
  const planName = planDetails.planTaken || "";
  return planName ? planName.charAt(0).toUpperCase() + planName.slice(1) : "";
}
const allowedRoutes = [
  "/app",
  "/app/",
  "/app/pricing-plan"
];
const connectionRestrictedRoutes = [
  "/app/auto-triggers/create-abandoned-cart",
  "/app/auto-triggers/create-order-confirmation",
  "/apps/getgabsnewwabadesign/app/auto-triggers/create-auto-reply"
];
const connectionRestrictedPatterns = [
  /^\/app\/create-template\//,
  /^\/app\/broadcast\//
];
const planRestrictedRoutes = [
  "/app/auto-triggers/create-abandoned-cart",
  "/app/auto-triggers/create-order-confirmation",
  "/apps/getgabsnewwabadesign/app/auto-triggers/create-auto-reply"
];
const planRestrictedPatterns = [
  /^\/app\/create-template\//,
  /^\/app\/broadcast\//
];
const matchesRestricted = (pathname, routes2, patterns) => routes2.includes(pathname) || patterns.some((pattern) => pattern.test(pathname));
function isRouteAccessible(pathname) {
  const connected2 = isAccountConnected();
  const purchased = isPlanPurchased();
  if (allowedRoutes.includes(pathname)) {
    return true;
  }
  if (!connected2 && matchesRestricted(pathname, connectionRestrictedRoutes, connectionRestrictedPatterns)) {
    return false;
  }
  if (connected2 && !purchased && matchesRestricted(pathname, planRestrictedRoutes, planRestrictedPatterns)) {
    return false;
  }
  return true;
}
function getRedirectUrl(pathname) {
  const connected2 = isAccountConnected();
  const purchased = isPlanPurchased();
  if (!connected2 && matchesRestricted(pathname, connectionRestrictedRoutes, connectionRestrictedPatterns)) {
    return "/app";
  }
  if (connected2 && !purchased && matchesRestricted(pathname, planRestrictedRoutes, planRestrictedPatterns)) {
    return "/app/pricing-plan";
  }
  return "/app";
}
function RouteProtection({ children }) {
  const location = useLocation();
  const navigate = useNavigate();
  useEffect(() => {
    const checkRouteAccess = () => {
      const hasAccess = isRouteAccessible(location.pathname);
      if (!hasAccess) {
        navigate(getRedirectUrl(), { replace: true });
      }
    };
    checkRouteAccess();
  }, [location.pathname, navigate]);
  return children;
}
const links = () => [{ rel: "stylesheet", href: polarisStyles }];
const loader$3 = async ({ request }) => {
  const { session } = await authenticate.admin(request);
  return {
    apiKey: process.env.SHOPIFY_API_KEY || "",
    shop: session.shop
  };
};
function App() {
  const { apiKey, shop } = useLoaderData();
  useEffect(() => {
    if (shop) {
      initializeUserData(shop);
    }
  }, [shop]);
  return /* @__PURE__ */ jsxs(AppProvider$1, { isEmbeddedApp: true, apiKey, children: [
    /* @__PURE__ */ jsxs(NavMenu, { children: [
      /* @__PURE__ */ jsx(Link, { to: "/app", rel: "home", children: "Home" }),
      /* @__PURE__ */ jsx(Link, { to: "/app/products", children: "Products list" }),
      /* @__PURE__ */ jsx(Link, { to: "/app/abandoned-cart-list", children: "Abandoned Cart List" }),
      /* @__PURE__ */ jsx(Link, { to: "/app/auto-triggers", children: "Auto triggers" }),
      /* @__PURE__ */ jsx(Link, { to: "/app/templates", children: "Templates" }),
      /* @__PURE__ */ jsx(Link, { to: "/app/broadcast", children: "Broadcast" }),
      /* @__PURE__ */ jsx(Link, { to: "/app/contact-list", children: "Contact List" }),
      /* @__PURE__ */ jsx(Link, { to: "/app/chats", children: "Chats" }),
      /* @__PURE__ */ jsx(Link, { to: "/app/create-chat-widget", children: "Create Chat Widget" }),
      /* @__PURE__ */ jsx(Link, { to: "/app/manage-whatsapp-profile", children: "Manage WhatsApp Profile" }),
      /* @__PURE__ */ jsx(Link, { to: "/app/pricing-plan", children: "Pricing & Plan" })
    ] }),
    /* @__PURE__ */ jsx(RouteProtection, { children: /* @__PURE__ */ jsx(Outlet, {}) })
  ] });
}
function ErrorBoundary() {
  return boundary.error(useRouteError());
}
const headers = (headersArgs) => {
  return boundary.headers(headersArgs);
};
const route6 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  ErrorBoundary,
  default: App,
  headers,
  links,
  loader: loader$3
}, Symbol.toStringTag, { value: "Module" }));
function parseMarkdown(text2) {
  if (!text2) return text2;
  const variables = [];
  let protectedText = String(text2).replace(/\{\{[^}]+\}\}/g, (match) => {
    const index2 = variables.length;
    variables.push(match);
    return `XVARX${index2}XVARX`;
  });
  protectedText = protectedText.replace(/\*([^*]+)\*/g, "<strong>$1</strong>").replace(/_([^_]+)_/g, "<em>$1</em>").replace(/~([^~]+)~/g, "<del>$1</del>").replace(/```([^`]+)```/g, '<code class="monospace">$1</code>').replace(/`([^`]+)`/g, '<code class="inline">$1</code>').replace(/^> (.+)$/gm, "<blockquote>$1</blockquote>").replace(/^\* (.+)$/gm, '<li class="bullet">$1</li>').replace(/^(\d+)\. (.+)$/gm, '<li class="numbered" data-number="$1">$2</li>').replace(/<br\s*\/?>(?=\s*|$)/gi, "\n").replace(/\\r\\n/g, "\n").replace(/\\n/g, "\n").replace(/<(?!\/?(strong|em|del|code|blockquote|li)\b)[^>]*>/g, "").replace(/&nbsp;/g, " ").replace(/&amp;/g, "&").replace(/&lt;/g, "<").replace(/&gt;/g, ">");
  variables.forEach((variable, index2) => {
    protectedText = protectedText.replace(`XVARX${index2}XVARX`, variable);
  });
  return protectedText;
}
function convertWhatsAppMessageToPreview(input2) {
  var _a2, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s;
  if (!input2) return null;
  if (typeof input2 === "string" && !input2.trim().startsWith("{")) {
    return { type: "text", body: parseMarkdown(input2) };
  }
  let data = input2;
  try {
    if (typeof input2 === "string") {
      data = JSON.parse(input2);
    }
  } catch (e) {
    return { type: "text", body: parseMarkdown(String(input2)) };
  }
  if ((data == null ? void 0 : data.data) && Array.isArray(data.data) && data.data.length > 0) {
    data = data.data[0];
  }
  const asTemplate = ((_a2 = data == null ? void 0 : data.template) == null ? void 0 : _a2.components) || (data == null ? void 0 : data.components);
  if (asTemplate) {
    const components = {};
    const list2 = ((_b = data.template) == null ? void 0 : _b.components) || data.components || [];
    const carouselComponent = list2.find((component) => component.type === "CAROUSEL");
    if (carouselComponent) {
      components.type = "carousel";
      components.carousel = parseCarouselComponent(carouselComponent);
      const bodyComponent = list2.find((component) => component.type === "BODY");
      if (bodyComponent) {
        components.body = parseMarkdown(replaceVariablesWithExamples(bodyComponent.text, bodyComponent.example));
      }
      return components;
    }
    list2.forEach((component) => {
      switch (component.type) {
        case "HEADER":
          components.header = parseTemplateHeaderComponent(component);
          break;
        case "BODY":
          components.body = parseMarkdown(replaceVariablesWithExamples(component.text, component.example));
          break;
        case "FOOTER":
          components.footer = parseMarkdown(component.text);
          break;
        case "BUTTONS":
          components.buttons = parseTemplateButtonsComponent(component);
          break;
      }
    });
    return components;
  }
  const messageType = data == null ? void 0 : data.type;
  if (messageType === "interactive" && data.interactive) {
    return parseInteractiveServiceMessage(data.interactive);
  }
  if (messageType === "text") {
    return { type: "text", body: parseMarkdown(((_c = data.text) == null ? void 0 : _c.body) || data.body || "") };
  }
  if (messageType === "image") {
    return { type: "image", image: { link: ((_d = data.image) == null ? void 0 : _d.link) || ((_e = data.image) == null ? void 0 : _e.url), caption: parseMarkdown(((_f = data.image) == null ? void 0 : _f.caption) || "") } };
  }
  if (messageType === "video") {
    return { type: "video", video: { link: ((_g = data.video) == null ? void 0 : _g.link) || ((_h = data.video) == null ? void 0 : _h.url), caption: parseMarkdown(((_i = data.video) == null ? void 0 : _i.caption) || "") } };
  }
  if (messageType === "audio") {
    return { type: "audio", audio: { link: ((_j = data.audio) == null ? void 0 : _j.link) || ((_k = data.audio) == null ? void 0 : _k.url) } };
  }
  if (messageType === "document") {
    return { type: "document", document: { link: ((_l = data.document) == null ? void 0 : _l.link) || ((_m = data.document) == null ? void 0 : _m.url), filename: ((_n = data.document) == null ? void 0 : _n.filename) || "Document", caption: parseMarkdown(((_o = data.document) == null ? void 0 : _o.caption) || "") } };
  }
  if (messageType === "location") {
    return { type: "location", location: { latitude: (_p = data.location) == null ? void 0 : _p.latitude, longitude: (_q = data.location) == null ? void 0 : _q.longitude, name: ((_r = data.location) == null ? void 0 : _r.name) || "", address: ((_s = data.location) == null ? void 0 : _s.address) || "" } };
  }
  return { type: "text", body: parseMarkdown(JSON.stringify(data)) };
}
function replaceVariablesWithExamples(text2, example) {
  if (!text2 || !example) return text2;
  let result = text2;
  if (example.header_text && Array.isArray(example.header_text)) {
    example.header_text.forEach((value, index2) => {
      const variablePattern = new RegExp(`\\{\\{${index2 + 1}\\}\\}`, "g");
      result = result.replace(variablePattern, value);
    });
  }
  if (example.body_text && Array.isArray(example.body_text) && example.body_text.length > 0) {
    const bodyExamples = example.body_text[0];
    if (Array.isArray(bodyExamples)) {
      bodyExamples.forEach((value, index2) => {
        const variablePattern = new RegExp(`\\{\\{${index2 + 1}\\}\\}`, "g");
        result = result.replace(variablePattern, value);
      });
    }
  }
  if (example && Array.isArray(example)) {
    example.forEach((value, index2) => {
      const variablePattern = new RegExp(`\\{\\{${index2 + 1}\\}\\}`, "g");
      result = result.replace(variablePattern, value);
    });
  }
  return result;
}
function parseTemplateHeaderComponent(component) {
  var _a2, _b, _c, _d, _e, _f;
  if (!component) return null;
  switch (component.format) {
    case "TEXT":
      return { type: "text", content: parseMarkdown(replaceVariablesWithExamples(component.text, component.example)) };
    case "IMAGE":
      return { type: "image", content: ((_b = (_a2 = component.example) == null ? void 0 : _a2.header_handle) == null ? void 0 : _b[0]) || component.url || null };
    case "VIDEO":
      return { type: "video", content: ((_d = (_c = component.example) == null ? void 0 : _c.header_handle) == null ? void 0 : _d[0]) || component.url || null };
    case "DOCUMENT":
      return { type: "document", content: ((_f = (_e = component.example) == null ? void 0 : _e.header_handle) == null ? void 0 : _f[0]) || component.url || null, filename: component.filename || "Document" };
    default:
      return null;
  }
}
function parseTemplateButtonsComponent(component) {
  if (!(component == null ? void 0 : component.buttons) || !Array.isArray(component.buttons)) return null;
  return component.buttons.map((button2) => ({
    type: button2.type || "QUICK_REPLY",
    text: button2.text,
    url: button2.url ? replaceVariablesWithExamples(button2.url, button2.example) : null,
    phone_number: button2.phone_number || null
  }));
}
function parseInteractiveServiceMessage(interactive) {
  const components = { type: "interactive", interactiveType: interactive.type };
  if (interactive.header) {
    components.header = parseServiceHeader(interactive.header);
  }
  if (interactive.body) {
    components.body = parseMarkdown(interactive.body.text);
  }
  if (interactive.footer) {
    components.footer = parseMarkdown(interactive.footer.text);
  }
  if (interactive.action) {
    if (interactive.action.buttons) {
      components.buttons = parseServiceButtons(interactive.action.buttons);
    } else if (interactive.action.sections) {
      components.list = parseServiceList(interactive.action.sections);
    }
  }
  return components;
}
function parseServiceHeader(header) {
  var _a2, _b, _c, _d, _e, _f, _g;
  if (!header) return null;
  switch (header.type) {
    case "text":
      return { type: "text", content: parseMarkdown(header.text) };
    case "image":
      return { type: "image", content: ((_a2 = header.image) == null ? void 0 : _a2.link) || ((_b = header.image) == null ? void 0 : _b.url) || null };
    case "video":
      return { type: "video", content: ((_c = header.video) == null ? void 0 : _c.link) || ((_d = header.video) == null ? void 0 : _d.url) || null };
    case "document":
      return { type: "document", content: ((_e = header.document) == null ? void 0 : _e.link) || ((_f = header.document) == null ? void 0 : _f.url) || null, filename: ((_g = header.document) == null ? void 0 : _g.filename) || "Document" };
    default:
      return null;
  }
}
function parseServiceButtons(buttons) {
  if (!buttons || !Array.isArray(buttons)) return null;
  return buttons.map((button2) => {
    var _a2, _b, _c;
    return {
      type: button2.type === "reply" ? "QUICK_REPLY" : ((_a2 = button2.type) == null ? void 0 : _a2.toUpperCase()) || "QUICK_REPLY",
      text: ((_b = button2.reply) == null ? void 0 : _b.title) || button2.text || "",
      id: ((_c = button2.reply) == null ? void 0 : _c.id) || button2.id || "",
      url: button2.url || null,
      phone_number: button2.phone_number || null
    };
  });
}
function parseServiceList(sections) {
  if (!sections || !Array.isArray(sections)) return null;
  return sections.map((section) => {
    var _a2;
    return {
      title: section.title || "",
      rows: ((_a2 = section.rows) == null ? void 0 : _a2.map((row) => ({ id: row.id || "", title: row.title || "", description: row.description || "" }))) || []
    };
  });
}
function parseCarouselComponent(component, templateData) {
  if (!(component == null ? void 0 : component.cards) || !Array.isArray(component.cards)) return null;
  return component.cards.map((card, index2) => {
    const cardData = {
      id: card.card_index || index2,
      components: {}
    };
    if (card.components && Array.isArray(card.components)) {
      card.components.forEach((cardComponent) => {
        switch (cardComponent.type) {
          case "HEADER":
            cardData.components.header = parseTemplateHeaderComponent(cardComponent);
            break;
          case "BODY":
            cardData.components.body = parseMarkdown(
              replaceVariablesWithExamples(
                cardComponent.text || extractTextFromParameters(cardComponent.parameters),
                cardComponent.example
              )
            );
            break;
          case "BUTTONS":
            cardData.components.buttons = parseTemplateButtonsComponent(cardComponent);
            break;
        }
      });
    }
    return cardData;
  });
}
function extractTextFromParameters(parameters) {
  if (!parameters || !Array.isArray(parameters)) return "";
  return parameters.filter((param) => param.type === "text").map((param) => param.text || "").join(" ");
}
function extractVariablesFromWhatsAppMessage(input2) {
  var _a2, _b, _c, _d, _e, _f, _g;
  if (!input2) return [];
  let textToSearch = "";
  if (typeof input2 === "string" && input2.trim().startsWith("{")) {
    try {
      const data = JSON.parse(input2);
      const comps = ((_a2 = data == null ? void 0 : data.template) == null ? void 0 : _a2.components) || (data == null ? void 0 : data.components);
      if (Array.isArray(comps)) {
        comps.forEach((c) => {
          if (c.text) textToSearch += " " + c.text;
        });
      }
      if (data == null ? void 0 : data.interactive) {
        const it = data.interactive;
        if ((_b = it.header) == null ? void 0 : _b.text) textToSearch += " " + it.header.text;
        if ((_c = it.body) == null ? void 0 : _c.text) textToSearch += " " + it.body.text;
        if ((_d = it.footer) == null ? void 0 : _d.text) textToSearch += " " + it.footer.text;
      }
      if (data == null ? void 0 : data.text) textToSearch += " " + (data.text.body || data.text);
      if ((_e = data == null ? void 0 : data.image) == null ? void 0 : _e.caption) textToSearch += " " + data.image.caption;
      if ((_f = data == null ? void 0 : data.video) == null ? void 0 : _f.caption) textToSearch += " " + data.video.caption;
      if ((_g = data == null ? void 0 : data.document) == null ? void 0 : _g.caption) textToSearch += " " + data.document.caption;
    } catch (e) {
      textToSearch = String(input2);
    }
  } else {
    textToSearch = String(input2);
  }
  const regex = /\{\{([^}]+)\}\}/g;
  const variables = [];
  let match;
  while ((match = regex.exec(textToSearch)) !== null) {
    const variable = match[1].trim();
    if (!variables.includes(variable)) variables.push(variable);
  }
  return variables;
}
function getFormattedTextData(text2) {
  if (!text2) return [];
  const parts = String(text2).split(/(<\/?(?:strong|em|del|code|blockquote|li)(?:\s[^>]*)?>)/g);
  const elements = [];
  let current = [];
  parts.forEach((part, index2) => {
    if (part === "<strong>") current.push("bold");
    else if (part === "</strong>") current = current.filter((s) => s !== "bold");
    else if (part === "<em>") current.push("italic");
    else if (part === "</em>") current = current.filter((s) => s !== "italic");
    else if (part === "<del>") current.push("strikethrough");
    else if (part === "</del>") current = current.filter((s) => s !== "strikethrough");
    else if (part.startsWith('<code class="monospace">')) current.push("monospace");
    else if (part === "</code>" && current.includes("monospace")) current = current.filter((s) => s !== "monospace");
    else if (part.startsWith('<code class="inline">')) current.push("inline-code");
    else if (part === "</code>" && current.includes("inline-code")) current = current.filter((s) => s !== "inline-code");
    else if (part === "<blockquote>") current.push("quote");
    else if (part === "</blockquote>") current = current.filter((s) => s !== "quote");
    else if (part.startsWith('<li class="bullet">')) current.push("bullet");
    else if (part === "</li>" && current.includes("bullet")) current = current.filter((s) => s !== "bullet");
    else if (part.startsWith('<li class="numbered"')) current.push("numbered");
    else if (part === "</li>" && current.includes("numbered")) current = current.filter((s) => s !== "numbered");
    else if (part && !part.startsWith("<")) {
      const textLines = part.split("\n");
      textLines.forEach((line, lineIndex) => {
        const style = {};
        if (current.includes("bold")) style.fontWeight = "bold";
        if (current.includes("italic")) style.fontStyle = "italic";
        if (current.includes("strikethrough")) style.textDecoration = "line-through";
        if (current.includes("monospace")) style.fontFamily = "monospace";
        if (current.includes("inline-code")) {
          style.fontFamily = "monospace";
          style.backgroundColor = "#f1f1f1";
          style.padding = "2px 4px";
          style.borderRadius = "3px";
        }
        if (current.includes("quote")) {
          style.borderLeft = "3px solid #ccc";
          style.paddingLeft = "10px";
          style.fontStyle = "italic";
        }
        if (current.includes("bullet")) {
          style.listStyleType = "disc";
          style.marginLeft = "1px";
        }
        if (current.includes("numbered")) {
          style.listStyleType = "decimal";
          style.marginLeft = "1px";
        }
        elements.push({
          text: line,
          style,
          key: `${index2}-${lineIndex}`,
          isLineBreak: lineIndex < textLines.length - 1,
          isBullet: current.includes("bullet"),
          isNumbered: current.includes("numbered"),
          isQuote: current.includes("quote")
        });
      });
    }
  });
  return elements;
}
const getAllVariables = async () => {
  const response = await fetch(`https://app.getgabs.com/partners/shopify/CustomerLabel/fetchList?token=${API_TOKEN}`, {
    method: "GET",
    headers: {
      "Content-Type": "application/json",
      "Authorization": `Bearer ${API_TOKEN}`
    }
  });
  if (!response.ok) throw new Error("Failed to fetch variable list");
  const data = await response.json();
  console.log("variable list", data);
  return data;
};
const transformApiVariables = (apiVariables) => {
  if (!Array.isArray(apiVariables)) return [];
  return apiVariables.filter((variable) => variable.status === 1).map((variable) => ({
    label: variable.name,
    value: variable.name
  }));
};
const getApiVariables = async () => {
  try {
    const response = await getAllVariables();
    if (response.status && response.data && response.data.data) {
      return transformApiVariables(response.data.data);
    }
    return [];
  } catch (error) {
    console.error("Error fetching API variables:", error);
    return [];
  }
};
const getTemplateVariables = async () => {
  try {
    const apiVariables = await getApiVariables();
    return apiVariables;
  } catch (error) {
    console.error("Failed to fetch API variables:", error);
    return [];
  }
};
const fetchTemplates = async (options = {}) => {
  const {
    templateStatus = "All",
    page = 1,
    perPageData = 20
  } = options;
  try {
    const url = new URL(buildApiUrl(`${ENDPOINTS.TEMPLATE.BASE}/${ENDPOINTS.TEMPLATE.GET_TEMPLATES}`));
    url.searchParams.append("TemplateStatus", templateStatus);
    url.searchParams.append("page", page.toString());
    url.searchParams.append("perPageData", perPageData.toString());
    url.searchParams.append("token", API_TOKEN);
    const response = await fetch(url.toString(), {
      method: "GET",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json"
      }
    });
    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }
    const data = await response.json();
    return data;
  } catch (error) {
    console.error("Error fetching templates:", error);
    throw error;
  }
};
const transformTemplateData = (apiTemplate) => {
  var _a2, _b;
  try {
    const templateData = JSON.parse(apiTemplate.template_data || "{}");
    const templateInfo = ((_a2 = templateData.data) == null ? void 0 : _a2[0]) || {};
    let templateStructure = {};
    let components = [];
    let language = "en_US";
    if (apiTemplate.draft_json && apiTemplate.draft_json !== "null") {
      templateStructure = JSON.parse(apiTemplate.draft_json);
      components = templateStructure.components || [];
      language = templateStructure.language || "en_US";
    } else if (templateInfo.components) {
      components = templateInfo.components || [];
      language = templateInfo.language || "en_US";
    }
    const category = apiTemplate.category || "Custom";
    const statusMap = {
      "APPROVED": "Approved",
      "PENDING": "Pending",
      "REJECTED": "Rejected",
      "DISABLED": "Disabled",
      "DRAFT": "Draft"
    };
    const status = statusMap[apiTemplate.status] || apiTemplate.status;
    let qualityRating = "yellow";
    if (status === "Approved") {
      qualityRating = "green";
    } else if (status === "Draft") {
      qualityRating = "grey";
    } else if (status === "Pending") {
      qualityRating = "yellow";
    } else if (status === "Disabled" || status === "Rejected") {
      qualityRating = "red";
    }
    const updatedOn = new Date(apiTemplate.updated_at || apiTemplate.datetime).toISOString().split("T")[0];
    const templateValue = {
      sender: "",
      campaign_id: "put_campaign_id",
      messaging_product: "whatsapp",
      recipient_type: "individual",
      to: "receiver_number",
      type: "template",
      template: {
        name: apiTemplate.template_name,
        language: {
          code: language
        },
        components
      }
    };
    return {
      id: apiTemplate.id ? apiTemplate.id.toString() : "unknown",
      label: apiTemplate.template_name || "Unknown Template",
      category,
      status,
      qualityRating,
      language: getLanguageName(language),
      updatedOn,
      template: JSON.stringify(templateValue),
      template_id: apiTemplate.template_id,
      reason: apiTemplate.reason,
      templateforapi: apiTemplate.templateforapi,
      draft_json: apiTemplate.draft_json,
      template_data: apiTemplate.template_data
    };
  } catch (error) {
    console.error("Error transforming template data:", error);
    return {
      id: ((_b = apiTemplate.id) == null ? void 0 : _b.toString()) || "unknown",
      label: apiTemplate.template_name || "Unknown Template",
      category: "Marketing",
      status: "Draft",
      qualityRating: "red",
      language: "English",
      updatedOn: (/* @__PURE__ */ new Date()).toISOString().split("T")[0],
      template: null
    };
  }
};
const getLanguageName = (languageCode) => {
  const languageMap = {
    "en_US": "English",
    "es_ES": "Spanish",
    "fr_FR": "French",
    "de_DE": "German",
    "it_IT": "Italian",
    "pt_BR": "Portuguese",
    "hi_IN": "Hindi",
    "ar_AR": "Arabic",
    "zh_CN": "Chinese",
    "ja_JP": "Japanese",
    "ko_KR": "Korean",
    "ru_RU": "Russian"
  };
  return languageMap[languageCode] || "English";
};
const handleApiError$1 = (error) => {
  console.error("Template API Error:", error);
  if (error.name === "TypeError" && error.message.includes("fetch")) {
    return {
      message: "Network error. Please check your internet connection.",
      type: "network"
    };
  }
  if (error.message.includes("401")) {
    return {
      message: "Authentication failed. Please check your API token.",
      type: "auth"
    };
  }
  if (error.message.includes("403")) {
    return {
      message: "Access denied. You do not have permission to access templates.",
      type: "permission"
    };
  }
  if (error.message.includes("404")) {
    return {
      message: "Templates not found. The API endpoint may have changed.",
      type: "notfound"
    };
  }
  if (error.message.includes("500")) {
    return {
      message: "Server error. Please try again later.",
      type: "server"
    };
  }
  return {
    message: "An unexpected error occurred while fetching templates.",
    type: "unknown"
  };
};
const getAllTemplateList = async () => {
  const response = await fetch("https://app.getgabs.com/partners/broadcast/campaignmanage/gettemplatelists?template_name=template_name", {
    method: "GET",
    headers: {
      "Content-Type": "application/json",
      "Authorization": `Bearer ${API_TOKEN}`
    }
  });
  if (!response.ok) throw new Error("Failed to fetch template list");
  const data = await response.json();
  console.log("template list", data);
  return data;
};
const getAllTemplateListForAbandonedCart = async () => {
  const response = await fetch("https://app.getgabs.com/partners/broadcast/campaignmanage/gettemplatelists?template_name=template_name&template_type=2", {
    method: "GET",
    headers: {
      "Content-Type": "application/json",
      "Authorization": `Bearer ${API_TOKEN}`
    }
  });
  if (!response.ok) throw new Error("Failed to fetch template list");
  const data = await response.json();
  console.log("template list", data);
  return data;
};
const getAllTemplateListForOrderConfirmation = async () => {
  const response = await fetch("https://app.getgabs.com/partners/broadcast/campaignmanage/gettemplatelists?template_name=template_name&template_type=1", {
    method: "GET",
    headers: {
      "Content-Type": "application/json",
      "Authorization": `Bearer ${API_TOKEN}`
    }
  });
  if (!response.ok) throw new Error("Failed to fetch template list");
  const data = await response.json();
  console.log("template list", data);
  return data;
};
const getSelectedTemplatebyName = async (template_name) => {
  const response = await fetch(`https://app.getgabs.com/partners/getmessagetemplateapi?template_name=${template_name}`, {
    method: "GET",
    headers: {
      "Content-Type": "application/json",
      "Authorization": `Bearer ${API_TOKEN}`
    }
  });
  if (!response.ok) throw new Error("Failed to fetch template list");
  const data = await response.json();
  console.log("template list", data);
  return data;
};
const saveTemporaryFile = async (filepayload) => {
  const response = await fetch(`https://app.getgabs.com/partners/broadcast/campaignmanage/saveFileTemporarily`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      "Authorization": `Bearer ${API_TOKEN}`
    },
    body: JSON.stringify(filepayload)
  });
  if (!response.ok) throw new Error("Failed to save temporary file");
  const data = await response.json();
  console.log("save temporary file", data);
  return data;
};
const Checkisteplatenameavailable = async (templatename) => {
  const response = await fetch(`https://app.getgabs.com/partners/template/chechtemplatename?templatename=${templatename}`, {
    method: "GET",
    headers: {
      "Content-Type": "application/json",
      "Authorization": `Bearer ${API_TOKEN}`
    }
  });
  if (!response.ok) throw new Error("Failed to check template name");
  const data = await response.json();
  console.log("check template name", data);
  return data;
};
const WhatsAppPreview = ({
  template,
  variant = "bubble",
  maxWidth = "280px",
  showWhatsAppHeader = false,
  variableMapping = {},
  mediaMapping = {}
}) => {
  if (!template) {
    return /* @__PURE__ */ jsx(Text, { variant: "bodyMd", tone: "subdued", children: "No preview available" });
  }
  const applyVariableMapping = (text2) => {
    if (!text2 || typeof text2 !== "string") return text2;
    let processedText = text2;
    Object.entries(variableMapping).forEach(([variable, mappedValue]) => {
      if (mappedValue) {
        const variableRegex = new RegExp(`\\{\\{${variable}\\}\\}`, "g");
        const displayValue = getVariableDisplayValue(mappedValue);
        processedText = processedText.replace(variableRegex, displayValue);
      }
    });
    return processedText;
  };
  const getVariableDisplayValue = (variableValue) => {
    const sampleData = {
      customer_name: "John Doe",
      first_name: "John",
      last_name: "Doe",
      product_name: "Premium Widget",
      order_id: "ORD-12345",
      order_number: "#12345",
      tracking_link: "https://track.example.com/12345",
      company_name: "Acme Corp",
      support_email: "support@business.com",
      support_phone: "+1 800-123-4567"
    };
    return sampleData[variableValue] || `[${variableValue}]`;
  };
  let processedTemplate = template;
  if (typeof template === "string" && Object.keys(variableMapping).length > 0) {
    try {
      const templateObj = JSON.parse(template);
      processedTemplate = JSON.stringify(templateObj, (key, value) => {
        if (typeof value === "string") {
          return applyVariableMapping(value);
        }
        return value;
      });
    } catch (e) {
      processedTemplate = applyVariableMapping(template);
    }
  }
  const previewComponents = convertWhatsAppMessageToPreview(processedTemplate);
  if (!previewComponents) {
    return /* @__PURE__ */ jsx(Text, { variant: "bodyMd", tone: "subdued", children: "Unable to generate preview" });
  }
  const renderFormattedText = (text2) => {
    if (!text2) return null;
    const processedText = applyVariableMapping(text2);
    const elements = getFormattedTextData(processedText);
    return elements.map((element, index2) => {
      var _a2;
      if (element.isBullet) {
        return /* @__PURE__ */ jsxs("div", { style: { display: "flex", alignItems: "flex-start", marginBottom: "4px" }, children: [
          /* @__PURE__ */ jsx("span", { style: { marginRight: "8px", fontSize: "14px" }, children: "•" }),
          /* @__PURE__ */ jsx("span", { style: element.style, children: element.text })
        ] }, element.key || index2);
      }
      if (element.isNumbered) {
        return /* @__PURE__ */ jsxs("div", { style: { display: "flex", alignItems: "flex-start", marginBottom: "4px" }, children: [
          /* @__PURE__ */ jsxs("span", { style: { marginRight: "8px", fontSize: "14px", minWidth: "1px" }, children: [
            ((_a2 = element.text.match(/^(\d+)\./)) == null ? void 0 : _a2[1]) || "1",
            "."
          ] }),
          /* @__PURE__ */ jsx("span", { style: element.style, children: element.text.replace(/^\d+\.\s*/, "") })
        ] }, element.key || index2);
      }
      if (element.isQuote) {
        return /* @__PURE__ */ jsx("div", { style: {
          borderLeft: "3px solid #ccc",
          paddingLeft: "10px",
          fontStyle: "italic",
          marginBottom: "4px",
          backgroundColor: "#f9f9f9"
        }, children: /* @__PURE__ */ jsx("span", { style: element.style, children: element.text }) }, element.key || index2);
      }
      return /* @__PURE__ */ jsxs("span", { children: [
        /* @__PURE__ */ jsx("span", { style: element.style, children: element.text }),
        element.isLineBreak && /* @__PURE__ */ jsx("br", {})
      ] }, element.key || index2);
    });
  };
  const renderHeader = (header, mediaId = null) => {
    var _a2;
    if (!header) return null;
    const mappedFile = mediaId && mediaMapping[mediaId];
    let mediaUrl = header.content;
    if (mappedFile) {
      if (mappedFile.fileUrl) {
        mediaUrl = mappedFile.fileUrl;
      } else if (mappedFile.link) {
        mediaUrl = mappedFile.link;
      } else if (mappedFile.file && mappedFile.file instanceof File) {
        mediaUrl = URL.createObjectURL(mappedFile.file);
      } else if (mappedFile instanceof File) {
        mediaUrl = URL.createObjectURL(mappedFile);
      } else if (typeof mappedFile === "string") {
        mediaUrl = mappedFile;
      }
    }
    return /* @__PURE__ */ jsxs("div", { children: [
      header.type === "image" && /* @__PURE__ */ jsx(
        "img",
        {
          src: mediaUrl,
          alt: "Header image",
          style: {
            width: "100%",
            // maxWidth: '250px',
            height: "auto",
            borderRadius: "8px"
          }
        }
      ),
      header.type === "video" && /* @__PURE__ */ jsx(
        "video",
        {
          src: mediaUrl,
          controls: true,
          style: {
            width: "100%",
            // maxWidth: '250px',
            height: "auto",
            borderRadius: "8px"
          }
        }
      ),
      header.type === "text" && /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "div", fontWeight: "bold", children: renderFormattedText(header.content) }),
      header.type === "document" && /* @__PURE__ */ jsxs("div", { style: {
        padding: "8px 12px",
        backgroundColor: "#f5f5f5",
        borderRadius: "8px",
        border: "1px solid #ddd"
      }, children: [
        "📄 ",
        mappedFile ? ((_a2 = mappedFile.file) == null ? void 0 : _a2.name) || mappedFile.fileName || mappedFile.name : header.filename || "Document"
      ] })
    ] });
  };
  const renderButtons = (buttons) => {
    if (!buttons || !Array.isArray(buttons) || buttons.length === 0) return null;
    return /* @__PURE__ */ jsx(BlockStack, { gap: "100", children: buttons.map((button2, index2) => /* @__PURE__ */ jsxs("div", { style: {
      backgroundColor: button2.type === "URL" ? "#e3f2fd" : button2.type === "CATALOG" ? "#e8f5e8" : "#f0f0f0",
      padding: "8px 12px",
      borderRadius: "5px",
      border: "1px solid #ddd",
      textAlign: "center",
      fontSize: "12px",
      color: button2.type === "URL" ? "#1976d2" : button2.type === "CATALOG" ? "#2e7d32" : "inherit",
      display: "flex",
      alignItems: "center",
      justifyContent: "center",
      gap: "6px"
    }, children: [
      button2.type === "URL" && /* @__PURE__ */ jsx("span", { children: /* @__PURE__ */ jsx(Icon, { source: LinkIcon, tone: "base" }) }),
      button2.type === "PHONE_NUMBER" && /* @__PURE__ */ jsx("span", { children: /* @__PURE__ */ jsx(Icon, { source: PhoneIcon, tone: "base" }) }),
      (button2.type === "QUICK_REPLY" || (!button2.type || button2.type === "REPLY")) && /* @__PURE__ */ jsx("span", { children: /* @__PURE__ */ jsx(Icon, { source: UndoIcon, tone: "base" }) }),
      button2.type === "CATALOG" && " ",
      /* @__PURE__ */ jsx("span", { children: button2.text })
    ] }, index2)) });
  };
  const renderCarousel = (carousel) => {
    if (!carousel || !Array.isArray(carousel) || carousel.length === 0) return null;
    return /* @__PURE__ */ jsx("div", { style: {
      display: "flex",
      gap: "8px",
      overflowX: "auto",
      padding: "4px",
      maxWidth: "100%"
    }, children: carousel.map((card, index2) => {
      var _a2, _b, _c;
      return /* @__PURE__ */ jsx("div", { style: {
        minWidth: "200px",
        maxWidth: "200px",
        backgroundColor: "#f8f9fa",
        border: "1px solid #e1e3e5",
        borderRadius: "8px",
        overflow: "hidden",
        flexShrink: 0
      }, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "100", children: [
        ((_a2 = card.components) == null ? void 0 : _a2.header) && /* @__PURE__ */ jsx("div", { style: { padding: "0" }, children: renderHeader(card.components.header, `carousel_${index2}_header`) }),
        /* @__PURE__ */ jsx("div", { style: { padding: "8px 12px" }, children: ((_b = card.components) == null ? void 0 : _b.body) && /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "div", children: renderFormattedText(card.components.body) }) }),
        ((_c = card.components) == null ? void 0 : _c.buttons) && /* @__PURE__ */ jsx("div", { style: { padding: "0 8px 8px 8px" }, children: renderButtons(card.components.buttons) })
      ] }) }, card.id || index2);
    }) });
  };
  if (variant === "full" && showWhatsAppHeader) {
    return /* @__PURE__ */ jsxs("div", { style: {
      maxWidth: "350px",
      margin: "0 auto",
      border: "1px solid #e1e3e5",
      borderRadius: "12px",
      backgroundColor: "#ffffff",
      overflow: "hidden",
      boxShadow: "0 2px 8px rgba(0,0,0,0.1)"
    }, children: [
      /* @__PURE__ */ jsxs("div", { style: {
        backgroundColor: "#075e54",
        color: "white",
        padding: "12px 16px",
        display: "flex",
        alignItems: "center",
        gap: "12px"
      }, children: [
        /* @__PURE__ */ jsx("div", { style: {
          width: "32px",
          height: "32px",
          borderRadius: "50%",
          backgroundColor: "#128c7e",
          display: "flex",
          alignItems: "center",
          justifyContent: "center",
          fontSize: "14px",
          fontWeight: "bold"
        }, children: "B" }),
        /* @__PURE__ */ jsxs("div", { children: [
          /* @__PURE__ */ jsx(Text, { variant: "bodyMd", fontWeight: "semibold", style: {
            color: "white"
          }, children: "Business Name" }),
          /* @__PURE__ */ jsx("div", { style: { fontSize: "12px", opacity: 0.8 }, children: "online" })
        ] })
      ] }),
      /* @__PURE__ */ jsx("div", { style: {
        padding: "16px",
        backgroundColor: "#e5ddd5",
        minHeight: "100px"
      }, children: /* @__PURE__ */ jsxs("div", { style: {
        backgroundColor: "#ffffff",
        borderRadius: "8px",
        padding: "12px",
        boxShadow: "0 1px 2px rgba(0,0,0,0.1)",
        position: "relative"
      }, children: [
        /* @__PURE__ */ jsx("div", { style: {
          position: "absolute",
          left: "-8px",
          top: "10px",
          width: 0,
          height: 0,
          borderTop: "8px solid transparent",
          borderBottom: "8px solid transparent",
          borderRight: "8px solid #ffffff"
        } }),
        /* @__PURE__ */ jsx(BlockStack, { gap: "200", children: previewComponents.type === "carousel" ? /* @__PURE__ */ jsxs(Fragment, { children: [
          previewComponents.body && /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "div", children: renderFormattedText(previewComponents.body) }),
          renderCarousel(previewComponents.carousel),
          /* @__PURE__ */ jsx(Text, { variant: "caption", as: "div", tone: "subdued", alignment: "center", children: "Swipe to see more cards →" })
        ] }) : /* @__PURE__ */ jsxs(Fragment, { children: [
          renderHeader(previewComponents.header, "header_0"),
          previewComponents.body && /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "div", children: renderFormattedText(previewComponents.body) }),
          previewComponents.footer && /* @__PURE__ */ jsx(Text, { variant: "caption", as: "div", tone: "subdued", children: renderFormattedText(previewComponents.footer) }),
          renderButtons(previewComponents.buttons)
        ] }) }),
        /* @__PURE__ */ jsx("div", { style: {
          textAlign: "right",
          marginTop: "8px",
          fontSize: "11px",
          color: "#667781"
        }, children: (/* @__PURE__ */ new Date()).toLocaleTimeString([], { hour: "2-digit", minute: "2-digit" }) })
      ] }) })
    ] });
  }
  if (previewComponents.type === "carousel") {
    return /* @__PURE__ */ jsx("div", { style: {
      backgroundColor: "#fff",
      padding: "12px 16px",
      borderRadius: "4px 18px 18px 18px",
      boxShadow: "rgba(0, 0, 0, 0.1) 0px 0px 13px",
      maxWidth
    }, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
      previewComponents.body && /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "div", children: renderFormattedText(previewComponents.body) }),
      renderCarousel(previewComponents.carousel),
      /* @__PURE__ */ jsx(Text, { variant: "caption", as: "div", tone: "subdued", alignment: "center", children: "Swipe to see more cards →" })
    ] }) });
  }
  return /* @__PURE__ */ jsx("div", { style: {
    backgroundColor: "#fff",
    padding: "12px 16px",
    borderRadius: "4px 18px 18px 18px",
    boxShadow: "rgba(0, 0, 0, 0.1) 0px 0px 13px",
    maxWidth
  }, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
    renderHeader(previewComponents.header, "header_0"),
    previewComponents.body && /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "div", children: renderFormattedText(previewComponents.body) }),
    previewComponents.footer && /* @__PURE__ */ jsx(Text, { variant: "caption", as: "div", tone: "subdued", children: renderFormattedText(previewComponents.footer) }),
    renderButtons(previewComponents.buttons)
  ] }) });
};
const emojiCategories = {
  smileys: {
    name: "Smileys & People",
    icon: "😀",
    emojis: [
      "😀",
      "😃",
      "😄",
      "😁",
      "😆",
      "😅",
      "🤣",
      "😂",
      "🙂",
      "🙃",
      "😉",
      "😊",
      "😇",
      "🥰",
      "😍",
      "🤩",
      "😘",
      "😗",
      "😚",
      "😙",
      "😋",
      "😛",
      "😜",
      "🤪",
      "😝",
      "🤑",
      "🤗",
      "🤭",
      "🤫",
      "🤔",
      "🤐",
      "🤨",
      "😐",
      "😑",
      "😶",
      "😏",
      "😒",
      "🙄",
      "😬",
      "🤥",
      "😔",
      "😪",
      "🤤",
      "😴",
      "😷",
      "🤒",
      "🤕",
      "🤢",
      "🤮",
      "🤧",
      "🥵",
      "🥶",
      "🥴",
      "😵",
      "🤯",
      "🤠",
      "🥳",
      "😎",
      "🤓",
      "🧐",
      "👋",
      "🤚",
      "🖐️",
      "✋",
      "🖖",
      "👌",
      "🤏",
      "✌️",
      "🤞",
      "🤟",
      "🤘",
      "🤙",
      "👈",
      "👉",
      "👆",
      "🖕",
      "👇",
      "☝️",
      "👍",
      "👎",
      "👊",
      "✊",
      "🤛",
      "🤜",
      "👏",
      "🙌",
      "👐",
      "🤲",
      "🤝",
      "🙏"
    ]
  },
  hearts: {
    name: "Hearts & Love",
    icon: "❤️",
    emojis: [
      "❤️",
      "🧡",
      "💛",
      "💚",
      "💙",
      "💜",
      "🖤",
      "🤍",
      "🤎",
      "💔",
      "❣️",
      "💕",
      "💞",
      "💓",
      "💗",
      "💖",
      "💘",
      "💝",
      "💟",
      "♥️",
      "💋",
      "💌",
      "💐",
      "🌹",
      "🌷",
      "🌺",
      "🌸",
      "🌻",
      "🌼",
      "💒"
    ]
  },
  gestures: {
    name: "Gestures",
    icon: "👍",
    emojis: [
      "👍",
      "👎",
      "👌",
      "✌️",
      "🤞",
      "🤟",
      "🤘",
      "🤙",
      "👈",
      "👉",
      "👆",
      "👇",
      "☝️",
      "👋",
      "🤚",
      "🖐️",
      "✋",
      "🖖",
      "👏",
      "🙌",
      "👐",
      "🤲",
      "🤝",
      "🙏",
      "✍️",
      "💪",
      "🦵",
      "🦶",
      "👂",
      "👃"
    ]
  },
  activities: {
    name: "Activities & Sports",
    icon: "⚽",
    emojis: [
      "⚽",
      "🏀",
      "🏈",
      "⚾",
      "🥎",
      "🎾",
      "🏐",
      "🏉",
      "🥏",
      "🎱",
      "🪀",
      "🏓",
      "🏸",
      "🏒",
      "🏑",
      "🥍",
      "🏏",
      "🪃",
      "🥅",
      "⛳",
      "🪁",
      "🏹",
      "🎣",
      "🤿",
      "🥊",
      "🥋",
      "🎽",
      "🛹",
      "🛷",
      "⛸️",
      "🥌",
      "🎿",
      "⛷️",
      "🏂",
      "🪂",
      "🏋️",
      "🤼",
      "🤸",
      "⛹️",
      "🤺",
      "🏇",
      "🧘",
      "🏄",
      "🏊",
      "🤽",
      "🚣",
      "🧗",
      "🚵",
      "🚴",
      "🏆"
    ]
  },
  food: {
    name: "Food & Drink",
    icon: "🍕",
    emojis: [
      "🍎",
      "🍐",
      "🍊",
      "🍋",
      "🍌",
      "🍉",
      "🍇",
      "🍓",
      "🫐",
      "🍈",
      "🍒",
      "🍑",
      "🥭",
      "🍍",
      "🥥",
      "🥝",
      "🍅",
      "🍆",
      "🥑",
      "🥦",
      "🥬",
      "🥒",
      "🌶️",
      "🫑",
      "🌽",
      "🥕",
      "🫒",
      "🧄",
      "🧅",
      "🥔",
      "🍠",
      "🥐",
      "🥖",
      "🍞",
      "🥨",
      "🥯",
      "🧀",
      "🥚",
      "🍳",
      "🧈",
      "🥞",
      "🧇",
      "🥓",
      "🥩",
      "🍗",
      "🍖",
      "🦴",
      "🌭",
      "🍔",
      "🍟",
      "🍕",
      "🫓",
      "🥪",
      "🥙",
      "🧆",
      "🌮",
      "🌯",
      "🫔",
      "🥗",
      "🥘",
      "🫕",
      "🍝",
      "🍜",
      "🍲",
      "🍛",
      "🍣",
      "🍱",
      "🥟",
      "🦪",
      "🍤"
    ]
  },
  travel: {
    name: "Travel & Places",
    icon: "✈️",
    emojis: [
      "🚗",
      "🚕",
      "🚙",
      "🚌",
      "🚎",
      "🏎️",
      "🚓",
      "🚑",
      "🚒",
      "🚐",
      "🛻",
      "🚚",
      "🚛",
      "🚜",
      "🏍️",
      "🛵",
      "🚲",
      "🛴",
      "🛹",
      "🛼",
      "🚁",
      "🛸",
      "✈️",
      "🛩️",
      "🪂",
      "💺",
      "🚀",
      "🛰️",
      "🚢",
      "⛵",
      "🚤",
      "🛥️",
      "🛳️",
      "⛴️",
      "🚂",
      "🚃",
      "🚄",
      "🚅",
      "🚆",
      "🚇",
      "🚈",
      "🚉",
      "🚊",
      "🚝",
      "🚞",
      "🚋",
      "🚌",
      "🚍",
      "🎡",
      "🎢",
      "🎠",
      "🏗️",
      "🌁",
      "🗼",
      "🏭",
      "⛲",
      "🎡",
      "🎢",
      "🏖️",
      "🏝️"
    ]
  },
  objects: {
    name: "Objects",
    icon: "📱",
    emojis: [
      "📱",
      "💻",
      "🖥️",
      "🖨️",
      "⌨️",
      "🖱️",
      "🖲️",
      "💽",
      "💾",
      "💿",
      "📀",
      "📼",
      "📷",
      "📸",
      "📹",
      "🎥",
      "📽️",
      "🎞️",
      "📞",
      "☎️",
      "📟",
      "📠",
      "📺",
      "📻",
      "🎙️",
      "🎚️",
      "🎛️",
      "🧭",
      "⏱️",
      "⏲️",
      "⏰",
      "🕰️",
      "⌛",
      "⏳",
      "📡",
      "🔋",
      "🔌",
      "💡",
      "🔦",
      "🕯️",
      "🪔",
      "🧯",
      "🛢️",
      "💸",
      "💵",
      "💴",
      "💶",
      "💷",
      "🪙",
      "💰"
    ]
  },
  symbols: {
    name: "Symbols",
    icon: "⭐",
    emojis: [
      "⭐",
      "🌟",
      "💫",
      "✨",
      "🌠",
      "🌙",
      "☀️",
      "⛅",
      "⛈️",
      "🌤️",
      "🌦️",
      "🌧️",
      "⛆",
      "❄️",
      "☃️",
      "⛄",
      "🌈",
      "🔥",
      "💧",
      "🌊",
      "🎵",
      "🎶",
      "🎼",
      "🎹",
      "🥁",
      "🎷",
      "🎺",
      "🎸",
      "🪕",
      "🎻",
      "✅",
      "❌",
      "❎",
      "✔️",
      "☑️",
      "🔘",
      "⚪",
      "⚫",
      "🔴",
      "🟠",
      "🟡",
      "🟢",
      "🔵",
      "🟣",
      "🟤",
      "⭕",
      "🚫",
      "💯",
      "💢",
      "💥"
    ]
  },
  flags: {
    name: "Flags",
    icon: "🏳️",
    emojis: [
      "🏳️",
      "🏴",
      "🏁",
      "🚩",
      "🏳️‍🌈",
      "🏳️‍⚧️",
      "🇺🇸",
      "🇬🇧",
      "🇨🇦",
      "🇦🇺",
      "🇩🇪",
      "🇫🇷",
      "🇮🇹",
      "🇪🇸",
      "🇯🇵",
      "🇰🇷",
      "🇨🇳",
      "🇮🇳",
      "🇧🇷",
      "🇲🇽",
      "🇷🇺",
      "🇿🇦",
      "🇳🇬",
      "🇪🇬",
      "🇸🇦",
      "🇦🇪",
      "🇹🇷",
      "🇬🇷",
      "🇳🇱",
      "🇸🇪"
    ]
  }
};
const getAllEmojis = () => {
  const allEmojis = [];
  Object.values(emojiCategories).forEach((category) => {
    allEmojis.push(...category.emojis);
  });
  return allEmojis;
};
const searchEmojis = (query) => {
  if (!query) return getAllEmojis();
  const searchTerms = {
    "happy": ["😀", "😃", "😄", "😁", "😆", "😅", "😊", "🙂", "😇", "🥰", "😍", "🤩"],
    "sad": ["😔", "😢", "😭", "😞", "😟", "😕", "🙁", "☹️", "😣", "😖"],
    "love": ["❤️", "💕", "💖", "💗", "💓", "💞", "💘", "💝", "💟", "♥️", "💋", "😍", "🥰"],
    "angry": ["😠", "😡", "🤬", "😤", "💢", "👿", "😾"],
    "surprised": ["😲", "😯", "😮", "😧", "😦", "🤯", "😱"],
    "food": emojiCategories.food.emojis,
    "travel": emojiCategories.travel.emojis,
    "heart": emojiCategories.hearts.emojis,
    "thumbs": ["👍", "👎"],
    "fire": ["🔥"],
    "star": ["⭐", "🌟", "💫", "✨"],
    "money": ["💰", "💵", "💸", "🤑", "💳", "💎"],
    "time": ["⏰", "⏱️", "⏲️", "🕐", "🕑", "🕒", "🕓", "🕔", "🕕"]
  };
  const lowerQuery = query.toLowerCase();
  const matchedEmojis = [];
  Object.entries(searchTerms).forEach(([term, emojis]) => {
    if (term.includes(lowerQuery) || lowerQuery.includes(term)) {
      matchedEmojis.push(...emojis);
    }
  });
  if (matchedEmojis.length === 0) {
    return ["😀", "😊", "👍", "❤️", "🔥", "⭐", "🎉", "💯", "🚀", "💪"];
  }
  return [...new Set(matchedEmojis)];
};
const getFrequentlyUsedEmojis = () => {
  return [
    "😀",
    "😊",
    "👍",
    "❤️",
    "🔥",
    "⭐",
    "🎉",
    "💯",
    "🚀",
    "💪",
    "👏",
    "🙏",
    "💖",
    "😍",
    "🤝",
    "✅",
    "🎯",
    "💡",
    "🌟",
    "🎊"
  ];
};
const getRecentlyUsedEmojis = () => {
  try {
    const recent = localStorage.getItem("recentlyUsedEmojis");
    return recent ? JSON.parse(recent) : [];
  } catch {
    return [];
  }
};
const addToRecentlyUsed = (emoji) => {
  try {
    let recent = getRecentlyUsedEmojis();
    recent = recent.filter((e) => e !== emoji);
    recent.unshift(emoji);
    recent = recent.slice(0, 20);
    localStorage.setItem("recentlyUsedEmojis", JSON.stringify(recent));
  } catch {
  }
};
function EmojiPicker({ onEmojiSelect, buttonSize = "micro", disabled = false }) {
  var _a2;
  const [popoverActive, setPopoverActive] = useState(false);
  const [searchQuery, setSearchQuery] = useState("");
  const [selectedTab, setSelectedTab] = useState(0);
  const [recentEmojis, setRecentEmojis] = useState(getRecentlyUsedEmojis());
  const buttonRef = useRef(null);
  const togglePopoverActive = useCallback(() => {
    setPopoverActive((popoverActive2) => !popoverActive2);
  }, []);
  const handleEmojiClick = useCallback((emoji) => {
    if (onEmojiSelect) {
      onEmojiSelect(emoji);
    }
    addToRecentlyUsed(emoji);
    setRecentEmojis(getRecentlyUsedEmojis());
    setPopoverActive(false);
  }, [onEmojiSelect]);
  const handleSearchChange = useCallback((value) => {
    setSearchQuery(value);
  }, []);
  const handleTabChange = useCallback((selectedTabIndex) => {
    setSelectedTab(selectedTabIndex);
    setSearchQuery("");
  }, []);
  const categoryTabs = [
    { id: "recent", content: "🕒", accessibilityLabel: "Recently Used" },
    { id: "frequent", content: "⭐", accessibilityLabel: "Frequently Used" },
    ...Object.entries(emojiCategories).map(([key, category]) => ({
      id: key,
      content: category.icon,
      accessibilityLabel: category.name
    }))
  ];
  const getEmojisToDisplay = () => {
    if (searchQuery) {
      return searchEmojis(searchQuery);
    }
    switch (selectedTab) {
      case 0:
        return recentEmojis.length > 0 ? recentEmojis : getFrequentlyUsedEmojis();
      case 1:
        return getFrequentlyUsedEmojis();
      default:
        const categoryKey = Object.keys(emojiCategories)[selectedTab - 2];
        return categoryKey ? emojiCategories[categoryKey].emojis : [];
    }
  };
  const emojisToDisplay = getEmojisToDisplay();
  const activator = /* @__PURE__ */ jsx("div", { ref: buttonRef, children: /* @__PURE__ */ jsx(Tooltip, { content: "Insert emoji", children: /* @__PURE__ */ jsx(
    Button,
    {
      size: buttonSize,
      onClick: togglePopoverActive,
      disabled,
      accessibilityLabel: "Insert emoji",
      children: "😀"
    }
  ) }) });
  return /* @__PURE__ */ jsx(
    Popover,
    {
      active: popoverActive,
      activator,
      onClose: togglePopoverActive,
      ariaHaspopup: false,
      sectioned: false,
      preferredAlignment: "left",
      preferredPosition: "above",
      children: /* @__PURE__ */ jsx(Box, { width: "380px", maxHeight: "450px", children: /* @__PURE__ */ jsxs(BlockStack, { gap: "0", children: [
        /* @__PURE__ */ jsx(Box, { paddingInlineStart: "300", paddingInlineEnd: "300", paddingBlockStart: "300", paddingBlockEnd: "200", children: /* @__PURE__ */ jsx(
          TextField,
          {
            placeholder: "Search emojis... like happy, sad, etc.",
            value: searchQuery,
            onChange: handleSearchChange,
            clearButton: true,
            onClearButtonClick: () => setSearchQuery(""),
            autoComplete: "off"
          }
        ) }),
        /* @__PURE__ */ jsx(Box, { paddingInlineStart: "300", paddingInlineEnd: "300", paddingBlockEnd: "200", children: /* @__PURE__ */ jsx(Scrollable, { style: { maxWidth: "100%" }, horizontal: true, children: /* @__PURE__ */ jsx(InlineStack, { gap: "100", wrap: false, children: categoryTabs.map((tab, index2) => /* @__PURE__ */ jsx(
          Button,
          {
            onClick: () => handleTabChange(index2),
            variant: selectedTab === index2 ? "primary" : "tertiary",
            size: "micro",
            accessibilityLabel: tab.accessibilityLabel,
            children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "span", children: tab.content })
          },
          tab.id
        )) }) }) }),
        !searchQuery && /* @__PURE__ */ jsx(Box, { paddingInlineStart: "300", paddingInlineEnd: "300", paddingBlockEnd: "200", children: /* @__PURE__ */ jsxs(Text, { variant: "headingSm", tone: "subdued", children: [
          selectedTab === 0 && "Recently Used",
          selectedTab === 1 && "Frequently Used",
          selectedTab > 1 && ((_a2 = Object.values(emojiCategories)[selectedTab - 2]) == null ? void 0 : _a2.name)
        ] }) }),
        /* @__PURE__ */ jsx(Divider, {}),
        /* @__PURE__ */ jsx(Box, { paddingInlineStart: "300", paddingInlineEnd: "300", paddingBlockStart: "200", paddingBlockEnd: "300", children: /* @__PURE__ */ jsx(Scrollable, { style: { height: "300px" }, children: /* @__PURE__ */ jsx(Box, { paddingBlockEnd: "200", children: emojisToDisplay.length > 0 ? /* @__PURE__ */ jsx(
          "div",
          {
            style: {
              display: "grid",
              gridTemplateColumns: "repeat(9, 1fr)",
              gap: "var(--p-space-100)"
            },
            children: emojisToDisplay.map((emoji, index2) => /* @__PURE__ */ jsx(
              Button,
              {
                onClick: () => handleEmojiClick(emoji),
                variant: "plain",
                size: "micro",
                textAlign: "center",
                accessibilityLabel: `Insert ${emoji} emoji`,
                fullWidth: true,
                children: /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "span", children: emoji })
              },
              `${emoji}-${index2}`
            ))
          }
        ) : /* @__PURE__ */ jsx(Box, { paddingBlockStart: "500", paddingBlockEnd: "500", children: /* @__PURE__ */ jsx(
          EmptyState,
          {
            heading: searchQuery ? "No emojis found" : "No emojis available",
            image: "",
            children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", children: searchQuery ? "Try searching with different keywords" : "Start using emojis to see them here" })
          }
        ) }) }) }) })
      ] }) })
    }
  );
}
function CreateCatalogTemplatePage() {
  const navigate = useNavigate();
  const [templateName, setTemplateName] = useState("");
  const [templateCategory, setTemplateCategory] = useState("marketing");
  const [templateLanguage, setTemplateLanguage] = useState("en_US");
  const [bodyText, setBodyText] = useState("");
  const [cursorPosition, setCursorPosition] = useState(0);
  const [bodyVariableMapping, setBodyVariableMapping] = useState({});
  const [variableInputValues, setVariableInputValues] = useState({});
  const [hasFooter, setHasFooter] = useState(false);
  const [footerText, setFooterText] = useState("");
  const [catalogButtonText, setCatalogButtonText] = useState("View Catalog");
  const [availableVariables, setAvailableVariables] = useState([]);
  const [loadingVariables, setLoadingVariables] = useState(true);
  const [showVariablesModal, setShowVariablesModal] = useState(false);
  const [variableSearchQuery, setVariableSearchQuery] = useState("");
  const [templateNameAvailability, setTemplateNameAvailability] = useState(null);
  const [checkingTemplateName, setCheckingTemplateName] = useState(false);
  const [templateNameError, setTemplateNameError] = useState("");
  const categoryOptions = [
    { label: "Marketing", value: "marketing" },
    { label: "Utility", value: "utility" },
    { label: "Authentication", value: "authentication" }
  ];
  const languageOptions = [
    { label: "English (US)", value: "en_US" },
    { label: "English (UK)", value: "en_GB" },
    { label: "Spanish", value: "es" },
    { label: "French", value: "fr" },
    { label: "German", value: "de" },
    { label: "Hindi", value: "hi" }
  ];
  useEffect(() => {
    const fetchVariables = async () => {
      try {
        setLoadingVariables(true);
        const variables = await getTemplateVariables();
        setAvailableVariables(variables);
      } catch (error) {
        console.error("Error fetching variables:", error);
        setAvailableVariables([]);
      } finally {
        setLoadingVariables(false);
      }
    };
    fetchVariables();
  }, []);
  useEffect(() => {
    if (!templateName.trim()) {
      setTemplateNameAvailability(null);
      setTemplateNameError("");
      return;
    }
    const timeoutId = setTimeout(async () => {
      try {
        setCheckingTemplateName(true);
        setTemplateNameError("");
        const response = await Checkisteplatenameavailable(templateName.toLowerCase().replace(/\s+/g, "_"));
        if (response.status === true) {
          setTemplateNameAvailability(true);
        } else {
          setTemplateNameAvailability(false);
          setTemplateNameError(response.message || "Template name is not available");
        }
      } catch (error) {
        console.error("Error checking template name:", error);
        setTemplateNameError("Error checking template name availability");
        setTemplateNameAvailability(false);
      } finally {
        setCheckingTemplateName(false);
      }
    }, 500);
    return () => clearTimeout(timeoutId);
  }, [templateName]);
  useMemo(() => {
    return [
      { label: "Select mapping...", value: "" },
      ...availableVariables.map((variable) => ({
        label: variable.label,
        value: variable.value
      }))
    ];
  }, [availableVariables]);
  useCallback((variableIndex, mappingValue) => {
    setBodyVariableMapping((prev) => ({
      ...prev,
      [variableIndex]: mappingValue
    }));
  }, []);
  const bodyVariables = useMemo(() => {
    if (bodyText) {
      return extractVariablesFromWhatsAppMessage(JSON.stringify({ text: bodyText }));
    }
    return [];
  }, [bodyText]);
  const handleVariableSelectionChange = useCallback((variable, value) => {
    const variableIndex = bodyVariables.indexOf(variable);
    setBodyVariableMapping((prev) => ({
      ...prev,
      [variableIndex]: value
    }));
    if (value) {
      const selectedVar = availableVariables.find((av) => av.value === value);
      setVariableInputValues((prev) => ({
        ...prev,
        [variable]: (selectedVar == null ? void 0 : selectedVar.label) || ""
      }));
    } else {
      setVariableInputValues((prev) => ({
        ...prev,
        [variable]: ""
      }));
    }
  }, [bodyVariables, availableVariables]);
  const generateTemplateJSON = useMemo(() => {
    const template = {
      sender: "",
      campaign_id: "put_campaign_id",
      messaging_product: "whatsapp",
      recipient_type: "individual",
      to: "receiver_number",
      type: "template",
      template: {
        name: templateName.toLowerCase().replace(/\s+/g, "_") || "new_catalog_template",
        language: {
          code: templateLanguage
        },
        components: []
      }
    };
    if (bodyText) {
      const bodyComponent = {
        type: "BODY",
        text: bodyText
      };
      if (bodyVariables.length > 0) {
        bodyComponent.parameters = bodyVariables.map((variable, index2) => ({
          type: "text",
          text: bodyVariableMapping[index2] || variable
        }));
      }
      template.template.components.push(bodyComponent);
    }
    if (hasFooter && footerText) {
      template.template.components.push({
        type: "FOOTER",
        text: footerText
      });
    }
    if (catalogButtonText) {
      template.template.components.push({
        type: "BUTTONS",
        buttons: [
          {
            type: "CATALOG",
            text: catalogButtonText
          }
        ]
      });
    }
    return JSON.stringify(template);
  }, [templateName, templateLanguage, bodyText, hasFooter, footerText, catalogButtonText]);
  const extractVariables = useMemo(() => {
    return bodyVariables;
  }, [bodyVariables]);
  useEffect(() => {
    setBodyVariableMapping((prev) => {
      const newMapping = {};
      bodyVariables.forEach((variable, index2) => {
        if (prev[index2]) {
          newMapping[index2] = prev[index2];
        }
      });
      return newMapping;
    });
  }, [bodyVariables]);
  const handleTextSelection = useCallback(() => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    setCursorPosition(textarea.selectionStart);
  }, []);
  const applyFormatting = useCallback((format) => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const end = textarea.selectionEnd;
    const selectedText = textarea.value.substring(start, end);
    let formattedText = "";
    let cursorOffset = 0;
    if (selectedText) {
      switch (format) {
        case "bold":
          formattedText = `*${selectedText}*`;
          cursorOffset = formattedText.length;
          break;
        case "italic":
          formattedText = `_${selectedText}_`;
          cursorOffset = formattedText.length;
          break;
        case "strikethrough":
          formattedText = `~${selectedText}~`;
          cursorOffset = formattedText.length;
          break;
        case "monospace":
          formattedText = `\`\`\`${selectedText}\`\`\``;
          cursorOffset = formattedText.length;
          break;
        case "inline-code":
          formattedText = `\`${selectedText}\``;
          cursorOffset = formattedText.length;
          break;
        case "quote":
          const needsNewLineBeforeQuote = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfterQuote = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBeforeQuote ? "\n" : "") + `> ${selectedText}` + (needsNewLineAfterQuote ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        case "bullet-list":
          const bulletLines = selectedText.split("\n").map((line) => line.trim() ? `* ${line}` : line).join("\n");
          const needsNewLineBefore = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfter = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBefore ? "\n" : "") + bulletLines + (needsNewLineAfter ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        case "numbered-list":
          const numberedLines = selectedText.split("\n").filter((line) => line.trim()).map((line, index2) => `${index2 + 1}. ${line}`).join("\n");
          const needsNewLineBeforeNum = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfterNum = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBeforeNum ? "\n" : "") + numberedLines + (needsNewLineAfterNum ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        default:
          formattedText = selectedText;
          cursorOffset = formattedText.length;
      }
    } else {
      switch (format) {
        case "bold":
          formattedText = "**";
          cursorOffset = 1;
          break;
        case "italic":
          formattedText = "__";
          cursorOffset = 1;
          break;
        case "strikethrough":
          formattedText = "~~";
          cursorOffset = 1;
          break;
        case "monospace":
          formattedText = "```\n\n```";
          cursorOffset = 4;
          break;
        case "inline-code":
          formattedText = "``";
          cursorOffset = 1;
          break;
        case "quote":
          const needsNewLineBeforeQuoteEmpty = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeQuoteEmpty ? "\n> " : "> ";
          cursorOffset = formattedText.length;
          break;
        case "bullet-list":
          const needsNewLineBeforeBullet = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeBullet ? "\n* " : "* ";
          cursorOffset = formattedText.length;
          break;
        case "numbered-list":
          const needsNewLineBeforeNumber = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeNumber ? "\n1. " : "1. ";
          cursorOffset = formattedText.length;
          break;
        default:
          formattedText = "";
          cursorOffset = 0;
      }
    }
    const newValue = textarea.value.substring(0, start) + formattedText + textarea.value.substring(end);
    setBodyText(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + cursorOffset, start + cursorOffset);
    }, 0);
  }, []);
  const insertVariable = useCallback((variable) => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const variableText = `{{${variable}}}`;
    const newValue = textarea.value.substring(0, start) + variableText + textarea.value.substring(start);
    setBodyText(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + variableText.length, start + variableText.length);
    }, 0);
  }, []);
  const insertEmoji = useCallback((emoji) => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const newValue = textarea.value.substring(0, start) + emoji + textarea.value.substring(start);
    setBodyText(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + emoji.length, start + emoji.length);
    }, 0);
  }, []);
  useEffect(() => {
    const handleKeyDown = (event) => {
      if ((event.ctrlKey || event.metaKey) && event.target.id === "body-text-field") {
        switch (event.key.toLowerCase()) {
          case "b":
            event.preventDefault();
            applyFormatting("bold");
            break;
          case "i":
            event.preventDefault();
            applyFormatting("italic");
            break;
          case "s":
            event.preventDefault();
            applyFormatting("strikethrough");
            break;
          case "m":
            event.preventDefault();
            applyFormatting("monospace");
            break;
          case "k":
            event.preventDefault();
            applyFormatting("inline-code");
            break;
          case "q":
            event.preventDefault();
            applyFormatting("quote");
            break;
          case "l":
            event.preventDefault();
            applyFormatting("bullet-list");
            break;
          case "n":
            event.preventDefault();
            applyFormatting("numbered-list");
            break;
        }
      }
    };
    document.addEventListener("keydown", handleKeyDown);
    return () => document.removeEventListener("keydown", handleKeyDown);
  }, [applyFormatting]);
  const handleSave = useCallback(async () => {
    console.log("Saving catalog template:", {
      name: templateName,
      category: templateCategory,
      language: templateLanguage,
      template: generateTemplateJSON,
      hasFooter,
      footerText,
      catalogButtonText
    });
    try {
      const payload = {
        draftedtemplateid: 0,
        normaltemplateid: 0,
        _token: "",
        templatename: templateName.toLowerCase().replace(/\s+/g, "_"),
        language: templateLanguage,
        category: templateCategory.toUpperCase(),
        body: bodyText,
        bodyVars: Object.values(bodyVariableMapping),
        previewfooterText: hasFooter ? footerText : "",
        CatalogButtonText: catalogButtonText
      };
      const response = await fetch(`https://app.getgabs.com/partners/template/with-custom-vars/designtemplate?token=${API_TOKEN}`, {
        method: "POST",
        body: JSON.stringify(payload),
        headers: {
          "Content-Type": "application/json",
          "Authorization": `Bearer ${API_TOKEN}`,
          "X-Requested-With": "XMLHttpRequest"
        }
      });
      if (!response.ok) throw new Error("Failed to save template");
      const result = await response.json();
      console.log("Template saved successfully:", result);
      navigate("/app/templates");
    } catch (error) {
      console.error("Error saving template:", error);
    }
  }, [templateName, templateCategory, templateLanguage, generateTemplateJSON, hasFooter, footerText, catalogButtonText, navigate]);
  const handleCancel = useCallback(() => {
    navigate("/app/templates");
  }, [navigate]);
  return /* @__PURE__ */ jsxs(
    Page,
    {
      fullWidth: true,
      backAction: {
        content: "Templates",
        onAction: () => navigate("/app/templates")
      },
      title: "Create Catalog Template",
      subtitle: "Create a new catalog WhatsApp message template to showcase your products",
      primaryAction: {
        content: "Save Template",
        onAction: handleSave,
        disabled: !templateName || !bodyText || !catalogButtonText || templateNameAvailability !== true || checkingTemplateName
      },
      secondaryActions: [
        {
          content: "Cancel",
          onAction: handleCancel
        }
      ],
      children: [
        /* @__PURE__ */ jsxs(Grid, { children: [
          /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 8, lg: 8, xl: 8 }, children: /* @__PURE__ */ jsx("div", { style: { marginRight: "20px" }, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "500", children: [
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Basic Information" }),
              /* @__PURE__ */ jsxs(FormLayout, { children: [
                /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: "Template Name",
                    value: templateName,
                    onChange: (value) => setTemplateName(value.replace(/\s+/g, "_")),
                    placeholder: "Enter catalog template name",
                    helpText: checkingTemplateName ? "Checking availability..." : templateNameAvailability === true ? "✓ Template name is available" : templateNameAvailability === false ? templateNameError : "This will be used as the template identifier",
                    error: templateNameAvailability === false ? templateNameError : void 0,
                    tone: checkingTemplateName ? void 0 : templateNameAvailability === true ? "success" : templateNameAvailability === false ? "critical" : void 0,
                    autoComplete: "off"
                  }
                ),
                /* @__PURE__ */ jsxs(InlineStack, { gap: "400", children: [
                  /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                    Select,
                    {
                      label: "Category",
                      options: categoryOptions,
                      value: templateCategory,
                      onChange: setTemplateCategory
                    }
                  ) }),
                  /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                    Select,
                    {
                      label: "Language",
                      options: languageOptions,
                      value: templateLanguage,
                      onChange: setTemplateLanguage
                    }
                  ) })
                ] })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Body Text *" }),
              /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                  "Click to insert variables or create your own using ",
                  "{{ }}",
                  ":"
                ] }),
                /* @__PURE__ */ jsxs(InlineStack, { gap: "100", wrap: true, children: [
                  availableVariables.slice(0, 15).map((variable) => /* @__PURE__ */ jsx(
                    Button,
                    {
                      size: "micro",
                      variant: "tertiary",
                      onClick: () => insertVariable(variable.value),
                      children: variable.label
                    },
                    variable.value
                  )),
                  availableVariables.length > 15 && /* @__PURE__ */ jsxs(
                    Button,
                    {
                      size: "micro",
                      variant: "primary",
                      onClick: () => setShowVariablesModal(true),
                      children: [
                        "More Variables (",
                        availableVariables.length - 15,
                        ")"
                      ]
                    }
                  )
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { style: { position: "relative" }, children: [
                /* @__PURE__ */ jsxs("div", { style: { position: "absolute", bottom: 12, right: 6, zIndex: 99, display: "flex", gap: "4px", flexWrap: "wrap" }, children: [
                  /* @__PURE__ */ jsx(ButtonGroup, { variant: "segmented", children: /* @__PURE__ */ jsx(EmojiPicker, { onEmojiSelect: insertEmoji, buttonSize: "micro" }) }),
                  /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Bold",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘B" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bold"), accessibilityLabel: "Bold", children: /* @__PURE__ */ jsx(Text, { fontWeight: "bold", children: "B" }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Italic",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘I" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("italic"), accessibilityLabel: "Italic", children: /* @__PURE__ */ jsx(Text, { as: "em", children: "I" }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Strikethrough",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘S" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("strikethrough"), accessibilityLabel: "Strikethrough", children: /* @__PURE__ */ jsx(Text, { as: "s", children: "S" }) }) })
                  ] }),
                  /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Monospace",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘M" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("monospace"), accessibilityLabel: "Monospace", children: /* @__PURE__ */ jsxs(Text, { as: "code", children: [
                      " ",
                      "</>"
                    ] }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Inline Code",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘K" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("inline-code"), accessibilityLabel: "Inline Code", children: /* @__PURE__ */ jsx(Text, { as: "code", children: "<>" }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Quote",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘Q" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("quote"), accessibilityLabel: "Quote", children: '"' }) })
                  ] }),
                  /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Bullet List",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘L" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bullet-list"), accessibilityLabel: "Bullet List", children: "•" }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Numbered List",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘N" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("numbered-list"), accessibilityLabel: "Numbered List", children: "1." }) })
                  ] })
                ] }),
                /* @__PURE__ */ jsx(
                  TextField,
                  {
                    id: "body-text-field",
                    label: "Message Body",
                    value: bodyText,
                    onChange: setBodyText,
                    onSelect: handleTextSelection,
                    multiline: 8,
                    maxLength: 1024,
                    placeholder: "Type your catalog message body here... This message will introduce your product catalog. Formatting options: *bold*, _italic_, ~strikethrough~, ```monospace```, `inline code`, > quote, * bullet list, 1. numbered list. Use keyboard shortcuts or click buttons above.",
                    helpText: `${bodyText.length}/1024 characters`,
                    showCharacterCount: true,
                    autoComplete: "off"
                  }
                )
              ] }),
              extractVariables.length > 0 && /* @__PURE__ */ jsxs("div", { children: [
                /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "semibold", tone: "subdued", children: "Body Variable Mapping" }),
                /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", style: { marginBottom: "12px" }, children: "Map the variables in your body text to actual data fields:" }),
                /* @__PURE__ */ jsx(BlockStack, { gap: "300", children: extractVariables.map((variable, index2) => /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
                  /* @__PURE__ */ jsx(
                    TextField,
                    {
                      label: `Variable: {{${variable}}}`,
                      value: `{{${variable}}}`,
                      disabled: true,
                      helpText: "Template variable"
                    }
                  ),
                  /* @__PURE__ */ jsx(
                    Autocomplete,
                    {
                      options: availableVariables.filter((av) => {
                        const searchValue = variableInputValues[variable] || "";
                        return searchValue === "" || av.label.toLowerCase().includes(searchValue.toLowerCase());
                      }).map((av) => ({
                        value: av.value,
                        label: av.label
                      })),
                      selected: bodyVariableMapping[index2] ? [bodyVariableMapping[index2]] : [],
                      onSelect: (selected) => {
                        const value = selected.length > 0 ? selected[0] : "";
                        handleVariableSelectionChange(variable, value);
                        if (value) {
                          const selectedVar = availableVariables.find((av) => av.value === value);
                          setVariableInputValues((prev) => ({
                            ...prev,
                            [variable]: (selectedVar == null ? void 0 : selectedVar.label) || ""
                          }));
                        } else {
                          setVariableInputValues((prev) => ({
                            ...prev,
                            [variable]: ""
                          }));
                        }
                      },
                      textField: /* @__PURE__ */ jsx(
                        Autocomplete.TextField,
                        {
                          label: "Map to",
                          value: variableInputValues[variable] || "",
                          onChange: (value) => {
                            setVariableInputValues((prev) => ({
                              ...prev,
                              [variable]: value
                            }));
                          },
                          placeholder: "Search and choose data field",
                          autoComplete: "off"
                        }
                      ),
                      loading: loadingVariables,
                      emptyState: loadingVariables ? "Loading variables..." : "No variables found",
                      preferredPosition: "below"
                    }
                  )
                ] }, index2)) })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Footer Text (Optional)" }),
                /* @__PURE__ */ jsx(
                  Button,
                  {
                    variant: hasFooter ? "primary" : "plain",
                    onClick: () => setHasFooter(!hasFooter),
                    size: "slim",
                    children: hasFooter ? "Remove Footer" : "Add Footer"
                  }
                )
              ] }),
              hasFooter && /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Footer Text",
                  value: footerText,
                  onChange: setFooterText,
                  placeholder: "Enter footer text (e.g., Terms & Conditions apply)",
                  maxLength: 60,
                  showCharacterCount: true,
                  helpText: "Footer text appears at the bottom of the message",
                  autoComplete: "off"
                }
              )
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Catalog Button Text *" }),
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Button Text",
                  value: catalogButtonText,
                  onChange: setCatalogButtonText,
                  placeholder: "Enter catalog button text",
                  maxLength: 20,
                  showCharacterCount: true,
                  helpText: "This button will open your product catalog for customers",
                  autoComplete: "off"
                }
              ),
              /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "The catalog button will automatically link to your WhatsApp Business catalog, allowing customers to browse and select products directly from the chat." })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(InlineStack, { gap: "300", align: "end", children: [
              /* @__PURE__ */ jsx(
                Button,
                {
                  variant: "secondary",
                  onClick: handleCancel,
                  children: "Cancel"
                }
              ),
              /* @__PURE__ */ jsx(
                Button,
                {
                  variant: "primary",
                  onClick: handleSave,
                  disabled: !templateName || !bodyText || !catalogButtonText || templateNameAvailability !== true || checkingTemplateName,
                  children: "Save Catalog Template"
                }
              )
            ] }) })
          ] }) }) }),
          /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 4, lg: 4, xl: 4 }, children: /* @__PURE__ */ jsx("div", { style: { position: "sticky", top: "20px" }, children: /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Template Preview" }),
            generateTemplateJSON && (bodyText || hasFooter || catalogButtonText) ? /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", children: [
                "Template: ",
                templateName ? templateName.toLowerCase().replace(/\s+/g, "_") : "untitled_catalog_template"
              ] }),
              /* @__PURE__ */ jsx(
                WhatsAppPreview,
                {
                  template: generateTemplateJSON,
                  variant: "full",
                  maxWidth: "280px",
                  showWhatsAppHeader: false
                }
              ),
              /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "This is how your catalog template will appear to customers. The catalog button will open your product catalog when tapped." })
            ] }) : /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
              /* @__PURE__ */ jsx(Text, { as: "p", tone: "subdued", children: "Enter template details to see the preview" }),
              /* @__PURE__ */ jsx("div", { style: {
                padding: "16px",
                border: "1px solid #e1e3e5",
                borderRadius: "8px",
                backgroundColor: "#fafbfb"
              }, children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Your catalog template preview will appear here once you add template content (body text, footer, or catalog button)." }) })
            ] })
          ] }) }) }) })
        ] }),
        /* @__PURE__ */ jsx(
          Modal,
          {
            open: showVariablesModal,
            onClose: () => {
              setShowVariablesModal(false);
              setVariableSearchQuery("");
            },
            title: "All Available Variables",
            primaryAction: {
              content: "Close",
              onAction: () => {
                setShowVariablesModal(false);
                setVariableSearchQuery("");
              }
            },
            size: "large",
            children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", tone: "subdued", children: "Click on any variable to insert it into your template:" }),
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Search Variables",
                  value: variableSearchQuery,
                  onChange: setVariableSearchQuery,
                  placeholder: "Type to search variables...",
                  clearButton: true,
                  onClearButtonClick: () => setVariableSearchQuery(""),
                  autoComplete: "off"
                }
              ),
              /* @__PURE__ */ jsx(InlineStack, { gap: "200", wrap: true, children: availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).map((variable) => /* @__PURE__ */ jsx(
                Button,
                {
                  size: "medium",
                  variant: "tertiary",
                  onClick: () => {
                    insertVariable(variable.value);
                    setShowVariablesModal(false);
                    setVariableSearchQuery("");
                  },
                  children: variable.label
                },
                variable.value
              )) }),
              availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).length === 0 && variableSearchQuery && /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", tone: "subdued", alignment: "center", children: [
                'No variables found matching "',
                variableSearchQuery,
                '"'
              ] }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", tone: "subdued", children: [
                "You can also create custom variables using the format: ",
                "{{variable_name}}"
              ] })
            ] }) })
          }
        )
      ]
    }
  );
}
const route7 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: CreateCatalogTemplatePage
}, Symbol.toStringTag, { value: "Module" }));
const getWhatsappProfileJson = async () => {
  const response = await fetch(`https://app.getgabs.com/partners/settings/whatsappprofile/fetchprofile?JsonData=2`, {
    method: "GET",
    headers: {
      "Content-Type": "application/json",
      "Authorization": `Bearer ${API_TOKEN}`
    }
  });
  if (!response.ok) throw new Error("Failed to fetch template list");
  const data = await response.json();
  console.log("whatsapp profile json", data);
  return data;
};
const updateWhatsappProfile = async (updateWhatsappProfilePayload) => {
  try {
    const url = `https://app.getgabs.com/partners/settings/whatsappprofile/updatewpprofile`;
    const response = await fetch(url, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json",
        "Authorization": `Bearer ${API_TOKEN}`,
        "X-Requested-With": "XMLHttpRequest"
      },
      body: JSON.stringify(updateWhatsappProfilePayload)
    });
    const maybeJson = await response.json().catch(() => null);
    if (!response.ok) {
      const message = maybeJson && (maybeJson.message || maybeJson.error) || `HTTP ${response.status}`;
      throw new Error(message);
    }
    const data = maybeJson ?? {};
    const success = (data == null ? void 0 : data.status) === true || (data == null ? void 0 : data.success) === true || (data == null ? void 0 : data.status) === "success";
    if (!success) {
      throw new Error((data == null ? void 0 : data.message) || "Update whatsapp profile failed");
    }
    console.log("update whatsapp profile", data);
    return data;
  } catch (error) {
    console.error("Error updating whatsapp profile:", error);
    throw error;
  }
};
const getChatWidgetDataJson = async () => {
  const response = await fetch(`https://app.getgabs.com/partners/managechat/customertagmanage/chatwidget/fetchWidgetData?dataJson=1`, {
    method: "GET",
    headers: {
      "Content-Type": "application/json",
      "Authorization": `Bearer ${API_TOKEN}`
    }
  });
  if (!response.ok) throw new Error("Failed to fetch chat widget data");
  const data = await response.json();
  console.log("chat widget data", data);
  return data;
};
const updateWhatappchatWidget = async (updateWhatsappchatWidgetPayload) => {
  try {
    const url = `https://app.getgabs.com/partners/managechat/customertagmanage/chatwidget/updateWidgetData`;
    const response = await fetch(url, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json",
        "Authorization": `Bearer ${API_TOKEN}`,
        "X-Requested-With": "XMLHttpRequest"
      },
      body: JSON.stringify(updateWhatsappchatWidgetPayload)
    });
    const maybeJson = await response.json().catch(() => null);
    if (!response.ok) {
      const message = maybeJson && (maybeJson.message || maybeJson.error) || `HTTP ${response.status}`;
      throw new Error(message);
    }
    const data = maybeJson ?? {};
    const success = (data == null ? void 0 : data.status) === true || (data == null ? void 0 : data.success) === true || (data == null ? void 0 : data.status) === "success";
    if (!success) {
      throw new Error((data == null ? void 0 : data.message) || "Update whatsapp chat widget failed");
    }
    console.log("update whatsapp chat widget", data);
    return data;
  } catch (error) {
    console.error("Error updating whatsapp chat widget:", error);
    throw error;
  }
};
function ManageWhatsAppProfilePage() {
  const [isLoading, setIsLoading] = useState(true);
  const [error, setError] = useState(null);
  const [successMessage, setSuccessMessage] = useState("");
  const [businessName, setBusinessName] = useState("Your Business Name");
  const [businessAbout, setBusinessAbout] = useState("Quality products and excellent service");
  const [businessDescription, setBusinessDescription] = useState("We are a leading provider of high-quality products with a focus on customer satisfaction. Our team is dedicated to delivering exceptional service and building lasting relationships with our customers.");
  const [businessEmail, setBusinessEmail] = useState("contact@yourbusiness.com");
  const [businessPhone, setBusinessPhone] = useState("+1234567890");
  const [businessAddress, setBusinessAddress] = useState("123 Business Street, City, State 12345");
  const [businessWebsite, setBusinessWebsite] = useState("https://www.yourbusiness.com");
  const [businessCategory, setBusinessCategory] = useState("RETAIL");
  const [businessLogo, setBusinessLogo] = useState(null);
  const [logoPreview, setLogoPreview] = useState(null);
  const [logoError, setLogoError] = useState("");
  const fileInputRef = useRef(null);
  const [selectedTab, setSelectedTab] = useState(0);
  useEffect(() => {
    const fetchProfileData = async () => {
      try {
        setIsLoading(true);
        setError(null);
        const response = await getWhatsappProfileJson();
        if (response.status && response.message) {
          const profileData = response.message;
          setBusinessName(profileData.business_name || "Your Business Name");
          setBusinessAbout(profileData.about || "Quality products and excellent service");
          setBusinessDescription(profileData.description || "We are a leading provider of high-quality products with a focus on customer satisfaction. Our team is dedicated to delivering exceptional service and building lasting relationships with our customers.");
          setBusinessEmail(profileData.email || "contact@yourbusiness.com");
          setBusinessAddress(profileData.address || "123 Business Street, City, State 12345");
          setBusinessWebsite(profileData.website1 || "https://www.yourbusiness.com");
          setBusinessCategory(profileData.vertical || "RETAIL");
          if (profileData.profile_picture_url) {
            setLogoPreview(`https://app.getgabs.com/customers/mediafile/${profileData.profile_picture_url}`);
          }
        }
      } catch (err) {
        console.error("Error fetching WhatsApp profile:", err);
        setError("Failed to load WhatsApp profile data. Please try again.");
      } finally {
        setIsLoading(false);
      }
    };
    fetchProfileData();
  }, []);
  const handleSave = useCallback(async () => {
    try {
      setError(null);
      setSuccessMessage("");
      const payload = {
        ...logoPreview && typeof logoPreview === "string" && logoPreview.startsWith("data:") ? { profile_logo: logoPreview } : {},
        vertical: businessCategory,
        about: businessAbout,
        description: businessDescription,
        address: businessAddress,
        email: businessEmail,
        website: businessWebsite
      };
      const resp = await updateWhatsappProfile(payload);
      if (resp) {
        setSuccessMessage("WhatsApp profile updated successfully.");
      }
    } catch (e) {
      setError((e == null ? void 0 : e.message) || "Failed to update WhatsApp profile.");
    }
  }, [logoPreview, businessCategory, businessAbout, businessDescription, businessAddress, businessEmail, businessWebsite]);
  const categoryOptions = [
    { label: "UNDEFINED", value: "UNDEFINED" },
    { label: "OTHER", value: "OTHER" },
    { label: "AUTO", value: "AUTO" },
    { label: "BEAUTY", value: "BEAUTY" },
    { label: "APPAREL", value: "APPAREL" },
    { label: "EDU", value: "EDU" },
    { label: "ENTERTAIN", value: "ENTERTAIN" },
    { label: "EVENT PLAN", value: "EVENT_PLAN" },
    { label: "FINANCE", value: "FINANCE" },
    { label: "GROCERY", value: "GROCERY" },
    { label: "GOVT", value: "GOVT" },
    { label: "HOTEL", value: "HOTEL" },
    { label: "HEALTH", value: "HEALTH" },
    { label: "NONPROFIT", value: "NONPROFIT" },
    { label: "PROF SERVICES", value: "PROF_SERVICES" },
    { label: "RETAIL", value: "RETAIL" },
    { label: "TRAVEL", value: "TRAVEL" },
    { label: "RESTAURANT", value: "RESTAURANT" },
    { label: "ALCOHOL", value: "ALCOHOL" },
    { label: "ONLINE GAMBLING", value: "ONLINE_GAMBLING" },
    { label: "PHYSICAL GAMBLING", value: "PHYSICAL_GAMBLING" },
    { label: "OTC DRUGS", value: "OTC_DRUGS" }
  ];
  const handleLogoUpload = useCallback((files) => {
    const file = files[0];
    if (!file) return;
    if (!file.type.includes("image/jpeg") && !file.type.includes("image/png")) {
      setLogoError("Please upload a JPEG or PNG image file.");
      return;
    }
    if (file.size > 5 * 1024 * 1024) {
      setLogoError("File size must not exceed 5MB.");
      return;
    }
    const reader = new FileReader();
    reader.onload = (e) => {
      setLogoPreview(e.target.result);
      setBusinessLogo(file);
      setLogoError("");
    };
    reader.readAsDataURL(file);
  }, []);
  const handleRemoveLogo = useCallback(() => {
    setBusinessLogo(null);
    setLogoPreview(null);
    setLogoError("");
    if (fileInputRef.current) {
      fileInputRef.current.value = "";
    }
  }, []);
  const renderProfilePreview = () => /* @__PURE__ */ jsx(Card, { sectioned: true, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
    /* @__PURE__ */ jsx(Text, { variant: "headingMd", children: "Business Profile Preview" }),
    /* @__PURE__ */ jsx(Divider, {}),
    /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
      /* @__PURE__ */ jsx(Text, { variant: "bodyMd", fontWeight: "medium", children: "Business Logo" }),
      /* @__PURE__ */ jsx("div", { style: { textAlign: "center" }, children: logoPreview ? /* @__PURE__ */ jsx("div", { style: {
        width: "120px",
        height: "120px",
        borderRadius: "12px",
        overflow: "hidden",
        margin: "0 auto",
        border: "2px solid #e1e3e5"
      }, children: /* @__PURE__ */ jsx(
        "img",
        {
          src: logoPreview,
          alt: "Business Logo",
          style: {
            width: "100%",
            height: "100%",
            objectFit: "cover"
          }
        }
      ) }) : /* @__PURE__ */ jsx("div", { style: {
        width: "120px",
        height: "120px",
        borderRadius: "12px",
        backgroundColor: "#f6f6f7",
        border: "2px dashed #c9cccf",
        display: "flex",
        alignItems: "center",
        justifyContent: "center",
        margin: "0 auto"
      }, children: /* @__PURE__ */ jsx(Icon, { source: ImageIcon, color: "subdued" }) }) })
    ] }),
    /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
      /* @__PURE__ */ jsx("div", { style: { textAlign: "center" }, children: /* @__PURE__ */ jsx(Text, { variant: "headingMd", children: businessName }) }),
      /* @__PURE__ */ jsx(BlockStack, { gap: "200", children: /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx(Text, { variant: "bodySm", color: "subdued", children: "About " }),
        /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: businessAbout })
      ] }) })
    ] }),
    /* @__PURE__ */ jsx(BlockStack, { gap: "300", children: /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx(Text, { variant: "bodySm", color: "subdued", children: "Description" }),
        /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: businessDescription })
      ] }),
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx(Text, { variant: "bodySm", color: "subdued", children: "Address" }),
        /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: businessAddress })
      ] }),
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx(Text, { variant: "bodySm", color: "subdued", children: "Email" }),
        /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: businessEmail })
      ] }),
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx(Text, { variant: "bodySm", color: "subdued", children: "Website" }),
        /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: businessWebsite })
      ] })
    ] }) })
  ] }) });
  const renderProfileForm = () => /* @__PURE__ */ jsxs(BlockStack, { gap: "500", children: [
    /* @__PURE__ */ jsx(Card, { sectioned: true, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
      /* @__PURE__ */ jsx(Text, { variant: "headingMd", children: "Business Logo" }),
      /* @__PURE__ */ jsx(Text, { variant: "bodySm", color: "subdued", children: "Use a square image with a recommended size of 500x500 pixels (minimum 192x192 pixels) and a file size not exceeding 5MB." }),
      logoError && /* @__PURE__ */ jsx(Banner, { status: "critical", children: /* @__PURE__ */ jsx("p", { children: logoError }) }),
      /* @__PURE__ */ jsx(DropZone, { onDrop: handleLogoUpload, accept: "image/jpeg,image/png", children: logoPreview ? /* @__PURE__ */ jsxs("div", { style: { textAlign: "center", paddingTop: "10px", paddingBottom: "10px" }, children: [
        /* @__PURE__ */ jsx("div", { style: { textAlign: "center", display: "flex", alignItems: "center", justifyContent: "center" }, children: /* @__PURE__ */ jsx(
          Thumbnail,
          {
            source: logoPreview,
            alt: "Business Logo",
            size: "large"
          }
        ) }),
        /* @__PURE__ */ jsx("div", { style: { marginTop: "16px" }, children: /* @__PURE__ */ jsx(Button, { onClick: handleRemoveLogo, children: "Remove Logo" }) })
      ] }) : /* @__PURE__ */ jsx(DropZone.FileUpload, {}) }),
      /* @__PURE__ */ jsx(Text, { variant: "bodySm", color: "subdued", children: "Choose a file • JPEG, PNG" })
    ] }) }),
    /* @__PURE__ */ jsx(Card, { sectioned: true, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
      /* @__PURE__ */ jsx(Text, { variant: "headingMd", children: "About Business" }),
      /* @__PURE__ */ jsx(Text, { variant: "bodySm", color: "subdued", children: "Provide your business category and a short bio (up to 20 words) that clearly describe your services, products, or mission." }),
      /* @__PURE__ */ jsxs(FormLayout, { children: [
        /* @__PURE__ */ jsx(
          TextField,
          {
            label: "Business Name",
            value: businessName,
            onChange: setBusinessName,
            helpText: "This will be displayed as your business name on WhatsApp",
            placeholder: "Enter your business name"
          }
        ),
        /* @__PURE__ */ jsx(
          Select,
          {
            label: "Business Category",
            options: categoryOptions,
            value: businessCategory,
            onChange: setBusinessCategory,
            helpText: "Select the category that best describes your business"
          }
        ),
        /* @__PURE__ */ jsx(
          TextField,
          {
            label: "About",
            value: businessAbout,
            onChange: setBusinessAbout,
            helpText: `Brief description of your business (${businessAbout.split(" ").length}/20 words)`,
            placeholder: "Quality products and excellent service",
            maxLength: 200
          }
        )
      ] })
    ] }) }),
    /* @__PURE__ */ jsx(Card, { sectioned: true, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
      /* @__PURE__ */ jsx(Text, { variant: "headingMd", children: "More Details" }),
      /* @__PURE__ */ jsx(Text, { variant: "bodySm", color: "subdued", children: "Add your business description, address, email, and website to your WhatsApp Business profile for better visibility and customer engagement." }),
      /* @__PURE__ */ jsxs(FormLayout, { children: [
        /* @__PURE__ */ jsx(
          TextField,
          {
            label: "Description",
            value: businessDescription,
            onChange: setBusinessDescription,
            multiline: 4,
            helpText: "Detailed description of your business, products, or services",
            placeholder: "Tell customers about your business..."
          }
        ),
        /* @__PURE__ */ jsx(
          TextField,
          {
            label: "Address",
            value: businessAddress,
            onChange: setBusinessAddress,
            helpText: "Your business address for customer visits",
            placeholder: "123 Business Street, City, State 12345"
          }
        ),
        /* @__PURE__ */ jsx(
          TextField,
          {
            label: "Email",
            value: businessEmail,
            onChange: setBusinessEmail,
            type: "email",
            helpText: "Business email for customer inquiries",
            placeholder: "contact@yourbusiness.com"
          }
        ),
        /* @__PURE__ */ jsx(
          TextField,
          {
            label: "Website",
            value: businessWebsite,
            onChange: setBusinessWebsite,
            type: "url",
            helpText: "Your business website URL",
            placeholder: "https://www.yourbusiness.com"
          }
        )
      ] })
    ] }) }),
    /* @__PURE__ */ jsx(Card, { sectioned: true, children: /* @__PURE__ */ jsx(InlineStack, { align: "end", children: /* @__PURE__ */ jsx(Button, { primary: true, onClick: handleSave, size: "large", children: "Update WhatsApp Profile" }) }) })
  ] });
  if (isLoading) {
    return /* @__PURE__ */ jsx(Page, { title: "Manage WhatsApp Profile", fullWidth: true, children: /* @__PURE__ */ jsx(Layout, { children: /* @__PURE__ */ jsx(Layout.Section, { children: /* @__PURE__ */ jsx(Card, { sectioned: true, children: /* @__PURE__ */ jsxs("div", { style: { textAlign: "center", padding: "40px" }, children: [
      /* @__PURE__ */ jsx(Spinner, { size: "large" }),
      /* @__PURE__ */ jsx("div", { style: { marginTop: "16px" }, children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: "Loading WhatsApp profile data..." }) })
    ] }) }) }) }) });
  }
  return /* @__PURE__ */ jsx(
    Page,
    {
      title: "Manage WhatsApp Profile",
      subtitle: "Configure your business profile and WhatsApp settings",
      primaryAction: {
        content: "Update WhatsApp Profile",
        onAction: handleSave
      },
      fullWidth: true,
      children: /* @__PURE__ */ jsxs(Layout, { children: [
        successMessage && /* @__PURE__ */ jsx(Layout.Section, { children: /* @__PURE__ */ jsx(Banner, { status: "success", children: /* @__PURE__ */ jsx("p", { children: successMessage }) }) }),
        error && /* @__PURE__ */ jsx(Layout.Section, { children: /* @__PURE__ */ jsx(Banner, { status: "critical", children: /* @__PURE__ */ jsx("p", { children: error }) }) }),
        /* @__PURE__ */ jsx(Layout.Section, { variant: "twoThirds", children: renderProfileForm() }),
        /* @__PURE__ */ jsx(Layout.Section, { variant: "oneThird", children: /* @__PURE__ */ jsx("div", { style: { position: "sticky", top: "20px" }, children: renderProfilePreview() }) })
      ] })
    }
  );
}
const route8 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: ManageWhatsAppProfilePage
}, Symbol.toStringTag, { value: "Module" }));
const fetchAbandonedCartTriggerList = async (options = {}) => {
  const {
    page = 1,
    perPageData = 20,
    TriggerCategory = 1
  } = options;
  try {
    const url = new URL(buildApiUrl(`${ENDPOINTS.ABANDONED_CART.BASE}/${ENDPOINTS.ABANDONED_CART.GET_ABANDONED_CART_LIST}`));
    url.searchParams.append("page", page.toString());
    url.searchParams.append("perPageData", perPageData.toString());
    url.searchParams.append("TriggerCategory", TriggerCategory.toString());
    url.searchParams.append("token", API_TOKEN);
    const response = await fetch(url.toString(), {
      method: "GET",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json"
      }
    });
    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }
    const data = await response.json();
    return data;
  } catch (error) {
    console.error("Error fetching abandoned cart list:", error);
    throw error;
  }
};
const fetchAbandonedList = async (options = {}) => {
  const {
    page = 1,
    perPageData = 20
  } = options;
  try {
    const url = new URL(buildApiUrl(`${ENDPOINTS.ABANDONED_LIST.BASE}/${ENDPOINTS.ABANDONED_LIST.GET_ABANDONED_LIST}`));
    url.searchParams.append("page", page.toString());
    url.searchParams.append("perPageData", perPageData.toString());
    url.searchParams.append("token", API_TOKEN);
    const response = await fetch(url.toString(), {
      method: "GET",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json"
      }
    });
    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }
    const data = await response.json();
    return data;
  } catch (error) {
    console.error("Error fetching abandoned cart list:", error);
    throw error;
  }
};
const createAbandonedCartTrigger = async (createAbandonedCartTriggerPayload) => {
  try {
    const url = `http://app.getgabs.com/partners/template/notification/saveTrigger`;
    const response = await fetch(url, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json",
        "Authorization": `Bearer ${API_TOKEN}`,
        "X-Requested-With": "XMLHttpRequest"
      },
      body: JSON.stringify(createAbandonedCartTriggerPayload)
    });
    const maybeJson = await response.json().catch(() => null);
    if (!response.ok) {
      const message = maybeJson && (maybeJson.message || maybeJson.error) || `HTTP ${response.status}`;
      throw new Error(message);
    }
    const data = maybeJson ?? {};
    const success = (data == null ? void 0 : data.status) === true || (data == null ? void 0 : data.success) === true || (data == null ? void 0 : data.status) === "success";
    if (!success) {
      throw new Error((data == null ? void 0 : data.message) || "Create abandoned cart trigger failed");
    }
    console.log("create abandoned cart trigger", data);
    return data;
  } catch (error) {
    console.error("Error creating abandoned cart trigger:", error);
    throw error;
  }
};
function AbandonedCartList() {
  const sleep = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
  const [selectedProduct, setSelectedProduct] = useState(null);
  const [previewModalActive, setPreviewModalActive] = useState(false);
  const [itemStrings, setItemStrings] = useState([
    "All Abandoned Carts"
  ]);
  const [selected, setSelected] = useState(0);
  const [queryValue, setQueryValue] = useState("");
  const [sortSelected, setSortSelected] = useState(["name asc"]);
  const [statusFilter, setStatusFilter2] = useState([]);
  const [collectionFilter, setCollectionFilter] = useState("");
  const [priceRange, setPriceRange] = useState([0, 500]);
  const { mode: mode2, setMode } = useSetIndexFiltersMode();
  const [abandonedCarts, setAbandonedCarts] = useState([]);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);
  const [apiPagination, setApiPagination] = useState(null);
  const [currentPage, setCurrentPage] = useState(1);
  const itemsPerPage = 20;
  const fetchAbandonedCartData = useCallback(async (page = 1) => {
    try {
      setLoading(true);
      setError(null);
      const response = await fetchAbandonedList({
        page,
        perPageData: itemsPerPage
      });
      if (response.status && response.data) {
        const transformedData = response.data.customerData.data.map((cart) => ({
          id: cart.last_id,
          customerName: `${cart.customer.first_name} ${cart.customer.last_name}`.trim(),
          firstName: cart.customer.first_name,
          lastName: cart.customer.last_name,
          email: cart.customer.email || "N/A",
          phone: cart.customer.phone,
          image: cart.customer.image,
          address: cart.customer.default_address || "N/A",
          cartValue: `${cart.total_price} ${cart.currency}`,
          cartQuantity: cart.line_items.reduce((total, item) => total + item.quantity, 0),
          createdAt: cart.created_at,
          completedAt: cart.completed_at,
          lineItems: cart.line_items,
          lifetimeDuration: cart.customer.lifetime_duration,
          numberOfOrders: cart.customer.number_of_orders
        }));
        setAbandonedCarts(transformedData);
        setApiPagination(response.data.customerData);
      }
    } catch (err) {
      console.error("Error fetching abandoned cart data:", err);
      setError("Failed to load abandoned cart data. Please try again.");
    } finally {
      setLoading(false);
    }
  }, [itemsPerPage]);
  useEffect(() => {
    fetchAbandonedCartData(currentPage);
  }, [fetchAbandonedCartData, currentPage]);
  const deleteView = (index2) => {
    const newItemStrings = [...itemStrings];
    newItemStrings.splice(index2, 1);
    setItemStrings(newItemStrings);
    setSelected(0);
  };
  const duplicateView = async (name) => {
    setItemStrings([...itemStrings, name]);
    setSelected(itemStrings.length);
    await sleep(1);
    return true;
  };
  const onCreateNewView = async (value) => {
    await sleep(500);
    setItemStrings([...itemStrings, value]);
    setSelected(itemStrings.length);
    return true;
  };
  const tabs = itemStrings.map((item, index2) => ({
    content: item,
    index: index2,
    onAction: () => {
    },
    id: `${item}-${index2}`,
    isLocked: index2 === 0,
    actions: index2 === 0 ? [] : [
      {
        type: "rename",
        onAction: () => {
        },
        onPrimaryAction: async (value) => {
          const newItemsStrings = tabs.map((item2, idx) => {
            if (idx === index2) {
              return value;
            }
            return item2.content;
          });
          await sleep(1);
          setItemStrings(newItemsStrings);
          return true;
        }
      },
      {
        type: "duplicate",
        onPrimaryAction: async (value) => {
          await sleep(1);
          duplicateView(value);
          return true;
        }
      },
      {
        type: "edit"
      },
      {
        type: "delete",
        onPrimaryAction: async () => {
          await sleep(1);
          deleteView(index2);
          return true;
        }
      }
    ]
  }));
  const filteredCarts = useMemo(() => {
    let filtered = abandonedCarts;
    return filtered.filter((cart) => {
      const matchesSearch = cart.customerName.toLowerCase().includes(queryValue.toLowerCase()) || cart.email.toLowerCase().includes(queryValue.toLowerCase()) || cart.phone.toLowerCase().includes(queryValue.toLowerCase());
      const cartValueNum = parseFloat(cart.cartValue.split(" ")[0]);
      const matchesPrice = cartValueNum >= priceRange[0] && cartValueNum <= priceRange[1];
      return matchesSearch && matchesPrice;
    });
  }, [abandonedCarts, queryValue, priceRange]);
  useMemo(() => {
    const sorted = [...filteredCarts];
    const [sortKey, sortDirection] = sortSelected[0].split(" ");
    sorted.sort((a, b) => {
      let aValue, bValue;
      switch (sortKey) {
        case "name":
          aValue = a.customerName.toLowerCase();
          bValue = b.customerName.toLowerCase();
          break;
        case "email":
          aValue = a.email.toLowerCase();
          bValue = b.email.toLowerCase();
          break;
        case "phone":
          aValue = a.phone.toLowerCase();
          bValue = b.phone.toLowerCase();
          break;
        case "cartValue":
          aValue = parseFloat(a.cartValue.split(" ")[0]);
          bValue = parseFloat(b.cartValue.split(" ")[0]);
          break;
        case "cartQuantity":
          aValue = a.cartQuantity;
          bValue = b.cartQuantity;
          break;
        case "createdAt":
          aValue = new Date(a.createdAt);
          bValue = new Date(b.createdAt);
          break;
        default:
          return 0;
      }
      if (aValue < bValue) return sortDirection === "asc" ? -1 : 1;
      if (aValue > bValue) return sortDirection === "asc" ? 1 : -1;
      return 0;
    });
    return sorted;
  }, [filteredCarts, sortSelected]);
  const paginatedCarts = abandonedCarts;
  const handlePreviousPage = useCallback(() => {
    if (apiPagination && apiPagination.prev_page_url) {
      setCurrentPage((prev) => Math.max(1, prev - 1));
    }
  }, [apiPagination]);
  const handleNextPage = useCallback(() => {
    if (apiPagination && apiPagination.next_page_url) {
      setCurrentPage((prev) => prev + 1);
    }
  }, [apiPagination]);
  const totalItems = (apiPagination == null ? void 0 : apiPagination.total) || 0;
  (apiPagination == null ? void 0 : apiPagination.last_page) || 1;
  const startItem = (apiPagination == null ? void 0 : apiPagination.from) || 0;
  const endItem = (apiPagination == null ? void 0 : apiPagination.to) || 0;
  const hasNext = !!(apiPagination == null ? void 0 : apiPagination.next_page_url);
  const hasPrevious = !!(apiPagination == null ? void 0 : apiPagination.prev_page_url);
  const sortOptions = [
    { label: "Customer Name", value: "name asc", directionLabel: "A-Z" },
    { label: "Customer Name", value: "name desc", directionLabel: "Z-A" },
    { label: "Email", value: "email asc", directionLabel: "A-Z" },
    { label: "Email", value: "email desc", directionLabel: "Z-A" },
    { label: "Cart Value", value: "cartValue asc", directionLabel: "Low to High" },
    { label: "Cart Value", value: "cartValue desc", directionLabel: "High to Low" },
    { label: "Cart Quantity", value: "cartQuantity asc", directionLabel: "Low to High" },
    { label: "Cart Quantity", value: "cartQuantity desc", directionLabel: "High to Low" },
    { label: "Created Date", value: "createdAt asc", directionLabel: "Oldest First" },
    { label: "Created Date", value: "createdAt desc", directionLabel: "Newest First" }
  ];
  const handlePreviewClick = useCallback((product) => {
    setSelectedProduct(product);
    setPreviewModalActive(true);
  }, []);
  const handleModalClose = useCallback(() => {
    setPreviewModalActive(false);
    setSelectedProduct(null);
  }, []);
  const handleFiltersQueryChange = useCallback((value) => {
    setQueryValue(value);
  }, []);
  const handleQueryValueRemove = useCallback(() => setQueryValue(""), []);
  const handlePriceRangeChange = useCallback((value) => {
    setPriceRange(value);
  }, []);
  const handlePriceRangeRemove = useCallback(() => setPriceRange([0, 500]), []);
  const handleFiltersClearAll = useCallback(() => {
    handlePriceRangeRemove();
    handleQueryValueRemove();
  }, [handlePriceRangeRemove, handleQueryValueRemove]);
  const onHandleCancel = () => {
  };
  const onHandleSave = async () => {
    await sleep(1);
    return true;
  };
  const primaryAction = selected === 0 ? {
    type: "save-as",
    onAction: onCreateNewView,
    disabled: false,
    loading: false
  } : {
    type: "save",
    onAction: onHandleSave,
    disabled: false,
    loading: false
  };
  const filters = [
    {
      key: "priceRange",
      label: "Cart Value Range",
      filter: /* @__PURE__ */ jsx(
        RangeSlider,
        {
          label: "Cart value range",
          labelHidden: true,
          value: priceRange || [0, 500],
          prefix: "₹",
          output: true,
          min: 0,
          max: 500,
          step: 5,
          onChange: handlePriceRangeChange
        }
      )
    }
  ];
  const appliedFilters = [];
  if (priceRange && (priceRange[0] !== 0 || priceRange[1] !== 500)) {
    appliedFilters.push({
      key: "priceRange",
      label: disambiguateLabel("priceRange", priceRange),
      onRemove: handlePriceRangeRemove
    });
  }
  const resourceName = {
    singular: "abandoned cart",
    plural: "abandoned carts"
  };
  const { selectedResources, allResourcesSelected, handleSelectionChange } = useIndexResourceState(paginatedCarts);
  function disambiguateLabel(key, value) {
    switch (key) {
      case "priceRange":
        return `Cart value is between ₹${value[0]} and ₹${value[1]}`;
      default:
        return value;
    }
  }
  const formatDate = (dateString) => {
    const date = new Date(dateString);
    return date.toLocaleDateString("en-US", {
      year: "numeric",
      month: "short",
      day: "numeric",
      hour: "2-digit",
      minute: "2-digit"
    });
  };
  const rowMarkup = paginatedCarts.map(
    (cart, index2) => /* @__PURE__ */ jsxs(
      IndexTable.Row,
      {
        id: cart.id,
        selected: selectedResources.includes(cart.id),
        position: index2,
        children: [
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsxs(InlineStack, { gap: "300", align: "start", children: [
            /* @__PURE__ */ jsx(
              Thumbnail,
              {
                source: cart.image,
                alt: cart.customerName,
                size: "small"
              }
            ),
            /* @__PURE__ */ jsxs(BlockStack, { gap: "100", children: [
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", fontWeight: "semibold", as: "span", children: cart.customerName }),
              /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", as: "span", children: cart.phone })
            ] })
          ] }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "span", children: cart.email }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "span", children: cart.address }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", fontWeight: "semibold", as: "span", tone: "success", children: cart.cartValue }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsxs(Badge, { tone: "info", children: [
            cart.cartQuantity,
            " items"
          ] }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "span", children: formatDate(cart.createdAt) }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(InlineStack, { align: "end", children: /* @__PURE__ */ jsx(Tooltip, { content: "View cart details", children: /* @__PURE__ */ jsx(
            Button,
            {
              size: "slim",
              onClick: (event) => {
                event.stopPropagation();
                handlePreviewClick(cart);
              },
              children: /* @__PURE__ */ jsx(Icon, { source: ViewIcon })
            }
          ) }) }) })
        ]
      },
      cart.id
    )
  );
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(
      Page,
      {
        title: "All Abandoned Cart List",
        subtitle: "Manage your Abandoned Cart",
        fullWidth: true,
        primaryAction: {
          content: /* @__PURE__ */ jsxs(InlineStack, { alignment: "center", children: [
            /* @__PURE__ */ jsx(Icon, { source: RefreshIcon }),
            /* @__PURE__ */ jsx(Text, { as: "span", children: "Sync" })
          ] }),
          onAction: () => fetchAbandonedCartData(currentPage)
        },
        children: [
          error && /* @__PURE__ */ jsx(Banner, { tone: "critical", onDismiss: () => setError(null), children: /* @__PURE__ */ jsx("p", { children: error }) }),
          /* @__PURE__ */ jsx(LegacyCard, { children: loading ? /* @__PURE__ */ jsxs("div", { style: { padding: "40px", textAlign: "center" }, children: [
            /* @__PURE__ */ jsx(Spinner, { accessibilityLabel: "Loading abandoned carts", size: "large" }),
            /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: "Loading abandoned carts..." })
          ] }) : /* @__PURE__ */ jsxs(Fragment, { children: [
            /* @__PURE__ */ jsx(
              IndexFilters,
              {
                sortOptions,
                sortSelected,
                queryValue,
                queryPlaceholder: "Search customers...",
                onQueryChange: handleFiltersQueryChange,
                onQueryClear: () => setQueryValue(""),
                onSort: setSortSelected,
                primaryAction,
                cancelAction: {
                  onAction: onHandleCancel,
                  disabled: false,
                  loading: false
                },
                tabs,
                selected,
                onSelect: setSelected,
                canCreateNewView: true,
                onCreateNewView,
                filters,
                appliedFilters,
                onClearAll: handleFiltersClearAll,
                mode: mode2,
                setMode
              }
            ),
            /* @__PURE__ */ jsx(
              IndexTable,
              {
                resourceName,
                itemCount: paginatedCarts.length,
                selectedItemsCount: allResourcesSelected ? "All" : selectedResources.length,
                onSelectionChange: handleSelectionChange,
                headings: [
                  { title: "Customer" },
                  { title: "Email" },
                  { title: "Address" },
                  { title: "Cart Value" },
                  { title: "Quantity" },
                  { title: "Created" },
                  { title: "Actions", alignment: "end" }
                ],
                children: rowMarkup
              }
            ),
            totalItems > 0 && /* @__PURE__ */ jsx(
              "div",
              {
                style: {
                  maxWidth: "700px",
                  margin: "auto",
                  border: "1px solid var(--p-color-border)",
                  marginTop: "16px"
                },
                children: /* @__PURE__ */ jsx(
                  Pagination,
                  {
                    onPrevious: hasPrevious ? handlePreviousPage : void 0,
                    onNext: hasNext ? handleNextPage : void 0,
                    type: "table",
                    hasNext,
                    hasPrevious,
                    label: `${startItem}-${endItem} of ${totalItems} abandoned carts`
                  }
                )
              }
            )
          ] }) })
        ]
      }
    ),
    selectedProduct && /* @__PURE__ */ jsx(
      Modal,
      {
        open: previewModalActive,
        onClose: handleModalClose,
        title: `Cart Details: ${selectedProduct.customerName}`,
        primaryAction: {
          content: "Close",
          onAction: handleModalClose
        },
        secondaryActions: [
          {
            content: "Send Message",
            onAction: () => {
              console.log("Send message to:", selectedProduct.id);
              handleModalClose();
            }
          }
        ],
        children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsxs(InlineStack, { align: "center", gap: "400", children: [
            /* @__PURE__ */ jsx(
              Thumbnail,
              {
                source: selectedProduct.image,
                alt: selectedProduct.customerName,
                size: "large"
              }
            ),
            /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: selectedProduct.customerName }),
              /* @__PURE__ */ jsx(Text, { variant: "headingLg", as: "p", tone: "success", children: selectedProduct.cartValue }),
              /* @__PURE__ */ jsxs(Badge, { tone: "info", children: [
                selectedProduct.cartQuantity,
                " items"
              ] })
            ] })
          ] }),
          /* @__PURE__ */ jsxs(TextContainer, { children: [
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Email:" }),
              " ",
              selectedProduct.email
            ] }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Phone:" }),
              " ",
              selectedProduct.phone
            ] }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Address:" }),
              " ",
              selectedProduct.address
            ] }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Created:" }),
              " ",
              formatDate(selectedProduct.createdAt)
            ] }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Customer Lifetime:" }),
              " ",
              selectedProduct.lifetimeDuration
            ] }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Number of Orders:" }),
              " ",
              selectedProduct.numberOfOrders
            ] })
          ] }),
          selectedProduct.lineItems && selectedProduct.lineItems.length > 0 && /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingSm", as: "h4", children: "Cart Items:" }),
            selectedProduct.lineItems.map((item, index2) => /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
              /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "span", children: [
                item.title,
                " ",
                item.variant_title ? `(${item.variant_title})` : ""
              ] }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "span", children: [
                "Qty: ",
                item.quantity
              ] })
            ] }, index2))
          ] })
        ] }) })
      }
    )
  ] });
}
const route9 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: AbandonedCartList
}, Symbol.toStringTag, { value: "Module" }));
const messageTemplateOptions = [
  {
    id: "JDJD723KDKD1",
    label: "Diwali Offer Template",
    category: "Marketing",
    value: JSON.stringify({
      sender: "",
      campaign_id: "put_campaign_id",
      messaging_product: "whatsapp",
      recipient_type: "individual",
      to: "receiver_number",
      type: "template",
      template: {
        name: "pandit_diwali_offer",
        language: {
          code: "en_US"
        },
        components: [
          {
            type: "HEADER",
            format: "IMAGE",
            example: {
              header_handle: [
                "https://scontent.whatsapp.net/v/t61.29466-34/516934587_1244266223766536_2941614163967020774_n.jpg?ccb=1-7&_nc_sid=8b1bef&_nc_ohc=tKid-3GgrswQ7kNvwHo84gW&_nc_oc=AdnphcBXJRz-TbiJtAGzDpS9t_UOdtFRT7cwRkT2zwXz8S4AP8R14BT5AzskHhHm0Ks&_nc_zt=3&_nc_ht=scontent.whatsapp.net&edm=AH51TzQEAAAA&_nc_gid=vrOUkqB-cMtr5uhuY6dcGA&oh=01_Q5Aa2gHZYGa3Bvw7r5MEu3IvlVy6SsiPCOLVGcxkQhOVFr8x-w&oe=68EF2357"
              ]
            }
          },
          {
            type: "BODY",
            text: "*Diwali Offer on Recharge on 99Pandit*<br><br>Namskar {{customer_name}}<br><br>We have launched an Offer on *99Pandit Wallet Recharge*.<br><br>*SAVE GST TAX of 18%* <br><br>Also *Get upto 48% Extra Wallet Points* on all Recharge till 31st Oct. <br><br>_Don't Miss this opportunity._ <br><br>Please send screen shot of payment on this number or to 99pandit."
          },
          {
            type: "FOOTER",
            text: "reply STOP to unsubscribe"
          },
          {
            type: "BUTTONS",
            buttons: [
              {
                type: "QUICK_REPLY",
                text: "Interesting Diwali Offer"
              }
            ]
          }
        ]
      }
    })
  },
  {
    id: "JDJD723KDK12",
    label: "Abandoned Cart Recovery",
    category: "Marketing",
    value: JSON.stringify({
      sender: "",
      campaign_id: "put_campaign_id",
      messaging_product: "whatsapp",
      recipient_type: "individual",
      to: "receiver_number",
      type: "template",
      template: {
        name: "abandoned_cart_recovery",
        language: {
          code: "en_US"
        },
        components: [
          {
            type: "BODY",
            text: "Hi {{1}}! 👋 You left some amazing items in your cart. Complete your purchase now and get 10% off with code SAVE10!",
            example: {
              body_text: [
                [
                  "customer name"
                ]
              ]
            }
          },
          {
            type: "BUTTONS",
            buttons: [
              {
                type: "QUICK_REPLY",
                text: "Complete Purchase"
              }
            ]
          }
        ]
      }
    })
  },
  {
    id: "JDJD723KDKH23",
    label: "Order Confirmation",
    category: "Marketing",
    value: JSON.stringify({
      sender: "",
      campaign_id: "put_campaign_id",
      messaging_product: "whatsapp",
      recipient_type: "individual",
      to: "receiver_number",
      type: "template",
      template: {
        name: "order_confirmation",
        language: {
          code: "en_US"
        },
        components: [
          {
            type: "HEADER",
            format: "TEXT",
            text: "🎉 Order Confirmed"
          },
          {
            type: "BODY",
            text: "Thank you {{1}}! Your order #{{2}} has been confirmed. We'll send you tracking details soon!",
            example: {
              body_text: [
                [
                  "customer name",
                  "order number"
                ]
              ]
            }
          },
          {
            type: "FOOTER",
            text: "Questions? Reply to this message"
          }
        ]
      }
    })
  },
  {
    id: "JDJD723KDKH234",
    label: "Welcome New Customer",
    category: "Utility",
    value: JSON.stringify({
      sender: "",
      campaign_id: "put_campaign_id",
      messaging_product: "whatsapp",
      recipient_type: "individual",
      to: "receiver_number",
      type: "template",
      template: {
        name: "welcome_new_customer",
        language: {
          code: "en_US"
        },
        components: [
          {
            type: "HEADER",
            format: "TEXT",
            text: "🌟 Welcome!"
          },
          {
            type: "BODY",
            text: "Welcome to our store {{1}}! Thanks for joining us. Enjoy 15% off your first order with code WELCOME15!",
            example: {
              body_text: [
                [
                  "customer name"
                ]
              ]
            }
          },
          {
            type: "BUTTONS",
            buttons: [
              {
                type: "QUICK_REPLY",
                text: "Shop Now"
              },
              {
                type: "QUICK_REPLY",
                text: "View Offers"
              }
            ]
          }
        ]
      }
    })
  },
  {
    id: "JDJD723KDKH2345",
    label: "Support Auto Reply",
    category: "Utility",
    value: JSON.stringify({
      sender: "",
      campaign_id: "put_campaign_id",
      messaging_product: "whatsapp",
      recipient_type: "individual",
      to: "receiver_number",
      type: "template",
      template: {
        name: "support_auto_reply",
        language: {
          code: "en_US"
        },
        components: [
          {
            type: "BODY",
            text: "Hi {{1}}! Thanks for reaching out. Our support team will get back to you within 24 hours. For urgent matters, call us at +1-800-SUPPORT.",
            example: {
              body_text: [
                [
                  "customer name"
                ]
              ]
            }
          },
          {
            type: "FOOTER",
            text: "We're here to help!"
          }
        ]
      }
    })
  },
  {
    id: "JDJD723KDKH23456",
    label: "Shipping Notification",
    category: "Utility",
    value: JSON.stringify({
      sender: "",
      campaign_id: "put_campaign_id",
      messaging_product: "whatsapp",
      recipient_type: "individual",
      to: "receiver_number",
      type: "template",
      template: {
        name: "shipping_notification",
        language: {
          code: "en_US"
        },
        components: [
          {
            type: "HEADER",
            format: "TEXT",
            text: "📦 Package Update"
          },
          {
            type: "BODY",
            text: "Great news {{1}}! Your order #{{2}} is on its way. Track your package: {{3}}",
            example: {
              body_text: [
                [
                  "customer name",
                  "order number",
                  "tracking link"
                ]
              ]
            }
          },
          {
            type: "BUTTONS",
            buttons: [
              {
                type: "URL",
                text: "Track Package",
                url: "{{3}}"
              }
            ]
          }
        ]
      }
    })
  },
  {
    id: "JDJD723KDKH234567",
    label: "Product Launch with Video",
    category: "Marketing",
    value: JSON.stringify({
      sender: "",
      campaign_id: "put_campaign_id",
      messaging_product: "whatsapp",
      recipient_type: "individual",
      to: "receiver_number",
      type: "template",
      template: {
        name: "product_launch_video",
        language: {
          code: "en_US"
        },
        components: [
          {
            type: "HEADER",
            format: "VIDEO",
            example: {
              header_handle: [
                "https://sample-videos.com/zip/10/mp4/SampleVideo_1280x720_1mb.mp4"
              ]
            }
          },
          {
            type: "BODY",
            text: "🎉 Introducing our latest product: {{product_name}}! Watch the video above to see it in action. Get 20% off with code LAUNCH20!",
            example: {
              body_text: [
                [
                  "Amazing Widget Pro"
                ]
              ]
            }
          },
          {
            type: "FOOTER",
            text: "Limited time offer - ends soon!"
          },
          {
            type: "BUTTONS",
            buttons: [
              {
                type: "QUICK_REPLY",
                text: "Shop Now"
              },
              {
                type: "QUICK_REPLY",
                text: "Learn More"
              }
            ]
          }
        ]
      }
    })
  }
];
const getTemplateById = (id) => {
  return messageTemplateOptions.find((template) => template.id === id) || null;
};
const fetchApiTemplates = async (options = {}) => {
  try {
    const apiResponse = await fetchTemplates(options);
    if (!apiResponse.datas || !apiResponse.datas.data) {
      throw new Error("Invalid API response format");
    }
    const transformedTemplates = apiResponse.datas.data.map(transformTemplateData);
    return {
      templates: transformedTemplates,
      pagination: {
        currentPage: apiResponse.datas.current_page,
        lastPage: apiResponse.datas.last_page,
        total: apiResponse.datas.total,
        perPage: parseInt(apiResponse.datas.per_page),
        from: apiResponse.datas.from,
        to: apiResponse.datas.to,
        hasNextPage: !!apiResponse.datas.next_page_url,
        hasPrevPage: !!apiResponse.datas.prev_page_url,
        nextPageUrl: apiResponse.datas.next_page_url,
        prevPageUrl: apiResponse.datas.prev_page_url
      },
      counts: apiResponse.counts
    };
  } catch (error) {
    const errorInfo = handleApiError$1(error);
    throw new Error(errorInfo.message);
  }
};
const searchTemplates = (templates, searchTerm) => {
  if (!searchTerm || searchTerm.trim() === "") {
    return templates;
  }
  const term = searchTerm.toLowerCase().trim();
  return templates.filter(
    (template) => template.label.toLowerCase().includes(term) || template.category.toLowerCase().includes(term) || template.status && template.status.toLowerCase().includes(term)
  );
};
function CreateAutoTriggerPage() {
  var _a2, _b;
  const navigate = useNavigate();
  const [triggerName, setTriggerName] = useState("");
  const [triggerType, setTriggerType] = useState("abandoned_cart");
  const [selectedTemplate, setSelectedTemplate] = useState("");
  const [messageTemplate, setMessageTemplate] = useState("");
  const [delayTime, setDelayTime] = useState("30");
  const [delayUnit, setDelayUnit] = useState("minutes");
  const [isActive, setIsActive] = useState(true);
  const [targetAudience, setTargetAudience] = useState(["abandoned_cart_customers"]);
  const [keywords, setKeywords] = useState("");
  const [variableSelections, setVariableSelections] = useState({});
  const [messageType, setMessageType] = useState("");
  const [customServiceMessage, setCustomServiceMessage] = useState("");
  const [selectedText, setSelectedText] = useState("");
  const [cursorPosition, setCursorPosition] = useState(0);
  const [filterByCollection, setFilterByCollection] = useState(false);
  const [selectedCollections, setSelectedCollections] = useState([]);
  const [collectionInputValue, setCollectionInputValue] = useState("");
  const [availableVariables, setAvailableVariables] = useState([]);
  const [loadingVariables, setLoadingVariables] = useState(true);
  const [showVariablesModal, setShowVariablesModal] = useState(false);
  const [variableSearchQuery, setVariableSearchQuery] = useState("");
  const handleTriggerNameChange = useCallback((value) => setTriggerName(value), []);
  const handleTriggerTypeChange = useCallback((value) => {
    setTriggerType(value);
    setSelectedTemplate("");
    setMessageTemplate("");
    setCustomServiceMessage("");
    setMessageType("");
    setVariableSelections({});
    setFilterByCollection(false);
    setSelectedCollections([]);
    setCollectionInputValue("");
    switch (value) {
      case "abandoned_cart":
        setTargetAudience(["abandoned_cart_customers"]);
        break;
      case "order_confirmation":
        setTargetAudience(["order_confirmation_customers"]);
        break;
      case "keywords_auto_reply":
        setTargetAudience(["all_customers"]);
        setFilterByCollection(false);
        setSelectedCollections([]);
        break;
      default:
        setTargetAudience(["all_customers"]);
        setFilterByCollection(false);
        setSelectedCollections([]);
        break;
    }
  }, []);
  const handleSelectedTemplateChange = useCallback((value) => {
    setSelectedTemplate(value);
    if (value && value !== "custom") {
      setMessageTemplate(value);
    } else if (value === "custom") {
      setMessageTemplate("");
    }
  }, []);
  useCallback((value) => setMessageTemplate(value), []);
  const handleDelayTimeChange = useCallback((value) => setDelayTime(value), []);
  const handleDelayUnitChange = useCallback((value) => setDelayUnit(value), []);
  useCallback((value) => setIsActive(value), []);
  useCallback((value) => setTargetAudience(value), []);
  const handleKeywordsChange = useCallback((value) => setKeywords(value), []);
  const handleVariableSelectionChange = useCallback((variable, value) => {
    setVariableSelections((prev) => ({
      ...prev,
      [variable]: value
    }));
  }, []);
  const handleMessageTypeChange = useCallback((value) => {
    setMessageType(value);
    setSelectedTemplate("");
    setCustomServiceMessage("");
    setMessageTemplate("");
  }, []);
  const handleCustomServiceMessageChange = useCallback((value) => {
    setCustomServiceMessage(value);
    setMessageTemplate(value);
  }, []);
  const handleFilterByCollectionChange = useCallback((value) => {
    setFilterByCollection(value);
    if (!value) {
      setSelectedCollections([]);
      setCollectionInputValue("");
    }
  }, []);
  useCallback((value) => {
    setSelectedCollections(value);
  }, []);
  const handleCollectionInputChange = useCallback((value) => {
    setCollectionInputValue(value);
  }, []);
  const handleCollectionSelect = useCallback((selectedValue) => {
    if (selectedValue && !selectedCollections.includes(selectedValue) && selectedCollections.length < 5) {
      setSelectedCollections([...selectedCollections, selectedValue]);
    }
    setCollectionInputValue("");
  }, [selectedCollections]);
  const handleCollectionRemove = useCallback((collectionToRemove) => {
    setSelectedCollections(selectedCollections.filter((collection) => collection !== collectionToRemove));
  }, [selectedCollections]);
  const handleTextSelection = useCallback((event) => {
    const textarea = event.target;
    setSelectedText(textarea.value.substring(textarea.selectionStart, textarea.selectionEnd));
    setCursorPosition(textarea.selectionStart);
  }, []);
  const applyFormatting = useCallback((format) => {
    const textarea = document.querySelector("#custom-service-message");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const end = textarea.selectionEnd;
    const selectedText2 = textarea.value.substring(start, end);
    let formattedText = "";
    let cursorOffset = 0;
    if (selectedText2) {
      switch (format) {
        case "bold":
          formattedText = `*${selectedText2}*`;
          cursorOffset = formattedText.length;
          break;
        case "italic":
          formattedText = `_${selectedText2}_`;
          cursorOffset = formattedText.length;
          break;
        case "strikethrough":
          formattedText = `~${selectedText2}~`;
          cursorOffset = formattedText.length;
          break;
        case "monospace":
          formattedText = `\`\`\`${selectedText2}\`\`\``;
          cursorOffset = formattedText.length;
          break;
        case "inline-code":
          formattedText = `\`${selectedText2}\``;
          cursorOffset = formattedText.length;
          break;
        case "quote":
          const needsNewLineBeforeQuote = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfterQuote = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBeforeQuote ? "\n" : "") + `> ${selectedText2}` + (needsNewLineAfterQuote ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        case "bullet-list":
          const bulletLines = selectedText2.split("\n").map((line) => line.trim() ? `* ${line}` : line).join("\n");
          const needsNewLineBefore = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfter = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBefore ? "\n" : "") + bulletLines + (needsNewLineAfter ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        case "numbered-list":
          const numberedLines = selectedText2.split("\n").filter((line) => line.trim()).map((line, index2) => `${index2 + 1}. ${line}`).join("\n");
          const needsNewLineBeforeNum = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfterNum = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBeforeNum ? "\n" : "") + numberedLines + (needsNewLineAfterNum ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        default:
          formattedText = selectedText2;
          cursorOffset = formattedText.length;
      }
    } else {
      switch (format) {
        case "bold":
          formattedText = "**";
          cursorOffset = 1;
          break;
        case "italic":
          formattedText = "__";
          cursorOffset = 1;
          break;
        case "strikethrough":
          formattedText = "~~";
          cursorOffset = 1;
          break;
        case "monospace":
          formattedText = "```\n\n```";
          cursorOffset = 4;
          break;
        case "inline-code":
          formattedText = "``";
          cursorOffset = 1;
          break;
        case "quote":
          const needsNewLineBeforeQuoteEmpty = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeQuoteEmpty ? "\n> " : "> ";
          cursorOffset = formattedText.length;
          break;
        case "bullet-list":
          const needsNewLineBeforeBullet = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeBullet ? "\n* " : "* ";
          cursorOffset = formattedText.length;
          break;
        case "numbered-list":
          const needsNewLineBeforeNumber = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeNumber ? "\n1. " : "1. ";
          cursorOffset = formattedText.length;
          break;
        default:
          formattedText = "";
          cursorOffset = 0;
      }
    }
    const newValue = textarea.value.substring(0, start) + formattedText + textarea.value.substring(end);
    setCustomServiceMessage(newValue);
    setMessageTemplate(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + cursorOffset, start + cursorOffset);
    }, 0);
  }, []);
  useEffect(() => {
    const handleKeyDown = (event) => {
      if ((event.ctrlKey || event.metaKey) && event.target.id === "custom-service-message") {
        switch (event.key.toLowerCase()) {
          case "b":
            event.preventDefault();
            applyFormatting("bold");
            break;
          case "i":
            event.preventDefault();
            applyFormatting("italic");
            break;
          case "s":
            event.preventDefault();
            applyFormatting("strikethrough");
            break;
          case "m":
            event.preventDefault();
            applyFormatting("monospace");
            break;
          case "k":
            event.preventDefault();
            applyFormatting("inline-code");
            break;
          case "q":
            event.preventDefault();
            applyFormatting("quote");
            break;
          case "l":
            event.preventDefault();
            applyFormatting("bullet-list");
            break;
          case "n":
            event.preventDefault();
            applyFormatting("numbered-list");
            break;
        }
      }
    };
    document.addEventListener("keydown", handleKeyDown);
    return () => document.removeEventListener("keydown", handleKeyDown);
  }, [applyFormatting]);
  const insertVariable = useCallback((variable) => {
    const textarea = document.querySelector("#custom-service-message");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const variableText = `{{${variable}}}`;
    const newValue = textarea.value.substring(0, start) + variableText + textarea.value.substring(start);
    setCustomServiceMessage(newValue);
    setMessageTemplate(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + variableText.length, start + variableText.length);
    }, 0);
  }, []);
  const insertEmoji = useCallback((emoji) => {
    const textarea = document.querySelector("#custom-service-message");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const newValue = textarea.value.substring(0, start) + emoji + textarea.value.substring(start);
    setCustomServiceMessage(newValue);
    setMessageTemplate(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + emoji.length, start + emoji.length);
    }, 0);
  }, []);
  const handleSave = useCallback(() => {
    console.log("Saving trigger:", {
      triggerName,
      triggerType,
      messageTemplate,
      delayTime,
      delayUnit,
      isActive,
      targetAudience,
      keywords,
      filterByCollection,
      selectedCollections
    });
    navigate("/app/auto-triggers");
  }, [triggerName, triggerType, messageTemplate, delayTime, delayUnit, isActive, targetAudience, keywords, filterByCollection, selectedCollections, navigate]);
  const handleCancel = useCallback(() => {
    navigate("/app/auto-triggers");
  }, [navigate]);
  const triggerTypeOptions = [
    { label: "Abandoned Cart", value: "abandoned_cart" },
    { label: "Order Confirmation", value: "order_confirmation" },
    { label: "Keywords Auto Reply", value: "keywords_auto_reply" }
  ];
  const delayUnitOptions = [
    { label: "Minutes", value: "minutes" },
    { label: "Hours", value: "hours" },
    { label: "Days", value: "days" }
  ];
  const getTargetAudienceOptions = () => {
    switch (triggerType) {
      case "abandoned_cart":
        return [
          { label: "Abandoned Cart Customers", value: "abandoned_cart_customers" }
        ];
      case "order_confirmation":
        return [
          { label: "Order Confirmation Customers", value: "order_confirmation_customers" }
        ];
      case "keywords_auto_reply":
        return [
          { label: "All Customers", value: "all_customers" }
        ];
      default:
        return [
          { label: "All Customers", value: "all_customers" }
        ];
    }
  };
  const targetAudienceOptions = getTargetAudienceOptions();
  const collectionOptions = [
    { label: "Electronics", value: "electronics" },
    { label: "Clothing", value: "clothing" },
    { label: "Home & Garden", value: "home-garden" },
    { label: "Sports & Outdoors", value: "sports-outdoors" },
    { label: "Books", value: "books" },
    { label: "Beauty & Personal Care", value: "beauty-personal-care" },
    { label: "Toys & Games", value: "toys-games" },
    { label: "Automotive", value: "automotive" }
  ];
  const filteredCollectionOptions = useMemo(() => {
    if (selectedCollections.length >= 5) return [];
    if (!collectionInputValue) return collectionOptions.filter((option) => !selectedCollections.includes(option.value));
    return collectionOptions.filter(
      (option) => option.label.toLowerCase().includes(collectionInputValue.toLowerCase()) && !selectedCollections.includes(option.value)
    );
  }, [collectionInputValue, selectedCollections]);
  const extractVariables = useMemo(() => {
    return extractVariablesFromWhatsAppMessage(messageTemplate);
  }, [messageTemplate, triggerType, messageType]);
  useEffect(() => {
    const fetchVariables = async () => {
      try {
        setLoadingVariables(true);
        const variables = await getTemplateVariables();
        setAvailableVariables(variables);
      } catch (error) {
        console.error("Error fetching variables:", error);
        setAvailableVariables([]);
      } finally {
        setLoadingVariables(false);
      }
    };
    fetchVariables();
  }, []);
  const messageTypeOptions = [
    { label: "Select Template", value: "template" },
    { label: "Create Service Message", value: "service" }
  ];
  return /* @__PURE__ */ jsxs(
    Page,
    {
      title: "Create Auto Trigger",
      subtitle: "Set up a new automated trigger for customer engagement",
      backAction: {
        content: "Auto Triggers",
        onAction: () => navigate("/app/auto-triggers")
      },
      primaryAction: {
        content: "Save Trigger",
        onAction: handleSave,
        disabled: !triggerName || !messageTemplate || triggerType === "keywords_auto_reply" && !messageType
      },
      secondaryActions: [
        {
          content: "Cancel",
          onAction: handleCancel
        }
      ],
      fullWidth: true,
      children: [
        /* @__PURE__ */ jsxs(Grid, { children: [
          /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 8, lg: 8, xl: 8 }, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "500", children: [
            /* @__PURE__ */ jsx(Banner, { status: "info", children: /* @__PURE__ */ jsx(Text, { as: "p", children: "Create automated triggers to engage with your customers at the right moment. Configure when and how messages are sent based on customer behavior." }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Basic Information" }),
              /* @__PURE__ */ jsxs(FormLayout, { children: [
                /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: "Trigger Name",
                    value: triggerName,
                    onChange: handleTriggerNameChange,
                    placeholder: "e.g., Abandoned Cart Recovery",
                    helpText: "Give your trigger a descriptive name",
                    requiredIndicator: true
                  }
                ),
                /* @__PURE__ */ jsx(
                  Select,
                  {
                    label: "Trigger Type",
                    options: triggerTypeOptions,
                    value: triggerType,
                    onChange: handleTriggerTypeChange
                  }
                )
              ] })
            ] }) }),
            triggerType === "keywords_auto_reply" && /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Keywords Configuration" }),
              /* @__PURE__ */ jsxs(FormLayout, { children: [
                /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: "Keywords",
                    value: keywords,
                    onChange: handleKeywordsChange,
                    placeholder: "e.g., help, support, refund",
                    helpText: "Enter keywords separated by commas",
                    multiline: 2
                  }
                ),
                /* @__PURE__ */ jsx(
                  Select,
                  {
                    label: "Message Type",
                    options: messageTypeOptions,
                    value: messageType,
                    onChange: handleMessageTypeChange,
                    placeholder: "Choose message type",
                    helpText: "Select whether to use a template or service message"
                  }
                )
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Message Settings" }),
              /* @__PURE__ */ jsxs(FormLayout, { children: [
                (triggerType !== "keywords_auto_reply" || messageType === "template") && /* @__PURE__ */ jsx(
                  Select,
                  {
                    label: "Select Template",
                    options: messageTemplateOptions,
                    value: selectedTemplate,
                    onChange: handleSelectedTemplateChange,
                    placeholder: "Choose a message template",
                    helpText: "Select a predefined template or choose 'Custom Template' to create your own"
                  }
                ),
                triggerType === "keywords_auto_reply" && messageType === "service" && /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "h3", children: "Custom Service Message" }),
                  /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                    /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "click to insert variables:" }),
                    /* @__PURE__ */ jsxs(InlineStack, { gap: "100", wrap: true, children: [
                      availableVariables.slice(0, 15).map((variable) => /* @__PURE__ */ jsx(
                        Button,
                        {
                          size: "micro",
                          variant: "tertiary",
                          onClick: () => insertVariable(variable.value),
                          children: variable.label
                        },
                        variable.value
                      )),
                      availableVariables.length > 15 && /* @__PURE__ */ jsxs(
                        Button,
                        {
                          size: "micro",
                          variant: "primary",
                          onClick: () => setShowVariablesModal(true),
                          children: [
                            "More Variables (",
                            availableVariables.length - 15,
                            ")"
                          ]
                        }
                      )
                    ] })
                  ] }),
                  /* @__PURE__ */ jsxs("div", { style: { position: "relative" }, children: [
                    /* @__PURE__ */ jsxs("div", { style: { position: "absolute", bottom: 12, right: 6, zIndex: 99, display: "flex", gap: "4px", flexWrap: "wrap" }, children: [
                      /* @__PURE__ */ jsx(ButtonGroup, { variant: "segmented", children: /* @__PURE__ */ jsx(EmojiPicker, { onEmojiSelect: insertEmoji, buttonSize: "micro" }) }),
                      /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Bold",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘B" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bold"), accessibilityLabel: "Bold", children: /* @__PURE__ */ jsx(Text, { fontWeight: "bold", children: "B" }) }) }),
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Italic",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘I" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("italic"), accessibilityLabel: "Italic", children: /* @__PURE__ */ jsx(Text, { as: "em", children: "I" }) }) }),
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Strikethrough",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘S" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("strikethrough"), accessibilityLabel: "Strikethrough", children: /* @__PURE__ */ jsx(Text, { as: "s", children: "S" }) }) })
                      ] }),
                      /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Monospace",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘M" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("monospace"), accessibilityLabel: "Monospace", children: /* @__PURE__ */ jsxs(Text, { as: "code", children: [
                          " ",
                          "</>"
                        ] }) }) }),
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Inline Code",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘K" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("inline-code"), accessibilityLabel: "Inline Code", children: /* @__PURE__ */ jsx(Text, { as: "code", children: "<>" }) }) }),
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Quote",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘Q" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("quote"), accessibilityLabel: "Quote", children: '"' }) })
                      ] }),
                      /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Bullet List",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘L" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bullet-list"), accessibilityLabel: "Bullet List", children: "•" }) }),
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Numbered List",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘N" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("numbered-list"), accessibilityLabel: "Numbered List", children: "1." }) })
                      ] })
                    ] }),
                    /* @__PURE__ */ jsx(
                      TextField,
                      {
                        id: "custom-service-message",
                        label: "Message Content",
                        value: customServiceMessage,
                        onChange: handleCustomServiceMessageChange,
                        onSelect: handleTextSelection,
                        multiline: 8,
                        maxLength: 4096,
                        placeholder: "Type your custom service message here...    Formatting options:*bold*, _italic_, ~strikethrough~, ```monospace```, `inline code`, > quote,* bullet list, 1. numbered list. Use keyboard shortcuts or click buttons above.",
                        helpText: `${customServiceMessage.length}/4096 characters`
                      }
                    )
                  ] })
                ] }),
                extractVariables.length > 0 && /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "h3", children: "Variable Mapping" }),
                  /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Map the template variables to actual data fields:" }),
                  extractVariables.map((variable, index2) => /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
                    /* @__PURE__ */ jsx(
                      TextField,
                      {
                        label: `Variable: {{${variable}}}`,
                        value: `{{${variable}}}`,
                        disabled: true,
                        helpText: "Template variable"
                      }
                    ),
                    /* @__PURE__ */ jsx(
                      Select,
                      {
                        label: "Map to",
                        options: [
                          { label: "Select mapping...", value: "" },
                          ...availableVariables
                        ],
                        value: variableSelections[variable] || "",
                        onChange: (value) => handleVariableSelectionChange(variable, value),
                        placeholder: "Choose data field"
                      }
                    )
                  ] }, variable))
                ] }),
                triggerType !== "keywords_auto_reply" && /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
                  /* @__PURE__ */ jsx(
                    TextField,
                    {
                      label: "Delay Time",
                      type: "number",
                      value: delayTime,
                      onChange: handleDelayTimeChange,
                      min: "1"
                    }
                  ),
                  /* @__PURE__ */ jsx(
                    Select,
                    {
                      label: "Delay Unit",
                      options: delayUnitOptions,
                      value: delayUnit,
                      onChange: handleDelayUnitChange
                    }
                  )
                ] })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Target Audience" }),
              /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                /* @__PURE__ */ jsx(Text, { as: "p", tone: "subdued", children: "Who should receive this trigger?" }),
                /* @__PURE__ */ jsx(
                  Checkbox,
                  {
                    label: (_a2 = targetAudienceOptions[0]) == null ? void 0 : _a2.label,
                    checked: true,
                    disabled: true,
                    helpText: "This audience is automatically selected based on your trigger type"
                  }
                ),
                (triggerType === "abandoned_cart" || triggerType === "order_confirmation") && /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                  /* @__PURE__ */ jsx(
                    Checkbox,
                    {
                      label: "Do you want to filter target customers based on your product category/collection?",
                      checked: filterByCollection,
                      onChange: handleFilterByCollectionChange,
                      helpText: "Filter customers based on the products they have in their cart or ordered"
                    }
                  ),
                  filterByCollection && /* @__PURE__ */ jsx(FormLayout, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                    /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                      /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "h3", children: "Select Collections (Maximum 5)" }),
                      /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: selectedCollections.length >= 5 ? "critical" : "subdued", children: [
                        selectedCollections.length,
                        "/5 selected"
                      ] })
                    ] }),
                    selectedCollections.length > 0 && /* @__PURE__ */ jsx(InlineStack, { gap: "100", wrap: true, children: selectedCollections.map((collectionValue, index2) => {
                      const collectionOption = collectionOptions.find((opt) => opt.value === collectionValue);
                      const displayLabel = collectionOption ? collectionOption.label : collectionValue;
                      return /* @__PURE__ */ jsx(
                        Tag,
                        {
                          onRemove: () => handleCollectionRemove(collectionValue),
                          children: displayLabel
                        },
                        collectionValue
                      );
                    }) }),
                    /* @__PURE__ */ jsx(
                      Combobox,
                      {
                        activator: /* @__PURE__ */ jsx(
                          Combobox.TextField,
                          {
                            onChange: handleCollectionInputChange,
                            label: "",
                            labelHidden: true,
                            value: collectionInputValue,
                            placeholder: selectedCollections.length >= 5 ? "Maximum 5 collections selected" : "Search and select collections...",
                            autoComplete: "off",
                            disabled: selectedCollections.length >= 5
                          }
                        ),
                        children: filteredCollectionOptions.length > 0 ? /* @__PURE__ */ jsx(Listbox, { onSelect: handleCollectionSelect, children: filteredCollectionOptions.map((option) => /* @__PURE__ */ jsx(
                          Listbox.Option,
                          {
                            value: option.value,
                            selected: selectedCollections.includes(option.value),
                            disabled: selectedCollections.includes(option.value),
                            children: option.label
                          },
                          option.value
                        )) }) : /* @__PURE__ */ jsx(Listbox, { children: /* @__PURE__ */ jsx(Listbox.Option, { value: "", disabled: true, children: selectedCollections.length >= 5 ? "Maximum collections selected" : "No collections found" }) })
                      }
                    ),
                    /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Only customers who have products from the selected collections will receive this trigger. Maximum 5 collections allowed." })
                  ] }) })
                ] })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsx(InlineStack, { align: "end", children: /* @__PURE__ */ jsxs(ButtonGroup, { children: [
              /* @__PURE__ */ jsx(Button, { onClick: handleCancel, children: "Cancel" }),
              /* @__PURE__ */ jsx(
                Button,
                {
                  variant: "primary",
                  onClick: handleSave,
                  disabled: !triggerName || !messageTemplate || triggerType === "keywords_auto_reply" && !messageType,
                  children: "Save Trigger"
                }
              )
            ] }) }) })
          ] }) }),
          /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 4, lg: 4, xl: 4 }, children: /* @__PURE__ */ jsx("div", { style: {
            position: "sticky",
            top: "20px",
            alignSelf: "flex-start",
            zIndex: 10
          }, children: /* @__PURE__ */ jsx(BlockStack, { gap: "500", children: /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Message Preview" }),
            messageTemplate ? /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
              /* @__PURE__ */ jsx(Text, { as: "p", tone: "", children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", children: (_b = messageTemplateOptions == null ? void 0 : messageTemplateOptions.find((option) => option.value === selectedTemplate)) == null ? void 0 : _b.label }) }),
              /* @__PURE__ */ jsx(Card, { sectioned: true, background: "bg-surface-secondary", children: /* @__PURE__ */ jsx(
                WhatsAppPreview,
                {
                  template: messageTemplate,
                  variant: "bubble",
                  maxWidth: "280px"
                }
              ) }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                "Variables like ",
                `{`,
                `{`,
                `customer_name`,
                `}`,
                `}`,
                " or ",
                `{`,
                `{`,
                `1`,
                `}`,
                `}`,
                " will be replaced with actual customer data when sent."
              ] })
            ] }) : /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
              /* @__PURE__ */ jsx(Text, { as: "p", tone: "subdued", children: "Select a template to see the preview" }),
              /* @__PURE__ */ jsx(LegacyCard, { sectioned: true, children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Your message preview will appear here once you select a template or enter a custom message." }) })
            ] })
          ] }) }) }) }) })
        ] }),
        /* @__PURE__ */ jsx(
          Modal,
          {
            open: showVariablesModal,
            onClose: () => {
              setShowVariablesModal(false);
              setVariableSearchQuery("");
            },
            title: "All Available Variables",
            primaryAction: {
              content: "Close",
              onAction: () => {
                setShowVariablesModal(false);
                setVariableSearchQuery("");
              }
            },
            size: "large",
            children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", tone: "subdued", children: "Click on any variable to insert it into your template:" }),
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Search Variables",
                  value: variableSearchQuery,
                  onChange: setVariableSearchQuery,
                  placeholder: "Type to search variables...",
                  clearButton: true,
                  onClearButtonClick: () => setVariableSearchQuery(""),
                  autoComplete: "off"
                }
              ),
              /* @__PURE__ */ jsx(InlineStack, { gap: "200", wrap: true, children: availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).map((variable) => /* @__PURE__ */ jsx(
                Button,
                {
                  size: "medium",
                  variant: "tertiary",
                  onClick: () => {
                    insertVariable(variable.value);
                    setShowVariablesModal(false);
                    setVariableSearchQuery("");
                  },
                  children: variable.label
                },
                variable.value
              )) }),
              availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).length === 0 && variableSearchQuery && /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", tone: "subdued", alignment: "center", children: [
                'No variables found matching "',
                variableSearchQuery,
                '"'
              ] }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", tone: "subdued", children: [
                "You can also create custom variables using the format: ",
                "{{variable_name}}"
              ] })
            ] }) })
          }
        )
      ]
    }
  );
}
const route10 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: CreateAutoTriggerPage
}, Symbol.toStringTag, { value: "Module" }));
function CreateChatWidgetPage() {
  const [countryCode, setCountryCode] = useState("+1");
  const [whatsappNumber, setWhatsappNumber] = useState("");
  const [businessName, setBusinessName] = useState("");
  const [currentLogo, setCurrentLogo] = useState(null);
  const [newLogo, setNewLogo] = useState(null);
  const [greetingsText, setGreetingsText] = useState("Hi! How can we help you today?");
  const [buttonText, setButtonText] = useState("Start Chat");
  const [incomingMessageText, setIncomingMessageText] = useState("Thanks for contacting us! We'll get back to you soon.");
  const [brandSubtitle, setBrandSubtitle] = useState("online");
  const [alignment, setAlignment] = useState(["right"]);
  const [themeColor, setThemeColor] = useState("#00ab88");
  const [showOn, setShowOn] = useState(["web_mobile"]);
  const [onloadBehavior, setOnloadBehavior] = useState(["closed"]);
  const [isSaving, setIsSaving] = useState(false);
  const [saveError, setSaveError] = useState(null);
  const [saveSuccess, setSaveSuccess] = useState(false);
  const [ifkey, setIfkey] = useState(null);
  const [embedToThemeModalActive, setEmbedToThemeModalActive] = useState(false);
  const [selectedTab, setSelectedTab] = useState(0);
  const fileInputRef = useRef(null);
  const buildImageUrl = useCallback((pathOrUrl) => {
    if (!pathOrUrl) return null;
    if (typeof pathOrUrl === "string" && /^https?:\/\//i.test(pathOrUrl)) return pathOrUrl;
    return `https://app.getgabs.com/img/ifusers/${pathOrUrl}`;
  }, []);
  useEffect(() => {
    let cancelled = false;
    (async () => {
      try {
        const response = await getChatWidgetDataJson();
        if (!response || !response.status) return;
        const data = response.data || {};
        if (cancelled) return;
        const fetchedCountry = data.countryCode ? `+${String(data.countryCode)}` : "+1";
        const fetchedNumber = data.NationalNumber || (data.number ? String(data.number) : "");
        setCountryCode(fetchedCountry);
        setWhatsappNumber(fetchedNumber);
        setBusinessName(data.profile_heading || "");
        setBrandSubtitle(data.brand_subtitle || "online");
        setCurrentLogo(buildImageUrl(data.profile_pic));
        setGreetingsText(data.greeting_msg || greetingsText);
        setButtonText(data.button_text || buttonText);
        setIncomingMessageText(data.chat_query_msg || incomingMessageText);
        setThemeColor(data.header_bg_color || data.button_color || "#00ab88");
        const alignVal = Number(data.aligned) === 1 ? "left" : "right";
        setAlignment([alignVal]);
        const showOnVal = Number(data.open_in_mobile) === 1 ? "web_mobile" : "web_only";
        setShowOn([showOnVal]);
        const onloadVal = Number(data.popup) === 1 ? "opened" : "closed";
        setOnloadBehavior([onloadVal]);
        if (data.ifkey) {
          setIfkey(data.ifkey);
        }
      } catch (e) {
      }
    })();
    return () => {
      cancelled = true;
    };
  }, []);
  const countryCodes = [
    { label: "United States (+1)", value: "+1" },
    { label: "United Kingdom (+44)", value: "+44" },
    { label: "India (+91)", value: "+91" },
    { label: "Canada (+1)", value: "+1" },
    { label: "Australia (+61)", value: "+61" },
    { label: "Germany (+49)", value: "+49" },
    { label: "France (+33)", value: "+33" },
    { label: "Japan (+81)", value: "+81" },
    { label: "China (+86)", value: "+86" },
    { label: "Brazil (+55)", value: "+55" },
    { label: "Mexico (+52)", value: "+52" },
    { label: "Spain (+34)", value: "+34" },
    { label: "Italy (+39)", value: "+39" },
    { label: "Netherlands (+31)", value: "+31" },
    { label: "South Africa (+27)", value: "+27" }
  ];
  const handleSave = useCallback(async () => {
    setIsSaving(true);
    setSaveError(null);
    setSaveSuccess(false);
    try {
      const payload = {
        Aignment: alignment[0] === "left" ? 1 : 0,
        BusinessGreetingsText: greetingsText,
        BusinessNameInput: businessName,
        FormButtonText: buttonText,
        Incomingmessagetext: incomingMessageText,
        newLogoSrc: newLogo ? newLogo.preview : "",
        open_in_mobile: showOn[0] === "web_mobile" ? "1" : "0",
        themeColor,
        widgetNumber: `${countryCode}${whatsappNumber}`.replace(/\+/g, "")
      };
      console.log("Saving widget configuration with payload:", payload);
      const response = await updateWhatappchatWidget(payload);
      console.log("Widget configuration saved successfully:", response);
      setSaveSuccess(true);
      if (newLogo) {
        setCurrentLogo(newLogo.preview);
        setNewLogo(null);
        if (fileInputRef.current) {
          fileInputRef.current.value = "";
        }
      }
      setTimeout(() => {
        setSaveSuccess(false);
      }, 3e3);
    } catch (error) {
      console.error("Error saving widget configuration:", error);
      setSaveError(error.message || "Failed to save widget configuration");
    } finally {
      setIsSaving(false);
    }
  }, [countryCode, whatsappNumber, businessName, currentLogo, newLogo, greetingsText, buttonText, incomingMessageText, alignment, themeColor, showOn, onloadBehavior]);
  const handleFileUpload = useCallback((event) => {
    const file = event.target.files[0];
    if (file && (file.type === "image/jpeg" || file.type === "image/png")) {
      const reader = new FileReader();
      reader.onload = (e) => {
        setNewLogo({
          file,
          preview: e.target.result,
          name: file.name
        });
      };
      reader.readAsDataURL(file);
    }
  }, []);
  const handleLogoUploadClick = useCallback(() => {
    var _a2;
    (_a2 = fileInputRef.current) == null ? void 0 : _a2.click();
  }, []);
  const removeLogo = useCallback(() => {
    setNewLogo(null);
    if (fileInputRef.current) {
      fileInputRef.current.value = "";
    }
  }, []);
  const copyScriptToClipboard = useCallback(async () => {
    if (!ifkey) return;
    const scriptTag = `<script src="https://app.getgabs.com/getredtowp/iframe/${ifkey}" async><\/script>`;
    try {
      await navigator.clipboard.writeText(scriptTag);
      console.log("Script copied to clipboard");
    } catch (err) {
      console.error("Failed to copy script: ", err);
    }
  }, [ifkey]);
  const copyIfkeyToClipboard = useCallback(async () => {
    if (!ifkey) return;
    try {
      await navigator.clipboard.writeText(ifkey);
      console.log("Ifkey copied to clipboard");
    } catch (err) {
      console.error("Failed to copy ifkey: ", err);
    }
  }, [ifkey]);
  const openEmbedToThemeModal = useCallback(() => {
    setEmbedToThemeModalActive(true);
  }, []);
  const renderPreview = () => /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
    /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: "Widget Preview" }),
    /* @__PURE__ */ jsxs("div", { style: {
      width: "100%",
      height: "500px",
      backgroundColor: "#f6f6f7",
      borderRadius: "8px",
      position: "relative",
      overflow: "hidden"
    }, children: [
      /* @__PURE__ */ jsxs("div", { style: { padding: "20px" }, children: [
        /* @__PURE__ */ jsx("div", { style: { fontSize: "18px", fontWeight: "600", marginBottom: "8px" }, children: "Your Website" }),
        /* @__PURE__ */ jsx("div", { style: { fontSize: "14px", color: "#666" }, children: "This is how your chat widget will appear on your website." })
      ] }),
      /* @__PURE__ */ jsxs("div", { style: {
        position: "absolute",
        bottom: "20px",
        [alignment[0] === "left" ? "left" : "right"]: "20px",
        width: "320px",
        height: "400px",
        backgroundColor: "#ffffff",
        borderRadius: "12px",
        boxShadow: "0 4px 20px rgba(0,0,0,0.15)",
        overflow: "hidden",
        display: "flex",
        flexDirection: "column"
      }, children: [
        /* @__PURE__ */ jsxs("div", { style: {
          backgroundColor: themeColor,
          color: "white",
          padding: "16px",
          display: "flex",
          alignItems: "center",
          gap: "12px"
        }, children: [
          newLogo || currentLogo ? /* @__PURE__ */ jsx(
            "img",
            {
              src: (newLogo == null ? void 0 : newLogo.preview) || currentLogo,
              alt: "Business Logo",
              style: {
                width: "40px",
                height: "40px",
                borderRadius: "50%",
                objectFit: "cover",
                backgroundColor: "white"
              }
            }
          ) : /* @__PURE__ */ jsx("div", { style: {
            width: "40px",
            height: "40px",
            borderRadius: "50%",
            backgroundColor: "rgba(255,255,255,0.2)",
            display: "flex",
            alignItems: "center",
            justifyContent: "center",
            fontSize: "18px",
            fontWeight: "bold"
          }, children: businessName ? businessName.charAt(0).toUpperCase() : "B" }),
          /* @__PURE__ */ jsxs("div", { style: { flex: 1 }, children: [
            /* @__PURE__ */ jsx("div", { style: { fontWeight: "600", fontSize: "16px" }, children: businessName || "Your Business Name" }),
            /* @__PURE__ */ jsx("div", { style: { fontSize: "12px", opacity: 0.9 }, children: brandSubtitle || "online" })
          ] }),
          /* @__PURE__ */ jsx("div", { style: { fontSize: "18px", cursor: "pointer" }, children: "×" })
        ] }),
        /* @__PURE__ */ jsxs("div", { style: {
          flex: 1,
          backgroundColor: "#e5ddd5",
          backgroundImage: `url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23d4c5b9' fill-opacity='0.1'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E")`,
          padding: "16px",
          display: "flex",
          flexDirection: "column",
          gap: "12px",
          position: "relative"
        }, children: [
          /* @__PURE__ */ jsx("div", { style: {
            textAlign: "center",
            marginBottom: "16px"
          }, children: /* @__PURE__ */ jsx("span", { style: {
            backgroundColor: "rgba(255,255,255,0.8)",
            padding: "4px 12px",
            borderRadius: "12px",
            fontSize: "12px",
            color: "#667781"
          }, children: "Today" }) }),
          /* @__PURE__ */ jsx("div", { style: {
            alignSelf: "flex-start",
            maxWidth: "80%"
          }, children: /* @__PURE__ */ jsx("div", { style: {
            backgroundColor: "white",
            padding: "8px 12px",
            borderRadius: "8px",
            boxShadow: "0 1px 2px rgba(0,0,0,0.1)",
            fontSize: "14px",
            color: "#333"
          }, children: greetingsText || "Hello Sir, How can I help you?" }) })
        ] }),
        /* @__PURE__ */ jsx("div", { style: {
          backgroundColor: "white",
          padding: "16px",
          borderTop: "1px solid #e0e0e0"
        }, children: /* @__PURE__ */ jsxs("button", { style: {
          width: "100%",
          backgroundColor: themeColor,
          color: "white",
          border: "none",
          padding: "12px 20px",
          borderRadius: "25px",
          fontSize: "14px",
          fontWeight: "500",
          cursor: "pointer",
          display: "flex",
          alignItems: "center",
          justifyContent: "center",
          gap: "8px"
        }, children: [
          /* @__PURE__ */ jsx("svg", { width: "16", height: "16", viewBox: "0 0 24 24", fill: "currentColor", children: /* @__PURE__ */ jsx("path", { d: "M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893A11.821 11.821 0 0020.893 3.085" }) }),
          buttonText || "Start Chat"
        ] }) })
      ] })
    ] })
  ] }) });
  const renderScriptCard = () => {
    if (!ifkey) return null;
    const scriptTag = `<script src="https://app.getgabs.com/getredtowp/iframe/${ifkey}" async><\/script>`;
    return /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
      /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: "Copy Script" }),
      /* @__PURE__ */ jsxs("div", { style: {
        backgroundColor: "#f6f6f7",
        border: "1px solid #d1d3d4",
        borderRadius: "8px",
        padding: "16px",
        fontFamily: "monospace",
        fontSize: "14px",
        wordBreak: "break-all",
        position: "relative"
      }, children: [
        /* @__PURE__ */ jsx("code", { children: scriptTag }),
        /* @__PURE__ */ jsx(
          Button,
          {
            size: "slim",
            onClick: copyScriptToClipboard,
            style: {
              position: "absolute",
              top: "8px",
              right: "8px"
            },
            children: "Copy"
          }
        )
      ] }),
      /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", color: "subdued", children: "Place this script tag before the closing </body> tag on all pages where you want the chat widget to appear." })
    ] }) });
  };
  const isFormValid = countryCode && whatsappNumber && businessName && greetingsText && buttonText && incomingMessageText;
  const renderEmbedToThemeModal = () => /* @__PURE__ */ jsx(
    Modal,
    {
      open: embedToThemeModalActive,
      onClose: () => setEmbedToThemeModalActive(false),
      title: "Embed Chat Widget to Your Theme",
      primaryAction: {
        content: "Close",
        onAction: () => setEmbedToThemeModalActive(false)
      },
      size: "large",
      children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "500", children: [
        /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: "Choose Your Embedding Method" }),
        /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h4", children: "Method 1: Using Shopify Theme Customizer" }),
          /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", color: "subdued", children: "Follow these steps to add the chat widget through Shopify's theme customizer:" }),
          /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
            /* @__PURE__ */ jsxs("div", { style: { display: "flex", alignItems: "center", gap: "12px" }, children: [
              /* @__PURE__ */ jsx("div", { style: {
                width: "24px",
                height: "24px",
                backgroundColor: "#00ab88",
                color: "white",
                borderRadius: "50%",
                display: "flex",
                alignItems: "center",
                justifyContent: "center",
                fontSize: "12px",
                fontWeight: "bold",
                flexShrink: 0
              }, children: "1" }),
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: "Go to Customize (Online Store → Customize)" })
            ] }),
            /* @__PURE__ */ jsxs("div", { style: { display: "flex", alignItems: "center", gap: "12px" }, children: [
              /* @__PURE__ */ jsx("div", { style: {
                width: "24px",
                height: "24px",
                backgroundColor: "#00ab88",
                color: "white",
                borderRadius: "50%",
                display: "flex",
                alignItems: "center",
                justifyContent: "center",
                fontSize: "12px",
                fontWeight: "bold",
                flexShrink: 0
              }, children: "2" }),
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: "Click on Add Section" })
            ] }),
            /* @__PURE__ */ jsxs("div", { style: { display: "flex", alignItems: "center", gap: "12px" }, children: [
              /* @__PURE__ */ jsx("div", { style: {
                width: "24px",
                height: "24px",
                backgroundColor: "#00ab88",
                color: "white",
                borderRadius: "50%",
                display: "flex",
                alignItems: "center",
                justifyContent: "center",
                fontSize: "12px",
                fontWeight: "bold",
                flexShrink: 0
              }, children: "3" }),
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: "Open Apps tab" })
            ] }),
            /* @__PURE__ */ jsxs("div", { style: { display: "flex", alignItems: "center", gap: "12px" }, children: [
              /* @__PURE__ */ jsx("div", { style: {
                width: "24px",
                height: "24px",
                backgroundColor: "#00ab88",
                color: "white",
                borderRadius: "50%",
                display: "flex",
                alignItems: "center",
                justifyContent: "center",
                fontSize: "12px",
                fontWeight: "bold",
                flexShrink: 0
              }, children: "4" }),
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: "Add GetGabs Chat widget" })
            ] }),
            /* @__PURE__ */ jsxs("div", { style: { display: "flex", alignItems: "center", gap: "12px" }, children: [
              /* @__PURE__ */ jsx("div", { style: {
                width: "24px",
                height: "24px",
                backgroundColor: "#00ab88",
                color: "white",
                borderRadius: "50%",
                display: "flex",
                alignItems: "center",
                justifyContent: "center",
                fontSize: "12px",
                fontWeight: "bold",
                flexShrink: 0
              }, children: "5" }),
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: "Paste the Script Key and save" })
            ] })
          ] }),
          ifkey && /* @__PURE__ */ jsxs("div", { style: {
            backgroundColor: "#f6f6f7",
            border: "1px solid #d1d3d4",
            borderRadius: "8px",
            padding: "16px",
            position: "relative"
          }, children: [
            /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "medium", color: "subdued", children: "Your Script Key:" }),
            /* @__PURE__ */ jsx("div", { style: {
              fontFamily: "monospace",
              fontSize: "14px",
              wordBreak: "break-all",
              marginTop: "8px",
              padding: "8px",
              backgroundColor: "white",
              borderRadius: "4px",
              border: "1px solid #e1e3e5"
            }, children: ifkey }),
            /* @__PURE__ */ jsx(
              Button,
              {
                size: "slim",
                onClick: copyIfkeyToClipboard,
                style: {
                  position: "absolute",
                  top: "8px",
                  right: "8px"
                },
                children: "Copy Key"
              }
            )
          ] })
        ] }) }),
        /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h4", children: "Method 2: Direct Script Embedding" }),
          /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", color: "subdued", children: "Copy and paste this script tag directly into your theme's footer.liquid file to display the chat widget." }),
          renderScriptCard()
        ] }) })
      ] }) })
    }
  );
  return /* @__PURE__ */ jsxs(
    Page,
    {
      fullWidth: true,
      title: "WhatsApp Chat Widget Configuration",
      subtitle: "Create and customize your WhatsApp chat widget for your website",
      primaryAction: {
        content: isSaving ? "Saving..." : "Save Widget Configuration",
        onAction: handleSave,
        disabled: !isFormValid || isSaving,
        loading: isSaving
      },
      children: [
        /* @__PURE__ */ jsxs(Layout, { children: [
          !isFormValid && /* @__PURE__ */ jsx(Layout.Section, { children: /* @__PURE__ */ jsx(Banner, { status: "warning", children: /* @__PURE__ */ jsx("p", { children: "Please fill in all required fields marked with * to save your widget configuration." }) }) }),
          saveSuccess && /* @__PURE__ */ jsx(Layout.Section, { children: /* @__PURE__ */ jsx(Banner, { status: "success", children: /* @__PURE__ */ jsx("p", { children: "Widget configuration saved successfully!" }) }) }),
          saveError && /* @__PURE__ */ jsx(Layout.Section, { children: /* @__PURE__ */ jsx(Banner, { status: "critical", children: /* @__PURE__ */ jsxs("p", { children: [
            "Error: ",
            saveError
          ] }) }) }),
          /* @__PURE__ */ jsx(Layout.Section, { children: /* @__PURE__ */ jsxs("div", { style: { display: "grid", gridTemplateColumns: "2fr 1fr", gap: "24px", alignItems: "start" }, children: [
            /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: "Contact Information" }),
                /* @__PURE__ */ jsxs(FormLayout, { children: [
                  /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
                    /* @__PURE__ */ jsx(
                      Select,
                      {
                        label: "Country Code",
                        options: countryCodes,
                        value: countryCode,
                        onChange: setCountryCode,
                        requiredIndicator: true
                      }
                    ),
                    /* @__PURE__ */ jsx(
                      TextField,
                      {
                        label: "WhatsApp Number",
                        value: whatsappNumber,
                        onChange: setWhatsappNumber,
                        placeholder: "1234567890",
                        helpText: "Enter your WhatsApp number without country code",
                        requiredIndicator: true
                      }
                    )
                  ] }),
                  /* @__PURE__ */ jsx(
                    TextField,
                    {
                      label: "Business Name",
                      value: businessName,
                      onChange: setBusinessName,
                      placeholder: "Your Business Name",
                      helpText: "This will be displayed in the chat widget",
                      requiredIndicator: true
                    }
                  )
                ] })
              ] }) }),
              /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: "Business Logo" }),
                /* @__PURE__ */ jsxs(FormLayout, { children: [
                  currentLogo && !newLogo && /* @__PURE__ */ jsxs("div", { children: [
                    /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: "Current Business Logo *" }),
                    /* @__PURE__ */ jsx(Box, { paddingBlockStart: "200", children: /* @__PURE__ */ jsx(
                      "img",
                      {
                        src: currentLogo,
                        alt: "Current Logo",
                        style: { maxWidth: "100px", maxHeight: "100px", objectFit: "contain" }
                      }
                    ) })
                  ] }),
                  /* @__PURE__ */ jsxs("div", { children: [
                    /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                      currentLogo ? "Choose New Business Logo" : "Choose Business Logo",
                      " *"
                    ] }),
                    /* @__PURE__ */ jsxs(Box, { paddingBlockStart: "200", children: [
                      /* @__PURE__ */ jsx(
                        "input",
                        {
                          ref: fileInputRef,
                          type: "file",
                          accept: "image/jpeg,image/png",
                          onChange: handleFileUpload,
                          style: { display: "none" }
                        }
                      ),
                      /* @__PURE__ */ jsxs(InlineStack, { gap: "200", align: "start", children: [
                        /* @__PURE__ */ jsx(Button, { onClick: handleLogoUploadClick, children: "Choose File" }),
                        newLogo && /* @__PURE__ */ jsx(Button, { variant: "plain", destructive: true, onClick: removeLogo, children: "Remove" })
                      ] }),
                      newLogo && /* @__PURE__ */ jsx(Box, { paddingBlockStart: "200", children: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", align: "start", children: [
                        /* @__PURE__ */ jsx(
                          "img",
                          {
                            src: newLogo.preview,
                            alt: "New Logo Preview",
                            style: { maxWidth: "100px", maxHeight: "100px", objectFit: "contain" }
                          }
                        ),
                        /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: newLogo.name })
                      ] }) }),
                      /* @__PURE__ */ jsx(Box, { paddingBlockStart: "100", children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", color: "subdued", children: "Supported formats: JPG, PNG. ** If You Need To Change The Logo Then Only Choose New Logo" }) })
                    ] })
                  ] })
                ] })
              ] }) }),
              /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: "Message Configuration" }),
                /* @__PURE__ */ jsxs(FormLayout, { children: [
                  /* @__PURE__ */ jsx(
                    TextField,
                    {
                      label: "Greetings Text",
                      value: greetingsText,
                      onChange: setGreetingsText,
                      multiline: 3,
                      placeholder: "Hi! How can we help you today?",
                      helpText: "This message will be pre-filled when users click the widget",
                      requiredIndicator: true
                    }
                  ),
                  /* @__PURE__ */ jsx(
                    TextField,
                    {
                      label: "Button Text",
                      value: buttonText,
                      onChange: setButtonText,
                      placeholder: "Start Chat",
                      helpText: "Text displayed on the chat widget button",
                      requiredIndicator: true
                    }
                  ),
                  /* @__PURE__ */ jsx(
                    TextField,
                    {
                      label: "Incoming Message Text",
                      value: incomingMessageText,
                      onChange: setIncomingMessageText,
                      multiline: 3,
                      placeholder: "Thanks for contacting us! We'll get back to you soon.",
                      helpText: "Auto-reply message when customers send their first message",
                      requiredIndicator: true
                    }
                  )
                ] })
              ] }) }),
              /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: "Appearance & Behavior" }),
                /* @__PURE__ */ jsxs(FormLayout, { children: [
                  /* @__PURE__ */ jsx(
                    ChoiceList,
                    {
                      title: "Alignment",
                      choices: [
                        { label: "Left", value: "left" },
                        { label: "Right", value: "right" }
                      ],
                      selected: alignment,
                      onChange: setAlignment
                    }
                  ),
                  /* @__PURE__ */ jsxs("div", { children: [
                    /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "medium", children: "Theme Color" }),
                    /* @__PURE__ */ jsx(Box, { paddingBlockStart: "200", children: /* @__PURE__ */ jsxs(InlineStack, { gap: "300", blockAlign: "center", style: { flexWrap: "wrap" }, children: [
                      /* @__PURE__ */ jsx("div", { style: { minWidth: "200px" }, children: /* @__PURE__ */ jsx(
                        TextField,
                        {
                          label: "HEX",
                          value: themeColor,
                          onChange: (value) => {
                            let next = value.trim();
                            if (next && !next.startsWith("#")) next = `#${next}`;
                            setThemeColor(next);
                          },
                          autoComplete: "off",
                          helpText: "Enter color like #00ab88 or #0a8"
                        }
                      ) }),
                      /* @__PURE__ */ jsx("div", { style: { display: "flex", alignItems: "center" }, children: /* @__PURE__ */ jsx(
                        "input",
                        {
                          type: "color",
                          value: /^#([0-9a-f]{6}|[0-9a-f]{3})$/i.test(themeColor) ? themeColor : "#00ab88",
                          onChange: (e) => setThemeColor(e.target.value),
                          style: {
                            width: "40px",
                            height: "40px",
                            padding: 0,
                            border: "1px solid #ccc",
                            borderRadius: "6px",
                            background: "none",
                            cursor: "pointer",
                            display: "block"
                          },
                          "aria-label": "Pick color"
                        }
                      ) })
                    ] }) })
                  ] }),
                  /* @__PURE__ */ jsx(
                    ChoiceList,
                    {
                      title: "Show On",
                      choices: [
                        { label: "Web + Mobile", value: "web_mobile" },
                        { label: "Web Only", value: "web_only" }
                      ],
                      selected: showOn,
                      onChange: setShowOn
                    }
                  ),
                  /* @__PURE__ */ jsxs("div", { children: [
                    /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "medium", children: "Setup Onload Behaviour" }),
                    /* @__PURE__ */ jsx(Box, { paddingBlockStart: "100", children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", color: "subdued", children: "When your website loads, should the chat bubble be opened or closed?" }) }),
                    /* @__PURE__ */ jsx(Box, { paddingBlockStart: "200", children: /* @__PURE__ */ jsx(
                      ChoiceList,
                      {
                        title: "Initial State",
                        choices: [
                          { label: "Opened Chat Bubble", value: "opened" },
                          { label: "Closed Chat Bubble", value: "closed" }
                        ],
                        selected: onloadBehavior,
                        onChange: setOnloadBehavior
                      }
                    ) })
                  ] })
                ] })
              ] }) }),
              /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsx(BlockStack, { gap: "400", children: /* @__PURE__ */ jsx(InlineStack, { gap: "300", align: "end", children: /* @__PURE__ */ jsx(
                Button,
                {
                  variant: "primary",
                  onClick: handleSave,
                  disabled: !isFormValid || isSaving,
                  loading: isSaving,
                  children: isSaving ? "Saving..." : "Save Widget Configuration"
                }
              ) }) }) })
            ] }) }),
            /* @__PURE__ */ jsxs("div", { style: { position: "sticky", top: "20px" }, children: [
              /* @__PURE__ */ jsx(BlockStack, { gap: "400", children: renderPreview() }),
              ifkey && /* @__PURE__ */ jsx(BlockStack, { gap: "400", children: /* @__PURE__ */ jsx(Button, { onClick: openEmbedToThemeModal, variant: "primary", children: "Embed to Website" }) })
            ] })
          ] }) })
        ] }),
        renderEmbedToThemeModal()
      ]
    }
  );
}
const route11 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: CreateChatWidgetPage
}, Symbol.toStringTag, { value: "Module" }));
const fetchStaticContactList = async (options = {}) => {
  const {
    page = 1,
    perPageData = 20,
    actionType = 0
  } = options;
  try {
    const url = new URL(buildApiUrl(`${ENDPOINTS.STATIC_CONTACT_LIST.BASE}/${ENDPOINTS.STATIC_CONTACT_LIST.GET_STATIC_CONTACT_LIST}`));
    url.searchParams.append("actionType", actionType);
    url.searchParams.append("page", page.toString());
    url.searchParams.append("perPageData", perPageData.toString());
    url.searchParams.append("token", API_TOKEN);
    const response = await fetch(url.toString(), {
      method: "GET",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json"
      }
    });
    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }
    const data = await response.json();
    return data;
  } catch (error) {
    console.error("Error fetching templates:", error);
    throw error;
  }
};
const fetchStaticContactListContacts = async (options = {}) => {
  const {
    page = 1,
    perPageData = 20,
    actionType = 1,
    contactListId = 0
  } = options;
  try {
    const url = new URL(buildApiUrl(`${ENDPOINTS.STATIC_CONTACT_LIST.BASE}/${ENDPOINTS.STATIC_CONTACT_LIST_CONTACTS.GET_STATIC_CONTACT_LIST_CONTACTS}`));
    url.searchParams.append("actionType", actionType);
    url.searchParams.append("page", page.toString());
    url.searchParams.append("perPageData", perPageData.toString());
    url.searchParams.append("tagId", contactListId.toString());
    url.searchParams.append("token", API_TOKEN);
    const response = await fetch(url.toString(), {
      method: "GET",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json"
      }
    });
    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }
    const data = await response.json();
    return data;
  } catch (error) {
    console.error("Error fetching templates:", error);
    throw error;
  }
};
const addNewContactListName = async (contactListNamePAYLOAD, csvFile, columnMappings = {}) => {
  try {
    const response = await fetch(`https://app.getgabs.com/partners/broadcast/addnewcontacttag`, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Authorization": `Bearer ${API_TOKEN}`,
        "X-Requested-With": "XMLHttpRequest"
      },
      body: JSON.stringify(contactListNamePAYLOAD)
    });
    if (!response.ok) throw new Error("Failed to add new contact list name");
    const data = await response.json();
    console.log("Contact list created successfully:", data);
    if ((data == null ? void 0 : data.status) === true || (data == null ? void 0 : data.success) === true || (data == null ? void 0 : data.status) === "success" || typeof (data == null ? void 0 : data.tagId) !== "undefined" || typeof (data == null ? void 0 : data.tag) !== "undefined" || typeof (data == null ? void 0 : data.id) !== "undefined") {
      const tagId = (data == null ? void 0 : data.tagId) ?? (data == null ? void 0 : data.tag) ?? (data == null ? void 0 : data.id);
      const formData = new FormData();
      formData.append("file", csvFile);
      formData.append("tag", tagId);
      if (Object.keys(columnMappings).length > 0) {
        const mappingsArray = Object.keys(columnMappings).sort((a, b) => parseInt(a) - parseInt(b)).map((columnIndex) => columnMappings[columnIndex]);
        formData.append("columnMappings", JSON.stringify(mappingsArray));
      }
      console.log("create contactlist Formdata contents:");
      for (let [key, value] of formData.entries()) {
        console.log(`${key}:`, value);
      }
      const uploadResponse = await fetch(`https://app.getgabs.com/partners/broadcast/uploadbulkcontact`, {
        method: "POST",
        headers: {
          "Authorization": `Bearer ${API_TOKEN}`
        },
        body: formData
      });
      if (!uploadResponse.ok) throw new Error("CSV upload failed");
      const uploadData = await uploadResponse.json();
      console.log(" CSV upload response:", uploadData);
      return {
        contactListResponse: data,
        csvUploadResponse: uploadData
      };
    } else {
      throw new Error("Contact list creation failed");
    }
  } catch (error) {
    console.error(" Error:", error);
    throw error;
  }
};
const addNewVariable = async (variableNamePAYLOAD) => {
  try {
    const response = await fetch(`https://app.getgabs.com/partners/shopify/CustomerLabel/create`, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Authorization": `Bearer ${API_TOKEN}`,
        "X-Requested-With": "XMLHttpRequest"
      },
      body: JSON.stringify(variableNamePAYLOAD)
    });
    if (!response.ok) throw new Error("Failed to add new variable");
    const data = await response.json();
    console.log("Variable created successfully:", data);
    return data;
  } catch (error) {
    console.error(" Error:", error);
    throw error;
  }
};
const deleteContactList = async (contactListId) => {
  try {
    const url = `https://app.getgabs.com/partners/broadcast/delete/taglist?ids=${encodeURIComponent(contactListId)}`;
    const response = await fetch(url, {
      method: "GET",
      headers: {
        "Accept": "application/json",
        "Authorization": `Bearer ${API_TOKEN}`,
        "X-Requested-With": "XMLHttpRequest"
      }
    });
    const maybeJson = await response.json().catch(() => null);
    if (!response.ok) {
      const message = maybeJson && (maybeJson.message || maybeJson.error) || `HTTP ${response.status}`;
      throw new Error(message);
    }
    const data = maybeJson ?? {};
    const success = (data == null ? void 0 : data.status) === true || (data == null ? void 0 : data.success) === true || (data == null ? void 0 : data.status) === "success";
    if (!success) {
      throw new Error((data == null ? void 0 : data.message) || "Delete failed");
    }
    console.log("delete contact list", data);
    return data;
  } catch (error) {
    console.error("Error deleting contact list:", error);
    throw error;
  }
};
const addSingleContact = async (singleContactPayload) => {
  try {
    const url = `https://app.getgabs.com/partners/broadcast/uploadsinglecontact`;
    const response = await fetch(url, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json",
        "Authorization": `Bearer ${API_TOKEN}`,
        "X-Requested-With": "XMLHttpRequest"
      },
      body: JSON.stringify(singleContactPayload)
    });
    const maybeJson = await response.json().catch(() => null);
    if (!response.ok) {
      const message = maybeJson && (maybeJson.message || maybeJson.error) || `HTTP ${response.status}`;
      throw new Error(message);
    }
    const data = maybeJson ?? {};
    const success = (data == null ? void 0 : data.status) === true || (data == null ? void 0 : data.success) === true || (data == null ? void 0 : data.status) === "success";
    if (!success) {
      throw new Error((data == null ? void 0 : data.message) || "Delete failed");
    }
    console.log("export contact list", data);
    return data;
  } catch (error) {
    console.error("Error exporting contact list:", error);
    throw error;
  }
};
const updateSingleContact = async (updateSingleContactPayload) => {
  try {
    const url = `https://app.getgabs.com/partners/broadcast/updatesinglecontact`;
    const response = await fetch(url, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json",
        "Authorization": `Bearer ${API_TOKEN}`,
        "X-Requested-With": "XMLHttpRequest"
      },
      body: JSON.stringify(updateSingleContactPayload)
    });
    const maybeJson = await response.json().catch(() => null);
    if (!response.ok) {
      const message = maybeJson && (maybeJson.message || maybeJson.error) || `HTTP ${response.status}`;
      throw new Error(message);
    }
    const data = maybeJson ?? {};
    const success = (data == null ? void 0 : data.status) === true || (data == null ? void 0 : data.success) === true || (data == null ? void 0 : data.status) === "success";
    if (!success) {
      throw new Error((data == null ? void 0 : data.message) || "Delete failed");
    }
    console.log("export contact list", data);
    return data;
  } catch (error) {
    console.error("Error exporting contact list:", error);
    throw error;
  }
};
const requestCache = /* @__PURE__ */ new Map();
const CACHE_DURATION = 5e3;
const wait = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
const hasContactlisthaveSelectedtemplateVariables = async (options = {}) => {
  const {
    tagIds = []
  } = options;
  const cacheKey = JSON.stringify(tagIds.sort());
  const now = Date.now();
  if (requestCache.has(cacheKey)) {
    const lastRequest = requestCache.get(cacheKey);
    if (now - lastRequest < CACHE_DURATION) {
      console.log("Rate limiting: Using cached request for getContactLabels");
      return new Promise((resolve) => {
        setTimeout(() => {
          resolve({ status: false, message: "Rate limited - please try again" });
        }, CACHE_DURATION - (now - lastRequest));
      });
    }
  }
  requestCache.set(cacheKey, now);
  let retryCount = 0;
  const maxRetries = 3;
  const baseDelay = 1e3;
  while (retryCount <= maxRetries) {
    try {
      const response = await fetch("https://app.getgabs.com/partners/broadcast/campaignmanage/getContactLabels", {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          "Authorization": `Bearer ${API_TOKEN}`,
          "X-Requested-With": "XMLHttpRequest"
        },
        body: JSON.stringify({
          tag_id: JSON.stringify(tagIds.map((id) => parseInt(id, 10)))
        })
      });
      if (response.status === 429) {
        retryCount++;
        if (retryCount > maxRetries) {
          throw new Error("Rate limit exceeded. Please try again later.");
        }
        const delay = baseDelay * Math.pow(2, retryCount - 1);
        console.log(`Rate limited. Retrying in ${delay}ms... (Attempt ${retryCount}/${maxRetries})`);
        await wait(delay);
        continue;
      }
      if (!response.ok) {
        throw new Error(`HTTP error! Status: ${response.status}`);
      }
      const data = await response.json();
      return data;
    } catch (error) {
      if (error.message.includes("Rate limit") || retryCount > maxRetries) {
        console.error("Error fetching contact labels:", error);
        throw error;
      }
      retryCount++;
      if (retryCount <= maxRetries) {
        const delay = baseDelay * Math.pow(2, retryCount - 1);
        console.log(`Request failed. Retrying in ${delay}ms... (Attempt ${retryCount}/${maxRetries})`);
        await wait(delay);
      } else {
        console.error("Error fetching contact labels:", error);
        throw error;
      }
    }
  }
};
const fetchBroadcastList = async (options = {}) => {
  const {
    statusType = "All",
    page = 1,
    perPageData = 20
  } = options;
  try {
    const url = new URL(buildApiUrl(`${ENDPOINTS.BROADCAST.BASE}/${ENDPOINTS.BROADCAST.GET_BROADCAST_LIST}`));
    url.searchParams.append("statusType", statusType);
    url.searchParams.append("page", page.toString());
    url.searchParams.append("perPageData", perPageData.toString());
    url.searchParams.append("token", API_TOKEN);
    const response = await fetch(url.toString(), {
      method: "GET",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json"
      }
    });
    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }
    const data = await response.json();
    return data;
  } catch (error) {
    console.error("Error fetching broadcast campaign list:", error);
    throw error;
  }
};
async function sendBroadcastCampaign(broadcastpayload) {
  try {
    const url = `${API_BASE_URL}/partners/broadcast/campaignmanage/campaignSubmit`;
    const response = await fetch(url, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json",
        "Authorization": `Bearer ${API_TOKEN}`
      },
      body: JSON.stringify(broadcastpayload)
    });
    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }
    const data = await response.json();
    return data;
  } catch (error) {
    console.error("Error sending broadcast campaign:", error);
    throw error;
  }
}
function CreateBroadcastPage() {
  var _a2, _b;
  const navigate = useNavigate();
  const [broadcastName, setBroadcastName] = useState("");
  const [selectedTemplateId, setSelectedTemplateId] = useState("");
  const [templateInputValue, setTemplateInputValue] = useState("");
  const [variableMapping, setVariableMapping] = useState({});
  const [mediaMapping, setMediaMapping] = useState({});
  const [targetAudience, setTargetAudience] = useState("all");
  const [customAudienceFilters, setCustomAudienceFilters] = useState({
    collections: [],
    customerTags: [],
    orderHistory: "any",
    location: ""
  });
  const [selectedLiveSegments, setSelectedLiveSegments] = useState([]);
  const [selectedStaticLists, setSelectedStaticLists] = useState([]);
  const [liveSegmentInputValue, setLiveSegmentInputValue] = useState("");
  const [staticListInputValue, setStaticListInputValue] = useState("");
  const [liveSegmentDropdownActive, setLiveSegmentDropdownActive] = useState(false);
  const [staticListDropdownActive, setStaticListDropdownActive] = useState(false);
  const [scheduleType, setScheduleType] = useState("immediate");
  const [scheduledDate, setScheduledDate] = useState(/* @__PURE__ */ new Date());
  const [scheduledTime, setScheduledTime] = useState("09:00");
  const [datePickerActive, setDatePickerActive] = useState(false);
  const [estimatedReach, setEstimatedReach] = useState(0);
  const [staticContactLists, setStaticContactLists] = useState([]);
  const [staticListsLoading, setStaticListsLoading] = useState(false);
  const [staticListsLoadingMore, setStaticListsLoadingMore] = useState(false);
  const [staticListsNextPageUrl, setStaticListsNextPageUrl] = useState(null);
  const [staticListsError, setStaticListsError] = useState(null);
  const [debouncedSearchTerm, setDebouncedSearchTerm] = useState("");
  const [apiTemplates, setApiTemplates] = useState([]);
  const [loadingTemplates, setLoadingTemplates] = useState(false);
  const [templateError, setTemplateError] = useState(null);
  const [selectedTemplateData, setSelectedTemplateData] = useState(null);
  const [loadingTemplateDetails, setLoadingTemplateDetails] = useState(false);
  const [uploadingMedia, setUploadingMedia] = useState({});
  const [sendingBroadcast, setSendingBroadcast] = useState(false);
  const [broadcastError, setBroadcastError] = useState(null);
  const [contactListFields, setContactListFields] = useState([]);
  const [loadingContactListFields, setLoadingContactListFields] = useState(false);
  const [contactListFieldsError, setContactListFieldsError] = useState(null);
  const [staticValueEnabled, setStaticValueEnabled] = useState({});
  const [staticValues, setStaticValues] = useState({});
  const [urlButtonVariableMapping, setUrlButtonVariableMapping] = useState({});
  const [urlButtonStaticValueEnabled, setUrlButtonStaticValueEnabled] = useState({});
  const [urlButtonStaticValues, setUrlButtonStaticValues] = useState({});
  const [availableVariables, setAvailableVariables] = useState([
    { label: "name", value: "{{name}}" },
    { label: "number", value: "{{number}}" }
  ]);
  const [loadingVariables, setLoadingVariables] = useState(true);
  const [showVariablesModal, setShowVariablesModal] = useState(false);
  const [variableSearchQuery, setVariableSearchQuery] = useState("");
  const [variableInputValues, setVariableInputValues] = useState({});
  const [urlButtonVariableInputValues, setUrlButtonVariableInputValues] = useState({});
  const fetchApiTemplates2 = useCallback(async () => {
    try {
      setLoadingTemplates(true);
      setTemplateError(null);
      const response = await getAllTemplateList();
      if (response.status && response.data && response.data.customtemplates) {
        const transformedTemplates = response.data.customtemplates.map((template) => ({
          id: template.template_id ? template.template_id.toString() : "unknown",
          name: template.template_name || "Unknown Template",
          templateId: template.template_id,
          userId: template.user_id,
          label: template.template_name || "Unknown Template",
          value: template.template_id ? template.template_id.toString() : "unknown"
        }));
        setApiTemplates(transformedTemplates);
      } else {
        console.error("Invalid API response format:", response);
        setApiTemplates([]);
      }
    } catch (error) {
      console.error("Error fetching templates:", error);
      setTemplateError(`Failed to load templates: ${error.message}`);
      setApiTemplates([]);
    } finally {
      setLoadingTemplates(false);
    }
  }, []);
  useEffect(() => {
    fetchApiTemplates2();
  }, [fetchApiTemplates2]);
  const allTemplateOptions = useMemo(() => {
    return apiTemplates;
  }, [apiTemplates]);
  useEffect(() => {
    if (selectedTemplateData) {
      const initialVariableMapping = {};
      if (selectedTemplateData.components) {
        selectedTemplateData.components.forEach((component, index2) => {
          if (component.type === "BODY" && component.text) {
            const variables = component.text.match(/\{\{([^}]+)\}\}/g);
            if (variables) {
              variables.forEach((variable, varIndex) => {
                const varName = variable.match(/\{\{([^}]+)\}\}/)[1];
                const key = `body_var_${varName}`;
                initialVariableMapping[key] = {
                  placeholder: `{{${varName}}}`,
                  value: "",
                  required: true,
                  componentType: "BODY"
                };
              });
            }
          } else if (component.type === "FOOTER" && component.text) {
            const variables = component.text.match(/\{\{([^}]+)\}\}/g);
            if (variables) {
              variables.forEach((variable, varIndex) => {
                const varName = variable.match(/\{\{([^}]+)\}\}/)[1];
                const key = `footer_var_${varName}`;
                initialVariableMapping[key] = {
                  placeholder: `{{${varName}}}`,
                  value: "",
                  required: true,
                  componentType: "FOOTER"
                };
              });
            }
          } else if (component.type === "HEADER" && component.text) {
            const variables = component.text.match(/\{\{([^}]+)\}\}/g);
            if (variables) {
              variables.forEach((variable, varIndex) => {
                const varName = variable.match(/\{\{([^}]+)\}\}/)[1];
                const key = `header_var_${varName}`;
                initialVariableMapping[key] = {
                  placeholder: `{{${varName}}}`,
                  value: "",
                  required: true,
                  componentType: "HEADER"
                };
              });
            }
          }
        });
      }
      setVariableMapping(initialVariableMapping);
      const initialUrlButtonVariableMapping = {};
      if (selectedTemplateData.components) {
        selectedTemplateData.components.forEach((component, componentIndex) => {
          if (component.type === "BUTTONS" && component.buttons) {
            component.buttons.forEach((button2, buttonIndex) => {
              if (button2.type === "URL" && button2.url) {
                const variables = button2.url.match(/\{\{([^}]+)\}\}/g);
                if (variables) {
                  variables.forEach((variable, varIndex) => {
                    const varName = variable.match(/\{\{([^}]+)\}\}/)[1];
                    const key = `url_button_${componentIndex}_${buttonIndex}_var_${varName}`;
                    initialUrlButtonVariableMapping[key] = {
                      placeholder: `{{${varName}}}`,
                      value: "",
                      required: true,
                      componentType: "URL_BUTTON",
                      buttonText: button2.text,
                      buttonUrl: button2.url,
                      componentIndex,
                      buttonIndex
                    };
                  });
                }
              }
            });
          }
        });
      }
      setUrlButtonVariableMapping(initialUrlButtonVariableMapping);
      const initialMediaMapping = {};
      if (selectedTemplateData.components) {
        selectedTemplateData.components.forEach((component, index2) => {
          var _a3, _b2, _c, _d, _e, _f;
          if (component.type === "HEADER" && component.format === "IMAGE") {
            initialMediaMapping[`header_${index2}`] = {
              type: "image",
              url: ((_b2 = (_a3 = component.example) == null ? void 0 : _a3.header_handle) == null ? void 0 : _b2[0]) || "",
              required: true,
              fileUrl: null,
              file: null
            };
          } else if (component.type === "HEADER" && component.format === "VIDEO") {
            initialMediaMapping[`header_${index2}`] = {
              type: "video",
              url: ((_d = (_c = component.example) == null ? void 0 : _c.header_handle) == null ? void 0 : _d[0]) || "",
              required: true,
              fileUrl: null,
              file: null
            };
          } else if (component.type === "HEADER" && component.format === "DOCUMENT") {
            initialMediaMapping[`header_${index2}`] = {
              type: "document",
              url: ((_f = (_e = component.example) == null ? void 0 : _e.header_handle) == null ? void 0 : _f[0]) || "",
              required: true,
              fileUrl: null,
              file: null
            };
          }
        });
      }
      setMediaMapping(initialMediaMapping);
    }
  }, [selectedTemplateData]);
  const filteredTemplateOptions = useMemo(() => {
    if (!templateInputValue.trim()) return allTemplateOptions;
    const searchLower = templateInputValue.toLowerCase();
    return allTemplateOptions.filter(
      (template) => {
        var _a3;
        return template.label.toLowerCase().includes(searchLower) || ((_a3 = template.name) == null ? void 0 : _a3.toLowerCase().includes(searchLower));
      }
    );
  }, [allTemplateOptions, templateInputValue]);
  const templateVariables = useMemo(() => {
    if (!selectedTemplateData) return {};
    const variableMapping2 = {};
    if (selectedTemplateData.components) {
      selectedTemplateData.components.forEach((component, index2) => {
        if (component.type === "BODY" && component.text) {
          const variables = component.text.match(/\{\{([^}]+)\}\}/g);
          if (variables) {
            variables.forEach((variable, varIndex) => {
              const varName = variable.match(/\{\{([^}]+)\}\}/)[1];
              variableMapping2[`body_var_${varName}`] = {
                placeholder: `{{${varName}}}`,
                value: "",
                required: true,
                componentType: "BODY"
              };
            });
          }
        } else if (component.type === "HEADER" && component.text) {
          const variables = component.text.match(/\{\{([^}]+)\}\}/g);
          if (variables) {
            variables.forEach((variable, varIndex) => {
              const varName = variable.match(/\{\{([^}]+)\}\}/)[1];
              variableMapping2[`header_var_${varName}`] = {
                placeholder: `{{${varName}}}`,
                value: "",
                required: true,
                componentType: "HEADER"
              };
            });
          }
        }
      });
    }
    return variableMapping2;
  }, [selectedTemplateData]);
  const urlButtonVariables = useMemo(() => {
    if (!selectedTemplateData) return {};
    const buttonVariableMapping = {};
    if (selectedTemplateData.components) {
      selectedTemplateData.components.forEach((component, componentIndex) => {
        if (component.type === "BUTTONS" && component.buttons) {
          component.buttons.forEach((button2, buttonIndex) => {
            if (button2.type === "URL" && button2.url) {
              const variables = button2.url.match(/\{\{([^}]+)\}\}/g);
              if (variables) {
                variables.forEach((variable, varIndex) => {
                  const varName = variable.match(/\{\{([^}]+)\}\}/)[1];
                  const key = `url_button_${componentIndex}_${buttonIndex}_var_${varName}`;
                  buttonVariableMapping[key] = {
                    placeholder: `{{${varName}}}`,
                    value: "",
                    required: true,
                    componentType: "URL_BUTTON",
                    buttonText: button2.text,
                    buttonUrl: button2.url,
                    componentIndex,
                    buttonIndex
                  };
                });
              }
            }
          });
        }
      });
    }
    return buttonVariableMapping;
  }, [selectedTemplateData]);
  const templateMedia = useMemo(() => {
    if (!selectedTemplateData) return {};
    const mediaMapping2 = {};
    if (selectedTemplateData.components) {
      selectedTemplateData.components.forEach((component, index2) => {
        var _a3, _b2, _c, _d, _e, _f;
        if (component.type === "HEADER" && component.format === "IMAGE") {
          mediaMapping2[`header_${index2}`] = {
            type: "image",
            url: ((_b2 = (_a3 = component.example) == null ? void 0 : _a3.header_handle) == null ? void 0 : _b2[0]) || "",
            required: true,
            fileUrl: null,
            file: null
          };
        } else if (component.type === "HEADER" && component.format === "VIDEO") {
          mediaMapping2[`header_${index2}`] = {
            type: "video",
            url: ((_d = (_c = component.example) == null ? void 0 : _c.header_handle) == null ? void 0 : _d[0]) || "",
            required: true,
            fileUrl: null,
            file: null
          };
        } else if (component.type === "HEADER" && component.format === "DOCUMENT") {
          mediaMapping2[`header_${index2}`] = {
            type: "document",
            url: ((_f = (_e = component.example) == null ? void 0 : _e.header_handle) == null ? void 0 : _f[0]) || "",
            required: true,
            fileUrl: null,
            file: null
          };
        }
      });
    }
    return mediaMapping2;
  }, [selectedTemplateData]);
  useEffect(() => {
    const fetchVariables = async () => {
      try {
        setLoadingVariables(true);
        const variables = await getTemplateVariables();
        const predefinedVariables = [
          { label: "name", value: "{{name}}" },
          { label: "number", value: "{{number}}" }
        ];
        setAvailableVariables([...predefinedVariables, ...variables]);
      } catch (error) {
        console.error("Error fetching variables:", error);
        setAvailableVariables([]);
      } finally {
        setLoadingVariables(false);
      }
    };
    fetchVariables();
  }, []);
  useEffect(() => {
    if (availableVariables.length > 0) {
      const newVariableInputValues = {};
      Object.entries(variableMapping).forEach(([variableKey, variableData]) => {
        if (variableData.value) {
          const selectedVar = availableVariables.find((av) => av.value === variableData.value);
          if (selectedVar) {
            newVariableInputValues[variableKey] = selectedVar.label;
          }
        }
      });
      setVariableInputValues(newVariableInputValues);
      const newUrlButtonInputValues = {};
      Object.entries(urlButtonVariableMapping).forEach(([variableKey, variableData]) => {
        if (variableData.value) {
          const selectedVar = availableVariables.find((av) => av.value === variableData.value);
          if (selectedVar) {
            newUrlButtonInputValues[variableKey] = selectedVar.label;
          }
        }
      });
      setUrlButtonVariableInputValues(newUrlButtonInputValues);
    }
  }, [availableVariables, variableMapping, urlButtonVariableMapping]);
  const convertVariableMappingForPreview = () => {
    const previewMapping = {};
    Object.entries(variableMapping).forEach(([variableKey, variableData]) => {
      const varName = variableKey.replace(/^(body_var_|header_var_|footer_var_)/, "");
      if (staticValueEnabled[variableKey] && staticValues[variableKey]) {
        previewMapping[varName] = staticValues[variableKey];
      } else if (variableData && variableData.value) {
        const availableVar = availableVariables.find((av) => av.value === variableData.value);
        const displayValue = availableVar ? availableVar.label : variableData.value;
        previewMapping[varName] = displayValue;
      }
    });
    return previewMapping;
  };
  const convertMediaMappingForPreview = () => {
    const previewMapping = {};
    Object.entries(mediaMapping).forEach(([mediaKey, mediaData]) => {
      if (mediaData && (mediaData.file || mediaData.url)) {
        previewMapping[mediaKey] = {
          link: mediaData.fileUrl || mediaData.url,
          file: mediaData.file,
          uploaded: mediaData.uploaded || false,
          fileName: mediaData.fileName
        };
      }
    });
    return previewMapping;
  };
  const getTemplateForPreview = (templateData) => {
    if (!templateData) return null;
    try {
      const templateValue = {
        sender: "",
        campaign_id: "put_campaign_id",
        messaging_product: "whatsapp",
        recipient_type: "individual",
        to: "receiver_number",
        type: "template",
        template: {
          name: templateData.name || "template",
          language: {
            code: templateData.language || "en_US"
          },
          components: templateData.components || []
        }
      };
      return JSON.stringify(templateValue);
    } catch (error) {
      console.error("Error preparing template for preview:", error);
      return null;
    }
  };
  const audienceOptions = [
    // { label: 'All customers', value: 'all' },
    { label: "Static List (your uploaded Contacts)", value: "static_list" },
    { label: "Live Segment", value: "live_segment" }
  ];
  const liveSegmentOptions = [
    { label: "High Value Customers", value: "high_value_customers", contacts: 2450 },
    { label: "Abandoned Cart Users", value: "abandoned_cart_users", contacts: 1230 },
    { label: "New Subscribers", value: "new_subscribers", contacts: 890 },
    { label: "Frequent Buyers", value: "frequent_buyers", contacts: 3200 },
    { label: "VIP Members", value: "vip_members", contacts: 450 },
    { label: "Recent Purchasers", value: "recent_purchasers", contacts: 1800 }
  ];
  const staticListOptions = useMemo(() => {
    const uniqueLists = /* @__PURE__ */ new Map();
    staticContactLists.forEach((list2) => {
      var _a3;
      if (list2.id && !uniqueLists.has(list2.id)) {
        uniqueLists.set(list2.id, {
          label: list2.name || `List ${list2.id}`,
          value: (_a3 = list2.id) == null ? void 0 : _a3.toString(),
          contacts: list2.totalcontatspertag_count || 0,
          id: list2.id
        });
      }
    });
    return Array.from(uniqueLists.values());
  }, [staticContactLists]);
  useEffect(() => {
    let reach = 0;
    switch (targetAudience) {
      case "all":
        reach = 0;
        break;
      case "live_segment":
        reach = selectedLiveSegments.reduce((total, segmentValue) => {
          const segment = liveSegmentOptions.find((option) => option.value === segmentValue);
          return total + (segment ? segment.contacts : 0);
        }, 0);
        break;
      case "static_list":
        reach = selectedStaticLists.reduce((total, listValue) => {
          const list2 = staticListOptions.find((option) => option.value === listValue);
          return total + (list2 ? list2.contacts : 0);
        }, 0);
        break;
      default:
        reach = 0;
    }
    setEstimatedReach(reach);
  }, [targetAudience, selectedLiveSegments, selectedStaticLists, liveSegmentOptions, staticListOptions]);
  useCallback(async (resetData = true) => {
    var _a3;
    if (resetData) {
      setStaticListsLoading(true);
      setStaticListsError(null);
      setStaticContactLists([]);
      setStaticListsNextPageUrl(null);
    } else {
      setStaticListsLoadingMore(true);
    }
    try {
      const response = await fetchStaticContactList({
        page: 1,
        perPageData: 50,
        actionType: 0
      });
      let newLists = [];
      let nextPageUrl = null;
      if (((_a3 = response == null ? void 0 : response.WhatsAppBusinessTag) == null ? void 0 : _a3.data) && Array.isArray(response.WhatsAppBusinessTag.data)) {
        newLists = response.WhatsAppBusinessTag.data;
        nextPageUrl = response.WhatsAppBusinessTag.next_page_url || null;
      } else if ((response == null ? void 0 : response.data) && Array.isArray(response.data)) {
        newLists = response.data;
        nextPageUrl = response.next_page_url || null;
      } else if ((response == null ? void 0 : response.contactLists) && Array.isArray(response.contactLists)) {
        newLists = response.contactLists;
        nextPageUrl = response.next_page_url || null;
      } else {
        console.warn("Unexpected API response format:", response);
        newLists = [];
      }
      if (resetData) {
        setStaticContactLists(newLists);
      } else {
        setStaticContactLists((prev) => [...prev, ...newLists]);
      }
      setStaticListsNextPageUrl(nextPageUrl);
    } catch (error) {
      console.error("Error fetching static contact lists:", error);
      setStaticListsError("Failed to load contact lists. Please try again.");
      if (resetData) {
        setStaticContactLists([]);
      }
    } finally {
      if (resetData) {
        setStaticListsLoading(false);
      } else {
        setStaticListsLoadingMore(false);
      }
    }
  }, []);
  useCallback(async (nextPageUrl) => {
    var _a3;
    if (!nextPageUrl) return;
    setStaticListsLoadingMore(true);
    try {
      const response = await fetch(nextPageUrl, {
        method: "GET",
        headers: {
          "Content-Type": "application/json",
          "Accept": "application/json"
        }
      });
      if (!response.ok) {
        throw new Error(`HTTP error! status: ${response.status}`);
      }
      const data = await response.json();
      let newLists = [];
      let nextUrl = null;
      if (((_a3 = data == null ? void 0 : data.WhatsAppBusinessTag) == null ? void 0 : _a3.data) && Array.isArray(data.WhatsAppBusinessTag.data)) {
        newLists = data.WhatsAppBusinessTag.data;
        nextUrl = data.WhatsAppBusinessTag.next_page_url || null;
      } else if ((data == null ? void 0 : data.data) && Array.isArray(data.data)) {
        newLists = data.data;
        nextUrl = data.next_page_url || null;
      } else if ((data == null ? void 0 : data.contactLists) && Array.isArray(data.contactLists)) {
        newLists = data.contactLists;
        nextUrl = data.next_page_url || null;
      }
      setStaticContactLists((prev) => {
        const existingIds = new Set(prev.map((list2) => list2.id));
        const uniqueNewLists = newLists.filter((list2) => !existingIds.has(list2.id));
        return [...prev, ...uniqueNewLists];
      });
      setStaticListsNextPageUrl(nextUrl);
    } catch (error) {
      console.error("Error loading more static contact lists:", error);
    } finally {
      setStaticListsLoadingMore(false);
    }
  }, []);
  const loadAllStaticLists = useCallback(async () => {
    var _a3;
    setStaticListsLoading(true);
    setStaticListsError(null);
    setStaticContactLists([]);
    setStaticListsNextPageUrl(null);
    try {
      let allLists = [];
      let currentPage = 1;
      let hasMorePages = true;
      while (hasMorePages) {
        const response = await fetchStaticContactList({
          page: currentPage,
          perPageData: 50,
          actionType: 0
        });
        let newLists = [];
        let nextPageUrl = null;
        if (((_a3 = response == null ? void 0 : response.WhatsAppBusinessTag) == null ? void 0 : _a3.data) && Array.isArray(response.WhatsAppBusinessTag.data)) {
          newLists = response.WhatsAppBusinessTag.data;
          nextPageUrl = response.WhatsAppBusinessTag.next_page_url || null;
        } else if ((response == null ? void 0 : response.data) && Array.isArray(response.data)) {
          newLists = response.data;
          nextPageUrl = response.next_page_url || null;
        } else if ((response == null ? void 0 : response.contactLists) && Array.isArray(response.contactLists)) {
          newLists = response.contactLists;
          nextPageUrl = response.next_page_url || null;
        }
        const existingIds = new Set(allLists.map((list2) => list2.id));
        const uniqueNewLists = newLists.filter((list2) => list2.id && !existingIds.has(list2.id));
        allLists = [...allLists, ...uniqueNewLists];
        if (nextPageUrl && newLists.length > 0) {
          currentPage++;
          await new Promise((resolve) => setTimeout(resolve, 100));
        } else {
          hasMorePages = false;
        }
        if (currentPage > 100) {
          console.warn("Reached maximum page limit (100) while loading static contact lists");
          hasMorePages = false;
        }
      }
      setStaticContactLists(allLists);
      console.log(`Loaded ${allLists.length} static contact lists from ${currentPage} pages`);
    } catch (error) {
      console.error("Error loading all static contact lists:", error);
      setStaticListsError("Failed to load all contact lists. Please try again.");
      setStaticContactLists([]);
    } finally {
      setStaticListsLoading(false);
    }
  }, []);
  useEffect(() => {
    if (targetAudience === "static_list" && staticContactLists.length === 0 && !staticListsLoading) {
      loadAllStaticLists();
    }
  }, [targetAudience, staticContactLists.length, staticListsLoading, loadAllStaticLists]);
  useEffect(() => {
    const timer = setTimeout(() => {
      setDebouncedSearchTerm(staticListInputValue);
    }, 300);
    return () => clearTimeout(timer);
  }, [staticListInputValue]);
  const handleTemplateChange = useCallback(async (value) => {
    setSelectedTemplateId(value);
    const selectedTemplate = allTemplateOptions.find((t) => t.id === value || t.value === value);
    if (selectedTemplate) {
      setTemplateInputValue(selectedTemplate.label);
      if (selectedTemplate.templateId) {
        try {
          setLoadingTemplateDetails(true);
          setTemplateError(null);
          const response = await getSelectedTemplatebyName(selectedTemplate.name);
          if (response.data && response.data.length > 0) {
            const templateData = response.data[0];
            setSelectedTemplateData(templateData);
          } else {
            console.error("No template data found");
            setTemplateError("Template not found or invalid");
            setSelectedTemplateData(null);
          }
        } catch (error) {
          console.error("Error fetching template details:", error);
          setTemplateError(`Failed to load template: ${error.message}`);
          setSelectedTemplateData(null);
        } finally {
          setLoadingTemplateDetails(false);
        }
      }
    } else {
      setTemplateInputValue("");
      setSelectedTemplateData(null);
    }
    setVariableMapping({});
    setMediaMapping({});
    setStaticValueEnabled({});
    setStaticValues({});
    setUrlButtonVariableMapping({});
    setUrlButtonStaticValueEnabled({});
    setUrlButtonStaticValues({});
    setVariableInputValues({});
    setUrlButtonVariableInputValues({});
  }, [allTemplateOptions]);
  const handleVariableMappingChange = useCallback((variableKey, value) => {
    setVariableMapping((prev) => ({
      ...prev,
      [variableKey]: {
        ...prev[variableKey],
        value
      }
    }));
  }, []);
  const handleStaticValueToggle = useCallback((variableKey) => {
    setStaticValueEnabled((prev) => {
      const newEnabled = { ...prev, [variableKey]: !prev[variableKey] };
      if (!newEnabled[variableKey]) {
        setStaticValues((prevStatic) => {
          const newStatic = { ...prevStatic };
          delete newStatic[variableKey];
          return newStatic;
        });
        setVariableInputValues((prev2) => {
          const newInputs = { ...prev2 };
          delete newInputs[variableKey];
          return newInputs;
        });
        setVariableMapping((prevMapping) => ({
          ...prevMapping,
          [variableKey]: {
            ...prevMapping[variableKey],
            value: ""
          }
        }));
      }
      return newEnabled;
    });
  }, []);
  const handleStaticValueChange = useCallback((variableKey, value) => {
    setStaticValues((prev) => ({
      ...prev,
      [variableKey]: value
    }));
  }, []);
  const handleUrlButtonVariableMappingChange = useCallback((variableKey, value) => {
    setUrlButtonVariableMapping((prev) => ({
      ...prev,
      [variableKey]: {
        ...prev[variableKey],
        value
      }
    }));
  }, []);
  const handleUrlButtonStaticValueToggle = useCallback((variableKey) => {
    setUrlButtonStaticValueEnabled((prev) => {
      const newEnabled = { ...prev, [variableKey]: !prev[variableKey] };
      if (!newEnabled[variableKey]) {
        setUrlButtonStaticValues((prevStatic) => {
          const newStatic = { ...prevStatic };
          delete newStatic[variableKey];
          return newStatic;
        });
        setUrlButtonVariableMapping((prevMapping) => ({
          ...prevMapping,
          [variableKey]: {
            ...prevMapping[variableKey],
            value: ""
          }
        }));
        setUrlButtonVariableInputValues((prev2) => {
          const newInputs = { ...prev2 };
          delete newInputs[variableKey];
          return newInputs;
        });
      }
      return newEnabled;
    });
  }, []);
  const handleUrlButtonStaticValueChange = useCallback((variableKey, value) => {
    setUrlButtonStaticValues((prev) => ({
      ...prev,
      [variableKey]: value
    }));
  }, []);
  const handleMediaMappingChange = useCallback(async (mediaKey, file) => {
    if (file) {
      setUploadingMedia((prev) => ({ ...prev, [mediaKey]: true }));
      try {
        const reader = new FileReader();
        reader.onload = async () => {
          try {
            const base64String = reader.result.split(",")[1];
            let fileType = "image";
            if (file.type.startsWith("video/")) {
              fileType = "video";
            } else if (file.type.startsWith("audio/")) {
              fileType = "audio";
            } else if (file.type.includes("pdf") || file.type.includes("document") || file.type.includes("text")) {
              fileType = "document";
            }
            const filePayload = {
              fileName: file.name,
              fileSrc: `data:${file.type};base64,${base64String}`,
              fileType
            };
            const uploadResponse = await saveTemporaryFile(filePayload);
            if (uploadResponse.status && uploadResponse.filename) {
              const getGabsUrl = `https://app.getgabs.com/customers/mediafile/newfiles/uploads/${uploadResponse.filename}`;
              setMediaMapping((prev) => ({
                ...prev,
                [mediaKey]: {
                  ...prev[mediaKey],
                  file,
                  fileUrl: getGabsUrl,
                  fileName: uploadResponse.filename,
                  uploaded: true,
                  uploadError: null
                }
              }));
            } else {
              throw new Error(uploadResponse.message || "Failed to upload file");
            }
          } catch (error) {
            console.error("Error uploading file:", error);
            setMediaMapping((prev) => ({
              ...prev,
              [mediaKey]: {
                ...prev[mediaKey],
                uploadError: error.message
              }
            }));
            setTemplateError(`Failed to upload file: ${error.message}`);
          } finally {
            setUploadingMedia((prev) => ({ ...prev, [mediaKey]: false }));
          }
        };
        reader.onerror = () => {
          setTemplateError("Failed to read file");
          setUploadingMedia((prev) => ({ ...prev, [mediaKey]: false }));
        };
        reader.readAsDataURL(file);
      } catch (error) {
        console.error("Error uploading file:", error);
        setTemplateError(`Failed to upload file: ${error.message}`);
        setUploadingMedia((prev) => ({ ...prev, [mediaKey]: false }));
      }
    } else {
      setMediaMapping((prev) => ({
        ...prev,
        [mediaKey]: {
          ...prev[mediaKey],
          file: null,
          fileUrl: null,
          fileName: null,
          uploaded: false,
          uploadError: null
        }
      }));
    }
  }, []);
  const handleTargetAudienceChange = useCallback((value) => {
    setTargetAudience(value);
    if (value !== "live_segment") {
      setSelectedLiveSegments([]);
      setLiveSegmentInputValue("");
      setLiveSegmentDropdownActive(false);
    }
    if (value !== "static_list") {
      setSelectedStaticLists([]);
      setStaticListInputValue("");
      setStaticListDropdownActive(false);
    }
    if (value === "static_list" && staticContactLists.length === 0 && !staticListsLoading) {
      loadAllStaticLists();
    }
  }, [staticContactLists.length, staticListsLoading, loadAllStaticLists]);
  useCallback((field, value) => {
    setCustomAudienceFilters((prev) => ({
      ...prev,
      [field]: value
    }));
  }, []);
  const handleDateChange = useCallback((date) => {
    setScheduledDate(date.start);
    setDatePickerActive(false);
  }, []);
  useCallback((value) => {
    console.log("Live segment selected:", value);
    if (value && !selectedLiveSegments.includes(value)) {
      setSelectedLiveSegments([...selectedLiveSegments, value]);
    }
    setLiveSegmentInputValue("");
    setLiveSegmentDropdownActive(false);
  }, [selectedLiveSegments]);
  const handleLiveSegmentRemove = useCallback((value) => {
    setSelectedLiveSegments(selectedLiveSegments.filter((segment) => segment !== value));
  }, [selectedLiveSegments]);
  const handleStaticListSelect = useCallback((value) => {
    console.log("Static list selected:", value);
    if (value && !selectedStaticLists.includes(value)) {
      setSelectedStaticLists([...selectedStaticLists, value]);
    }
    setStaticListInputValue("");
    setStaticListDropdownActive(false);
  }, [selectedStaticLists]);
  const handleStaticListRemove = useCallback((value) => {
    setSelectedStaticLists(selectedStaticLists.filter((list2) => list2 !== value));
  }, [selectedStaticLists]);
  const fetchContactListFieldsAndAutoMap = useCallback(async (tagIds) => {
    if (!tagIds || tagIds.length === 0 || !selectedTemplateData) {
      return { status: false, message: "Missing required parameters" };
    }
    try {
      setLoadingContactListFields(true);
      setContactListFieldsError(null);
      const response = await hasContactlisthaveSelectedtemplateVariables({ tagIds });
      if (response.status && response.data && response.data.length > 0) {
        setContactListFields(response.data);
        const templateVars = [];
        if (selectedTemplateData.components) {
          selectedTemplateData.components.forEach((component) => {
            if (component.text) {
              const variables = component.text.match(/\{\{([^}]+)\}\}/g);
              if (variables) {
                variables.forEach((variable) => {
                  const varName = variable.match(/\{\{([^}]+)\}\}/)[1];
                  if (!templateVars.includes(varName)) {
                    templateVars.push(varName);
                  }
                });
              }
            }
          });
        }
        const availableContactFields = /* @__PURE__ */ new Map();
        response.data.forEach((contactList) => {
          if (contactList.newjsonfields) {
            try {
              const fields = JSON.parse(contactList.newjsonfields);
              Object.entries(fields).forEach(([key, value]) => {
                if (value && !availableContactFields.has(value)) {
                  availableContactFields.set(value, {
                    value: value.toLowerCase().replace(/\s+/g, "_"),
                    label: value,
                    fieldKey: key
                  });
                }
              });
            } catch (error) {
              console.error("Error parsing newjsonfields:", error);
            }
          }
        });
        const availableVariablesList = Array.from(availableContactFields.values());
        const newVariableMapping = { ...variableMapping };
        const newVariableInputValues = { ...variableInputValues };
        templateVars.forEach((varName) => {
          const variableKey = `body_var_${varName}`;
          const matchingField = Array.from(availableContactFields.entries()).find(([fieldName]) => {
            const fieldNameLower = fieldName.toLowerCase();
            const varNameLower = varName.toLowerCase();
            return fieldNameLower.includes(varNameLower) || varNameLower.includes(fieldNameLower);
          });
          if (matchingField) {
            const [fieldName, fieldData] = matchingField;
            newVariableMapping[variableKey] = {
              ...newVariableMapping[variableKey],
              value: fieldData.value,
              fieldKey: fieldData.fieldKey
            };
            newVariableInputValues[variableKey] = fieldName;
          }
        });
        setVariableMapping(newVariableMapping);
        setVariableInputValues(newVariableInputValues);
        const predefinedVariables = [
          { label: "name", value: "{{name}}" },
          { label: "number", value: "{{number}}" }
        ];
        setAvailableVariables([...predefinedVariables, ...availableVariablesList]);
      } else {
        setContactListFields([]);
        setAvailableVariables([]);
      }
    } catch (error) {
      console.error("Error fetching contact list fields:", error);
      if (error.message.includes("Rate limit")) {
        setContactListFieldsError("Rate limit exceeded. Please wait a moment and try again.");
      } else {
        setContactListFieldsError("Failed to load contact list fields");
      }
      setContactListFields([]);
    } finally {
      setLoadingContactListFields(false);
    }
    return { status: true };
  }, [selectedTemplateData, availableVariables, variableMapping, variableInputValues, setVariableMapping, setVariableInputValues, setAvailableVariables, setContactListFields, setContactListFieldsError]);
  const lastProcessedTemplateId = useRef(null);
  const isProcessing = useRef(false);
  useEffect(() => {
    if (selectedStaticLists.length === 0 || !selectedTemplateData || targetAudience !== "static_list" || isProcessing.current) {
      return;
    }
    const currentTemplateKey = `${selectedTemplateData.id || ""}-${selectedStaticLists.sort().join("-")}`;
    if (lastProcessedTemplateId.current === currentTemplateKey) {
      return;
    }
    console.log("Analyzing contact list fields for auto-mapping...");
    isProcessing.current = true;
    lastProcessedTemplateId.current = currentTemplateKey;
    const timer = setTimeout(() => {
      fetchContactListFieldsAndAutoMap(selectedStaticLists).finally(() => {
        isProcessing.current = false;
      });
    }, 100);
    return () => {
      clearTimeout(timer);
      isProcessing.current = false;
    };
  }, [selectedStaticLists, selectedTemplateData, targetAudience, fetchContactListFieldsAndAutoMap]);
  const handleSaveBroadcast = useCallback(async () => {
    try {
      setSendingBroadcast(true);
      setBroadcastError(null);
      const campaignSchedule = scheduleType === "immediate" ? { scheduleType: "now" } : {
        scheduleType: "schedule",
        scheduleDateTime: `${scheduledDate.getFullYear()}-${String(scheduledDate.getMonth() + 1).padStart(2, "0")}-${String(scheduledDate.getDate()).padStart(2, "0")} ${scheduledTime}:00`
      };
      const templateComponents = [];
      if (selectedTemplateData == null ? void 0 : selectedTemplateData.components) {
        selectedTemplateData.components.forEach((component) => {
          if (component.type === "BODY") {
            const bodyParameters = [];
            if (component.text) {
              const variables = component.text.match(/\{\{([^}]+)\}\}/g);
              if (variables) {
                variables.forEach((variable) => {
                  var _a3;
                  const varName = variable.match(/\{\{([^}]+)\}\}/)[1];
                  const variableKey = `body_var_${varName}`;
                  let parameterValue = varName;
                  if (staticValueEnabled[variableKey] && staticValues[variableKey]) {
                    parameterValue = staticValues[variableKey];
                  } else if ((_a3 = variableMapping[variableKey]) == null ? void 0 : _a3.value) {
                    const selectedVariableKey = variableMapping[variableKey].value;
                    const availableVar = availableVariables.find((av) => av.value === selectedVariableKey);
                    parameterValue = availableVar ? availableVar.label : selectedVariableKey;
                  }
                  bodyParameters.push({
                    type: "text",
                    parameter_name: varName,
                    text: `{${parameterValue}}`
                  });
                });
              }
            }
            if (bodyParameters.length > 0) {
              templateComponents.push({
                type: "BODY",
                parameters: bodyParameters
              });
            }
          } else if (component.type === "HEADER" && component.text) {
            const headerParameters = [];
            const variables = component.text.match(/\{\{([^}]+)\}\}/g);
            if (variables) {
              variables.forEach((variable) => {
                var _a3;
                const varName = variable.match(/\{\{([^}]+)\}\}/)[1];
                const variableKey = `header_var_${varName}`;
                let parameterValue = varName;
                if (staticValueEnabled[variableKey] && staticValues[variableKey]) {
                  parameterValue = staticValues[variableKey];
                } else if ((_a3 = variableMapping[variableKey]) == null ? void 0 : _a3.value) {
                  const selectedVariableKey = variableMapping[variableKey].value;
                  const availableVar = availableVariables.find((av) => av.value === selectedVariableKey);
                  parameterValue = availableVar ? availableVar.label : selectedVariableKey;
                }
                headerParameters.push({
                  type: "text",
                  parameter_name: varName,
                  text: `{${parameterValue}}`
                });
              });
            }
            if (headerParameters.length > 0) {
              templateComponents.push({
                type: "HEADER",
                parameters: headerParameters
              });
            }
          } else if (component.type === "HEADER" && (component.format === "IMAGE" || component.format === "VIDEO" || component.format === "DOCUMENT")) {
            const headerKey = `header_${selectedTemplateData.components.indexOf(component)}`;
            const mediaData = mediaMapping[headerKey];
            if ((mediaData == null ? void 0 : mediaData.fileUrl) || (mediaData == null ? void 0 : mediaData.url)) {
              templateComponents.push({
                type: "HEADER",
                parameters: [{
                  type: component.format.toLowerCase(),
                  [component.format.toLowerCase()]: {
                    link: mediaData.fileUrl || mediaData.url
                  }
                }]
              });
            }
          } else if (component.type === "BUTTONS" && component.buttons) {
            const componentIndex = selectedTemplateData.components.indexOf(component);
            component.buttons.forEach((button2, buttonIndex) => {
              if (button2.type === "CATALOG") {
                templateComponents.push({
                  type: "button",
                  sub_type: "CATALOG",
                  index: buttonIndex,
                  parameters: [{
                    type: "action",
                    action: {
                      thumbnail_product_retailer_id: "iu2y8d292a"
                      // Default catalog ID
                    }
                  }]
                });
              } else if (button2.type === "URL" && button2.url) {
                const variables = button2.url.match(/\{\{([^}]+)\}\}/g);
                if (variables) {
                  const urlParameters = [];
                  variables.forEach((variable) => {
                    var _a3;
                    const varName = variable.match(/\{\{([^}]+)\}\}/)[1];
                    const variableKey = `url_button_${componentIndex}_${buttonIndex}_var_${varName}`;
                    let parameterValue = varName;
                    if (urlButtonStaticValueEnabled[variableKey] && urlButtonStaticValues[variableKey]) {
                      parameterValue = urlButtonStaticValues[variableKey];
                    } else if ((_a3 = urlButtonVariableMapping[variableKey]) == null ? void 0 : _a3.value) {
                      const selectedVariableKey = urlButtonVariableMapping[variableKey].value;
                      const availableVar = availableVariables.find((av) => av.value === selectedVariableKey);
                      parameterValue = availableVar ? availableVar.label : selectedVariableKey;
                    }
                    urlParameters.push({
                      type: "text",
                      text: urlButtonStaticValueEnabled[variableKey] && urlButtonStaticValues[variableKey] ? parameterValue : `{${parameterValue}}`
                    });
                  });
                  if (urlParameters.length > 0) {
                    templateComponents.push({
                      type: "button",
                      sub_type: "URL",
                      index: buttonIndex,
                      parameters: urlParameters
                    });
                  }
                }
              }
            });
          } else if (component.type === "FOOTER" && component.text) {
            const footerParameters = [];
            const variables = component.text.match(/\{\{([^}]+)\}\}/g);
            if (variables) {
              variables.forEach((variable) => {
                var _a3;
                const varName = variable.match(/\{\{([^}]+)\}\}/)[1];
                const variableKey = `footer_var_${varName}`;
                let parameterValue = varName;
                if (staticValueEnabled[variableKey] && staticValues[variableKey]) {
                  parameterValue = staticValues[variableKey];
                } else if ((_a3 = variableMapping[variableKey]) == null ? void 0 : _a3.value) {
                  const selectedVariableKey = variableMapping[variableKey].value;
                  const availableVar = availableVariables.find((av) => av.value === selectedVariableKey);
                  parameterValue = availableVar ? availableVar.label : selectedVariableKey;
                }
                footerParameters.push({
                  type: "text",
                  parameter_name: varName,
                  text: parameterValue
                });
              });
            }
            if (footerParameters.length > 0) {
              templateComponents.push({
                type: "FOOTER",
                parameters: footerParameters
              });
            }
          }
        });
      }
      const templateJson = {
        to: "receiver_number",
        type: "template",
        template: {
          name: (selectedTemplateData == null ? void 0 : selectedTemplateData.name) || "template",
          language: {
            code: (selectedTemplateData == null ? void 0 : selectedTemplateData.language) || "en_US"
          },
          components: templateComponents
        },
        recipient_type: "individual",
        messaging_product: "whatsapp"
      };
      const currentChoosedTemplateJson = {
        choosedTemplate: {
          name: (selectedTemplateData == null ? void 0 : selectedTemplateData.name) || "template",
          parameter_format: "POSITIONAL",
          components: (selectedTemplateData == null ? void 0 : selectedTemplateData.components) || [],
          language: (selectedTemplateData == null ? void 0 : selectedTemplateData.language) || "en_US",
          status: (selectedTemplateData == null ? void 0 : selectedTemplateData.status) || "APPROVED",
          category: (selectedTemplateData == null ? void 0 : selectedTemplateData.category) || "MARKETING",
          id: (selectedTemplateData == null ? void 0 : selectedTemplateData.id) || (selectedTemplateData == null ? void 0 : selectedTemplateData.template_id) || ""
        }
      };
      const contactTagIds = [];
      if (targetAudience === "static_list" && selectedStaticLists.length > 0) {
        contactTagIds.push(...selectedStaticLists);
      }
      const broadcastPayload = {
        CampaignSchedule: campaignSchedule,
        campaign_name: broadcastName,
        templateJson,
        currentChoosedTemplateJson,
        contactTagIds
      };
      console.log("Sending broadcast payload:", broadcastPayload);
      const response = await sendBroadcastCampaign(broadcastPayload);
      console.log("Broadcast sent successfully:", response);
      navigate("/app/broadcast");
    } catch (error) {
      console.error("Error sending broadcast:", error);
      setBroadcastError(`Failed to send broadcast: ${error.message}`);
    } finally {
      setSendingBroadcast(false);
    }
  }, [
    broadcastName,
    selectedTemplateId,
    selectedTemplateData,
    variableMapping,
    mediaMapping,
    staticValueEnabled,
    staticValues,
    urlButtonVariableMapping,
    urlButtonStaticValueEnabled,
    urlButtonStaticValues,
    targetAudience,
    selectedLiveSegments,
    selectedStaticLists,
    scheduleType,
    scheduledDate,
    scheduledTime,
    availableVariables,
    navigate
  ]);
  useMemo(() => {
    return liveSegmentOptions.filter(
      (option) => !selectedLiveSegments.includes(option.value) && option.label.toLowerCase().includes(liveSegmentInputValue.toLowerCase())
    );
  }, [liveSegmentOptions, selectedLiveSegments, liveSegmentInputValue]);
  const filteredStaticListOptions = useMemo(() => {
    const searchTerm = debouncedSearchTerm.trim().toLowerCase();
    if (!searchTerm) {
      return staticListOptions.filter(
        (option) => option.value && !selectedStaticLists.includes(option.value)
      );
    }
    return staticListOptions.filter(
      (option) => {
        var _a3;
        return option.value && !selectedStaticLists.includes(option.value) && (option.label.toLowerCase().includes(searchTerm) || ((_a3 = option.id) == null ? void 0 : _a3.toString().includes(searchTerm)));
      }
    );
  }, [staticListOptions, selectedStaticLists, debouncedSearchTerm]);
  const isFormValid = broadcastName.trim() && selectedTemplateId && selectedTemplateData && Object.keys(variableMapping).every((variableKey) => {
    var _a3, _b2;
    return staticValueEnabled[variableKey] && ((_a3 = staticValues[variableKey]) == null ? void 0 : _a3.trim()) || !staticValueEnabled[variableKey] && ((_b2 = variableMapping[variableKey]) == null ? void 0 : _b2.value);
  }) && Object.keys(urlButtonVariableMapping).every((variableKey) => {
    var _a3, _b2;
    return urlButtonStaticValueEnabled[variableKey] && ((_a3 = urlButtonStaticValues[variableKey]) == null ? void 0 : _a3.trim()) || !urlButtonStaticValueEnabled[variableKey] && ((_b2 = urlButtonVariableMapping[variableKey]) == null ? void 0 : _b2.value);
  }) && Object.keys(mediaMapping).every((mediaKey) => {
    const media = mediaMapping[mediaKey];
    return (media == null ? void 0 : media.uploaded) && (media == null ? void 0 : media.fileUrl) || (media == null ? void 0 : media.url);
  }) && !Object.values(uploadingMedia).some((isUploading) => isUploading) && (targetAudience !== "live_segment" || selectedLiveSegments.length > 0) && (targetAudience !== "static_list" || selectedStaticLists.length > 0) && !sendingBroadcast;
  return /* @__PURE__ */ jsxs(
    Page,
    {
      title: "Create Broadcast Campaign",
      subtitle: "Set up a new WhatsApp broadcast campaign",
      fullWidth: true,
      backAction: {
        content: "Back to Broadcasts",
        onAction: () => navigate("/app/broadcast")
      },
      primaryAction: {
        content: scheduleType === "immediate" ? "Send Now" : "Schedule Broadcast",
        onAction: handleSaveBroadcast,
        disabled: !isFormValid || sendingBroadcast,
        loading: sendingBroadcast,
        tone: scheduleType === "immediate" ? "success" : "primary"
      },
      secondaryActions: [
        {
          content: "Cancel",
          onAction: () => {
            navigate("/app/broadcast");
          }
        }
      ],
      children: [
        /* @__PURE__ */ jsxs(Layout, { children: [
          /* @__PURE__ */ jsx(Layout.Section, { variant: "twoThirds", children: /* @__PURE__ */ jsxs(BlockStack, { gap: "500", children: [
            /* @__PURE__ */ jsx(LegacyCard, { title: "Broadcast Details", sectioned: true, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Broadcast Name",
                  value: broadcastName,
                  onChange: setBroadcastName,
                  placeholder: "Enter broadcast campaign name",
                  helpText: "Choose a descriptive name for your campaign"
                }
              ),
              templateError && /* @__PURE__ */ jsx(Banner, { status: "critical", onDismiss: () => setTemplateError(null), children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: templateError }) }),
              broadcastError && /* @__PURE__ */ jsx(Banner, { status: "critical", onDismiss: () => setBroadcastError(null), children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: broadcastError }) }),
              /* @__PURE__ */ jsx(
                Autocomplete,
                {
                  label: "Search and select template",
                  options: filteredTemplateOptions.map((template) => ({
                    value: template.id || template.value,
                    label: template.label
                  })),
                  selected: selectedTemplateId ? [selectedTemplateId] : [],
                  onSelect: (selected) => {
                    const selectedValue = selected[0];
                    if (selectedValue) {
                      handleTemplateChange(selectedValue);
                    }
                  },
                  textField: /* @__PURE__ */ jsx(
                    Autocomplete.TextField,
                    {
                      onChange: (value) => setTemplateInputValue(value),
                      label: "Search and select template",
                      value: templateInputValue,
                      placeholder: "Type to search templates...",
                      autoComplete: "off"
                    }
                  ),
                  loading: loadingTemplates || loadingTemplateDetails,
                  emptyState: loadingTemplates ? "Loading templates..." : "No API templates found",
                  preferredPosition: "below",
                  willLoadMoreResults: false
                }
              ),
              selectedTemplateData && /* @__PURE__ */ jsx(Banner, { status: "info", children: /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                "Template selected: ",
                /* @__PURE__ */ jsx("strong", { children: (_a2 = allTemplateOptions.find((t) => t.id === selectedTemplateId || t.value === selectedTemplateId)) == null ? void 0 : _a2.label }),
                loadingTemplateDetails && /* @__PURE__ */ jsx("span", { children: " (Loading details...)" })
              ] }) })
            ] }) }),
            /* @__PURE__ */ jsx(LegacyCard, { title: "Target Audience", sectioned: true, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(
                ChoiceList,
                {
                  title: "Select your target audience",
                  choices: audienceOptions,
                  selected: [targetAudience],
                  onChange: (value) => handleTargetAudienceChange(value[0])
                }
              ),
              targetAudience === "live_segment" && /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
                /* @__PURE__ */ jsx(Divider, {}),
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: "Select Live Segments" }),
                selectedLiveSegments.length > 0 && /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: "Selected segments:" }),
                  /* @__PURE__ */ jsx(InlineStack, { gap: "200", wrap: true, children: selectedLiveSegments.map((segmentValue) => {
                    const segment = liveSegmentOptions.find((option) => option.value === segmentValue);
                    return /* @__PURE__ */ jsxs(
                      Tag,
                      {
                        onRemove: () => handleLiveSegmentRemove(segmentValue),
                        children: [
                          segment == null ? void 0 : segment.label,
                          " (",
                          segment == null ? void 0 : segment.contacts.toLocaleString(),
                          " contacts)"
                        ]
                      },
                      segmentValue
                    );
                  }) })
                ] }),
                /* @__PURE__ */ jsx("text", { children: "Live segments currently not available." })
              ] }),
              targetAudience === "static_list" && /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
                /* @__PURE__ */ jsx(Divider, {}),
                /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: "Select Static Lists" }),
                  /* @__PURE__ */ jsx(
                    Button,
                    {
                      variant: "plain",
                      onClick: loadAllStaticLists,
                      loading: staticListsLoading,
                      size: "slim",
                      children: "Refresh"
                    }
                  )
                ] }),
                staticListsError && /* @__PURE__ */ jsx(Banner, { status: "critical", children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: staticListsError }) }),
                staticListsLoading && /* @__PURE__ */ jsx(Banner, { status: "info", children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: "Loading all contact lists from all pages..." }) }),
                contactListFieldsError && /* @__PURE__ */ jsx(Banner, { status: "warning", onDismiss: () => setContactListFieldsError(null), children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: contactListFieldsError }) }),
                loadingContactListFields && /* @__PURE__ */ jsx(Banner, { status: "info", children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: "Analyzing contact list fields for auto-mapping..." }) }),
                selectedStaticLists.length > 0 && /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: "Selected lists:" }),
                  /* @__PURE__ */ jsx(InlineStack, { gap: "200", wrap: true, children: selectedStaticLists.map((listValue) => {
                    const list2 = staticListOptions.find((option) => option.value === listValue);
                    return /* @__PURE__ */ jsxs(
                      Tag,
                      {
                        onRemove: () => handleStaticListRemove(listValue),
                        children: [
                          list2 == null ? void 0 : list2.label,
                          " (",
                          list2 == null ? void 0 : list2.contacts.toLocaleString(),
                          " contacts)"
                        ]
                      },
                      listValue
                    );
                  }) })
                ] }),
                /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                  /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                    /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                      TextField,
                      {
                        label: "Search static lists",
                        value: staticListInputValue,
                        onChange: (value) => {
                          setStaticListInputValue(value);
                          if (value.length > 0 || staticListOptions.length > 0) {
                            setStaticListDropdownActive(true);
                          }
                        },
                        onFocus: () => {
                          setStaticListDropdownActive(true);
                        },
                        onBlur: () => {
                          setTimeout(() => setStaticListDropdownActive(false), 200);
                        },
                        placeholder: staticListsLoading ? "Loading all contact lists..." : "Click here or type to search lists...",
                        disabled: staticListsLoading,
                        autoComplete: "off"
                      }
                    ) }),
                    staticListInputValue && /* @__PURE__ */ jsx(
                      Button,
                      {
                        variant: "plain",
                        onClick: () => {
                          setStaticListInputValue("");
                          setStaticListDropdownActive(false);
                        },
                        size: "slim",
                        children: "Clear"
                      }
                    )
                  ] }),
                  staticListDropdownActive && !staticListsLoading && (staticListOptions.length > 0 || staticListInputValue) && /* @__PURE__ */ jsxs("div", { style: {
                    border: "1px solid var(--p-color-border)",
                    borderRadius: "6px",
                    maxHeight: "200px",
                    overflowY: "auto",
                    backgroundColor: "var(--p-color-bg-surface)"
                  }, children: [
                    filteredStaticListOptions.length > 0 && !debouncedSearchTerm && /* @__PURE__ */ jsx("div", { style: {
                      padding: "8px 16px",
                      borderBottom: "1px solid var(--p-color-border-subdued)",
                      backgroundColor: "var(--p-color-bg-surface-secondary)"
                    }, children: /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                      staticListOptions.length,
                      " contact list",
                      staticListOptions.length !== 1 ? "s" : "",
                      " available"
                    ] }) }),
                    filteredStaticListOptions.length > 0 && debouncedSearchTerm && /* @__PURE__ */ jsx("div", { style: {
                      padding: "8px 16px",
                      borderBottom: "1px solid var(--p-color-border-subdued)",
                      backgroundColor: "var(--p-color-bg-surface-secondary)"
                    }, children: /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                      filteredStaticListOptions.length,
                      " result",
                      filteredStaticListOptions.length !== 1 ? "s" : "",
                      ' for "',
                      debouncedSearchTerm,
                      '"'
                    ] }) }),
                    filteredStaticListOptions.length > 0 ? filteredStaticListOptions.map((option) => /* @__PURE__ */ jsx(
                      "div",
                      {
                        onClick: () => handleStaticListSelect(option.value),
                        style: {
                          padding: "12px 16px",
                          cursor: "pointer",
                          borderBottom: "1px solid var(--p-color-border-subdued)",
                          ":hover": { backgroundColor: "var(--p-color-bg-surface-hover)" }
                        },
                        onMouseEnter: (e) => e.target.style.backgroundColor = "var(--p-color-bg-surface-hover)",
                        onMouseLeave: (e) => e.target.style.backgroundColor = "transparent",
                        children: /* @__PURE__ */ jsxs(BlockStack, { gap: "100", children: [
                          /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: option.label }),
                          /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                            option.contacts.toLocaleString(),
                            " contacts"
                          ] })
                        ] })
                      },
                      option.value
                    )) : /* @__PURE__ */ jsx("div", { style: { padding: "16px", textAlign: "center" }, children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: staticContactLists.length === 0 ? "No contact lists available" : `No lists found matching "${debouncedSearchTerm || staticListInputValue}"` }) })
                  ] }),
                  staticListDropdownActive && staticListsLoading && /* @__PURE__ */ jsx("div", { style: {
                    padding: "16px",
                    textAlign: "center",
                    border: "1px solid var(--p-color-border)",
                    borderRadius: "6px"
                  }, children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: "Loading contact lists..." }) }),
                  staticContactLists.length === 0 && !staticListsLoading && /* @__PURE__ */ jsx(Banner, { status: "warning", children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: "No static contact lists found. Create contact lists first to use this option." }) })
                ] }),
                /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: "Static lists are fixed collections of contacts that were manually created or imported." })
              ] }),
              /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: /* @__PURE__ */ jsx("strong", { children: "Estimated Reach:" }) }),
                /* @__PURE__ */ jsxs(Badge, { tone: "info", children: [
                  estimatedReach.toLocaleString(),
                  " customers"
                ] })
              ] })
            ] }) }),
            Object.keys(templateVariables).length > 0 && /* @__PURE__ */ jsx(LegacyCard, { title: "Map Template Variables", sectioned: true, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: "Map the variables in your template to customer data fields:" }),
              targetAudience === "static_list" && selectedStaticLists.length > 0 && /* @__PURE__ */ jsx(Banner, { status: "info", onDismiss: () => {
              }, children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: loadingContactListFields ? "Analyzing contact list fields for auto-mapping..." : contactListFields.length > 0 ? `Auto-mapped variables from ${contactListFields.length} contact list(s). Review mappings below.` : "No field data found for selected contact lists. Please map variables manually." }) }),
              Object.entries(templateVariables).map(([variableKey, variableData]) => {
                var _a3, _b2;
                const isAutoMapped = ((_a3 = variableMapping[variableKey]) == null ? void 0 : _a3.value) && contactListFields.some((list2) => {
                  if (!list2.newjsonfields) return false;
                  try {
                    const fields = JSON.parse(list2.newjsonfields);
                    const fieldValues = Object.values(fields);
                    const varName = variableKey.replace(/^(body_var_|header_var_|footer_var_)/, "");
                    return fieldValues.some(
                      (field) => field.toLowerCase().includes(varName.toLowerCase()) || varName.toLowerCase().includes(field.toLowerCase())
                    );
                  } catch {
                    return false;
                  }
                });
                return /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                  /* @__PURE__ */ jsxs(InlineStack, { gap: "300", align: "space-between", blockAlign: "start", children: [
                    /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", blockAlign: "center", children: [
                      /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", fontWeight: "medium", children: [
                        "Map ",
                        variableData.placeholder,
                        " (",
                        variableData.componentType,
                        ")"
                      ] }),
                      isAutoMapped && /* @__PURE__ */ jsx(Badge, { tone: "success", children: "Auto-mapped" })
                    ] }) }),
                    /* @__PURE__ */ jsx(
                      Button,
                      {
                        variant: staticValueEnabled[variableKey] ? "plain" : "plain",
                        size: "slim",
                        onClick: () => handleStaticValueToggle(variableKey),
                        children: staticValueEnabled[variableKey] ? "Use Field Mapping" : "Add Static Value"
                      }
                    )
                  ] }),
                  staticValueEnabled[variableKey] ? /* @__PURE__ */ jsx(
                    TextField,
                    {
                      label: `Static value for ${variableData.placeholder}`,
                      value: staticValues[variableKey] || "",
                      onChange: (value) => handleStaticValueChange(variableKey, value),
                      placeholder: `Enter static value for ${variableData.placeholder}`,
                      helpText: "This value will be used for all recipients"
                    }
                  ) : /* @__PURE__ */ jsx(
                    Autocomplete,
                    {
                      options: availableVariables.filter((av) => {
                        const searchValue = variableInputValues[variableKey] || "";
                        return searchValue === "" || av.label.toLowerCase().includes(searchValue.toLowerCase());
                      }).map((av) => ({
                        value: av.value,
                        label: av.label
                      })),
                      selected: ((_b2 = variableMapping[variableKey]) == null ? void 0 : _b2.value) ? [variableMapping[variableKey].value] : [],
                      onSelect: (selected) => {
                        const value = selected.length > 0 ? selected[0] : "";
                        handleVariableMappingChange(variableKey, value);
                        if (value) {
                          const selectedVar = availableVariables.find((av) => av.value === value);
                          setVariableInputValues((prev) => ({
                            ...prev,
                            [variableKey]: (selectedVar == null ? void 0 : selectedVar.label) || ""
                          }));
                        } else {
                          setVariableInputValues((prev) => ({
                            ...prev,
                            [variableKey]: ""
                          }));
                        }
                      },
                      textField: /* @__PURE__ */ jsx(
                        Autocomplete.TextField,
                        {
                          onChange: (value) => {
                            setVariableInputValues((prev) => ({
                              ...prev,
                              [variableKey]: value
                            }));
                          },
                          label: `Select data field for ${variableData.placeholder}`,
                          value: variableInputValues[variableKey] || "",
                          placeholder: isAutoMapped ? `Auto-mapped field: ${variableInputValues[variableKey]} (click to change)` : `Search and select data field for ${variableData.placeholder}...`,
                          autoComplete: "off",
                          helpText: isAutoMapped ? "This field was automatically matched from your contact list. You can change it if needed." : "Select the data field that contains the values for this variable."
                        }
                      ),
                      loading: loadingVariables,
                      emptyState: loadingVariables ? "Loading variables..." : "No variables found",
                      preferredPosition: "below"
                    }
                  )
                ] }, variableKey);
              })
            ] }) }),
            Object.keys(urlButtonVariables).length > 0 && /* @__PURE__ */ jsx(LegacyCard, { title: "Map URL Button Variables", sectioned: true, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: "Map the variables in your URL button links to customer data fields:" }),
              Object.entries(urlButtonVariables).map(([variableKey, variableData]) => {
                var _a3;
                return /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                  /* @__PURE__ */ jsxs(InlineStack, { gap: "300", align: "space-between", blockAlign: "start", children: [
                    /* @__PURE__ */ jsxs("div", { style: { flex: 1 }, children: [
                      /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", fontWeight: "medium", children: [
                        "Map ",
                        variableData.placeholder,
                        ' in "',
                        variableData.buttonText,
                        '" button'
                      ] }),
                      /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                        "URL: ",
                        variableData.buttonUrl
                      ] })
                    ] }),
                    /* @__PURE__ */ jsx(
                      Button,
                      {
                        variant: urlButtonStaticValueEnabled[variableKey] ? "plain" : "plain",
                        size: "slim",
                        onClick: () => handleUrlButtonStaticValueToggle(variableKey),
                        children: urlButtonStaticValueEnabled[variableKey] ? "Use Field Mapping" : "Add Static Value"
                      }
                    )
                  ] }),
                  urlButtonStaticValueEnabled[variableKey] ? /* @__PURE__ */ jsx(
                    TextField,
                    {
                      label: `Static value for ${variableData.placeholder}`,
                      value: urlButtonStaticValues[variableKey] || "",
                      onChange: (value) => handleUrlButtonStaticValueChange(variableKey, value),
                      placeholder: `Enter static value for ${variableData.placeholder}`,
                      helpText: "This value will be used for all recipients"
                    }
                  ) : /* @__PURE__ */ jsx(
                    Autocomplete,
                    {
                      options: availableVariables.filter((av) => {
                        const searchValue = urlButtonVariableInputValues[variableKey] || "";
                        return searchValue === "" || av.label.toLowerCase().includes(searchValue.toLowerCase());
                      }).map((av) => ({
                        value: av.value,
                        label: av.label
                      })),
                      selected: ((_a3 = urlButtonVariableMapping[variableKey]) == null ? void 0 : _a3.value) ? [urlButtonVariableMapping[variableKey].value] : [],
                      onSelect: (selected) => {
                        const value = selected.length > 0 ? selected[0] : "";
                        handleUrlButtonVariableMappingChange(variableKey, value);
                        if (value) {
                          const selectedVar = availableVariables.find((av) => av.value === value);
                          setUrlButtonVariableInputValues((prev) => ({
                            ...prev,
                            [variableKey]: (selectedVar == null ? void 0 : selectedVar.label) || ""
                          }));
                        } else {
                          setUrlButtonVariableInputValues((prev) => ({
                            ...prev,
                            [variableKey]: ""
                          }));
                        }
                      },
                      textField: /* @__PURE__ */ jsx(
                        Autocomplete.TextField,
                        {
                          onChange: (value) => {
                            setUrlButtonVariableInputValues((prev) => ({
                              ...prev,
                              [variableKey]: value
                            }));
                          },
                          label: `Select data field for ${variableData.placeholder}`,
                          value: urlButtonVariableInputValues[variableKey] || "",
                          placeholder: `Search and select data field for ${variableData.placeholder}...`,
                          autoComplete: "off"
                        }
                      ),
                      loading: loadingVariables,
                      emptyState: loadingVariables ? "Loading variables..." : "No variables found",
                      preferredPosition: "below"
                    }
                  )
                ] }, variableKey);
              })
            ] }) }),
            Object.keys(templateMedia).length > 0 && /* @__PURE__ */ jsx(LegacyCard, { title: "Map Template Media Files", sectioned: true, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: "Upload new media files to replace the template's default media:" }),
              Object.entries(templateMedia).map(([mediaKey, mediaData]) => {
                var _a3, _b2, _c, _d;
                const uploadedFile = (_a3 = mediaMapping[mediaKey]) == null ? void 0 : _a3.file;
                const fileUrl = ((_b2 = mediaMapping[mediaKey]) == null ? void 0 : _b2.fileUrl) || mediaData.url;
                const isUploading = uploadingMedia[mediaKey];
                const uploadError = (_c = mediaMapping[mediaKey]) == null ? void 0 : _c.uploadError;
                const isUploaded = (_d = mediaMapping[mediaKey]) == null ? void 0 : _d.uploaded;
                return /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                  /* @__PURE__ */ jsxs(InlineStack, { gap: "200", align: "space-between", blockAlign: "center", children: [
                    /* @__PURE__ */ jsxs(InlineStack, { gap: "200", blockAlign: "center", children: [
                      /* @__PURE__ */ jsx(
                        Thumbnail,
                        {
                          source: uploadedFile ? fileUrl : mediaData.url || (mediaData.type === "document" ? "📄" : "📁"),
                          alt: (uploadedFile == null ? void 0 : uploadedFile.name) || `Header ${mediaData.type}`,
                          size: "small"
                        }
                      ),
                      /* @__PURE__ */ jsxs(BlockStack, { gap: "050", children: [
                        /* @__PURE__ */ jsxs(InlineStack, { gap: "200", blockAlign: "center", children: [
                          /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: uploadedFile ? uploadedFile.name : `Header ${mediaData.type}` }),
                          isUploading && /* @__PURE__ */ jsx(Badge, { tone: "info", children: "Uploading..." }),
                          isUploaded && !isUploading && /* @__PURE__ */ jsx(Badge, { tone: "success", children: "Uploaded" })
                        ] }),
                        /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: uploadedFile ? `${(uploadedFile.size / 1024 / 1024).toFixed(2)} MB` : `Original ${mediaData.type}` }),
                        uploadError && /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "critical", children: [
                          "Error: ",
                          uploadError
                        ] })
                      ] })
                    ] }),
                    uploadedFile ? /* @__PURE__ */ jsxs(InlineStack, { gap: "100", children: [
                      /* @__PURE__ */ jsx(
                        Button,
                        {
                          variant: "plain",
                          tone: "critical",
                          size: "slim",
                          onClick: () => handleMediaMappingChange(mediaKey, null),
                          disabled: isUploading,
                          children: "Remove"
                        }
                      ),
                      /* @__PURE__ */ jsx(
                        Button,
                        {
                          variant: "plain",
                          size: "slim",
                          onClick: () => document.getElementById(`upload-${mediaKey}`).click(),
                          disabled: isUploading,
                          children: "Replace"
                        }
                      )
                    ] }) : /* @__PURE__ */ jsxs(
                      Button,
                      {
                        variant: "plain",
                        size: "slim",
                        onClick: () => document.getElementById(`upload-${mediaKey}`).click(),
                        disabled: isUploading,
                        loading: isUploading,
                        children: [
                          "Upload ",
                          mediaData.type
                        ]
                      }
                    )
                  ] }),
                  /* @__PURE__ */ jsx(
                    "input",
                    {
                      id: `upload-${mediaKey}`,
                      type: "file",
                      accept: mediaData.type === "image" ? "image/*" : mediaData.type === "video" ? "video/*" : "application/pdf,.doc,.docx,.txt",
                      style: { display: "none" },
                      onChange: (e) => {
                        var _a4;
                        if (((_a4 = e.target.files) == null ? void 0 : _a4.length) > 0) {
                          handleMediaMappingChange(mediaKey, e.target.files[0]);
                        }
                      }
                    }
                  )
                ] }, mediaKey);
              })
            ] }) }),
            /* @__PURE__ */ jsx(LegacyCard, { title: "Schedule Broadcast", sectioned: true, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsxs(InlineStack, { gap: "400", children: [
                /* @__PURE__ */ jsx(
                  RadioButton,
                  {
                    label: "Send immediately",
                    checked: scheduleType === "immediate",
                    id: "immediate",
                    name: "scheduleType",
                    onChange: () => setScheduleType("immediate")
                  }
                ),
                /* @__PURE__ */ jsx(
                  RadioButton,
                  {
                    label: "Schedule for later",
                    checked: scheduleType === "scheduled",
                    id: "scheduled",
                    name: "scheduleType",
                    onChange: () => setScheduleType("scheduled")
                  }
                )
              ] }),
              scheduleType === "scheduled" && /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
                /* @__PURE__ */ jsx(Divider, {}),
                /* @__PURE__ */ jsxs(InlineStack, { gap: "400", children: [
                  /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                    Popover,
                    {
                      active: datePickerActive,
                      activator: /* @__PURE__ */ jsx(
                        Button,
                        {
                          onClick: () => setDatePickerActive(!datePickerActive),
                          disclosure: true,
                          children: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                            /* @__PURE__ */ jsx(Icon, { source: CalendarIcon }),
                            /* @__PURE__ */ jsx(Text, { as: "span", children: scheduledDate.toLocaleDateString() })
                          ] })
                        }
                      ),
                      onClose: () => setDatePickerActive(false),
                      children: /* @__PURE__ */ jsx(
                        DatePicker,
                        {
                          month: scheduledDate.getMonth(),
                          year: scheduledDate.getFullYear(),
                          selected: scheduledDate,
                          onMonthChange: (month, year) => {
                            setScheduledDate(new Date(year, month, scheduledDate.getDate()));
                          },
                          onChange: handleDateChange,
                          disableDatesBefore: /* @__PURE__ */ new Date()
                        }
                      )
                    }
                  ) }),
                  /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                    Select,
                    {
                      label: "Time",
                      labelHidden: true,
                      options: [
                        { label: "09:00 AM", value: "09:00" },
                        { label: "10:00 AM", value: "10:00" },
                        { label: "11:00 AM", value: "11:00" },
                        { label: "12:00 PM", value: "12:00" },
                        { label: "01:00 PM", value: "13:00" },
                        { label: "02:00 PM", value: "14:00" },
                        { label: "03:00 PM", value: "15:00" },
                        { label: "04:00 PM", value: "16:00" },
                        { label: "05:00 PM", value: "17:00" },
                        { label: "06:00 PM", value: "18:00" }
                      ],
                      value: scheduledTime,
                      onChange: setScheduledTime
                    }
                  ) })
                ] }),
                /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: [
                  /* @__PURE__ */ jsx(Icon, { source: ClockIcon }),
                  "Broadcast will be sent on ",
                  scheduledDate.toLocaleDateString(),
                  " at ",
                  scheduledTime
                ] })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(LegacyCard, { sectioned: true, children: /* @__PURE__ */ jsxs(InlineStack, { align: "end", gap: "300", children: [
              /* @__PURE__ */ jsx(
                Button,
                {
                  onClick: () => {
                    console.log("Saving as draft...");
                    navigate("/app/broadcast");
                  },
                  size: "large",
                  disabled: sendingBroadcast,
                  children: "Save as Draft"
                }
              ),
              /* @__PURE__ */ jsx(
                Button,
                {
                  variant: "primary",
                  onClick: handleSaveBroadcast,
                  disabled: !isFormValid || sendingBroadcast,
                  loading: sendingBroadcast,
                  tone: scheduleType === "immediate" ? "success" : "primary",
                  size: "large",
                  children: scheduleType === "immediate" ? "Send Now" : "Schedule Broadcast"
                }
              )
            ] }) })
          ] }) }),
          /* @__PURE__ */ jsx(Layout.Section, { variant: "oneThird", children: /* @__PURE__ */ jsx(LegacyCard, { title: "Template Preview", sectioned: true, children: /* @__PURE__ */ jsx(BlockStack, { gap: "400", children: selectedTemplateData ? /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: "WhatsApp Preview" }),
              /* @__PURE__ */ jsx(Badge, { tone: "info", children: (_b = allTemplateOptions.find((t) => t.id === selectedTemplateId || t.value === selectedTemplateId)) == null ? void 0 : _b.label })
            ] }),
            /* @__PURE__ */ jsx("div", { style: {
              border: "1px solid var(--p-color-border)",
              borderRadius: "8px",
              padding: "16px",
              backgroundColor: "var(--p-color-bg-surface-secondary)"
            }, children: /* @__PURE__ */ jsx(
              WhatsAppPreview,
              {
                template: getTemplateForPreview(selectedTemplateData),
                variant: "full",
                showWhatsAppHeader: true,
                variableMapping: convertVariableMappingForPreview(),
                mediaMapping: convertMediaMappingForPreview()
              }
            ) })
          ] }) : /* @__PURE__ */ jsxs("div", { style: {
            textAlign: "center",
            padding: "60px 20px",
            border: "2px dashed var(--p-color-border)",
            borderRadius: "8px"
          }, children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", tone: "subdued", children: "Select a Template" }),
            /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: "Choose a WhatsApp template from the form to see the preview here" })
          ] }) }) }) })
        ] }),
        /* @__PURE__ */ jsx(
          Modal,
          {
            open: showVariablesModal,
            onClose: () => {
              setShowVariablesModal(false);
              setVariableSearchQuery("");
            },
            title: "All Available Variables",
            primaryAction: {
              content: "Close",
              onAction: () => {
                setShowVariablesModal(false);
                setVariableSearchQuery("");
              }
            },
            size: "large",
            children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", tone: "subdued", children: "Available variables for your broadcast templates:" }),
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Search Variables",
                  value: variableSearchQuery,
                  onChange: setVariableSearchQuery,
                  placeholder: "Type to search variables...",
                  clearButton: true,
                  onClearButtonClick: () => setVariableSearchQuery(""),
                  autoComplete: "off"
                }
              ),
              /* @__PURE__ */ jsx(InlineStack, { gap: "200", wrap: true, children: availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).map((variable) => /* @__PURE__ */ jsx(
                Button,
                {
                  size: "medium",
                  variant: "tertiary",
                  onClick: () => {
                    navigator.clipboard.writeText(`{{${variable.value}}}`);
                    setShowVariablesModal(false);
                    setVariableSearchQuery("");
                  },
                  children: variable.label
                },
                variable.value
              )) }),
              availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).length === 0 && variableSearchQuery && /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", tone: "subdued", alignment: "center", children: [
                'No variables found matching "',
                variableSearchQuery,
                '"'
              ] }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", tone: "subdued", children: [
                "Click on any variable to copy it to your clipboard. Variables use the format: ",
                "{{variable_name}}"
              ] })
            ] }) })
          }
        )
      ]
    }
  );
}
const route12 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: CreateBroadcastPage
}, Symbol.toStringTag, { value: "Module" }));
function CreateTemplateLayout() {
  return /* @__PURE__ */ jsx(Outlet, {});
}
const route13 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: CreateTemplateLayout
}, Symbol.toStringTag, { value: "Module" }));
function CreateOrderConfirmationTemplatePage() {
  const navigate = useNavigate();
  const [templateName, setTemplateName] = useState("");
  const [templateCategory, setTemplateCategory] = useState("marketing");
  const [templateLanguage, setTemplateLanguage] = useState("en_US");
  const [templateType, setTemplateType] = useState("text");
  const [hasHeader, setHasHeader] = useState(false);
  const [headerType, setHeaderType] = useState("text");
  const [headerContent, setHeaderContent] = useState("");
  const [headerMediaUrl, setHeaderMediaUrl] = useState("");
  const [headerDocumentFilename, setHeaderDocumentFilename] = useState("");
  const [headerFile, setHeaderFile] = useState(null);
  const [headerFilePreview, setHeaderFilePreview] = useState("");
  const [bodyText, setBodyText] = useState("");
  const [cursorPosition, setCursorPosition] = useState(0);
  const [hasFooter, setHasFooter] = useState(false);
  const [footerText, setFooterText] = useState("");
  const [hasButtons, setHasButtons] = useState(false);
  const [buttons, setButtons] = useState([{ type: "QUICK_REPLY", text: "" }]);
  const [urlVariables, setUrlVariables] = useState({});
  const [headerVariableMapping, setHeaderVariableMapping] = useState({});
  const [bodyVariableMapping, setBodyVariableMapping] = useState({});
  const [showVariablesModal, setShowVariablesModal] = useState(false);
  const [variableSearchQuery, setVariableSearchQuery] = useState("");
  const availableVariables = [
    { label: "order_id", value: "order_id" },
    { label: "order_date", value: "order_date" },
    { label: "order_total_price", value: "order_total_price" },
    { label: "order_currency", value: "order_currency" },
    { label: "payment_status", value: "payment_status" },
    { label: "fulfillment_status", value: "fulfillment_status" },
    { label: "confirmation_status", value: "confirmation_status" },
    { label: "confirmation_number", value: "confirmation_number" },
    { label: "customer_id", value: "customer_id" },
    { label: "first_name", value: "first_name" },
    { label: "last_name", value: "last_name" },
    { label: "email", value: "email" },
    { label: "phone", value: "phone" },
    { label: "default_address", value: "default_address" },
    { label: "billing_address", value: "billing_address" },
    { label: "shipping_method", value: "shipping_method" },
    { label: "shipping_price", value: "shipping_price" },
    { label: "tracking_number", value: "tracking_number" },
    { label: "tracking_url", value: "tracking_url" },
    { label: "item_id", value: "item_id" },
    { label: "item_title", value: "item_title" },
    { label: "item_quantity", value: "item_quantity" },
    { label: "item_price", value: "item_price" },
    { label: "item_variant_title", value: "item_variant_title" },
    { label: "item_variant_image", value: "item_variant_image" },
    { label: "subtotal", value: "subtotal" },
    { label: "total_discounts", value: "total_discounts" },
    { label: "total_tax", value: "total_tax" }
  ];
  const [templateNameAvailability, setTemplateNameAvailability] = useState(null);
  const [checkingTemplateName, setCheckingTemplateName] = useState(false);
  const [templateNameError, setTemplateNameError] = useState("");
  const categoryOptions = [
    { label: "Marketing", value: "marketing" },
    { label: "Utility", value: "utility" },
    { label: "Authentication", value: "authentication" }
  ];
  const languageOptions = [
    { label: "English (US)", value: "en_US" },
    { label: "English (UK)", value: "en_GB" },
    { label: "Spanish", value: "es" },
    { label: "French", value: "fr" },
    { label: "German", value: "de" },
    { label: "Hindi", value: "hi" }
  ];
  const headerTypeOptions = [
    { label: "Text", value: "text" },
    { label: "Image", value: "image" },
    { label: "Video", value: "video" },
    { label: "Document", value: "document" }
  ];
  const buttonTypeOptions = [
    { label: "Quick Reply", value: "QUICK_REPLY" },
    { label: "URL", value: "URL" },
    { label: "Phone Number", value: "PHONE_NUMBER" }
  ];
  const phoneCountryOptions = [
    { label: "🇺🇸 +1 (US)", value: "+1" },
    { label: "🇬🇧 +44 (UK)", value: "+44" },
    { label: "🇦🇺 +61 (AU)", value: "+61" },
    { label: "🇮🇳 +91 (IN)", value: "+91" },
    { label: "🇨🇦 +1 (CA)", value: "+1-CA" },
    { label: "🇩🇪 +49 (DE)", value: "+49" },
    { label: "🇫🇷 +33 (FR)", value: "+33" },
    { label: "🇪🇸 +34 (ES)", value: "+34" }
  ];
  useEffect(() => {
    if (!templateName.trim()) {
      setTemplateNameAvailability(null);
      setTemplateNameError("");
      return;
    }
    const timeoutId = setTimeout(async () => {
      try {
        setCheckingTemplateName(true);
        setTemplateNameError("");
        const response = await Checkisteplatenameavailable(templateName.toLowerCase().replace(/\s+/g, "_"));
        if (response.status === true) {
          setTemplateNameAvailability(true);
        } else {
          setTemplateNameAvailability(false);
          setTemplateNameError(response.message || "Template name is not available");
        }
      } catch (error) {
        console.error("Error checking template name:", error);
        setTemplateNameError("Error checking template name availability");
        setTemplateNameAvailability(false);
      } finally {
        setCheckingTemplateName(false);
      }
    }, 500);
    return () => clearTimeout(timeoutId);
  }, [templateName]);
  const mappingOptions = useMemo(() => {
    return [
      { label: "Select mapping...", value: "" },
      ...availableVariables.map((variable) => ({
        label: variable.label,
        value: variable.value
      }))
    ];
  }, [availableVariables]);
  const handleHeaderVariableMapping = useCallback((variableIndex, mappingValue) => {
    setHeaderVariableMapping((prev) => ({
      ...prev,
      [variableIndex]: mappingValue
    }));
  }, []);
  const handleBodyVariableMapping = useCallback((variableIndex, mappingValue) => {
    setBodyVariableMapping((prev) => ({
      ...prev,
      [variableIndex]: mappingValue
    }));
  }, []);
  const validateHeaderText = useCallback((text2) => {
    if (headerType === "text") {
      const variables = extractVariablesFromWhatsAppMessage(JSON.stringify({ text: text2 }));
      if (variables.length > 1) {
        const firstVariable = variables[0];
        const newText = text2.replace(/\{\{[^}]+\}\}/g, (match, offset) => {
          return offset === text2.indexOf(`{{${firstVariable}}}`) ? match : "";
        });
        return newText;
      }
    }
    return text2;
  }, [headerType]);
  const handleHeaderContentChange = useCallback((value) => {
    const validatedValue = validateHeaderText(value);
    setHeaderContent(validatedValue);
    if (validatedValue !== value) {
      setHeaderVariableMapping({});
    }
  }, [validateHeaderText]);
  const headerVariables = useMemo(() => {
    if (hasHeader && headerType === "text" && headerContent) {
      const variables = extractVariablesFromWhatsAppMessage(JSON.stringify({ text: headerContent }));
      return variables.slice(0, 1);
    }
    return [];
  }, [hasHeader, headerType, headerContent]);
  const bodyVariables = useMemo(() => {
    if (bodyText) {
      return extractVariablesFromWhatsAppMessage(JSON.stringify({ text: bodyText }));
    }
    return [];
  }, [bodyText]);
  const generateTemplateJSON = useMemo(() => {
    const template = {
      sender: "",
      campaign_id: "put_campaign_id",
      messaging_product: "whatsapp",
      recipient_type: "individual",
      to: "receiver_number",
      type: "template",
      template: {
        name: templateName.toLowerCase().replace(/\s+/g, "_") || "new_template",
        language: {
          code: templateLanguage
        },
        components: []
      }
    };
    if (hasHeader && (headerContent || headerMediaUrl)) {
      const headerComponent = {
        type: "HEADER",
        format: headerType.toUpperCase()
      };
      if (headerType === "text") {
        headerComponent.text = headerContent;
        if (headerVariables.length > 0) {
          headerComponent.parameters = headerVariables.map((variable, index2) => ({
            type: "text",
            text: headerVariableMapping[index2] || variable
          }));
        }
      } else if (headerType === "image") {
        headerComponent.format = "IMAGE";
        headerComponent.example = {
          header_handle: [headerMediaUrl]
        };
      } else if (headerType === "video") {
        headerComponent.format = "VIDEO";
        headerComponent.example = {
          header_handle: [headerMediaUrl]
        };
      } else if (headerType === "document") {
        headerComponent.format = "DOCUMENT";
        headerComponent.example = {
          header_handle: [headerMediaUrl]
        };
        if (headerDocumentFilename) {
          headerComponent.filename = headerDocumentFilename;
        }
      }
      template.template.components.push(headerComponent);
    }
    if (bodyText) {
      const bodyComponent = {
        type: "BODY",
        text: bodyText
      };
      if (bodyVariables.length > 0) {
        bodyComponent.parameters = bodyVariables.map((variable, index2) => ({
          type: "text",
          text: bodyVariableMapping[index2] || variable
        }));
      }
      template.template.components.push(bodyComponent);
    }
    if (hasFooter && footerText) {
      template.template.components.push({
        type: "FOOTER",
        text: footerText
      });
    }
    if (hasButtons && buttons.some((btn) => btn.text)) {
      const validButtons = buttons.filter((btn) => btn.text);
      if (validButtons.length > 0) {
        template.template.components.push({
          type: "BUTTONS",
          buttons: validButtons.map((btn) => ({
            type: btn.type,
            text: btn.text,
            ...btn.type === "URL" && btn.url && { url: btn.url },
            ...btn.type === "PHONE_NUMBER" && btn.phone_number && { phone_number: btn.phone_number }
          }))
        });
      }
    }
    return JSON.stringify(template);
  }, [templateName, templateLanguage, hasHeader, headerType, headerContent, headerMediaUrl, headerDocumentFilename, bodyText, hasFooter, footerText, hasButtons, buttons, headerVariables, bodyVariables, headerVariableMapping, bodyVariableMapping]);
  useMemo(() => {
    return [...headerVariables, ...bodyVariables];
  }, [headerVariables, bodyVariables]);
  const handleTextSelection = useCallback(() => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    setCursorPosition(textarea.selectionStart);
  }, []);
  const applyFormatting = useCallback((format) => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const end = textarea.selectionEnd;
    const selectedText = textarea.value.substring(start, end);
    let formattedText = "";
    let cursorOffset = 0;
    if (selectedText) {
      switch (format) {
        case "bold":
          formattedText = `*${selectedText}*`;
          cursorOffset = formattedText.length;
          break;
        case "italic":
          formattedText = `_${selectedText}_`;
          cursorOffset = formattedText.length;
          break;
        case "strikethrough":
          formattedText = `~${selectedText}~`;
          cursorOffset = formattedText.length;
          break;
        case "monospace":
          formattedText = `\`\`\`${selectedText}\`\`\``;
          cursorOffset = formattedText.length;
          break;
        case "inline-code":
          formattedText = `\`${selectedText}\``;
          cursorOffset = formattedText.length;
          break;
        case "quote":
          const needsNewLineBeforeQuote = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfterQuote = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBeforeQuote ? "\n" : "") + `> ${selectedText}` + (needsNewLineAfterQuote ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        case "bullet-list":
          const bulletLines = selectedText.split("\n").map((line) => line.trim() ? `* ${line}` : line).join("\n");
          const needsNewLineBefore = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfter = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBefore ? "\n" : "") + bulletLines + (needsNewLineAfter ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        case "numbered-list":
          const numberedLines = selectedText.split("\n").filter((line) => line.trim()).map((line, index2) => `${index2 + 1}. ${line}`).join("\n");
          const needsNewLineBeforeNum = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfterNum = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBeforeNum ? "\n" : "") + numberedLines + (needsNewLineAfterNum ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        default:
          formattedText = selectedText;
          cursorOffset = formattedText.length;
      }
    } else {
      switch (format) {
        case "bold":
          formattedText = "**";
          cursorOffset = 1;
          break;
        case "italic":
          formattedText = "__";
          cursorOffset = 1;
          break;
        case "strikethrough":
          formattedText = "~~";
          cursorOffset = 1;
          break;
        case "monospace":
          formattedText = "```\n\n```";
          cursorOffset = 4;
          break;
        case "inline-code":
          formattedText = "``";
          cursorOffset = 1;
          break;
        case "quote":
          const needsNewLineBeforeQuoteEmpty = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeQuoteEmpty ? "\n> " : "> ";
          cursorOffset = formattedText.length;
          break;
        case "bullet-list":
          const needsNewLineBeforeBullet = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeBullet ? "\n* " : "* ";
          cursorOffset = formattedText.length;
          break;
        case "numbered-list":
          const needsNewLineBeforeNumber = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeNumber ? "\n1. " : "1. ";
          cursorOffset = formattedText.length;
          break;
        default:
          formattedText = "";
          cursorOffset = 0;
      }
    }
    const newValue = textarea.value.substring(0, start) + formattedText + textarea.value.substring(end);
    setBodyText(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + cursorOffset, start + cursorOffset);
    }, 0);
  }, []);
  const insertVariable = useCallback((variable) => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const variableText = `{{${variable}}}`;
    const newValue = textarea.value.substring(0, start) + variableText + textarea.value.substring(start);
    setBodyText(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + variableText.length, start + variableText.length);
    }, 0);
  }, []);
  const insertEmoji = useCallback((emoji) => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const newValue = textarea.value.substring(0, start) + emoji + textarea.value.substring(start);
    setBodyText(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + emoji.length, start + emoji.length);
    }, 0);
  }, []);
  useEffect(() => {
    const handleKeyDown = (event) => {
      if ((event.ctrlKey || event.metaKey) && event.target.id === "body-text-field") {
        switch (event.key.toLowerCase()) {
          case "b":
            event.preventDefault();
            applyFormatting("bold");
            break;
          case "i":
            event.preventDefault();
            applyFormatting("italic");
            break;
          case "s":
            event.preventDefault();
            applyFormatting("strikethrough");
            break;
          case "m":
            event.preventDefault();
            applyFormatting("monospace");
            break;
          case "k":
            event.preventDefault();
            applyFormatting("inline-code");
            break;
          case "q":
            event.preventDefault();
            applyFormatting("quote");
            break;
          case "l":
            event.preventDefault();
            applyFormatting("bullet-list");
            break;
          case "n":
            event.preventDefault();
            applyFormatting("numbered-list");
            break;
        }
      }
    };
    document.addEventListener("keydown", handleKeyDown);
    return () => document.removeEventListener("keydown", handleKeyDown);
  }, [applyFormatting]);
  useEffect(() => {
    setHeaderVariableMapping((prev) => {
      const newMapping = {};
      headerVariables.forEach((variable, index2) => {
        if (prev[index2]) {
          newMapping[index2] = prev[index2];
        }
      });
      return newMapping;
    });
  }, [headerVariables]);
  useEffect(() => {
    setBodyVariableMapping((prev) => {
      const newMapping = {};
      bodyVariables.forEach((variable, index2) => {
        if (prev[index2]) {
          newMapping[index2] = prev[index2];
        }
      });
      return newMapping;
    });
  }, [bodyVariables]);
  const validateUrlButton = useCallback((url) => {
    if (!url) return { isValid: false, error: "URL is required" };
    return { isValid: true, error: null };
  }, []);
  const checkUrlVariables = useCallback((url) => {
    const hasVariable = /\{\{1\}\}/.test(url);
    return hasVariable;
  }, []);
  const handleUrlVariableChange = useCallback((buttonIndex, value) => {
    setUrlVariables((prev) => ({
      ...prev,
      [buttonIndex]: value
    }));
  }, []);
  const handleButtonChange = useCallback((index2, field, value) => {
    setButtons((prev) => prev.map((btn, i) => {
      if (i === index2) {
        const updatedBtn = { ...btn, [field]: value };
        if (field === "url") {
          updatedBtn.urlError = null;
          if (!checkUrlVariables(value)) {
            setUrlVariables((prev2) => {
              const newVars = { ...prev2 };
              delete newVars[index2];
              return newVars;
            });
          }
        }
        return updatedBtn;
      }
      return btn;
    }));
  }, [checkUrlVariables]);
  const addButton = useCallback(() => {
    if (buttons.length < 8) {
      setButtons((prev) => [...prev, { type: "QUICK_REPLY", text: "" }]);
    }
  }, [buttons.length]);
  const removeButton = useCallback((index2) => {
    setButtons((prev) => prev.filter((_, i) => i !== index2));
  }, []);
  const handleHeaderFileUpload = useCallback((files) => {
    if (files.length > 0) {
      const file = files[0];
      setHeaderFile(file);
      const reader = new FileReader();
      reader.onload = (e) => {
        setHeaderFilePreview(e.target.result);
        setHeaderMediaUrl(e.target.result);
      };
      reader.readAsDataURL(file);
      if (headerType === "document") {
        setHeaderDocumentFilename(file.name);
      }
    }
  }, [headerType]);
  const handleRemoveHeaderFile = useCallback(() => {
    setHeaderFile(null);
    setHeaderFilePreview("");
    setHeaderMediaUrl("");
    setHeaderDocumentFilename("");
  }, []);
  const handleSave = useCallback(async () => {
    try {
      const payload = {
        template_type: 1,
        draftedtemplateid: 0,
        normaltemplateid: 0,
        _token: "",
        templatename: templateName.toLowerCase().replace(/\s+/g, "_"),
        language: templateLanguage,
        category: templateCategory.toUpperCase(),
        body: bodyText,
        bodyVars: Object.values(bodyVariableMapping),
        phoneCountry: 91,
        previewfooterText: hasFooter ? footerText : ""
      };
      if (hasButtons && Array.isArray(buttons)) {
        const quickReplyButtons = buttons.filter((btn) => btn.type === "QUICK_REPLY" && btn.text);
        if (quickReplyButtons.length > 0) {
          payload.quickReplyButtonText = quickReplyButtons.map((btn) => btn.text);
        }
        const urlButtons = buttons.filter((btn) => btn.type === "URL" && btn.text && btn.url);
        if (urlButtons.length > 0) {
          payload.websiteButtonText = urlButtons.map((btn) => btn.text);
          payload.previewWebsiteUrl = urlButtons.map((btn) => btn.url);
          const urlVarsArray = urlButtons.map((btn, index2) => {
            return urlVariables[index2] || "";
          }).filter((varValue) => varValue.trim() !== "");
          if (urlVarsArray.length > 0) {
            payload.UrlVars = urlVarsArray;
          }
        }
        const phoneButtons = buttons.filter((btn) => btn.type === "PHONE_NUMBER" && btn.text && btn.phone_number);
        if (phoneButtons.length > 0) {
          const primaryPhoneButton = phoneButtons[0];
          payload.callbuttonText = primaryPhoneButton.text;
          payload.prevviewphoneNumber = String(primaryPhoneButton.phone_number).replace(/^\+/, "");
          const selectedCode = (primaryPhoneButton.phone_country_code || "").replace(/^\+/, "");
          let countryCode = selectedCode;
          if (!countryCode && primaryPhoneButton.phone_number) {
            const match = String(primaryPhoneButton.phone_number).match(/^\+?(\d{1,3})/);
            if (match && match[1]) {
              countryCode = match[1];
            }
          }
          if (countryCode) {
            const parsedCode = parseInt(countryCode, 10);
            if (!Number.isNaN(parsedCode)) {
              payload.phoneCountry = parsedCode;
            }
          }
        }
      }
      if (hasHeader) {
        payload.headerType = headerType.charAt(0).toUpperCase() + headerType.slice(1);
        if (headerType === "text") {
          payload.headerText = headerContent;
          if (Object.keys(headerVariableMapping).length > 0) {
            payload.headerVar = Object.values(headerVariableMapping)[0];
          }
        } else {
          if (headerFile) {
            const formData = new FormData();
            formData.append("headerFile", headerFile);
            Object.entries(payload).forEach(([key, value]) => {
              if (Array.isArray(value)) {
                value.forEach((item) => {
                  formData.append(`${key}[]`, item);
                });
              } else {
                formData.append(key, value);
              }
            });
            console.log("Payload:", payload);
            const response2 = await fetch(`https://app.getgabs.com/partners/template/with-custom-vars/designtemplate?token=${API_TOKEN}`, {
              method: "POST",
              body: formData,
              headers: {
                "X-Requested-With": "XMLHttpRequest"
              }
            });
            if (!response2.ok) throw new Error("Failed to save template");
            const result2 = await response2.json();
            console.log("Template saved successfully:", result2);
            navigate("/app/templates");
            return;
          }
        }
      }
      const response = await fetch(`https://app.getgabs.com/partners/template/with-custom-vars/designtemplate?token=${API_TOKEN}`, {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          "Authorization": `Bearer ${API_TOKEN}`,
          "X-Requested-With": "XMLHttpRequest"
        },
        body: JSON.stringify(payload)
      });
      if (!response.ok) throw new Error("Failed to save template");
      const result = await response.json();
      console.log("Template saved successfully:", result);
      navigate("/app/templates");
    } catch (error) {
      console.error("Error saving template:", error);
    }
  }, [
    templateName,
    templateLanguage,
    templateCategory,
    bodyText,
    hasFooter,
    footerText,
    hasHeader,
    headerType,
    headerContent,
    headerFile,
    headerVariableMapping,
    bodyVariableMapping,
    headerVariables,
    bodyVariables,
    urlVariables,
    generateTemplateJSON,
    navigate
  ]);
  const handleCancel = useCallback(() => {
    navigate("/app/templates");
  }, [navigate]);
  return /* @__PURE__ */ jsxs(
    Page,
    {
      fullWidth: true,
      backAction: {
        content: "Templates",
        onAction: () => navigate("/app/templates")
      },
      title: "Create Order Confirmation Template",
      subtitle: "Create a new custom WhatsApp message template",
      primaryAction: {
        content: "Save Template",
        onAction: handleSave,
        disabled: !templateName || !bodyText || templateNameAvailability !== true || checkingTemplateName
      },
      secondaryActions: [
        {
          content: "Cancel",
          onAction: handleCancel
        }
      ],
      children: [
        /* @__PURE__ */ jsxs(Grid, { children: [
          /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 8, lg: 8, xl: 8 }, children: /* @__PURE__ */ jsx("div", { style: { marginRight: "20px" }, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "500", children: [
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Basic Information" }),
              /* @__PURE__ */ jsxs(FormLayout, { children: [
                /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: "Template Name",
                    value: templateName,
                    onChange: (value) => setTemplateName(value.replace(/\s+/g, "_")),
                    placeholder: "Enter template name",
                    helpText: checkingTemplateName ? "Checking availability..." : templateNameAvailability === true ? "✓ Template name is available" : templateNameAvailability === false ? templateNameError : "This will be used as the template identifier",
                    error: templateNameAvailability === false ? templateNameError : void 0,
                    tone: checkingTemplateName ? void 0 : templateNameAvailability === true ? "success" : templateNameAvailability === false ? "critical" : void 0,
                    autoComplete: "off"
                  }
                ),
                /* @__PURE__ */ jsxs(InlineStack, { gap: "400", children: [
                  /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                    Select,
                    {
                      label: "Category",
                      options: categoryOptions,
                      value: templateCategory,
                      onChange: setTemplateCategory
                    }
                  ) }),
                  /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                    Select,
                    {
                      label: "Language",
                      options: languageOptions,
                      value: templateLanguage,
                      onChange: setTemplateLanguage
                    }
                  ) })
                ] })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Header" }),
                /* @__PURE__ */ jsx(
                  Button,
                  {
                    variant: hasHeader ? "primary" : "plain",
                    onClick: () => setHasHeader(!hasHeader),
                    size: "slim",
                    children: hasHeader ? "Remove Header" : "Add Header"
                  }
                )
              ] }),
              hasHeader && /* @__PURE__ */ jsxs(FormLayout, { children: [
                /* @__PURE__ */ jsx(
                  Select,
                  {
                    label: "Header Type",
                    options: headerTypeOptions,
                    value: headerType,
                    onChange: setHeaderType
                  }
                ),
                headerType === "text" && /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: "Header Text",
                    value: headerContent,
                    onChange: handleHeaderContentChange,
                    placeholder: "Enter header text (max 1 variable allowed)",
                    maxLength: 60,
                    showCharacterCount: true,
                    helpText: "Header text can contain maximum 1 variable. Use {{variable_name}} format.",
                    autoComplete: "off"
                  }
                ),
                (headerType === "image" || headerType === "video" || headerType === "document") && /* @__PURE__ */ jsxs("div", { children: [
                  /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", fontWeight: "medium", children: [
                    "Choose ",
                    headerType.charAt(0).toUpperCase() + headerType.slice(1)
                  ] }),
                  /* @__PURE__ */ jsx("div", { style: { marginTop: "8px" }, children: !headerFile ? /* @__PURE__ */ jsx(
                    DropZone,
                    {
                      onDrop: handleHeaderFileUpload,
                      accept: headerType === "image" ? "image/*" : headerType === "video" ? "video/*" : "*/*",
                      type: "file",
                      allowMultiple: false,
                      children: /* @__PURE__ */ jsx(DropZone.FileUpload, { actionTitle: `Choose ${headerType}`, actionHint: `or drag and drop your ${headerType} here` })
                    }
                  ) : /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                    /* @__PURE__ */ jsxs(InlineStack, { gap: "200", align: "space-between", children: [
                      /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                        /* @__PURE__ */ jsx(
                          Thumbnail,
                          {
                            source: headerFilePreview || (headerType === "document" ? "📄" : "📁"),
                            alt: headerFile.name,
                            size: "small"
                          }
                        ),
                        /* @__PURE__ */ jsxs(BlockStack, { gap: "050", children: [
                          /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: headerFile.name }),
                          /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                            (headerFile.size / 1024 / 1024).toFixed(2),
                            " MB"
                          ] })
                        ] })
                      ] }),
                      /* @__PURE__ */ jsx(
                        Button,
                        {
                          variant: "plain",
                          tone: "critical",
                          onClick: handleRemoveHeaderFile,
                          size: "slim",
                          children: "Remove"
                        }
                      )
                    ] }),
                    /* @__PURE__ */ jsxs(
                      Button,
                      {
                        variant: "plain",
                        onClick: () => {
                          handleRemoveHeaderFile();
                        },
                        size: "slim",
                        children: [
                          "Choose Different ",
                          headerType.charAt(0).toUpperCase() + headerType.slice(1)
                        ]
                      }
                    )
                  ] }) })
                ] }),
                headerType === "document" && /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: "Document Filename",
                    value: headerDocumentFilename,
                    onChange: setHeaderDocumentFilename,
                    placeholder: "Enter document filename",
                    autoComplete: "off"
                  }
                ),
                headerType === "text" && headerVariables.length > 0 && /* @__PURE__ */ jsxs("div", { children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "semibold", tone: "subdued", children: "Header Variable Mapping" }),
                  /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", style: { marginBottom: "12px" }, children: "Map the variables in your header text to actual data fields:" }),
                  /* @__PURE__ */ jsx(BlockStack, { gap: "300", align: "center", children: headerVariables.map((variable, index2) => /* @__PURE__ */ jsxs(
                    InlineStack,
                    {
                      gap: "300",
                      align: "center",
                      blockAlign: "center",
                      children: [
                        /* @__PURE__ */ jsx("div", { style: { minWidth: "120px", textAlign: "center" }, children: /* @__PURE__ */ jsx(Badge, { tone: "info", children: `{{${variable}}}` }) }),
                        /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "span", children: "→" }),
                        /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                          Select,
                          {
                            options: mappingOptions,
                            value: headerVariableMapping[index2] || "",
                            onChange: (value) => handleHeaderVariableMapping(index2, value),
                            placeholder: "Select mapping..."
                          }
                        ) })
                      ]
                    },
                    index2
                  )) })
                ] })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Body Text *" }),
              /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Click to insert variables :" }),
                /* @__PURE__ */ jsxs(InlineStack, { gap: "100", wrap: true, children: [
                  availableVariables.slice(0, 8).map((variable) => /* @__PURE__ */ jsx(
                    Button,
                    {
                      size: "micro",
                      variant: "tertiary",
                      onClick: () => insertVariable(variable.value),
                      children: variable.label
                    },
                    variable.value
                  )),
                  availableVariables.length > 8 && /* @__PURE__ */ jsxs(
                    Button,
                    {
                      size: "micro",
                      variant: "primary",
                      onClick: () => setShowVariablesModal(true),
                      children: [
                        "More Variables (",
                        availableVariables.length - 8,
                        ")"
                      ]
                    }
                  )
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { style: { position: "relative" }, children: [
                /* @__PURE__ */ jsxs("div", { style: { position: "absolute", bottom: 12, right: 6, zIndex: 99, display: "flex", gap: "4px", flexWrap: "wrap" }, children: [
                  /* @__PURE__ */ jsx(ButtonGroup, { variant: "segmented", children: /* @__PURE__ */ jsx(EmojiPicker, { onEmojiSelect: insertEmoji, buttonSize: "micro" }) }),
                  /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Bold",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘B" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bold"), accessibilityLabel: "Bold", children: /* @__PURE__ */ jsx(Text, { fontWeight: "bold", children: "B" }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Italic",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘I" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("italic"), accessibilityLabel: "Italic", children: /* @__PURE__ */ jsx(Text, { as: "em", children: "I" }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Strikethrough",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘S" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("strikethrough"), accessibilityLabel: "Strikethrough", children: /* @__PURE__ */ jsx(Text, { as: "s", children: "S" }) }) })
                  ] }),
                  /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Monospace",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘M" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("monospace"), accessibilityLabel: "Monospace", children: /* @__PURE__ */ jsxs(Text, { as: "code", children: [
                      " ",
                      "</>"
                    ] }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Inline Code",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘K" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("inline-code"), accessibilityLabel: "Inline Code", children: /* @__PURE__ */ jsx(Text, { as: "code", children: "<>" }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Quote",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘Q" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("quote"), accessibilityLabel: "Quote", children: '"' }) })
                  ] }),
                  /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Bullet List",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘L" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bullet-list"), accessibilityLabel: "Bullet List", children: "•" }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Numbered List",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘N" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("numbered-list"), accessibilityLabel: "Numbered List", children: "1." }) })
                  ] })
                ] }),
                /* @__PURE__ */ jsx(
                  TextField,
                  {
                    id: "body-text-field",
                    label: "Message Body",
                    value: bodyText,
                    onChange: setBodyText,
                    onSelect: handleTextSelection,
                    multiline: 8,
                    maxLength: 1024,
                    placeholder: "Type your message body here... Formatting options: *bold*, _italic_, ~strikethrough~, ```monospace```, `inline code`, > quote, * bullet list, 1. numbered list. Use keyboard shortcuts or click buttons above.",
                    helpText: `${bodyText.length}/1024 characters`,
                    showCharacterCount: true,
                    autoComplete: "off"
                  }
                )
              ] }),
              bodyVariables.length > 0 && /* @__PURE__ */ jsxs("div", { children: [
                /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "semibold", tone: "subdued", children: "Body Variable Mapping" }),
                /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", style: { marginBottom: "12px" }, children: "Map the variables in your body text to actual data fields:" }),
                /* @__PURE__ */ jsx(BlockStack, { gap: "300", align: "center", children: bodyVariables.map((variable, index2) => /* @__PURE__ */ jsxs(
                  InlineStack,
                  {
                    gap: "300",
                    align: "center",
                    blockAlign: "center",
                    children: [
                      /* @__PURE__ */ jsx("div", { style: { minWidth: "120px", textAlign: "center" }, children: /* @__PURE__ */ jsx(Badge, { tone: "info", children: `{{${variable}}}` }) }),
                      /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "span", children: "→" }),
                      /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                        Select,
                        {
                          options: mappingOptions,
                          value: bodyVariableMapping[index2] || "",
                          onChange: (value) => handleBodyVariableMapping(index2, value),
                          placeholder: "Select mapping..."
                        }
                      ) })
                    ]
                  },
                  index2
                )) })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Footer" }),
                /* @__PURE__ */ jsx(
                  Button,
                  {
                    variant: hasFooter ? "primary" : "plain",
                    onClick: () => setHasFooter(!hasFooter),
                    size: "slim",
                    children: hasFooter ? "Remove Footer" : "Add Footer"
                  }
                )
              ] }),
              hasFooter && /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Footer Text",
                  value: footerText,
                  onChange: setFooterText,
                  placeholder: "Enter footer text",
                  maxLength: 60,
                  showCharacterCount: true,
                  helpText: "Footer text appears at the bottom of the message",
                  autoComplete: "off"
                }
              )
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Buttons" }),
                /* @__PURE__ */ jsx(
                  Button,
                  {
                    variant: hasButtons ? "primary" : "plain",
                    onClick: () => setHasButtons(!hasButtons),
                    size: "slim",
                    children: hasButtons ? "Remove Buttons" : "Add Buttons"
                  }
                )
              ] }),
              hasButtons && /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                buttons.map((button2, index2) => /* @__PURE__ */ jsx(Card, { background: "bg-surface-secondary", children: /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                  /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                    /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", fontWeight: "semibold", children: [
                      "Button ",
                      index2 + 1
                    ] }),
                    buttons.length > 1 && /* @__PURE__ */ jsx(
                      Button,
                      {
                        variant: "plain",
                        tone: "critical",
                        onClick: () => removeButton(index2),
                        size: "slim",
                        children: "Remove"
                      }
                    )
                  ] }),
                  /* @__PURE__ */ jsxs(FormLayout, { children: [
                    /* @__PURE__ */ jsx(
                      Select,
                      {
                        label: "Button Type",
                        options: buttonTypeOptions,
                        value: button2.type,
                        onChange: (value) => handleButtonChange(index2, "type", value)
                      }
                    ),
                    /* @__PURE__ */ jsx(
                      TextField,
                      {
                        label: "Button Text",
                        value: button2.text,
                        onChange: (value) => handleButtonChange(index2, "text", value),
                        placeholder: "Enter button text",
                        maxLength: 20,
                        showCharacterCount: true,
                        autoComplete: "off"
                      }
                    ),
                    button2.type === "URL" && /* @__PURE__ */ jsxs(Fragment, { children: [
                      /* @__PURE__ */ jsx(
                        TextField,
                        {
                          label: "URL",
                          value: button2.url || "",
                          onChange: (value) => {
                            handleButtonChange(index2, "url", value);
                            const validation = validateUrlButton(value);
                            if (!validation.isValid && value) {
                              handleButtonChange(index2, "urlError", validation.error);
                            } else {
                              handleButtonChange(index2, "urlError", null);
                            }
                          },
                          placeholder: "https://example.com/{{1}}",
                          error: button2.urlError,
                          helpText: "URL can contain a variable in {{1}} format at the end (optional for order confirmation templates)",
                          autoComplete: "off"
                        }
                      ),
                      button2.url && checkUrlVariables(button2.url) && /* @__PURE__ */ jsx(
                        TextField,
                        {
                          label: "URL Variable Value",
                          value: urlVariables[index2] || "",
                          onChange: (value) => handleUrlVariableChange(index2, value),
                          placeholder: "Enter value for {{1}} variable",
                          helpText: "This value will replace the {{1}} variable in the URL when sending",
                          autoComplete: "off"
                        }
                      )
                    ] }),
                    button2.type === "PHONE_NUMBER" && /* @__PURE__ */ jsxs(Fragment, { children: [
                      /* @__PURE__ */ jsx(
                        Select,
                        {
                          label: "Country Code",
                          options: phoneCountryOptions,
                          value: button2.phone_country_code || "+91",
                          onChange: (value) => handleButtonChange(index2, "phone_country_code", value.startsWith("+1-") ? "+1" : value)
                        }
                      ),
                      /* @__PURE__ */ jsx(
                        TextField,
                        {
                          label: "Phone Number",
                          value: button2.phone_number || "",
                          onChange: (value) => handleButtonChange(index2, "phone_number", value),
                          placeholder: "Enter phone number",
                          autoComplete: "off"
                        }
                      )
                    ] })
                  ] })
                ] }) }, index2)),
                buttons.length < 8 && /* @__PURE__ */ jsx(Button, { onClick: addButton, variant: "plain", children: "Add Another Button" }),
                /* @__PURE__ */ jsxs(Text, { variant: "bodySm", tone: "subdued", children: [
                  "You can add up to 8 buttons per template. URL variables in ",
                  "{{1}}",
                  " format are optional for order confirmation templates."
                ] })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(InlineStack, { gap: "300", align: "end", children: [
              /* @__PURE__ */ jsx(
                Button,
                {
                  variant: "secondary",
                  onClick: handleCancel,
                  children: "Cancel"
                }
              ),
              /* @__PURE__ */ jsx(
                Button,
                {
                  variant: "primary",
                  onClick: handleSave,
                  disabled: !templateName || !bodyText || templateNameAvailability !== true || checkingTemplateName,
                  children: "Save Template"
                }
              )
            ] }) })
          ] }) }) }),
          /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 4, lg: 4, xl: 4 }, children: /* @__PURE__ */ jsx("div", { style: { position: "sticky", top: "20px" }, children: /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Template Preview" }),
            generateTemplateJSON && (bodyText || hasHeader && (headerContent || headerMediaUrl) || hasFooter && footerText || hasButtons && buttons.some((btn) => btn.text)) ? /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", children: [
                "Template: ",
                templateName ? templateName.toLowerCase().replace(/\s+/g, "_") : "untitled_template"
              ] }),
              /* @__PURE__ */ jsx(
                WhatsAppPreview,
                {
                  template: generateTemplateJSON,
                  variant: "full",
                  maxWidth: "280px",
                  showWhatsAppHeader: false
                }
              ),
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                "Variables like ",
                `{{customer_name}}`,
                " or ",
                `{{1}}`,
                " will be replaced with actual data when sent."
              ] })
            ] }) : /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
              /* @__PURE__ */ jsx(Text, { as: "p", tone: "subdued", children: "Enter template details to see the preview" }),
              /* @__PURE__ */ jsx(LegacyCard, { sectioned: true, children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Your template preview will appear here once you add template content (header, body text, footer, or buttons)." }) })
            ] })
          ] }) }) }) })
        ] }),
        /* @__PURE__ */ jsx(
          Modal,
          {
            open: showVariablesModal,
            onClose: () => {
              setShowVariablesModal(false);
              setVariableSearchQuery("");
            },
            title: "All Available Variables",
            primaryAction: {
              content: "Close",
              onAction: () => {
                setShowVariablesModal(false);
                setVariableSearchQuery("");
              }
            },
            size: "large",
            children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", tone: "subdued", children: "Click on any variable to insert it into your template:" }),
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Search Variables",
                  value: variableSearchQuery,
                  onChange: setVariableSearchQuery,
                  placeholder: "Type to search variables...",
                  clearButton: true,
                  onClearButtonClick: () => setVariableSearchQuery(""),
                  autoComplete: "off"
                }
              ),
              /* @__PURE__ */ jsx(InlineStack, { gap: "200", wrap: true, children: availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).map((variable) => /* @__PURE__ */ jsx(
                Button,
                {
                  size: "medium",
                  variant: "tertiary",
                  onClick: () => {
                    insertVariable(variable.value);
                    setShowVariablesModal(false);
                    setVariableSearchQuery("");
                  },
                  children: variable.label
                },
                variable.value
              )) }),
              availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).length === 0 && variableSearchQuery && /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", tone: "subdued", alignment: "center", children: [
                'No variables found matching "',
                variableSearchQuery,
                '"'
              ] }),
              /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", children: "variable for order confirmation templates is fixed you can't create custom variables" })
            ] }) })
          }
        )
      ]
    }
  );
}
const route14 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: CreateOrderConfirmationTemplatePage
}, Symbol.toStringTag, { value: "Module" }));
const loader$2 = async ({ request }) => {
  const { session } = await authenticate.admin(request);
  return { shop: session.shop };
};
function CreateAbandonedCartTemplatePage() {
  const navigate = useNavigate();
  const { shop } = useLoaderData();
  const [templateName, setTemplateName] = useState("");
  const [templateCategory, setTemplateCategory] = useState("marketing");
  const [templateLanguage, setTemplateLanguage] = useState("en_US");
  const [templateType, setTemplateType] = useState("text");
  const [hasHeader, setHasHeader] = useState(false);
  const [headerType, setHeaderType] = useState("text");
  const [headerContent, setHeaderContent] = useState("");
  const [headerMediaUrl, setHeaderMediaUrl] = useState("");
  const [headerDocumentFilename, setHeaderDocumentFilename] = useState("");
  const [headerFile, setHeaderFile] = useState(null);
  const [headerFilePreview, setHeaderFilePreview] = useState("");
  const [bodyText, setBodyText] = useState("");
  const [cursorPosition, setCursorPosition] = useState(0);
  const [hasFooter, setHasFooter] = useState(false);
  const [footerText, setFooterText] = useState("");
  const [hasButtons, setHasButtons] = useState(false);
  const [buttons, setButtons] = useState([{ type: "URL", text: "", url: "" }]);
  const [urlVariables, setUrlVariables] = useState({});
  const [headerVariableMapping, setHeaderVariableMapping] = useState({});
  const [bodyVariableMapping, setBodyVariableMapping] = useState({});
  const availableVariables = [
    { label: "cart_last_id", value: "cart_last_id" },
    { label: "cart_created_at", value: "cart_created_at" },
    { label: "cart_completed_at", value: "cart_completed_at" },
    { label: "cart_total_price", value: "cart_total_price" },
    { label: "cart_currency", value: "cart_currency" },
    { label: "cart_customer_id", value: "cart_customer_id" },
    { label: "customer_first_name", value: "customer_first_name" },
    { label: "customer_last_name", value: "customer_last_name" },
    { label: "customer_email", value: "customer_email" },
    { label: "customer_phone", value: "customer_phone" },
    { label: "number_of_orders", value: "number_of_orders" },
    { label: "customer_duration", value: "customer_duration" },
    { label: "customer_address", value: "customer_address" },
    { label: "line_item_id", value: "line_item_id" },
    { label: "line_item_title", value: "line_item_title" },
    { label: "line_item_quantity", value: "line_item_quantity" },
    { label: "line_item_variant", value: "line_item_variant" },
    { label: "support_email", value: "support_email" },
    { label: "support_phone", value: "support_phone" }
  ];
  const [showVariablesModal, setShowVariablesModal] = useState(false);
  const [variableSearchQuery, setVariableSearchQuery] = useState("");
  const [templateNameAvailability, setTemplateNameAvailability] = useState(null);
  const [checkingTemplateName, setCheckingTemplateName] = useState(false);
  const [templateNameError, setTemplateNameError] = useState("");
  const categoryOptions = [
    { label: "Marketing", value: "marketing" },
    { label: "Utility", value: "utility" },
    { label: "Authentication", value: "authentication" }
  ];
  const languageOptions = [
    { label: "English (US)", value: "en_US" },
    { label: "English (UK)", value: "en_GB" },
    { label: "Spanish", value: "es" },
    { label: "French", value: "fr" },
    { label: "German", value: "de" },
    { label: "Hindi", value: "hi" }
  ];
  const headerTypeOptions = [
    { label: "Text", value: "text" },
    { label: "Image", value: "image" },
    { label: "Video", value: "video" },
    { label: "Document", value: "document" }
  ];
  useEffect(() => {
    if (!templateName.trim()) {
      setTemplateNameAvailability(null);
      setTemplateNameError("");
      return;
    }
    const timeoutId = setTimeout(async () => {
      try {
        setCheckingTemplateName(true);
        setTemplateNameError("");
        const response = await Checkisteplatenameavailable(templateName.toLowerCase().replace(/\s+/g, "_"));
        if (response.status === true) {
          setTemplateNameAvailability(true);
        } else {
          setTemplateNameAvailability(false);
          setTemplateNameError(response.message || "Template name is not available");
        }
      } catch (error) {
        console.error("Error checking template name:", error);
        setTemplateNameError("Error checking template name availability");
        setTemplateNameAvailability(false);
      } finally {
        setCheckingTemplateName(false);
      }
    }, 500);
    return () => clearTimeout(timeoutId);
  }, [templateName]);
  const mappingOptions = useMemo(() => {
    return [
      { label: "Select mapping...", value: "" },
      ...availableVariables.map((variable) => ({
        label: variable.label,
        value: variable.value
      }))
    ];
  }, [availableVariables]);
  const handleHeaderVariableMapping = useCallback((variableIndex, mappingValue) => {
    setHeaderVariableMapping((prev) => ({
      ...prev,
      [variableIndex]: mappingValue
    }));
  }, []);
  const handleBodyVariableMapping = useCallback((variableIndex, mappingValue) => {
    setBodyVariableMapping((prev) => ({
      ...prev,
      [variableIndex]: mappingValue
    }));
  }, []);
  const validateHeaderText = useCallback((text2) => {
    if (headerType === "text") {
      const variables = extractVariablesFromWhatsAppMessage(JSON.stringify({ text: text2 }));
      if (variables.length > 1) {
        const firstVariable = variables[0];
        const newText = text2.replace(/\{\{[^}]+\}\}/g, (match, offset) => {
          return offset === text2.indexOf(`{{${firstVariable}}}`) ? match : "";
        });
        return newText;
      }
    }
    return text2;
  }, [headerType]);
  const handleHeaderContentChange = useCallback((value) => {
    const validatedValue = validateHeaderText(value);
    setHeaderContent(validatedValue);
    if (validatedValue !== value) {
      setHeaderVariableMapping({});
    }
  }, [validateHeaderText]);
  const headerVariables = useMemo(() => {
    if (hasHeader && headerType === "text" && headerContent) {
      const variables = extractVariablesFromWhatsAppMessage(JSON.stringify({ text: headerContent }));
      return variables.slice(0, 1);
    }
    return [];
  }, [hasHeader, headerType, headerContent]);
  const bodyVariables = useMemo(() => {
    if (bodyText) {
      return extractVariablesFromWhatsAppMessage(JSON.stringify({ text: bodyText }));
    }
    return [];
  }, [bodyText]);
  const generateTemplateJSON = useMemo(() => {
    const template = {
      sender: "",
      campaign_id: "put_campaign_id",
      messaging_product: "whatsapp",
      recipient_type: "individual",
      to: "receiver_number",
      type: "template",
      template: {
        name: templateName.toLowerCase().replace(/\s+/g, "_") || "new_template",
        language: {
          code: templateLanguage
        },
        components: []
      }
    };
    if (hasHeader && (headerContent || headerMediaUrl)) {
      const headerComponent = {
        type: "HEADER",
        format: headerType.toUpperCase()
      };
      if (headerType === "text") {
        headerComponent.text = headerContent;
        if (headerVariables.length > 0) {
          headerComponent.parameters = headerVariables.map((variable, index2) => ({
            type: "text",
            text: headerVariableMapping[index2] || variable
          }));
        }
      } else if (headerType === "image") {
        headerComponent.format = "IMAGE";
        headerComponent.example = {
          header_handle: [headerMediaUrl]
        };
      } else if (headerType === "video") {
        headerComponent.format = "VIDEO";
        headerComponent.example = {
          header_handle: [headerMediaUrl]
        };
      } else if (headerType === "document") {
        headerComponent.format = "DOCUMENT";
        headerComponent.example = {
          header_handle: [headerMediaUrl]
        };
        if (headerDocumentFilename) {
          headerComponent.filename = headerDocumentFilename;
        }
      }
      template.template.components.push(headerComponent);
    }
    if (bodyText) {
      const bodyComponent = {
        type: "BODY",
        text: bodyText
      };
      if (bodyVariables.length > 0) {
        bodyComponent.parameters = bodyVariables.map((variable, index2) => ({
          type: "text",
          text: bodyVariableMapping[index2] || variable
        }));
      }
      template.template.components.push(bodyComponent);
    }
    if (hasFooter && footerText) {
      template.template.components.push({
        type: "FOOTER",
        text: footerText
      });
    }
    if (hasButtons && buttons.some((btn) => btn.text && btn.url)) {
      const validButtons = buttons.filter((btn) => btn.text && btn.url);
      if (validButtons.length > 0) {
        template.template.components.push({
          type: "BUTTONS",
          buttons: validButtons.map((btn) => ({
            type: "URL",
            text: btn.text,
            url: btn.url,
            example: [btn.text.toLowerCase()]
          }))
        });
      }
    }
    return JSON.stringify(template);
  }, [templateName, templateLanguage, hasHeader, headerType, headerContent, headerMediaUrl, headerDocumentFilename, bodyText, hasFooter, footerText, hasButtons, buttons, headerVariables, bodyVariables, headerVariableMapping, bodyVariableMapping]);
  useMemo(() => {
    return [...headerVariables, ...bodyVariables];
  }, [headerVariables, bodyVariables]);
  const handleTextSelection = useCallback(() => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    setCursorPosition(textarea.selectionStart);
  }, []);
  const applyFormatting = useCallback((format) => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const end = textarea.selectionEnd;
    const selectedText = textarea.value.substring(start, end);
    let formattedText = "";
    let cursorOffset = 0;
    if (selectedText) {
      switch (format) {
        case "bold":
          formattedText = `*${selectedText}*`;
          cursorOffset = formattedText.length;
          break;
        case "italic":
          formattedText = `_${selectedText}_`;
          cursorOffset = formattedText.length;
          break;
        case "strikethrough":
          formattedText = `~${selectedText}~`;
          cursorOffset = formattedText.length;
          break;
        case "monospace":
          formattedText = `\`\`\`${selectedText}\`\`\``;
          cursorOffset = formattedText.length;
          break;
        case "inline-code":
          formattedText = `\`${selectedText}\``;
          cursorOffset = formattedText.length;
          break;
        case "quote":
          const needsNewLineBeforeQuote = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfterQuote = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBeforeQuote ? "\n" : "") + `> ${selectedText}` + (needsNewLineAfterQuote ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        case "bullet-list":
          const bulletLines = selectedText.split("\n").map((line) => line.trim() ? `* ${line}` : line).join("\n");
          const needsNewLineBefore = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfter = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBefore ? "\n" : "") + bulletLines + (needsNewLineAfter ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        case "numbered-list":
          const numberedLines = selectedText.split("\n").filter((line) => line.trim()).map((line, index2) => `${index2 + 1}. ${line}`).join("\n");
          const needsNewLineBeforeNum = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfterNum = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBeforeNum ? "\n" : "") + numberedLines + (needsNewLineAfterNum ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        default:
          formattedText = selectedText;
          cursorOffset = formattedText.length;
      }
    } else {
      switch (format) {
        case "bold":
          formattedText = "**";
          cursorOffset = 1;
          break;
        case "italic":
          formattedText = "__";
          cursorOffset = 1;
          break;
        case "strikethrough":
          formattedText = "~~";
          cursorOffset = 1;
          break;
        case "monospace":
          formattedText = "```\n\n```";
          cursorOffset = 4;
          break;
        case "inline-code":
          formattedText = "``";
          cursorOffset = 1;
          break;
        case "quote":
          const needsNewLineBeforeQuoteEmpty = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeQuoteEmpty ? "\n> " : "> ";
          cursorOffset = formattedText.length;
          break;
        case "bullet-list":
          const needsNewLineBeforeBullet = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeBullet ? "\n* " : "* ";
          cursorOffset = formattedText.length;
          break;
        case "numbered-list":
          const needsNewLineBeforeNumber = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeNumber ? "\n1. " : "1. ";
          cursorOffset = formattedText.length;
          break;
        default:
          formattedText = "";
          cursorOffset = 0;
      }
    }
    const newValue = textarea.value.substring(0, start) + formattedText + textarea.value.substring(end);
    setBodyText(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + cursorOffset, start + cursorOffset);
    }, 0);
  }, []);
  const insertVariable = useCallback((variable) => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const variableText = `{{${variable}}}`;
    const newValue = textarea.value.substring(0, start) + variableText + textarea.value.substring(start);
    setBodyText(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + variableText.length, start + variableText.length);
    }, 0);
  }, []);
  const insertEmoji = useCallback((emoji) => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const newValue = textarea.value.substring(0, start) + emoji + textarea.value.substring(start);
    setBodyText(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + emoji.length, start + emoji.length);
    }, 0);
  }, []);
  useEffect(() => {
    const handleKeyDown = (event) => {
      if ((event.ctrlKey || event.metaKey) && event.target.id === "body-text-field") {
        switch (event.key.toLowerCase()) {
          case "b":
            event.preventDefault();
            applyFormatting("bold");
            break;
          case "i":
            event.preventDefault();
            applyFormatting("italic");
            break;
          case "s":
            event.preventDefault();
            applyFormatting("strikethrough");
            break;
          case "m":
            event.preventDefault();
            applyFormatting("monospace");
            break;
          case "k":
            event.preventDefault();
            applyFormatting("inline-code");
            break;
          case "q":
            event.preventDefault();
            applyFormatting("quote");
            break;
          case "l":
            event.preventDefault();
            applyFormatting("bullet-list");
            break;
          case "n":
            event.preventDefault();
            applyFormatting("numbered-list");
            break;
        }
      }
    };
    document.addEventListener("keydown", handleKeyDown);
    return () => document.removeEventListener("keydown", handleKeyDown);
  }, [applyFormatting]);
  useEffect(() => {
    setHeaderVariableMapping((prev) => {
      const newMapping = {};
      headerVariables.forEach((variable, index2) => {
        if (prev[index2]) {
          newMapping[index2] = prev[index2];
        }
      });
      return newMapping;
    });
  }, [headerVariables]);
  useEffect(() => {
    setBodyVariableMapping((prev) => {
      const newMapping = {};
      bodyVariables.forEach((variable, index2) => {
        if (prev[index2]) {
          newMapping[index2] = prev[index2];
        }
      });
      return newMapping;
    });
  }, [bodyVariables]);
  const validateUrlButton = useCallback((url) => {
    if (!url) return { isValid: false, error: "URL is required" };
    const storeUrl = `https://${shop}/`;
    if (!url.startsWith(storeUrl)) {
      return { isValid: false, error: `URL must start with ${storeUrl}` };
    }
    const variablePattern = /\{\{1\}\}/;
    if (!variablePattern.test(url)) {
      return { isValid: false, error: "URL must contain a variable in {{1}} format at the end (mandatory for abandoned cart templates)" };
    }
    return { isValid: true, error: null };
  }, [shop]);
  const checkUrlVariables = useCallback((url) => {
    const hasVariable = /\{\{1\}\}/.test(url);
    return hasVariable;
  }, []);
  const handleUrlVariableChange = useCallback((buttonIndex, value) => {
    setUrlVariables((prev) => ({
      ...prev,
      [buttonIndex]: value
    }));
  }, []);
  const handleButtonChange = useCallback((index2, field, value) => {
    setButtons((prev) => prev.map((btn, i) => {
      if (i === index2) {
        const updatedBtn = { ...btn, [field]: value };
        if (field === "url") {
          updatedBtn.urlError = null;
          if (!checkUrlVariables(value)) {
            setUrlVariables((prev2) => {
              const newVars = { ...prev2 };
              delete newVars[index2];
              return newVars;
            });
          }
        }
        return updatedBtn;
      }
      return btn;
    }));
  }, [checkUrlVariables]);
  const addButton = useCallback(() => {
    if (buttons.length < 2) {
      setButtons((prev) => [...prev, { type: "URL", text: "", url: "" }]);
    }
  }, [buttons.length]);
  const removeButton = useCallback((index2) => {
    setButtons((prev) => prev.filter((_, i) => i !== index2));
  }, []);
  const handleHeaderFileUpload = useCallback((files) => {
    if (files.length > 0) {
      const file = files[0];
      setHeaderFile(file);
      const reader = new FileReader();
      reader.onload = (e) => {
        setHeaderFilePreview(e.target.result);
        setHeaderMediaUrl(e.target.result);
      };
      reader.readAsDataURL(file);
      if (headerType === "document") {
        setHeaderDocumentFilename(file.name);
      }
    }
  }, [headerType]);
  const handleRemoveHeaderFile = useCallback(() => {
    setHeaderFile(null);
    setHeaderFilePreview("");
    setHeaderMediaUrl("");
    setHeaderDocumentFilename("");
  }, []);
  const handleSave = useCallback(async () => {
    try {
      const payload = {
        template_type: 2,
        draftedtemplateid: 0,
        normaltemplateid: 0,
        _token: "",
        templatename: templateName.toLowerCase().replace(/\s+/g, "_"),
        language: templateLanguage,
        category: templateCategory.toUpperCase(),
        body: bodyText,
        bodyVars: Object.values(bodyVariableMapping),
        phoneCountry: 91,
        previewfooterText: hasFooter ? footerText : ""
      };
      if (hasButtons && Array.isArray(buttons)) {
        const quickReplyButtons = buttons.filter((btn) => btn.type === "QUICK_REPLY" && btn.text);
        if (quickReplyButtons.length > 0) {
          payload.quickReplyButtonText = quickReplyButtons.map((btn) => btn.text);
        }
        const urlButtons = buttons.filter((btn) => btn.type === "URL" && btn.text && btn.url);
        if (urlButtons.length > 0) {
          const invalidButtons = urlButtons.filter((btn) => {
            const validation = validateUrlButton(btn.url);
            return !validation.isValid;
          });
          if (invalidButtons.length > 0) {
            console.error("Invalid URL buttons found");
            return;
          }
          payload.websiteButtonText = urlButtons.map((btn) => btn.text);
          payload.previewWebsiteUrl = urlButtons.map((btn) => btn.url);
          const urlVarsArray = urlButtons.map((btn, index2) => {
            return urlVariables[index2] || "";
          }).filter((varValue) => varValue.trim() !== "");
          if (urlVarsArray.length > 0) {
            payload.UrlVars = urlVarsArray;
          }
        }
        const phoneButtons = buttons.filter((btn) => btn.type === "PHONE_NUMBER" && btn.text && btn.phone_number);
        if (phoneButtons.length > 0) {
          const primaryPhoneButton = phoneButtons[0];
          payload.callbuttonText = primaryPhoneButton.text;
          payload.prevviewphoneNumber = String(primaryPhoneButton.phone_number).replace(/^\+/, "");
          const selectedCode = (primaryPhoneButton.phone_country_code || "").replace(/^\+/, "");
          let countryCode = selectedCode;
          if (!countryCode && primaryPhoneButton.phone_number) {
            const match = String(primaryPhoneButton.phone_number).match(/^\+?(\d{1,3})/);
            if (match && match[1]) {
              countryCode = match[1];
            }
          }
          if (countryCode) {
            const parsedCode = parseInt(countryCode, 10);
            if (!Number.isNaN(parsedCode)) {
              payload.phoneCountry = parsedCode;
            }
          }
        }
      }
      if (hasHeader) {
        payload.headerType = headerType.charAt(0).toUpperCase() + headerType.slice(1);
        if (headerType === "text") {
          payload.headerText = headerContent;
          if (Object.keys(headerVariableMapping).length > 0) {
            payload.headerVar = Object.values(headerVariableMapping)[0];
          }
        } else {
          if (headerFile) {
            const formData = new FormData();
            formData.append("headerFile", headerFile);
            Object.entries(payload).forEach(([key, value]) => {
              if (Array.isArray(value)) {
                value.forEach((item) => {
                  formData.append(`${key}[]`, item);
                });
              } else {
                formData.append(key, value);
              }
            });
            console.log("Payload:", payload);
            const response2 = await fetch(`https://app.getgabs.com/partners/template/with-custom-vars/designtemplate?token=${API_TOKEN}`, {
              method: "POST",
              body: formData,
              headers: {
                "X-Requested-With": "XMLHttpRequest"
              }
            });
            if (!response2.ok) throw new Error("Failed to save template");
            const result2 = await response2.json();
            console.log("Template saved successfully:", result2);
            navigate("/app/templates");
            return;
          }
        }
      }
      const response = await fetch(`https://app.getgabs.com/partners/template/with-custom-vars/designtemplate?token=${API_TOKEN}`, {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          "Authorization": `Bearer ${API_TOKEN}`,
          "X-Requested-With": "XMLHttpRequest"
        },
        body: JSON.stringify(payload)
      });
      if (!response.ok) throw new Error("Failed to save template");
      const result = await response.json();
      console.log("Template saved successfully:", result);
      navigate("/app/templates");
    } catch (error) {
      console.error("Error saving template:", error);
    }
  }, [
    templateName,
    templateLanguage,
    templateCategory,
    bodyText,
    hasFooter,
    footerText,
    hasHeader,
    headerType,
    headerContent,
    headerFile,
    headerVariableMapping,
    bodyVariableMapping,
    headerVariables,
    bodyVariables,
    urlVariables,
    generateTemplateJSON,
    navigate
  ]);
  const handleCancel = useCallback(() => {
    navigate("/app/templates");
  }, [navigate]);
  return /* @__PURE__ */ jsxs(
    Page,
    {
      fullWidth: true,
      backAction: {
        content: "Templates",
        onAction: () => navigate("/app/templates")
      },
      title: "Create Abandoned Cart Template",
      subtitle: "Create a new abandoned cart WhatsApp message template",
      primaryAction: {
        content: "Save Template",
        onAction: handleSave,
        disabled: !templateName || !bodyText || hasButtons && buttons.some((btn) => btn.text && (!btn.url || btn.urlError || !urlVariables[buttons.indexOf(btn)])) || templateNameAvailability !== true || checkingTemplateName
      },
      secondaryActions: [
        {
          content: "Cancel",
          onAction: handleCancel
        }
      ],
      children: [
        /* @__PURE__ */ jsxs(Grid, { children: [
          /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 8, lg: 8, xl: 8 }, children: /* @__PURE__ */ jsx("div", { style: { marginRight: "20px" }, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "500", children: [
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Basic Information" }),
              /* @__PURE__ */ jsxs(FormLayout, { children: [
                /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: "Template Name",
                    value: templateName,
                    onChange: (value) => setTemplateName(value.replace(/\s+/g, "_")),
                    placeholder: "Enter template name",
                    helpText: checkingTemplateName ? "Checking availability..." : templateNameAvailability === true ? "✓ Template name is available" : templateNameAvailability === false ? templateNameError : "This will be used as the template identifier",
                    error: templateNameAvailability === false ? templateNameError : void 0,
                    tone: checkingTemplateName ? void 0 : templateNameAvailability === true ? "success" : templateNameAvailability === false ? "critical" : void 0,
                    autoComplete: "off"
                  }
                ),
                /* @__PURE__ */ jsxs(InlineStack, { gap: "400", children: [
                  /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                    Select,
                    {
                      label: "Category",
                      options: categoryOptions,
                      value: templateCategory,
                      onChange: setTemplateCategory
                    }
                  ) }),
                  /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                    Select,
                    {
                      label: "Language",
                      options: languageOptions,
                      value: templateLanguage,
                      onChange: setTemplateLanguage
                    }
                  ) })
                ] })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Header" }),
                /* @__PURE__ */ jsx(
                  Button,
                  {
                    variant: hasHeader ? "primary" : "plain",
                    onClick: () => setHasHeader(!hasHeader),
                    size: "slim",
                    children: hasHeader ? "Remove Header" : "Add Header"
                  }
                )
              ] }),
              hasHeader && /* @__PURE__ */ jsxs(FormLayout, { children: [
                /* @__PURE__ */ jsx(
                  Select,
                  {
                    label: "Header Type",
                    options: headerTypeOptions,
                    value: headerType,
                    onChange: setHeaderType
                  }
                ),
                headerType === "text" && /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: "Header Text",
                    value: headerContent,
                    onChange: handleHeaderContentChange,
                    placeholder: "Enter header text (max 1 variable allowed)",
                    maxLength: 60,
                    showCharacterCount: true,
                    helpText: "Header text can contain maximum 1 variable. Use {{variable_name}} format.",
                    autoComplete: "off"
                  }
                ),
                (headerType === "image" || headerType === "video" || headerType === "document") && /* @__PURE__ */ jsxs("div", { children: [
                  /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", fontWeight: "medium", children: [
                    "Choose ",
                    headerType.charAt(0).toUpperCase() + headerType.slice(1)
                  ] }),
                  /* @__PURE__ */ jsx("div", { style: { marginTop: "8px" }, children: !headerFile ? /* @__PURE__ */ jsx(
                    DropZone,
                    {
                      onDrop: handleHeaderFileUpload,
                      accept: headerType === "image" ? "image/*" : headerType === "video" ? "video/*" : "*/*",
                      type: "file",
                      allowMultiple: false,
                      children: /* @__PURE__ */ jsx(DropZone.FileUpload, { actionTitle: `Choose ${headerType}`, actionHint: `or drag and drop your ${headerType} here` })
                    }
                  ) : /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                    /* @__PURE__ */ jsxs(InlineStack, { gap: "200", align: "space-between", children: [
                      /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                        /* @__PURE__ */ jsx(
                          Thumbnail,
                          {
                            source: headerFilePreview || (headerType === "document" ? "📄" : "📁"),
                            alt: headerFile.name,
                            size: "small"
                          }
                        ),
                        /* @__PURE__ */ jsxs(BlockStack, { gap: "050", children: [
                          /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: headerFile.name }),
                          /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                            (headerFile.size / 1024 / 1024).toFixed(2),
                            " MB"
                          ] })
                        ] })
                      ] }),
                      /* @__PURE__ */ jsx(
                        Button,
                        {
                          variant: "plain",
                          tone: "critical",
                          onClick: handleRemoveHeaderFile,
                          size: "slim",
                          children: "Remove"
                        }
                      )
                    ] }),
                    /* @__PURE__ */ jsxs(
                      Button,
                      {
                        variant: "plain",
                        onClick: () => {
                          handleRemoveHeaderFile();
                        },
                        size: "slim",
                        children: [
                          "Choose Different ",
                          headerType.charAt(0).toUpperCase() + headerType.slice(1)
                        ]
                      }
                    )
                  ] }) })
                ] }),
                headerType === "document" && /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: "Document Filename",
                    value: headerDocumentFilename,
                    onChange: setHeaderDocumentFilename,
                    placeholder: "Enter document filename",
                    autoComplete: "off"
                  }
                ),
                headerType === "text" && headerVariables.length > 0 && /* @__PURE__ */ jsxs("div", { children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "semibold", tone: "subdued", children: "Header Variable Mapping" }),
                  /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", style: { marginBottom: "12px" }, children: "Map the variables in your header text to actual data fields:" }),
                  /* @__PURE__ */ jsx(BlockStack, { gap: "300", align: "center", children: headerVariables.map((variable, index2) => /* @__PURE__ */ jsxs(
                    InlineStack,
                    {
                      gap: "300",
                      align: "center",
                      blockAlign: "center",
                      children: [
                        /* @__PURE__ */ jsx("div", { style: { minWidth: "120px", textAlign: "center" }, children: /* @__PURE__ */ jsx(Badge, { tone: "info", children: `{{${variable}}}` }) }),
                        /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "span", children: "→" }),
                        /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                          Select,
                          {
                            options: mappingOptions,
                            value: headerVariableMapping[index2] || "",
                            onChange: (value) => handleHeaderVariableMapping(index2, value),
                            placeholder: "Select mapping..."
                          }
                        ) })
                      ]
                    },
                    index2
                  )) })
                ] })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Body Text *" }),
              /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Click to insert variables  :" }),
                /* @__PURE__ */ jsxs(InlineStack, { gap: "100", wrap: true, children: [
                  availableVariables.slice(0, 8).map((variable) => /* @__PURE__ */ jsx(
                    Button,
                    {
                      size: "micro",
                      variant: "tertiary",
                      onClick: () => insertVariable(variable.value),
                      children: variable.label
                    },
                    variable.value
                  )),
                  availableVariables.length > 8 && /* @__PURE__ */ jsxs(
                    Button,
                    {
                      size: "micro",
                      variant: "primary",
                      onClick: () => setShowVariablesModal(true),
                      children: [
                        "More Variables (",
                        availableVariables.length - 8,
                        ")"
                      ]
                    }
                  )
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { style: { position: "relative" }, children: [
                /* @__PURE__ */ jsxs("div", { style: { position: "absolute", bottom: 12, right: 6, zIndex: 99, display: "flex", gap: "4px", flexWrap: "wrap" }, children: [
                  /* @__PURE__ */ jsx(ButtonGroup, { variant: "segmented", children: /* @__PURE__ */ jsx(EmojiPicker, { onEmojiSelect: insertEmoji, buttonSize: "micro" }) }),
                  /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Bold",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘B" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bold"), accessibilityLabel: "Bold", children: /* @__PURE__ */ jsx(Text, { fontWeight: "bold", children: "B" }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Italic",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘I" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("italic"), accessibilityLabel: "Italic", children: /* @__PURE__ */ jsx(Text, { as: "em", children: "I" }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Strikethrough",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘S" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("strikethrough"), accessibilityLabel: "Strikethrough", children: /* @__PURE__ */ jsx(Text, { as: "s", children: "S" }) }) })
                  ] }),
                  /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Monospace",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘M" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("monospace"), accessibilityLabel: "Monospace", children: /* @__PURE__ */ jsxs(Text, { as: "code", children: [
                      " ",
                      "</>"
                    ] }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Inline Code",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘K" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("inline-code"), accessibilityLabel: "Inline Code", children: /* @__PURE__ */ jsx(Text, { as: "code", children: "<>" }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Quote",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘Q" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("quote"), accessibilityLabel: "Quote", children: '"' }) })
                  ] }),
                  /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Bullet List",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘L" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bullet-list"), accessibilityLabel: "Bullet List", children: "•" }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Numbered List",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘N" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("numbered-list"), accessibilityLabel: "Numbered List", children: "1." }) })
                  ] })
                ] }),
                /* @__PURE__ */ jsx(
                  TextField,
                  {
                    id: "body-text-field",
                    label: "Message Body",
                    value: bodyText,
                    onChange: setBodyText,
                    onSelect: handleTextSelection,
                    multiline: 8,
                    maxLength: 1024,
                    placeholder: "Type your message body here... Formatting options: *bold*, _italic_, ~strikethrough~, ```monospace```, `inline code`, > quote, * bullet list, 1. numbered list. Use keyboard shortcuts or click buttons above.",
                    helpText: `${bodyText.length}/1024 characters`,
                    showCharacterCount: true,
                    autoComplete: "off"
                  }
                )
              ] }),
              bodyVariables.length > 0 && /* @__PURE__ */ jsxs("div", { children: [
                /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "semibold", tone: "subdued", children: "Body Variable Mapping" }),
                /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", style: { marginBottom: "12px" }, children: "Map the variables in your body text to actual data fields:" }),
                /* @__PURE__ */ jsx(BlockStack, { gap: "300", align: "center", children: bodyVariables.map((variable, index2) => /* @__PURE__ */ jsxs(
                  InlineStack,
                  {
                    gap: "300",
                    align: "center",
                    blockAlign: "center",
                    children: [
                      /* @__PURE__ */ jsx("div", { style: { minWidth: "120px", textAlign: "center" }, children: /* @__PURE__ */ jsx(Badge, { tone: "info", children: `{{${variable}}}` }) }),
                      /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "span", children: "→" }),
                      /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                        Select,
                        {
                          options: mappingOptions,
                          value: bodyVariableMapping[index2] || "",
                          onChange: (value) => handleBodyVariableMapping(index2, value),
                          placeholder: "Select mapping..."
                        }
                      ) })
                    ]
                  },
                  index2
                )) })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Footer" }),
                /* @__PURE__ */ jsx(
                  Button,
                  {
                    variant: hasFooter ? "primary" : "plain",
                    onClick: () => setHasFooter(!hasFooter),
                    size: "slim",
                    children: hasFooter ? "Remove Footer" : "Add Footer"
                  }
                )
              ] }),
              hasFooter && /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Footer Text",
                  value: footerText,
                  onChange: setFooterText,
                  placeholder: "Enter footer text",
                  maxLength: 60,
                  showCharacterCount: true,
                  helpText: "Footer text appears at the bottom of the message",
                  autoComplete: "off"
                }
              )
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Buttons" }),
                /* @__PURE__ */ jsx(
                  Button,
                  {
                    variant: hasButtons ? "primary" : "plain",
                    onClick: () => setHasButtons(!hasButtons),
                    size: "slim",
                    children: hasButtons ? "Remove Buttons" : "Add Buttons"
                  }
                )
              ] }),
              hasButtons && /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                buttons.map((button2, index2) => /* @__PURE__ */ jsx(Card, { background: "bg-surface-secondary", children: /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                  /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                    /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", fontWeight: "semibold", children: [
                      "Button ",
                      index2 + 1
                    ] }),
                    buttons.length > 1 && /* @__PURE__ */ jsx(
                      Button,
                      {
                        variant: "plain",
                        tone: "critical",
                        onClick: () => removeButton(index2),
                        size: "slim",
                        children: "Remove"
                      }
                    )
                  ] }),
                  /* @__PURE__ */ jsxs(FormLayout, { children: [
                    /* @__PURE__ */ jsx(
                      TextField,
                      {
                        label: "Button Text",
                        value: button2.text,
                        onChange: (value) => handleButtonChange(index2, "text", value),
                        placeholder: "Enter button text (e.g., Checkout)",
                        maxLength: 20,
                        showCharacterCount: true,
                        autoComplete: "off"
                      }
                    ),
                    /* @__PURE__ */ jsx(
                      TextField,
                      {
                        label: "URL",
                        value: button2.url || "",
                        onChange: (value) => {
                          handleButtonChange(index2, "url", value);
                          const validation = validateUrlButton(value);
                          if (!validation.isValid && value) {
                            handleButtonChange(index2, "urlError", validation.error);
                          } else {
                            handleButtonChange(index2, "urlError", null);
                          }
                        },
                        placeholder: `https://${shop}/{{1}}`,
                        error: button2.urlError,
                        helpText: `URL must start with https://${shop}/ and contain a variable like {{1}} (mandatory for abandoned cart templates)`,
                        autoComplete: "off"
                      }
                    ),
                    button2.url && checkUrlVariables(button2.url) && /* @__PURE__ */ jsx(
                      TextField,
                      {
                        label: "URL Variable Value *",
                        value: urlVariables[index2] || "",
                        onChange: (value) => handleUrlVariableChange(index2, value),
                        placeholder: "Enter value for {{1}} variable (mandatory)",
                        helpText: "This value will replace the {{1}} variable in the URL when sending (mandatory for abandoned cart templates)",
                        autoComplete: "off"
                      }
                    )
                  ] })
                ] }) }, index2)),
                buttons.length < 1 && /* @__PURE__ */ jsx(Button, { onClick: addButton, variant: "plain", children: "Add Another Button" }),
                /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", children: `You can add up to 2 URL buttons. Each URL must start with https://${shop}/ and contain a variable (mandatory for abandoned cart templates).` })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(InlineStack, { gap: "300", align: "end", children: [
              /* @__PURE__ */ jsx(
                Button,
                {
                  variant: "secondary",
                  onClick: handleCancel,
                  children: "Cancel"
                }
              ),
              /* @__PURE__ */ jsx(
                Button,
                {
                  variant: "primary",
                  onClick: handleSave,
                  disabled: !templateName || !bodyText || hasButtons && buttons.some((btn) => btn.text && (!btn.url || btn.urlError || !urlVariables[buttons.indexOf(btn)])) || templateNameAvailability !== true || checkingTemplateName,
                  children: "Save Template"
                }
              )
            ] }) })
          ] }) }) }),
          /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 4, lg: 4, xl: 4 }, children: /* @__PURE__ */ jsx("div", { style: { position: "sticky", top: "20px" }, children: /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Template Preview" }),
            generateTemplateJSON && (bodyText || hasHeader && (headerContent || headerMediaUrl) || hasFooter && footerText || hasButtons && buttons.some((btn) => btn.text)) ? /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", children: [
                "Template: ",
                templateName ? templateName.toLowerCase().replace(/\s+/g, "_") : "untitled_template"
              ] }),
              /* @__PURE__ */ jsx(
                WhatsAppPreview,
                {
                  template: generateTemplateJSON,
                  variant: "full",
                  maxWidth: "280px",
                  showWhatsAppHeader: false
                }
              ),
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                "Variables like ",
                `{{customer_name}}`,
                " or ",
                `{{1}}`,
                " will be replaced with actual data when sent."
              ] })
            ] }) : /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
              /* @__PURE__ */ jsx(Text, { as: "p", tone: "subdued", children: "Enter template details to see the preview" }),
              /* @__PURE__ */ jsx(LegacyCard, { sectioned: true, children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Your template preview will appear here once you add template content (header, body text, footer, or buttons)." }) })
            ] })
          ] }) }) }) })
        ] }),
        /* @__PURE__ */ jsx(
          Modal,
          {
            open: showVariablesModal,
            onClose: () => {
              setShowVariablesModal(false);
              setVariableSearchQuery("");
            },
            title: "All Available Variables",
            primaryAction: {
              content: "Close",
              onAction: () => {
                setShowVariablesModal(false);
                setVariableSearchQuery("");
              }
            },
            size: "large",
            children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", tone: "subdued", children: "Click on any variable to insert it into your template:" }),
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Search Variables",
                  value: variableSearchQuery,
                  onChange: setVariableSearchQuery,
                  placeholder: "Type to search variables...",
                  clearButton: true,
                  onClearButtonClick: () => setVariableSearchQuery(""),
                  autoComplete: "off"
                }
              ),
              /* @__PURE__ */ jsx(InlineStack, { gap: "200", wrap: true, children: availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).map((variable) => /* @__PURE__ */ jsx(
                Button,
                {
                  size: "medium",
                  variant: "tertiary",
                  onClick: () => {
                    insertVariable(variable.value);
                    setShowVariablesModal(false);
                    setVariableSearchQuery("");
                  },
                  children: variable.label
                },
                variable.value
              )) }),
              availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).length === 0 && variableSearchQuery && /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", tone: "subdued", alignment: "center", children: [
                'No variables found matching "',
                variableSearchQuery,
                '"'
              ] }),
              /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", children: "variable for abandoned cart templates is fixed you can't create custom variables" })
            ] }) })
          }
        )
      ]
    }
  );
}
const route15 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: CreateAbandonedCartTemplatePage,
  loader: loader$2
}, Symbol.toStringTag, { value: "Module" }));
function CreateCarouselTemplatePage() {
  const navigate = useNavigate();
  const [templateName, setTemplateName] = useState("");
  const [templateCategory, setTemplateCategory] = useState("marketing");
  const [templateLanguage, setTemplateLanguage] = useState("en_US");
  const [bodyText, setBodyText] = useState("");
  const [textSelection, setTextSelection] = useState({ start: 0, end: 0 });
  const [carouselCards, setCarouselCards] = useState([
    {
      id: 1,
      cardText: "",
      headerType: "IMAGE",
      // 'IMAGE' or 'VIDEO'
      imageUrl: "",
      videoUrl: "",
      mediaFile: null,
      mediaPreview: "",
      buttons: [{ type: "URL", text: "", url: "" }]
    }
  ]);
  const [urlVariables, setUrlVariables] = useState({});
  const categoryOptions = [
    { label: "Marketing", value: "marketing" },
    { label: "Utility", value: "utility" },
    { label: "Authentication", value: "authentication" }
  ];
  const languageOptions = [
    { label: "English (US)", value: "en_US" },
    { label: "English (UK)", value: "en_GB" },
    { label: "Spanish", value: "es" },
    { label: "French", value: "fr" },
    { label: "German", value: "de" },
    { label: "Hindi", value: "hi" }
  ];
  const buttonTypeOptions = [
    { label: "URL", value: "URL" },
    { label: "Phone Number", value: "PHONE_NUMBER" },
    { label: "Quick Reply", value: "QUICK_REPLY" }
  ];
  const [mainBodyVariableMapping, setMainBodyVariableMapping] = useState({});
  const [cardBodyVariableMapping, setCardBodyVariableMapping] = useState({});
  const [variableInputValues, setVariableInputValues] = useState({});
  const [availableVariables, setAvailableVariables] = useState([]);
  const [loadingVariables, setLoadingVariables] = useState(true);
  const [showVariablesModal, setShowVariablesModal] = useState(false);
  const [variableSearchQuery, setVariableSearchQuery] = useState("");
  const [templateNameAvailability, setTemplateNameAvailability] = useState(null);
  const [checkingTemplateName, setCheckingTemplateName] = useState(false);
  const [templateNameError, setTemplateNameError] = useState("");
  useEffect(() => {
    const fetchVariables = async () => {
      try {
        setLoadingVariables(true);
        const variables = await getTemplateVariables();
        setAvailableVariables(variables);
      } catch (error) {
        console.error("Error fetching variables:", error);
        setAvailableVariables([]);
      } finally {
        setLoadingVariables(false);
      }
    };
    fetchVariables();
  }, []);
  useEffect(() => {
    if (!templateName.trim()) {
      setTemplateNameAvailability(null);
      setTemplateNameError("");
      return;
    }
    const timeoutId = setTimeout(async () => {
      try {
        setCheckingTemplateName(true);
        setTemplateNameError("");
        const response = await Checkisteplatenameavailable(templateName.toLowerCase().replace(/\s+/g, "_"));
        if (response.status === true) {
          setTemplateNameAvailability(true);
        } else {
          setTemplateNameAvailability(false);
          setTemplateNameError(response.message || "Template name is not available");
        }
      } catch (error) {
        console.error("Error checking template name:", error);
        setTemplateNameError("Error checking template name availability");
        setTemplateNameAvailability(false);
      } finally {
        setCheckingTemplateName(false);
      }
    }, 500);
    return () => clearTimeout(timeoutId);
  }, [templateName]);
  useMemo(() => {
    return [
      { label: "Select mapping...", value: "" },
      ...availableVariables.map((variable) => ({
        label: variable.label,
        value: variable.value
      }))
    ];
  }, [availableVariables]);
  const mainBodyVariables = useMemo(() => {
    if (bodyText) {
      return extractVariablesFromWhatsAppMessage(JSON.stringify({ text: bodyText }));
    }
    return [];
  }, [bodyText]);
  const handleVariableSelectionChange = useCallback((variable, value, cardId = null) => {
    var _a2;
    if (cardId) {
      const cardVars = extractVariablesFromWhatsAppMessage(JSON.stringify({ text: ((_a2 = carouselCards.find((card) => card.id === cardId)) == null ? void 0 : _a2.cardText) || "" }));
      const variableIndex = cardVars.indexOf(variable);
      setCardBodyVariableMapping((prev) => ({
        ...prev,
        [cardId]: {
          ...prev[cardId] || {},
          [variableIndex]: value
        }
      }));
    } else {
      const variableIndex = mainBodyVariables.indexOf(variable);
      setMainBodyVariableMapping((prev) => ({
        ...prev,
        [variableIndex]: value
      }));
    }
    const variableKey = cardId ? `${cardId}-${variable}` : variable;
    if (value) {
      const selectedVar = availableVariables.find((av) => av.value === value);
      setVariableInputValues((prev) => ({
        ...prev,
        [variableKey]: (selectedVar == null ? void 0 : selectedVar.label) || ""
      }));
    } else {
      setVariableInputValues((prev) => ({
        ...prev,
        [variableKey]: ""
      }));
    }
  }, [mainBodyVariables, carouselCards, availableVariables]);
  const generateCarouselTemplateJSON = useMemo(() => {
    const template = {
      sender: "",
      campaign_id: "put_campaign_id",
      messaging_product: "whatsapp",
      recipient_type: "individual",
      to: "receiver_number",
      type: "template",
      template: {
        name: templateName.toLowerCase().replace(/\s+/g, "_") || "new_carousel_template",
        language: {
          code: templateLanguage
        },
        components: []
      }
    };
    if (bodyText) {
      template.template.components.push({
        type: "BODY",
        text: bodyText,
        parameters: mainBodyVariables.map((variable, index2) => ({
          type: "text",
          text: mainBodyVariableMapping[index2] || variable
        }))
      });
    }
    if (carouselCards.length > 0 && carouselCards.some((card) => card.cardText)) {
      const carouselComponent = {
        type: "CAROUSEL",
        cards: carouselCards.filter((card) => card.cardText).map((card, index2) => ({
          card_index: index2,
          components: [
            ...card.imageUrl || card.videoUrl ? [{
              type: "HEADER",
              format: card.headerType,
              example: {
                header_handle: [card.headerType === "IMAGE" ? card.imageUrl : card.videoUrl]
              },
              parameters: [{
                type: card.headerType,
                [card.headerType.toLowerCase()]: {
                  link: card.headerType === "IMAGE" ? card.imageUrl : card.videoUrl
                }
              }]
            }] : [],
            {
              type: "BODY",
              text: card.cardText,
              parameters: extractVariablesFromWhatsAppMessage(JSON.stringify({ text: card.cardText || "" })).map((variable, vIndex) => ({
                type: "text",
                text: cardBodyVariableMapping[card.id] && cardBodyVariableMapping[card.id][vIndex] || variable
              }))
            },
            ...card.buttons && card.buttons.length > 0 && card.buttons.some((btn) => btn.text) ? [{
              type: "BUTTONS",
              buttons: card.buttons.filter((btn) => btn.text).map((btn) => ({
                type: btn.type,
                text: btn.text,
                ...btn.type === "URL" && btn.url ? { url: btn.url } : {},
                ...btn.type === "PHONE_NUMBER" && btn.phone_number ? { phone_number: btn.phone_number } : {}
              }))
            }] : []
          ]
        }))
      };
      template.template.components.push(carouselComponent);
    }
    return JSON.stringify(template);
  }, [templateName, templateLanguage, bodyText, carouselCards, mainBodyVariables, mainBodyVariableMapping, cardBodyVariableMapping]);
  useMemo(() => {
    const allText = [
      bodyText,
      ...carouselCards.map((card) => card.cardText)
    ].join(" ");
    return extractVariablesFromWhatsAppMessage(allText);
  }, [bodyText, carouselCards]);
  useCallback((variableIndex, mappingValue) => {
    setMainBodyVariableMapping((prev) => ({
      ...prev,
      [variableIndex]: mappingValue
    }));
  }, []);
  useCallback((cardId, variableIndex, mappingValue) => {
    setCardBodyVariableMapping((prev) => ({
      ...prev,
      [cardId]: {
        ...prev[cardId] || {},
        [variableIndex]: mappingValue
      }
    }));
  }, []);
  const handleCardChange = useCallback((cardId, field, value) => {
    setCarouselCards((prev) => prev.map(
      (card) => card.id === cardId ? { ...card, [field]: value } : card
    ));
  }, []);
  const validateUrlButton = useCallback((url) => {
    if (!url) return { isValid: false, error: "URL is required" };
    const variablePattern = /\{\{1\}\}/;
    if (!variablePattern.test(url)) {
      return { isValid: false, error: "URL must contain a variable in {{1}} format at the end" };
    }
    return { isValid: true, error: null };
  }, []);
  const checkUrlVariables = useCallback((url) => {
    const hasVariable = /\{\{1\}\}/.test(url);
    return hasVariable;
  }, []);
  const handleUrlVariableChange = useCallback((cardId, buttonIndex, value) => {
    const key = `${cardId}-${buttonIndex}`;
    setUrlVariables((prev) => ({
      ...prev,
      [key]: value
    }));
  }, []);
  const handleCardButtonChange = useCallback((cardId, buttonIndex, field, value) => {
    setCarouselCards((prev) => prev.map(
      (card) => card.id === cardId ? {
        ...card,
        buttons: card.buttons.map((btn, idx) => {
          if (idx === buttonIndex) {
            const updatedBtn = { ...btn, [field]: value };
            if (field === "url") {
              updatedBtn.urlError = null;
              if (!checkUrlVariables(value)) {
                const key = `${cardId}-${buttonIndex}`;
                setUrlVariables((prev2) => {
                  const newVars = { ...prev2 };
                  delete newVars[key];
                  return newVars;
                });
              }
            }
            return updatedBtn;
          }
          return btn;
        })
      } : card
    ));
  }, [checkUrlVariables]);
  const addCard = useCallback(() => {
    if (carouselCards.length < 10) {
      const newCard = {
        id: Math.max(...carouselCards.map((c) => c.id)) + 1,
        cardText: "",
        headerType: "IMAGE",
        imageUrl: "",
        videoUrl: "",
        mediaFile: null,
        mediaPreview: "",
        buttons: [{ type: "URL", text: "", url: "" }]
      };
      setCarouselCards((prev) => [...prev, newCard]);
    }
  }, [carouselCards]);
  const removeCard = useCallback((cardId) => {
    if (carouselCards.length > 1) {
      setCarouselCards((prev) => prev.filter((card) => card.id !== cardId));
    }
  }, [carouselCards.length]);
  const addButtonToCard = useCallback((cardId) => {
    setCarouselCards((prev) => prev.map(
      (card) => card.id === cardId && card.buttons.length < 1 ? { ...card, buttons: [...card.buttons, { type: "URL", text: "", url: "" }] } : card
    ));
  }, []);
  const removeButtonFromCard = useCallback((cardId, buttonIndex) => {
    setCarouselCards((prev) => prev.map(
      (card) => card.id === cardId && card.buttons.length > 0 ? { ...card, buttons: card.buttons.filter((_, idx) => idx !== buttonIndex) } : card
    ));
  }, []);
  const handleCardMediaUpload = useCallback((cardId, files) => {
    if (files.length > 0) {
      const file = files[0];
      const isVideo = file.type.startsWith("video/");
      const reader = new FileReader();
      reader.onload = (e) => {
        setCarouselCards((prev) => prev.map(
          (card) => card.id === cardId ? {
            ...card,
            mediaFile: file,
            mediaPreview: e.target.result,
            headerType: isVideo ? "VIDEO" : "IMAGE",
            imageUrl: isVideo ? "" : e.target.result,
            videoUrl: isVideo ? e.target.result : ""
          } : card
        ));
      };
      reader.readAsDataURL(file);
    }
  }, []);
  const handleRemoveCardMedia = useCallback((cardId) => {
    setCarouselCards((prev) => prev.map(
      (card) => card.id === cardId ? {
        ...card,
        mediaFile: null,
        mediaPreview: "",
        imageUrl: "",
        videoUrl: "",
        headerType: "IMAGE"
      } : card
    ));
  }, []);
  const applyFormatting = useCallback((format, cardId, field) => {
    const fieldId = cardId && field ? field === "cardText" ? `card-text-${cardId}` : `card-${field}-${cardId}` : "body-text-field";
    const textarea = document.querySelector(`#${fieldId}`);
    if (!textarea) return;
    const start = textarea.selectionStart;
    const end = textarea.selectionEnd;
    const selectedText = textarea.value.substring(start, end);
    let formattedText = "";
    let cursorOffset = 0;
    if (selectedText) {
      switch (format) {
        case "bold":
          formattedText = `*${selectedText}*`;
          cursorOffset = formattedText.length;
          break;
        case "italic":
          formattedText = `_${selectedText}_`;
          cursorOffset = formattedText.length;
          break;
        case "strikethrough":
          formattedText = `~${selectedText}~`;
          cursorOffset = formattedText.length;
          break;
        case "monospace":
          formattedText = `\`\`\`${selectedText}\`\`\``;
          cursorOffset = formattedText.length;
          break;
        case "inline-code":
          formattedText = `\`${selectedText}\``;
          cursorOffset = formattedText.length;
          break;
        case "quote":
          const needsNewLineBeforeQuote = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfterQuote = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBeforeQuote ? "\n" : "") + `> ${selectedText}` + (needsNewLineAfterQuote ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        case "bullet-list":
          const bulletLines = selectedText.split("\n").map((line) => line.trim() ? `* ${line}` : line).join("\n");
          const needsNewLineBefore = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfter = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBefore ? "\n" : "") + bulletLines + (needsNewLineAfter ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        case "numbered-list":
          const numberedLines = selectedText.split("\n").filter((line) => line.trim()).map((line, index2) => `${index2 + 1}. ${line}`).join("\n");
          const needsNewLineBeforeNum = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfterNum = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBeforeNum ? "\n" : "") + numberedLines + (needsNewLineAfterNum ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        default:
          formattedText = selectedText;
          cursorOffset = formattedText.length;
      }
    } else {
      switch (format) {
        case "bold":
          formattedText = "**";
          cursorOffset = 1;
          break;
        case "italic":
          formattedText = "__";
          cursorOffset = 1;
          break;
        case "strikethrough":
          formattedText = "~~";
          cursorOffset = 1;
          break;
        case "monospace":
          formattedText = "```\n\n```";
          cursorOffset = 4;
          break;
        case "inline-code":
          formattedText = "``";
          cursorOffset = 1;
          break;
        case "quote":
          const needsNewLineBeforeQuoteEmpty = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeQuoteEmpty ? "\n> " : "> ";
          cursorOffset = formattedText.length;
          break;
        case "bullet-list":
          const needsNewLineBeforeBullet = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeBullet ? "\n* " : "* ";
          cursorOffset = formattedText.length;
          break;
        case "numbered-list":
          const needsNewLineBeforeNumber = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeNumber ? "\n1. " : "1. ";
          cursorOffset = formattedText.length;
          break;
        default:
          formattedText = "";
          cursorOffset = 0;
      }
    }
    const newValue = textarea.value.substring(0, start) + formattedText + textarea.value.substring(end);
    if (cardId && field) {
      setCarouselCards((prev) => prev.map(
        (card) => card.id === cardId ? { ...card, [field]: newValue } : card
      ));
    } else if (field === "body") {
      setBodyText(newValue);
    }
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + cursorOffset, start + cursorOffset);
    }, 0);
  }, []);
  const insertVariable = useCallback((variable, cardId, field) => {
    const fieldId = cardId && field ? field === "cardText" ? `card-text-${cardId}` : `card-${field}-${cardId}` : "body-text-field";
    const textarea = document.querySelector(`#${fieldId}`);
    if (!textarea) return;
    const start = textarea.selectionStart;
    const variableText = `{{${variable}}}`;
    const newValue = textarea.value.substring(0, start) + variableText + textarea.value.substring(start);
    if (cardId && field) {
      setCarouselCards((prev) => prev.map(
        (card) => card.id === cardId ? { ...card, [field]: newValue } : card
      ));
    } else if (field === "body") {
      setBodyText(newValue);
    }
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + variableText.length, start + variableText.length);
    }, 0);
  }, []);
  const insertEmoji = useCallback((emoji, cardId, field) => {
    const fieldId = cardId && field ? field === "cardText" ? `card-text-${cardId}` : `card-${field}-${cardId}` : "body-text-field";
    const textarea = document.querySelector(`#${fieldId}`);
    if (!textarea) return;
    const start = textarea.selectionStart;
    const newValue = textarea.value.substring(0, start) + emoji + textarea.value.substring(start);
    if (cardId && field) {
      setCarouselCards((prev) => prev.map(
        (card) => card.id === cardId ? { ...card, [field]: newValue } : card
      ));
    } else if (field === "body") {
      setBodyText(newValue);
    }
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + emoji.length, start + emoji.length);
    }, 0);
  }, []);
  const handleTextSelection = useCallback((event) => {
    const target = event.target;
    setTextSelection({
      start: target.selectionStart,
      end: target.selectionEnd
    });
  }, []);
  const handleSave = useCallback(async () => {
    console.log("Saving carousel template:", {
      name: templateName,
      category: templateCategory,
      language: templateLanguage,
      bodyText,
      cardsCount: carouselCards.length,
      carouselCards: carouselCards.map((card) => {
        var _a2, _b;
        return {
          id: card.id,
          cardText: card.cardText,
          headerType: card.headerType,
          hasMediaFile: !!card.mediaFile,
          mediaFileName: (_a2 = card.mediaFile) == null ? void 0 : _a2.name,
          buttonsCount: ((_b = card.buttons) == null ? void 0 : _b.length) || 0
        };
      })
    });
    try {
      const normalizedTemplateName = (templateName || "").toLowerCase().replace(/\s+/g, "_");
      const normalizedCategory = (templateCategory || "").toUpperCase();
      const allBodyVars = [];
      if (bodyText) {
        const mainBodyVars = extractVariablesFromWhatsAppMessage(JSON.stringify({ text: bodyText }));
        mainBodyVars.forEach((variable, index2) => {
          const mappedValue = mainBodyVariableMapping[index2] || variable;
          if (!allBodyVars.includes(mappedValue)) {
            allBodyVars.push(mappedValue);
          }
        });
      }
      carouselCards.forEach((card) => {
        if (card.cardText) {
          const cardVars = extractVariablesFromWhatsAppMessage(JSON.stringify({ text: card.cardText }));
          cardVars.forEach((variable, index2) => {
            const mappedValue = cardBodyVariableMapping[card.id] && cardBodyVariableMapping[card.id][index2] || variable;
            if (!allBodyVars.includes(mappedValue)) {
              allBodyVars.push(mappedValue);
            }
          });
        }
      });
      const carouselFiles = carouselCards.map((card) => {
        if (card && card.mediaFile && card.mediaFile.name) {
          return card.mediaFile.name;
        }
        const link = (card == null ? void 0 : card.headerType) === "VIDEO" ? card == null ? void 0 : card.videoUrl : card == null ? void 0 : card.imageUrl;
        if (typeof link === "string" && link.length > 0) {
          try {
            const withoutQuery = link.split("?")[0];
            const fileName = withoutQuery.split("/").pop();
            return fileName || "default-image.png";
          } catch {
            return "default-image.png";
          }
        }
        return "default-image.png";
      });
      const hasUrlButtons = carouselCards.some((c) => ((c == null ? void 0 : c.buttons) || []).some((b) => (b == null ? void 0 : b.type) === "URL" && (b == null ? void 0 : b.url)));
      const hasQuickReplies = carouselCards.some((c) => ((c == null ? void 0 : c.buttons) || []).some((b) => (b == null ? void 0 : b.type) === "QUICK_REPLY" && (b == null ? void 0 : b.text)));
      const payload = {
        draftedtemplateid: 0,
        normaltemplateid: 0,
        _token: autoReplyToken,
        templatename: normalizedTemplateName || "new_carousel_template",
        language: templateLanguage,
        category: normalizedCategory || "MARKETING",
        bodyVars: allBodyVars,
        buttontype: hasUrlButtons ? "cta_url" : hasQuickReplies ? "quick_reply" : "cta_url",
        quickReplyButtonText: hasQuickReplies ? Array.from(new Set(carouselCards.flatMap((c) => ((c == null ? void 0 : c.buttons) || []).filter((b) => (b == null ? void 0 : b.type) === "QUICK_REPLY" && (b == null ? void 0 : b.text)).map((b) => b.text)))) : [],
        savedata: "save_submit",
        mainBody: bodyText || "",
        carouselFiles,
        carouselCards: carouselCards.map((card, index2) => {
          const cardBodyVars = [];
          if (card.cardText) {
            const cardVars = extractVariablesFromWhatsAppMessage(JSON.stringify({ text: card.cardText }));
            cardVars.forEach((variable, vIndex) => {
              const mappedValue = cardBodyVariableMapping[card.id] && cardBodyVariableMapping[card.id][vIndex] || variable;
              cardBodyVars.push(mappedValue);
            });
          }
          const mappedButtons = ((card == null ? void 0 : card.buttons) || []).filter((btn) => btn == null ? void 0 : btn.text).map((btn) => {
            if (btn.type === "URL") {
              return {
                type: "url",
                text: btn.text,
                url: btn.url || "",
                example: btn.url ? [btn.url] : []
              };
            }
            if (btn.type === "PHONE_NUMBER") {
              return {
                type: "phone_number",
                text: btn.text,
                phone_number: btn.phone_number || ""
              };
            }
            return {
              type: "quick_reply",
              text: btn.text
            };
          });
          return {
            body: (card == null ? void 0 : card.cardText) || "",
            bodyVars: cardBodyVars,
            buttons: {
              type: "buttons",
              buttons: mappedButtons
            },
            image: `carouselFiles[${index2}]`
          };
        })
      };
      const allUrlVars = [];
      carouselCards.forEach((card) => {
        ((card == null ? void 0 : card.buttons) || []).forEach((btn, btnIndex) => {
          if (btn.type === "URL" && btn.url) {
            const key = `${card.id}-${btnIndex}`;
            if (urlVariables[key]) {
              allUrlVars.push(urlVariables[key]);
            }
          }
        });
      });
      if (allUrlVars.length > 0) {
        payload.UrlVars = allUrlVars;
      }
      console.log("Payload structure:", {
        templatename: payload.templatename,
        language: payload.language,
        category: payload.category,
        bodyVarsCount: payload.bodyVars.length,
        carouselFilesCount: payload.carouselFiles.length,
        carouselCardsCount: payload.carouselCards.length,
        buttontype: payload.buttontype
      });
      const response = await fetch("https://app.getgabs.com/partners/template/CarouselTemplateDesignProcess", {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          "Authorization": `Bearer ${API_TOKEN}`
        },
        body: JSON.stringify(payload)
      });
      if (!response.ok) throw new Error("Failed to save template");
      const result = await response.json();
      console.log("Template saved successfully:", result);
      navigate("/app/templates");
    } catch (error) {
      console.error("Error saving template:", error);
    }
  }, [
    templateName,
    templateLanguage,
    templateCategory,
    bodyText,
    carouselCards,
    mainBodyVariableMapping,
    cardBodyVariableMapping,
    urlVariables,
    navigate
  ]);
  const handleCancel = useCallback(() => {
    navigate("/app/templates");
  }, [navigate]);
  useEffect(() => {
    const handleKeyDown = (event) => {
      if ((event.ctrlKey || event.metaKey) && (event.target.id === "body-text-field" || event.target.id.startsWith("card-"))) {
        switch (event.key.toLowerCase()) {
          case "b":
            event.preventDefault();
            if (event.target.id === "body-text-field") {
              applyFormatting("bold", null, "body");
            } else if (event.target.id.startsWith("card-text-")) {
              const cardId = parseInt(event.target.id.split("-")[2]);
              applyFormatting("bold", cardId, "cardText");
            }
            break;
          case "i":
            event.preventDefault();
            if (event.target.id === "body-text-field") {
              applyFormatting("italic", null, "body");
            } else if (event.target.id.startsWith("card-text-")) {
              const cardId = parseInt(event.target.id.split("-")[2]);
              applyFormatting("italic", cardId, "cardText");
            }
            break;
          case "s":
            event.preventDefault();
            if (event.target.id === "body-text-field") {
              applyFormatting("strikethrough", null, "body");
            } else if (event.target.id.startsWith("card-text-")) {
              const cardId = parseInt(event.target.id.split("-")[2]);
              applyFormatting("strikethrough", cardId, "cardText");
            }
            break;
          case "m":
            event.preventDefault();
            if (event.target.id === "body-text-field") {
              applyFormatting("monospace", null, "body");
            } else if (event.target.id.startsWith("card-text-")) {
              const cardId = parseInt(event.target.id.split("-")[2]);
              applyFormatting("monospace", cardId, "cardText");
            }
            break;
          case "k":
            event.preventDefault();
            if (event.target.id === "body-text-field") {
              applyFormatting("inline-code", null, "body");
            } else if (event.target.id.startsWith("card-text-")) {
              const cardId = parseInt(event.target.id.split("-")[2]);
              applyFormatting("inline-code", cardId, "cardText");
            }
            break;
          case "q":
            event.preventDefault();
            if (event.target.id === "body-text-field") {
              applyFormatting("quote", null, "body");
            } else if (event.target.id.startsWith("card-text-")) {
              const cardId = parseInt(event.target.id.split("-")[2]);
              applyFormatting("quote", cardId, "cardText");
            }
            break;
          case "l":
            event.preventDefault();
            if (event.target.id === "body-text-field") {
              applyFormatting("bullet-list", null, "body");
            } else if (event.target.id.startsWith("card-text-")) {
              const cardId = parseInt(event.target.id.split("-")[2]);
              applyFormatting("bullet-list", cardId, "cardText");
            }
            break;
          case "n":
            event.preventDefault();
            if (event.target.id === "body-text-field") {
              applyFormatting("numbered-list", null, "body");
            } else if (event.target.id.startsWith("card-text-")) {
              const cardId = parseInt(event.target.id.split("-")[2]);
              applyFormatting("numbered-list", cardId, "cardText");
            }
            break;
        }
      }
    };
    document.addEventListener("keydown", handleKeyDown);
    return () => document.removeEventListener("keydown", handleKeyDown);
  }, [applyFormatting]);
  return /* @__PURE__ */ jsxs(
    Page,
    {
      fullWidth: true,
      backAction: {
        content: "Templates",
        onAction: () => navigate("/app/templates")
      },
      title: "Create Carousel Template",
      subtitle: "Create an interactive carousel template with multiple cards",
      primaryAction: {
        content: "Save Carousel Template",
        onAction: handleSave,
        disabled: !templateName || !bodyText || carouselCards.length === 0 || !carouselCards.some((card) => card.cardText) || templateNameAvailability !== true || checkingTemplateName
      },
      secondaryActions: [
        {
          content: "Cancel",
          onAction: handleCancel
        }
      ],
      children: [
        /* @__PURE__ */ jsxs(Grid, { children: [
          /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 8, lg: 8, xl: 8 }, children: /* @__PURE__ */ jsx("div", { style: { marginRight: "20px" }, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "500", children: [
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Basic Information" }),
              /* @__PURE__ */ jsxs(FormLayout, { children: [
                /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: "Template Name",
                    value: templateName,
                    onChange: (value) => setTemplateName(value.replace(/\s+/g, "_")),
                    placeholder: "Enter carousel template name",
                    helpText: checkingTemplateName ? "Checking availability..." : templateNameAvailability === true ? "✓ Template name is available" : templateNameAvailability === false ? templateNameError : "This will be used as the template identifier",
                    error: templateNameAvailability === false ? templateNameError : void 0,
                    tone: checkingTemplateName ? void 0 : templateNameAvailability === true ? "success" : templateNameAvailability === false ? "critical" : void 0,
                    autoComplete: "off"
                  }
                ),
                /* @__PURE__ */ jsxs(InlineStack, { gap: "400", children: [
                  /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                    Select,
                    {
                      label: "Category",
                      options: categoryOptions,
                      value: templateCategory,
                      onChange: setTemplateCategory
                    }
                  ) }),
                  /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                    Select,
                    {
                      label: "Language",
                      options: languageOptions,
                      value: templateLanguage,
                      onChange: setTemplateLanguage
                    }
                  ) })
                ] })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Body Text *" }),
              /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Click to insert variables :" }),
                /* @__PURE__ */ jsxs(InlineStack, { gap: "100", wrap: true, children: [
                  availableVariables.slice(0, 15).map((variable) => /* @__PURE__ */ jsx(
                    Button,
                    {
                      size: "micro",
                      variant: "tertiary",
                      onClick: () => insertVariable(variable.value, null, "body"),
                      children: variable.label
                    },
                    variable.value
                  )),
                  availableVariables.length > 15 && /* @__PURE__ */ jsxs(
                    Button,
                    {
                      size: "micro",
                      variant: "primary",
                      onClick: () => setShowVariablesModal(true),
                      children: [
                        "More Variables (",
                        availableVariables.length - 15,
                        ")"
                      ]
                    }
                  )
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { style: { position: "relative" }, children: [
                /* @__PURE__ */ jsxs("div", { style: { position: "absolute", bottom: 12, right: 6, zIndex: 99, display: "flex", gap: "4px", flexWrap: "wrap" }, children: [
                  /* @__PURE__ */ jsx(ButtonGroup, { variant: "segmented", children: /* @__PURE__ */ jsx(EmojiPicker, { onEmojiSelect: (emoji) => insertEmoji(emoji, null, "body"), buttonSize: "micro" }) }),
                  /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Bold",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘B" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bold", null, "body"), accessibilityLabel: "Bold", children: /* @__PURE__ */ jsx(Text, { fontWeight: "bold", children: "B" }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Italic",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘I" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("italic", null, "body"), accessibilityLabel: "Italic", children: /* @__PURE__ */ jsx(Text, { as: "em", children: "I" }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Strikethrough",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘S" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("strikethrough", null, "body"), accessibilityLabel: "Strikethrough", children: /* @__PURE__ */ jsx(Text, { as: "s", children: "S" }) }) })
                  ] }),
                  /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Monospace",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘M" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("monospace", null, "body"), accessibilityLabel: "Monospace", children: /* @__PURE__ */ jsxs(Text, { as: "code", children: [
                      " ",
                      "</>"
                    ] }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Inline Code",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘K" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("inline-code", null, "body"), accessibilityLabel: "Inline Code", children: /* @__PURE__ */ jsx(Text, { as: "code", children: "<>" }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Quote",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘Q" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("quote", null, "body"), accessibilityLabel: "Quote", children: '"' }) })
                  ] }),
                  /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Bullet List",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘L" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bullet-list", null, "body"), accessibilityLabel: "Bullet List", children: "•" }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Numbered List",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘N" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("numbered-list", null, "body"), accessibilityLabel: "Numbered List", children: "1." }) })
                  ] })
                ] }),
                /* @__PURE__ */ jsx(
                  TextField,
                  {
                    id: "body-text-field",
                    label: "Message Body",
                    value: bodyText,
                    onChange: setBodyText,
                    onSelect: handleTextSelection,
                    multiline: 8,
                    maxLength: 1024,
                    placeholder: "Type your message body here... Formatting options: *bold*, _italic_, ~strikethrough~, ```monospace` ``, ` inline code`, > quote, * bullet list, 1. numbered list. Use keyboard shortcuts or click buttons above.",
                    helpText: `${bodyText.length}/1024 characters`,
                    showCharacterCount: true,
                    autoComplete: "off"
                  }
                )
              ] }),
              mainBodyVariables.length > 0 && /* @__PURE__ */ jsxs("div", { children: [
                /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "semibold", tone: "subdued", children: "Body Variable Mapping" }),
                /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", style: { marginBottom: "12px" }, children: "Map the variables in your body text to actual data fields:" }),
                /* @__PURE__ */ jsx(BlockStack, { gap: "300", children: mainBodyVariables.map((variable, index2) => /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
                  /* @__PURE__ */ jsx(
                    TextField,
                    {
                      label: `Variable: {{${variable}}}`,
                      value: `{{${variable}}}`,
                      disabled: true,
                      helpText: "Template variable"
                    }
                  ),
                  /* @__PURE__ */ jsx(
                    Autocomplete,
                    {
                      options: availableVariables.filter((av) => {
                        const searchValue = variableInputValues[variable] || "";
                        return searchValue === "" || av.label.toLowerCase().includes(searchValue.toLowerCase());
                      }).map((av) => ({
                        value: av.value,
                        label: av.label
                      })),
                      selected: mainBodyVariableMapping[index2] ? [mainBodyVariableMapping[index2]] : [],
                      onSelect: (selected) => {
                        const value = selected.length > 0 ? selected[0] : "";
                        handleVariableSelectionChange(variable, value);
                        if (value) {
                          const selectedVar = availableVariables.find((av) => av.value === value);
                          setVariableInputValues((prev) => ({
                            ...prev,
                            [variable]: (selectedVar == null ? void 0 : selectedVar.label) || ""
                          }));
                        } else {
                          setVariableInputValues((prev) => ({
                            ...prev,
                            [variable]: ""
                          }));
                        }
                      },
                      textField: /* @__PURE__ */ jsx(
                        Autocomplete.TextField,
                        {
                          label: "Map to",
                          value: variableInputValues[variable] || "",
                          onChange: (value) => {
                            setVariableInputValues((prev) => ({
                              ...prev,
                              [variable]: value
                            }));
                          },
                          placeholder: "Search and choose data field",
                          autoComplete: "off"
                        }
                      ),
                      loading: loadingVariables,
                      emptyState: loadingVariables ? "Loading variables..." : "No variables found",
                      preferredPosition: "below"
                    }
                  )
                ] }, variable)) })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsxs(BlockStack, { gap: "100", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Carousel Cards" }),
                /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Create up to 10 cards for your carousel. Each card can have an image, text content, and buttons." })
              ] }),
              /* @__PURE__ */ jsx(BlockStack, { gap: "400", children: carouselCards.map((card, cardIndex) => /* @__PURE__ */ jsx(Card, { background: "bg-surface-secondary", children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
                /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                  /* @__PURE__ */ jsxs(Text, { variant: "headingSm", as: "h3", children: [
                    "Card ",
                    cardIndex + 1
                  ] }),
                  carouselCards.length > 1 && /* @__PURE__ */ jsx(
                    Button,
                    {
                      variant: "plain",
                      tone: "critical",
                      onClick: () => removeCard(card.id),
                      size: "slim",
                      icon: DeleteIcon,
                      children: "Remove Card"
                    }
                  )
                ] }),
                /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                  /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                    /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "medium", children: "Card Header" }),
                    /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      /* @__PURE__ */ jsx(
                        Button,
                        {
                          size: "micro",
                          variant: card.headerType === "IMAGE" ? "primary" : "tertiary",
                          onClick: () => handleCardChange(card.id, "headerType", "IMAGE"),
                          children: "Image"
                        }
                      ),
                      /* @__PURE__ */ jsx(
                        Button,
                        {
                          size: "micro",
                          variant: card.headerType === "VIDEO" ? "primary" : "tertiary",
                          onClick: () => handleCardChange(card.id, "headerType", "VIDEO"),
                          children: "Video"
                        }
                      )
                    ] })
                  ] }),
                  !card.mediaFile ? /* @__PURE__ */ jsx(
                    DropZone,
                    {
                      onDrop: (files) => handleCardMediaUpload(card.id, files),
                      accept: card.headerType === "VIDEO" ? "video/*" : "image/*",
                      type: "file",
                      allowMultiple: false,
                      children: /* @__PURE__ */ jsx(
                        DropZone.FileUpload,
                        {
                          actionTitle: `Choose ${card.headerType.toLowerCase()}`,
                          actionHint: `or drag and drop your ${card.headerType.toLowerCase()} here`
                        }
                      )
                    }
                  ) : /* @__PURE__ */ jsx(BlockStack, { gap: "200", children: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", align: "space-between", children: [
                    /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      /* @__PURE__ */ jsx(
                        Thumbnail,
                        {
                          source: card.mediaPreview,
                          alt: card.mediaFile.name,
                          size: "small"
                        }
                      ),
                      /* @__PURE__ */ jsxs(BlockStack, { gap: "050", children: [
                        /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: card.mediaFile.name }),
                        /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                          card.headerType,
                          " • ",
                          (card.mediaFile.size / 1024 / 1024).toFixed(2),
                          " MB"
                        ] })
                      ] })
                    ] }),
                    /* @__PURE__ */ jsx(
                      Button,
                      {
                        variant: "plain",
                        tone: "critical",
                        onClick: () => handleRemoveCardMedia(card.id),
                        size: "slim",
                        children: "Remove"
                      }
                    )
                  ] }) })
                ] }),
                /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "medium", children: "Card Body *" }),
                  /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                    /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Click to insert variables :" }),
                    /* @__PURE__ */ jsxs(InlineStack, { gap: "100", wrap: true, children: [
                      availableVariables.slice(0, 15).map((variable) => /* @__PURE__ */ jsx(
                        Button,
                        {
                          size: "micro",
                          variant: "tertiary",
                          onClick: () => insertVariable(variable.value, card.id, "cardText"),
                          children: variable.label
                        },
                        variable.value
                      )),
                      availableVariables.length > 15 && /* @__PURE__ */ jsxs(
                        Button,
                        {
                          size: "micro",
                          variant: "primary",
                          onClick: () => setShowVariablesModal(true),
                          children: [
                            "More Variables (",
                            availableVariables.length - 15,
                            ")"
                          ]
                        }
                      )
                    ] })
                  ] }),
                  /* @__PURE__ */ jsxs("div", { style: { position: "relative" }, children: [
                    /* @__PURE__ */ jsxs("div", { style: { position: "absolute", bottom: 12, right: 6, zIndex: 99, display: "flex", gap: "4px", flexWrap: "wrap" }, children: [
                      /* @__PURE__ */ jsx(ButtonGroup, { variant: "segmented", children: /* @__PURE__ */ jsx(EmojiPicker, { onEmojiSelect: (emoji) => insertEmoji(emoji, card.id, "cardText"), buttonSize: "micro" }) }),
                      /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Bold",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘B" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bold", card.id, "cardText"), accessibilityLabel: "Bold", children: /* @__PURE__ */ jsx(Text, { fontWeight: "bold", children: "B" }) }) }),
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Italic",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘I" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("italic", card.id, "cardText"), accessibilityLabel: "Italic", children: /* @__PURE__ */ jsx(Text, { as: "em", children: "I" }) }) }),
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Strikethrough",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘S" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("strikethrough", card.id, "cardText"), accessibilityLabel: "Strikethrough", children: /* @__PURE__ */ jsx(Text, { as: "s", children: "S" }) }) })
                      ] }),
                      /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Monospace",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘M" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("monospace", card.id, "cardText"), accessibilityLabel: "Monospace", children: /* @__PURE__ */ jsxs(Text, { as: "code", children: [
                          " ",
                          "</>"
                        ] }) }) }),
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Inline Code",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘K" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("inline-code", card.id, "cardText"), accessibilityLabel: "Inline Code", children: /* @__PURE__ */ jsx(Text, { as: "code", children: "<>" }) }) }),
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Quote",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘Q" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("quote", card.id, "cardText"), accessibilityLabel: "Quote", children: '"' }) })
                      ] }),
                      /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Bullet List",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘L" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bullet-list", card.id, "cardText"), accessibilityLabel: "Bullet List", children: "•" }) }),
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Numbered List",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘N" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("numbered-list", card.id, "cardText"), accessibilityLabel: "Numbered List", children: "1." }) })
                      ] })
                    ] }),
                    /* @__PURE__ */ jsx(
                      TextField,
                      {
                        id: `card-text-${card.id}`,
                        label: "Card Body Message",
                        value: card.cardText,
                        onChange: (value) => handleCardChange(card.id, "cardText", value),
                        onSelect: handleTextSelection,
                        multiline: 6,
                        maxLength: 512,
                        placeholder: "Type your card body message here... Formatting options: *bold*, _italic_, ~strikethrough~, ```monospace` ``, ` inline code`, > quote, * bullet list, 1. numbered list. Use keyboard shortcuts or click buttons above.",
                        helpText: `${card.cardText.length}/512 characters`,
                        showCharacterCount: true,
                        autoComplete: "off"
                      }
                    )
                  ] }),
                  extractVariablesFromWhatsAppMessage(JSON.stringify({ text: card.cardText || "" })).length > 0 && /* @__PURE__ */ jsxs("div", { children: [
                    /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "semibold", tone: "subdued", children: "Card Body Variable Mapping" }),
                    /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", style: { marginBottom: "12px" }, children: "Map the variables in this card's body to actual data fields:" }),
                    /* @__PURE__ */ jsx(BlockStack, { gap: "300", children: extractVariablesFromWhatsAppMessage(JSON.stringify({ text: card.cardText || "" })).map((variable, vIndex) => /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
                      /* @__PURE__ */ jsx(
                        TextField,
                        {
                          label: `Variable: {{${variable}}}`,
                          value: `{{${variable}}}`,
                          disabled: true,
                          helpText: "Template variable"
                        }
                      ),
                      /* @__PURE__ */ jsx(
                        Autocomplete,
                        {
                          options: availableVariables.filter((av) => {
                            const searchValue = variableInputValues[`${card.id}-${variable}`] || "";
                            return searchValue === "" || av.label.toLowerCase().includes(searchValue.toLowerCase());
                          }).map((av) => ({
                            value: av.value,
                            label: av.label
                          })),
                          selected: cardBodyVariableMapping[card.id] && cardBodyVariableMapping[card.id][vIndex] ? [cardBodyVariableMapping[card.id][vIndex]] : [],
                          onSelect: (selected) => {
                            const value = selected.length > 0 ? selected[0] : "";
                            handleVariableSelectionChange(variable, value, card.id);
                            if (value) {
                              const selectedVar = availableVariables.find((av) => av.value === value);
                              setVariableInputValues((prev) => ({
                                ...prev,
                                [`${card.id}-${variable}`]: (selectedVar == null ? void 0 : selectedVar.label) || ""
                              }));
                            } else {
                              setVariableInputValues((prev) => ({
                                ...prev,
                                [`${card.id}-${variable}`]: ""
                              }));
                            }
                          },
                          textField: /* @__PURE__ */ jsx(
                            Autocomplete.TextField,
                            {
                              label: "Map to",
                              value: variableInputValues[`${card.id}-${variable}`] || "",
                              onChange: (value) => {
                                setVariableInputValues((prev) => ({
                                  ...prev,
                                  [`${card.id}-${variable}`]: value
                                }));
                              },
                              placeholder: "Search and choose data field",
                              autoComplete: "off"
                            }
                          ),
                          loading: loadingVariables,
                          emptyState: loadingVariables ? "Loading variables..." : "No variables found",
                          preferredPosition: "below"
                        }
                      )
                    ] }, vIndex)) })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", fontWeight: "medium", children: "Card Buttons" }),
                  card.buttons.map((button2, buttonIndex) => /* @__PURE__ */ jsx(Card, { background: "bg-surface-tertiary", children: /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                    /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                      /* @__PURE__ */ jsxs(Text, { variant: "bodySm", fontWeight: "semibold", children: [
                        "Button ",
                        buttonIndex + 1
                      ] }),
                      card.buttons.length > 1 && /* @__PURE__ */ jsx(
                        Button,
                        {
                          variant: "plain",
                          tone: "critical",
                          onClick: () => removeButtonFromCard(card.id, buttonIndex),
                          size: "slim",
                          children: "Remove"
                        }
                      )
                    ] }),
                    /* @__PURE__ */ jsxs(FormLayout, { children: [
                      /* @__PURE__ */ jsx(
                        Select,
                        {
                          label: "Button Type",
                          options: buttonTypeOptions,
                          value: button2.type,
                          onChange: (value) => handleCardButtonChange(card.id, buttonIndex, "type", value)
                        }
                      ),
                      /* @__PURE__ */ jsx(
                        TextField,
                        {
                          label: "Button Text",
                          value: button2.text,
                          onChange: (value) => handleCardButtonChange(card.id, buttonIndex, "text", value),
                          placeholder: "Enter button text",
                          maxLength: 20,
                          showCharacterCount: true,
                          autoComplete: "off"
                        }
                      ),
                      button2.type === "URL" && /* @__PURE__ */ jsxs(Fragment, { children: [
                        /* @__PURE__ */ jsx(
                          TextField,
                          {
                            label: "URL",
                            value: button2.url || "",
                            onChange: (value) => {
                              handleCardButtonChange(card.id, buttonIndex, "url", value);
                              const validation = validateUrlButton(value);
                              if (!validation.isValid && value) {
                                handleCardButtonChange(card.id, buttonIndex, "urlError", validation.error);
                              } else {
                                handleCardButtonChange(card.id, buttonIndex, "urlError", null);
                              }
                            },
                            placeholder: "https://example.com/{{1}}",
                            error: button2.urlError,
                            helpText: "URL must contain a variable in {{1}} format at the end",
                            autoComplete: "off"
                          }
                        ),
                        button2.url && checkUrlVariables(button2.url) && /* @__PURE__ */ jsx(
                          TextField,
                          {
                            label: "URL Variable Value",
                            value: urlVariables[`${card.id}-${buttonIndex}`] || "",
                            onChange: (value) => handleUrlVariableChange(card.id, buttonIndex, value),
                            placeholder: "Enter value for {{1}} variable",
                            helpText: "This value will replace the {{1}} variable in the URL when sending",
                            autoComplete: "off"
                          }
                        )
                      ] }),
                      button2.type === "PHONE_NUMBER" && /* @__PURE__ */ jsx(
                        TextField,
                        {
                          label: "Phone Number",
                          value: button2.phone_number || "",
                          onChange: (value) => handleCardButtonChange(card.id, buttonIndex, "phone_number", value),
                          placeholder: "+1234567890",
                          autoComplete: "off"
                        }
                      )
                    ] })
                  ] }) }, buttonIndex)),
                  /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                    /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", children: "You can add up to 1 button per card" }),
                    card.buttons.length < 1 && /* @__PURE__ */ jsx(
                      Button,
                      {
                        onClick: () => addButtonToCard(card.id),
                        variant: "secondary",
                        size: "medium",
                        icon: PlusIcon,
                        children: "Add Button"
                      }
                    )
                  ] })
                ] })
              ] }) }, card.id)) }),
              /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", children: "You can add up to 10 cards in a carousel template" }),
                /* @__PURE__ */ jsx(
                  Button,
                  {
                    onClick: addCard,
                    disabled: carouselCards.length >= 10,
                    size: "large",
                    icon: PlusIcon,
                    variant: "secondary",
                    children: "Add Card"
                  }
                )
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(InlineStack, { gap: "300", align: "end", children: [
              /* @__PURE__ */ jsx(
                Button,
                {
                  variant: "secondary",
                  onClick: handleCancel,
                  children: "Cancel"
                }
              ),
              /* @__PURE__ */ jsx(
                Button,
                {
                  variant: "primary",
                  onClick: handleSave,
                  disabled: !templateName || !bodyText || carouselCards.length === 0 || !carouselCards.some((card) => card.cardText) || templateNameAvailability !== true || checkingTemplateName,
                  children: "Save Carousel Template"
                }
              )
            ] }) })
          ] }) }) }),
          /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 4, lg: 4, xl: 4 }, children: /* @__PURE__ */ jsx("div", { style: { position: "sticky", top: "20px" }, children: /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Carousel Preview" }),
            generateCarouselTemplateJSON && (bodyText || carouselCards.some((card) => card.cardText || card.mediaFile)) ? /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", children: [
                "Template: ",
                templateName ? templateName.toLowerCase().replace(/\s+/g, "_") : "untitled_carousel_template"
              ] }),
              /* @__PURE__ */ jsx(
                WhatsAppPreview,
                {
                  template: generateCarouselTemplateJSON,
                  variant: "full",
                  maxWidth: "280px",
                  showWhatsAppHeader: false
                }
              ),
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                "Variables like ",
                `{{product_name}}`,
                " will be replaced with actual data when sent."
              ] }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "info", children: [
                "Body: ",
                bodyText ? "✓" : "✗",
                " | Cards: ",
                carouselCards.filter((card) => card.cardText).length,
                " of ",
                carouselCards.length
              ] })
            ] }) : /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
              /* @__PURE__ */ jsx(Text, { as: "p", tone: "subdued", children: "Enter template details to see the carousel preview" }),
              /* @__PURE__ */ jsx(LegacyCard, { sectioned: true, children: /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                "Your carousel preview will appear here once you add template content:",
                /* @__PURE__ */ jsx("br", {}),
                "• Body text, header, or footer",
                /* @__PURE__ */ jsx("br", {}),
                "• At least one card with text, subtitle, or media"
              ] }) })
            ] })
          ] }) }) }) })
        ] }),
        /* @__PURE__ */ jsx(
          Modal,
          {
            open: showVariablesModal,
            onClose: () => {
              setShowVariablesModal(false);
              setVariableSearchQuery("");
            },
            title: "All Available Variables",
            primaryAction: {
              content: "Close",
              onAction: () => {
                setShowVariablesModal(false);
                setVariableSearchQuery("");
              }
            },
            size: "large",
            children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", tone: "subdued", children: "Click on any variable to insert it into your template:" }),
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Search Variables",
                  value: variableSearchQuery,
                  onChange: setVariableSearchQuery,
                  placeholder: "Type to search variables...",
                  clearButton: true,
                  onClearButtonClick: () => setVariableSearchQuery(""),
                  autoComplete: "off"
                }
              ),
              /* @__PURE__ */ jsx(InlineStack, { gap: "200", wrap: true, children: availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).map((variable) => /* @__PURE__ */ jsx(
                Button,
                {
                  size: "medium",
                  variant: "tertiary",
                  onClick: () => {
                    insertVariable(variable.value, null, "body");
                    setShowVariablesModal(false);
                    setVariableSearchQuery("");
                  },
                  children: variable.label
                },
                variable.value
              )) }),
              availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).length === 0 && variableSearchQuery && /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", tone: "subdued", alignment: "center", children: [
                'No variables found matching "',
                variableSearchQuery,
                '"'
              ] }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", tone: "subdued", children: [
                "You can also create custom variables using the format: ",
                "{{variable_name}}"
              ] })
            ] }) })
          }
        )
      ]
    }
  );
}
const route16 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: CreateCarouselTemplatePage
}, Symbol.toStringTag, { value: "Module" }));
function CreateCustomTemplatePage() {
  const navigate = useNavigate();
  const [templateName, setTemplateName] = useState("");
  const [templateCategory, setTemplateCategory] = useState("marketing");
  const [templateLanguage, setTemplateLanguage] = useState("en_US");
  const [templateType, setTemplateType] = useState("text");
  const [hasHeader, setHasHeader] = useState(false);
  const [headerType, setHeaderType] = useState("text");
  const [headerContent, setHeaderContent] = useState("");
  const [headerMediaUrl, setHeaderMediaUrl] = useState("");
  const [headerDocumentFilename, setHeaderDocumentFilename] = useState("");
  const [headerFile, setHeaderFile] = useState(null);
  const [headerFilePreview, setHeaderFilePreview] = useState("");
  const [bodyText, setBodyText] = useState("");
  const [cursorPosition, setCursorPosition] = useState(0);
  const [hasFooter, setHasFooter] = useState(false);
  const [footerText, setFooterText] = useState("");
  const [hasButtons, setHasButtons] = useState(false);
  const [buttons, setButtons] = useState([{ type: "QUICK_REPLY", text: "" }]);
  const [urlVariables, setUrlVariables] = useState({});
  const [headerVariableMapping, setHeaderVariableMapping] = useState({});
  const [bodyVariableMapping, setBodyVariableMapping] = useState({});
  const [variableInputValues, setVariableInputValues] = useState({});
  const [availableVariables, setAvailableVariables] = useState([]);
  const [loadingVariables, setLoadingVariables] = useState(true);
  const [showVariablesModal, setShowVariablesModal] = useState(false);
  const [variableSearchQuery, setVariableSearchQuery] = useState("");
  const [templateNameAvailability, setTemplateNameAvailability] = useState(null);
  const [checkingTemplateName, setCheckingTemplateName] = useState(false);
  const [templateNameError, setTemplateNameError] = useState("");
  const [apiError, setApiError] = useState("");
  const [showApiError, setShowApiError] = useState(false);
  const [isCreating, setIsCreating] = useState(false);
  const categoryOptions = [
    { label: "Marketing", value: "marketing" },
    { label: "Utility", value: "utility" },
    { label: "Authentication", value: "authentication" }
  ];
  const languageOptions = [
    { label: "English (US)", value: "en_US" },
    { label: "English (UK)", value: "en_GB" },
    { label: "Spanish", value: "es" },
    { label: "French", value: "fr" },
    { label: "German", value: "de" },
    { label: "Hindi", value: "hi" }
  ];
  const headerTypeOptions = [
    { label: "Text", value: "text" },
    { label: "Image", value: "image" },
    { label: "Video", value: "video" },
    { label: "Document", value: "document" }
  ];
  const buttonTypeOptions = [
    { label: "Quick Reply", value: "QUICK_REPLY" },
    { label: "URL", value: "URL" },
    { label: "Phone Number", value: "PHONE_NUMBER" }
  ];
  const phoneCountryOptions = [
    { label: "🇺🇸 +1 (US)", value: "+1" },
    { label: "🇬🇧 +44 (UK)", value: "+44" },
    { label: "🇦🇺 +61 (AU)", value: "+61" },
    { label: "🇮🇳 +91 (IN)", value: "+91" },
    { label: "🇨🇦 +1 (CA)", value: "+1-CA" },
    { label: "🇩🇪 +49 (DE)", value: "+49" },
    { label: "🇫🇷 +33 (FR)", value: "+33" },
    { label: "🇪🇸 +34 (ES)", value: "+34" }
  ];
  useEffect(() => {
    const fetchVariables = async () => {
      try {
        setLoadingVariables(true);
        const variables = await getTemplateVariables();
        setAvailableVariables(variables);
      } catch (error) {
        console.error("Error fetching variables:", error);
        setAvailableVariables([]);
      } finally {
        setLoadingVariables(false);
      }
    };
    fetchVariables();
  }, []);
  useEffect(() => {
    if (!templateName.trim()) {
      setTemplateNameAvailability(null);
      setTemplateNameError("");
      return;
    }
    const timeoutId = setTimeout(async () => {
      try {
        setCheckingTemplateName(true);
        setTemplateNameError("");
        const response = await Checkisteplatenameavailable(templateName.toLowerCase().replace(/\s+/g, "_"));
        if (response.status === true) {
          setTemplateNameAvailability(true);
        } else {
          setTemplateNameAvailability(false);
          setTemplateNameError(response.message || "Template name is not available");
        }
      } catch (error) {
        console.error("Error checking template name:", error);
        setTemplateNameError("Error checking template name availability");
        setTemplateNameAvailability(false);
      } finally {
        setCheckingTemplateName(false);
      }
    }, 500);
    return () => clearTimeout(timeoutId);
  }, [templateName]);
  useMemo(() => {
    return [
      { label: "Select mapping...", value: "" },
      ...availableVariables.map((variable) => ({
        label: variable.label,
        value: variable.value
      }))
    ];
  }, [availableVariables]);
  useCallback((variableIndex, mappingValue) => {
    setHeaderVariableMapping((prev) => ({
      ...prev,
      [variableIndex]: mappingValue
    }));
  }, []);
  useCallback((variableIndex, mappingValue) => {
    setBodyVariableMapping((prev) => ({
      ...prev,
      [variableIndex]: mappingValue
    }));
  }, []);
  const validateHeaderText = useCallback((text2) => {
    if (headerType === "text") {
      const variables = extractVariablesFromWhatsAppMessage(JSON.stringify({ text: text2 }));
      if (variables.length > 1) {
        const firstVariable = variables[0];
        const newText = text2.replace(/\{\{[^}]+\}\}/g, (match, offset) => {
          return offset === text2.indexOf(`{{${firstVariable}}}`) ? match : "";
        });
        return newText;
      }
    }
    return text2;
  }, [headerType]);
  const handleHeaderContentChange = useCallback((value) => {
    const validatedValue = validateHeaderText(value);
    setHeaderContent(validatedValue);
    if (validatedValue !== value) {
      setHeaderVariableMapping({});
    }
  }, [validateHeaderText]);
  const headerVariables = useMemo(() => {
    if (hasHeader && headerType === "text" && headerContent) {
      const variables = extractVariablesFromWhatsAppMessage(JSON.stringify({ text: headerContent }));
      return variables.slice(0, 1);
    }
    return [];
  }, [hasHeader, headerType, headerContent]);
  const bodyVariables = useMemo(() => {
    if (bodyText) {
      return extractVariablesFromWhatsAppMessage(JSON.stringify({ text: bodyText }));
    }
    return [];
  }, [bodyText]);
  const handleVariableSelectionChange = useCallback((variable, value) => {
    const isHeaderVariable = headerVariables.includes(variable);
    const variableIndex = isHeaderVariable ? headerVariables.indexOf(variable) : bodyVariables.indexOf(variable);
    if (isHeaderVariable) {
      setHeaderVariableMapping((prev) => ({
        ...prev,
        [variableIndex]: value
      }));
    } else {
      setBodyVariableMapping((prev) => ({
        ...prev,
        [variableIndex]: value
      }));
    }
    if (value) {
      const selectedVar = availableVariables.find((av) => av.value === value);
      setVariableInputValues((prev) => ({
        ...prev,
        [variable]: (selectedVar == null ? void 0 : selectedVar.label) || ""
      }));
    } else {
      setVariableInputValues((prev) => ({
        ...prev,
        [variable]: ""
      }));
    }
  }, [headerVariables, bodyVariables, availableVariables]);
  const generateTemplateJSON = useMemo(() => {
    const template = {
      sender: "",
      campaign_id: "put_campaign_id",
      messaging_product: "whatsapp",
      recipient_type: "individual",
      to: "receiver_number",
      type: "template",
      template: {
        name: templateName.toLowerCase().replace(/\s+/g, "_") || "new_template",
        language: {
          code: templateLanguage
        },
        components: []
      }
    };
    if (hasHeader && (headerContent || headerMediaUrl)) {
      const headerComponent = {
        type: "HEADER",
        format: headerType.toUpperCase()
      };
      if (headerType === "text") {
        headerComponent.text = headerContent;
        if (headerVariables.length > 0) {
          headerComponent.parameters = headerVariables.map((variable, index2) => ({
            type: "text",
            text: headerVariableMapping[index2] || variable
          }));
        }
      } else if (headerType === "image") {
        headerComponent.format = "IMAGE";
        headerComponent.example = {
          header_handle: [headerMediaUrl]
        };
      } else if (headerType === "video") {
        headerComponent.format = "VIDEO";
        headerComponent.example = {
          header_handle: [headerMediaUrl]
        };
      } else if (headerType === "document") {
        headerComponent.format = "DOCUMENT";
        headerComponent.example = {
          header_handle: [headerMediaUrl]
        };
        if (headerDocumentFilename) {
          headerComponent.filename = headerDocumentFilename;
        }
      }
      template.template.components.push(headerComponent);
    }
    if (bodyText) {
      const bodyComponent = {
        type: "BODY",
        text: bodyText
      };
      if (bodyVariables.length > 0) {
        bodyComponent.parameters = bodyVariables.map((variable, index2) => ({
          type: "text",
          text: bodyVariableMapping[index2] || variable
        }));
      }
      template.template.components.push(bodyComponent);
    }
    if (hasFooter && footerText) {
      template.template.components.push({
        type: "FOOTER",
        text: footerText
      });
    }
    if (hasButtons && buttons.some((btn) => btn.text)) {
      const validButtons = buttons.filter((btn) => btn.text);
      if (validButtons.length > 0) {
        template.template.components.push({
          type: "BUTTONS",
          buttons: validButtons.map((btn) => ({
            type: btn.type,
            text: btn.text,
            ...btn.type === "URL" && btn.url && { url: btn.url },
            ...btn.type === "PHONE_NUMBER" && btn.phone_number && { phone_number: btn.phone_number }
          }))
        });
      }
    }
    return JSON.stringify(template);
  }, [templateName, templateLanguage, hasHeader, headerType, headerContent, headerMediaUrl, headerDocumentFilename, bodyText, hasFooter, footerText, hasButtons, buttons, headerVariables, bodyVariables, headerVariableMapping, bodyVariableMapping]);
  useMemo(() => {
    return [...headerVariables, ...bodyVariables];
  }, [headerVariables, bodyVariables]);
  const handleTextSelection = useCallback(() => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    setCursorPosition(textarea.selectionStart);
  }, []);
  const applyFormatting = useCallback((format) => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const end = textarea.selectionEnd;
    const selectedText = textarea.value.substring(start, end);
    let formattedText = "";
    let cursorOffset = 0;
    if (selectedText) {
      switch (format) {
        case "bold":
          formattedText = `*${selectedText}*`;
          cursorOffset = formattedText.length;
          break;
        case "italic":
          formattedText = `_${selectedText}_`;
          cursorOffset = formattedText.length;
          break;
        case "strikethrough":
          formattedText = `~${selectedText}~`;
          cursorOffset = formattedText.length;
          break;
        case "monospace":
          formattedText = `\`\`\`${selectedText}\`\`\``;
          cursorOffset = formattedText.length;
          break;
        case "inline-code":
          formattedText = `\`${selectedText}\``;
          cursorOffset = formattedText.length;
          break;
        case "quote":
          const needsNewLineBeforeQuote = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfterQuote = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBeforeQuote ? "\n" : "") + `> ${selectedText}` + (needsNewLineAfterQuote ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        case "bullet-list":
          const bulletLines = selectedText.split("\n").map((line) => line.trim() ? `* ${line}` : line).join("\n");
          const needsNewLineBefore = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfter = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBefore ? "\n" : "") + bulletLines + (needsNewLineAfter ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        case "numbered-list":
          const numberedLines = selectedText.split("\n").filter((line) => line.trim()).map((line, index2) => `${index2 + 1}. ${line}`).join("\n");
          const needsNewLineBeforeNum = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfterNum = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBeforeNum ? "\n" : "") + numberedLines + (needsNewLineAfterNum ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        default:
          formattedText = selectedText;
          cursorOffset = formattedText.length;
      }
    } else {
      switch (format) {
        case "bold":
          formattedText = "**";
          cursorOffset = 1;
          break;
        case "italic":
          formattedText = "__";
          cursorOffset = 1;
          break;
        case "strikethrough":
          formattedText = "~~";
          cursorOffset = 1;
          break;
        case "monospace":
          formattedText = "```\n\n```";
          cursorOffset = 4;
          break;
        case "inline-code":
          formattedText = "``";
          cursorOffset = 1;
          break;
        case "quote":
          const needsNewLineBeforeQuoteEmpty = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeQuoteEmpty ? "\n> " : "> ";
          cursorOffset = formattedText.length;
          break;
        case "bullet-list":
          const needsNewLineBeforeBullet = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeBullet ? "\n* " : "* ";
          cursorOffset = formattedText.length;
          break;
        case "numbered-list":
          const needsNewLineBeforeNumber = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeNumber ? "\n1. " : "1. ";
          cursorOffset = formattedText.length;
          break;
        default:
          formattedText = "";
          cursorOffset = 0;
      }
    }
    const newValue = textarea.value.substring(0, start) + formattedText + textarea.value.substring(end);
    setBodyText(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + cursorOffset, start + cursorOffset);
    }, 0);
  }, []);
  const insertVariable = useCallback((variable) => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const variableText = `{{${variable}}}`;
    const newValue = textarea.value.substring(0, start) + variableText + textarea.value.substring(start);
    setBodyText(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + variableText.length, start + variableText.length);
    }, 0);
  }, []);
  const insertEmoji = useCallback((emoji) => {
    const textarea = document.querySelector("#body-text-field");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const newValue = textarea.value.substring(0, start) + emoji + textarea.value.substring(start);
    setBodyText(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + emoji.length, start + emoji.length);
    }, 0);
  }, []);
  useEffect(() => {
    const handleKeyDown = (event) => {
      if ((event.ctrlKey || event.metaKey) && event.target.id === "body-text-field") {
        switch (event.key.toLowerCase()) {
          case "b":
            event.preventDefault();
            applyFormatting("bold");
            break;
          case "i":
            event.preventDefault();
            applyFormatting("italic");
            break;
          case "s":
            event.preventDefault();
            applyFormatting("strikethrough");
            break;
          case "m":
            event.preventDefault();
            applyFormatting("monospace");
            break;
          case "k":
            event.preventDefault();
            applyFormatting("inline-code");
            break;
          case "q":
            event.preventDefault();
            applyFormatting("quote");
            break;
          case "l":
            event.preventDefault();
            applyFormatting("bullet-list");
            break;
          case "n":
            event.preventDefault();
            applyFormatting("numbered-list");
            break;
        }
      }
    };
    document.addEventListener("keydown", handleKeyDown);
    return () => document.removeEventListener("keydown", handleKeyDown);
  }, [applyFormatting]);
  useEffect(() => {
    setHeaderVariableMapping((prev) => {
      const newMapping = {};
      headerVariables.forEach((variable, index2) => {
        if (prev[index2]) {
          newMapping[index2] = prev[index2];
        }
      });
      return newMapping;
    });
  }, [headerVariables]);
  useEffect(() => {
    setBodyVariableMapping((prev) => {
      const newMapping = {};
      bodyVariables.forEach((variable, index2) => {
        if (prev[index2]) {
          newMapping[index2] = prev[index2];
        }
      });
      return newMapping;
    });
  }, [bodyVariables]);
  useEffect(() => {
    const allVariables = [...headerVariables, ...bodyVariables];
    if (allVariables.length > 0) {
      const initialInputValues = {};
      allVariables.forEach((variable) => {
        if (!variableInputValues[variable]) {
          const isHeaderVariable = headerVariables.includes(variable);
          const variableIndex = isHeaderVariable ? headerVariables.indexOf(variable) : bodyVariables.indexOf(variable);
          const currentMapping = isHeaderVariable ? headerVariableMapping[variableIndex] : bodyVariableMapping[variableIndex];
          if (currentMapping) {
            const selectedVar = availableVariables.find((av) => av.value === currentMapping);
            initialInputValues[variable] = (selectedVar == null ? void 0 : selectedVar.label) || "";
          }
        }
      });
      if (Object.keys(initialInputValues).length > 0) {
        setVariableInputValues((prev) => ({ ...prev, ...initialInputValues }));
      }
    }
  }, [headerVariables, bodyVariables, headerVariableMapping, bodyVariableMapping, availableVariables, variableInputValues]);
  const validateUrlButton = useCallback((url) => {
    if (!url) return { isValid: false, error: "URL is required" };
    return { isValid: true, error: null };
  }, []);
  const checkUrlVariables = useCallback((url) => {
    const hasVariable = /\{\{1\}\}/.test(url);
    return hasVariable;
  }, []);
  const handleUrlVariableChange = useCallback((buttonIndex, value) => {
    setUrlVariables((prev) => ({
      ...prev,
      [buttonIndex]: value
    }));
  }, []);
  const handleButtonChange = useCallback((index2, field, value) => {
    setButtons((prev) => prev.map((btn, i) => {
      if (i === index2) {
        const updatedBtn = { ...btn, [field]: value };
        if (field === "url") {
          updatedBtn.urlError = null;
          if (!checkUrlVariables(value)) {
            setUrlVariables((prev2) => {
              const newVars = { ...prev2 };
              delete newVars[index2];
              return newVars;
            });
          }
        }
        return updatedBtn;
      }
      return btn;
    }));
  }, [checkUrlVariables]);
  const addButton = useCallback(() => {
    if (buttons.length < 8) {
      setButtons((prev) => [...prev, { type: "QUICK_REPLY", text: "" }]);
    }
  }, [buttons.length]);
  const removeButton = useCallback((index2) => {
    setButtons((prev) => prev.filter((_, i) => i !== index2));
  }, []);
  const handleHeaderFileUpload = useCallback((files) => {
    if (files.length > 0) {
      const file = files[0];
      setHeaderFile(file);
      const reader = new FileReader();
      reader.onload = (e) => {
        setHeaderFilePreview(e.target.result);
        setHeaderMediaUrl(e.target.result);
      };
      reader.readAsDataURL(file);
      if (headerType === "document") {
        setHeaderDocumentFilename(file.name);
      }
    }
  }, [headerType]);
  const handleRemoveHeaderFile = useCallback(() => {
    setHeaderFile(null);
    setHeaderFilePreview("");
    setHeaderMediaUrl("");
    setHeaderDocumentFilename("");
  }, []);
  const handleSave = useCallback(async () => {
    setIsCreating(true);
    try {
      const payload = {
        template_type: 0,
        draftedtemplateid: 0,
        normaltemplateid: 0,
        _token: "",
        templatename: templateName.toLowerCase().replace(/\s+/g, "_"),
        language: templateLanguage,
        category: templateCategory.toUpperCase(),
        body: bodyText,
        bodyVars: Object.values(bodyVariableMapping),
        phoneCountry: 91,
        previewfooterText: hasFooter ? footerText : ""
      };
      if (hasButtons && Array.isArray(buttons)) {
        const quickReplyButtons = buttons.filter((btn) => btn.type === "QUICK_REPLY" && btn.text);
        if (quickReplyButtons.length > 0) {
          payload.quickReplyButtonText = quickReplyButtons.map((btn) => btn.text);
        }
        const urlButtons = buttons.filter((btn) => btn.type === "URL" && btn.text && btn.url);
        if (urlButtons.length > 0) {
          payload.websiteButtonText = urlButtons.map((btn) => btn.text);
          payload.previewWebsiteUrl = urlButtons.map((btn) => btn.url);
          const urlVarsArray = urlButtons.map((btn, index2) => {
            return urlVariables[index2] || "";
          }).filter((varValue) => varValue.trim() !== "");
          if (urlVarsArray.length > 0) {
            payload.UrlVars = urlVarsArray;
          }
        }
        const phoneButtons = buttons.filter((btn) => btn.type === "PHONE_NUMBER" && btn.text && btn.phone_number);
        if (phoneButtons.length > 0) {
          const primaryPhoneButton = phoneButtons[0];
          payload.callbuttonText = primaryPhoneButton.text;
          payload.prevviewphoneNumber = String(primaryPhoneButton.phone_number).replace(/^\+/, "");
          const selectedCode = (primaryPhoneButton.phone_country_code || "").replace(/^\+/, "");
          let countryCode = selectedCode;
          if (!countryCode && primaryPhoneButton.phone_number) {
            const match = String(primaryPhoneButton.phone_number).match(/^\+?(\d{1,3})/);
            if (match && match[1]) {
              countryCode = match[1];
            }
          }
          if (countryCode) {
            const parsedCode = parseInt(countryCode, 10);
            if (!Number.isNaN(parsedCode)) {
              payload.phoneCountry = parsedCode;
            }
          }
        }
      }
      if (hasHeader) {
        payload.headerType = headerType.charAt(0).toUpperCase() + headerType.slice(1);
        if (headerType === "text") {
          payload.headerText = headerContent;
          if (Object.keys(headerVariableMapping).length > 0) {
            payload.headerVar = Object.values(headerVariableMapping)[0];
          }
        } else {
          if (headerFile) {
            const formData = new FormData();
            formData.append("headerFile", headerFile);
            Object.entries(payload).forEach(([key, value]) => {
              if (Array.isArray(value)) {
                value.forEach((item) => {
                  formData.append(`${key}[]`, item);
                });
              } else {
                formData.append(key, value);
              }
            });
            console.log("Payload:", payload);
            const response2 = await fetch(`https://app.getgabs.com/partners/template/with-custom-vars/designtemplate?token=${API_TOKEN}`, {
              method: "POST",
              body: formData,
              headers: {
                "X-Requested-With": "XMLHttpRequest"
              }
            });
            const result2 = await response2.json();
            if (result2.success === true) {
              console.log("Template saved successfully:", result2);
              navigate("/app/templates");
              return;
            }
            if (result2.status === false) {
              let errorMessage = "Failed to save template";
              if (result2[0] && result2[0].error) {
                errorMessage = result2[0].error.error_user_msg || result2[0].error.message || errorMessage;
              } else if (result2.error) {
                errorMessage = result2.error.error_user_msg || result2.error.message || errorMessage;
              } else if (result2.message) {
                errorMessage = result2.message;
              }
              setApiError(errorMessage);
              setShowApiError(true);
              return;
            }
            if (!response2.ok) throw new Error("Failed to save template");
            if (result2.status === true) {
              console.log("Template saved successfully:", result2);
              navigate("/app/templates");
              return;
            } else {
              const errorMessage = result2.message || "Template could not be saved";
              setApiError(errorMessage);
              setShowApiError(true);
              return;
            }
          }
        }
      }
      const response = await fetch(`https://app.getgabs.com/partners/template/with-custom-vars/designtemplate?token=${API_TOKEN}`, {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          "Authorization": `Bearer ${API_TOKEN}`,
          "X-Requested-With": "XMLHttpRequest"
        },
        body: JSON.stringify(payload)
      });
      const result = await response.json();
      if (result.success === true) {
        console.log("Template saved successfully:", result);
        navigate("/app/templates");
        return;
      }
      if (result.status === false) {
        let errorMessage = "Failed to save template";
        if (result[0] && result[0].error) {
          errorMessage = result[0].error.error_user_msg || result[0].error.message || errorMessage;
        } else if (result.error) {
          errorMessage = result.error.error_user_msg || result.error.message || errorMessage;
        } else if (result.message) {
          errorMessage = result.message;
        }
        setApiError(errorMessage);
        setShowApiError(true);
        return;
      }
      if (!response.ok) throw new Error("Failed to save template");
      if (result.status === true) {
        console.log("Template saved successfully:", result);
        navigate("/app/templates");
      } else {
        const errorMessage = result.message || "Template could not be saved";
        setApiError(errorMessage);
        setShowApiError(true);
      }
    } catch (error) {
      console.error("Error saving template:", error);
      setApiError("An unexpected error occurred while saving the template. Please try again.");
      setShowApiError(true);
    } finally {
      setIsCreating(false);
    }
  }, [
    templateName,
    templateLanguage,
    templateCategory,
    bodyText,
    hasFooter,
    footerText,
    hasHeader,
    headerType,
    headerContent,
    headerFile,
    headerVariableMapping,
    bodyVariableMapping,
    headerVariables,
    bodyVariables,
    urlVariables,
    generateTemplateJSON,
    navigate
  ]);
  const handleCancel = useCallback(() => {
    navigate("/app/templates");
  }, [navigate]);
  const dismissApiError = useCallback(() => {
    setShowApiError(false);
    setApiError("");
  }, []);
  return /* @__PURE__ */ jsxs(
    Page,
    {
      fullWidth: true,
      backAction: {
        content: "Templates",
        onAction: () => navigate("/app/templates")
      },
      title: "Create Custom Template",
      subtitle: "Create a new custom WhatsApp message template",
      primaryAction: {
        content: "Save Template",
        onAction: handleSave,
        disabled: !templateName || !bodyText || templateNameAvailability !== true || checkingTemplateName,
        loading: isCreating
      },
      secondaryActions: [
        {
          content: "Cancel",
          onAction: handleCancel
        }
      ],
      children: [
        showApiError && /* @__PURE__ */ jsx("div", { style: { marginBottom: "20px" }, children: /* @__PURE__ */ jsx(
          Banner,
          {
            status: "critical",
            onDismiss: dismissApiError,
            children: /* @__PURE__ */ jsx("p", { children: apiError })
          }
        ) }),
        /* @__PURE__ */ jsxs(Grid, { children: [
          /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 8, lg: 8, xl: 8 }, children: /* @__PURE__ */ jsx("div", { style: { marginRight: "20px" }, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "500", children: [
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Basic Information" }),
              /* @__PURE__ */ jsxs(FormLayout, { children: [
                /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: "Template Name",
                    value: templateName,
                    onChange: (value) => setTemplateName(value.replace(/\s+/g, "_")),
                    placeholder: "Enter template name",
                    helpText: checkingTemplateName ? "Checking availability..." : templateNameAvailability === true ? "✓ Template name is available" : templateNameAvailability === false ? templateNameError : "This will be used as the template identifier",
                    error: templateNameAvailability === false ? templateNameError : void 0,
                    tone: checkingTemplateName ? void 0 : templateNameAvailability === true ? "success" : templateNameAvailability === false ? "critical" : void 0,
                    autoComplete: "off"
                  }
                ),
                /* @__PURE__ */ jsxs(InlineStack, { gap: "400", children: [
                  /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                    Select,
                    {
                      label: "Category",
                      options: categoryOptions,
                      value: templateCategory,
                      onChange: setTemplateCategory
                    }
                  ) }),
                  /* @__PURE__ */ jsx("div", { style: { flex: 1 }, children: /* @__PURE__ */ jsx(
                    Select,
                    {
                      label: "Language",
                      options: languageOptions,
                      value: templateLanguage,
                      onChange: setTemplateLanguage
                    }
                  ) })
                ] })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Header" }),
                /* @__PURE__ */ jsx(
                  Button,
                  {
                    variant: hasHeader ? "primary" : "plain",
                    onClick: () => setHasHeader(!hasHeader),
                    size: "slim",
                    children: hasHeader ? "Remove Header" : "Add Header"
                  }
                )
              ] }),
              hasHeader && /* @__PURE__ */ jsxs(FormLayout, { children: [
                /* @__PURE__ */ jsx(
                  Select,
                  {
                    label: "Header Type",
                    options: headerTypeOptions,
                    value: headerType,
                    onChange: setHeaderType
                  }
                ),
                headerType === "text" && /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: "Header Text",
                    value: headerContent,
                    onChange: handleHeaderContentChange,
                    placeholder: "Enter header text (max 1 variable allowed)",
                    maxLength: 60,
                    showCharacterCount: true,
                    helpText: "Header text can contain maximum 1 variable. Use {{variable_name}} format.",
                    autoComplete: "off"
                  }
                ),
                (headerType === "image" || headerType === "video" || headerType === "document") && /* @__PURE__ */ jsxs("div", { children: [
                  /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", fontWeight: "medium", children: [
                    "Choose ",
                    headerType.charAt(0).toUpperCase() + headerType.slice(1)
                  ] }),
                  /* @__PURE__ */ jsx("div", { style: { marginTop: "8px" }, children: !headerFile ? /* @__PURE__ */ jsx(
                    DropZone,
                    {
                      onDrop: handleHeaderFileUpload,
                      accept: headerType === "image" ? "image/*" : headerType === "video" ? "video/*" : "*/*",
                      type: "file",
                      allowMultiple: false,
                      children: /* @__PURE__ */ jsx(DropZone.FileUpload, { actionTitle: `Choose ${headerType}`, actionHint: `or drag and drop your ${headerType} here` })
                    }
                  ) : /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                    /* @__PURE__ */ jsxs(InlineStack, { gap: "200", align: "space-between", children: [
                      /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                        /* @__PURE__ */ jsx(
                          Thumbnail,
                          {
                            source: headerFilePreview || (headerType === "document" ? "📄" : "📁"),
                            alt: headerFile.name,
                            size: "small"
                          }
                        ),
                        /* @__PURE__ */ jsxs(BlockStack, { gap: "050", children: [
                          /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: headerFile.name }),
                          /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                            (headerFile.size / 1024 / 1024).toFixed(2),
                            " MB"
                          ] })
                        ] })
                      ] }),
                      /* @__PURE__ */ jsx(
                        Button,
                        {
                          variant: "plain",
                          tone: "critical",
                          onClick: handleRemoveHeaderFile,
                          size: "slim",
                          children: "Remove"
                        }
                      )
                    ] }),
                    /* @__PURE__ */ jsxs(
                      Button,
                      {
                        variant: "plain",
                        onClick: () => {
                          handleRemoveHeaderFile();
                        },
                        size: "slim",
                        children: [
                          "Choose Different ",
                          headerType.charAt(0).toUpperCase() + headerType.slice(1)
                        ]
                      }
                    )
                  ] }) })
                ] }),
                headerType === "document" && /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: "Document Filename",
                    value: headerDocumentFilename,
                    onChange: setHeaderDocumentFilename,
                    placeholder: "Enter document filename",
                    autoComplete: "off"
                  }
                ),
                headerType === "text" && headerVariables.length > 0 && /* @__PURE__ */ jsxs("div", { children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "semibold", tone: "subdued", children: "Header Variable Mapping" }),
                  /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", style: { marginBottom: "12px" }, children: "Map the variables in your header text to actual data fields:" }),
                  /* @__PURE__ */ jsx(BlockStack, { gap: "300", children: headerVariables.map((variable, index2) => /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
                    /* @__PURE__ */ jsx(
                      TextField,
                      {
                        label: `Variable: {{${variable}}}`,
                        value: `{{${variable}}}`,
                        disabled: true,
                        helpText: "Template variable"
                      }
                    ),
                    /* @__PURE__ */ jsx(
                      Autocomplete,
                      {
                        options: availableVariables.filter((av) => {
                          const searchValue = variableInputValues[variable] || "";
                          return searchValue === "" || av.label.toLowerCase().includes(searchValue.toLowerCase());
                        }).map((av) => ({
                          value: av.value,
                          label: av.label
                        })),
                        selected: headerVariableMapping[index2] ? [headerVariableMapping[index2]] : [],
                        onSelect: (selected) => {
                          const value = selected.length > 0 ? selected[0] : "";
                          handleVariableSelectionChange(variable, value);
                          if (value) {
                            const selectedVar = availableVariables.find((av) => av.value === value);
                            setVariableInputValues((prev) => ({
                              ...prev,
                              [variable]: (selectedVar == null ? void 0 : selectedVar.label) || ""
                            }));
                          } else {
                            setVariableInputValues((prev) => ({
                              ...prev,
                              [variable]: ""
                            }));
                          }
                        },
                        textField: /* @__PURE__ */ jsx(
                          Autocomplete.TextField,
                          {
                            label: "Map to",
                            value: variableInputValues[variable] || "",
                            onChange: (value) => {
                              setVariableInputValues((prev) => ({
                                ...prev,
                                [variable]: value
                              }));
                            },
                            placeholder: "Search and choose data field",
                            autoComplete: "off"
                          }
                        ),
                        loading: loadingVariables,
                        emptyState: loadingVariables ? "Loading variables..." : "No variables found",
                        preferredPosition: "below"
                      }
                    )
                  ] }, variable)) })
                ] })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Body Text *" }),
              /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Click to insert variables :" }),
                /* @__PURE__ */ jsxs(InlineStack, { gap: "100", wrap: true, children: [
                  availableVariables.slice(0, 15).map((variable) => /* @__PURE__ */ jsx(
                    Button,
                    {
                      size: "micro",
                      variant: "tertiary",
                      onClick: () => insertVariable(variable.value),
                      children: variable.label
                    },
                    variable.value
                  )),
                  availableVariables.length > 15 && /* @__PURE__ */ jsxs(
                    Button,
                    {
                      size: "micro",
                      variant: "primary",
                      onClick: () => setShowVariablesModal(true),
                      children: [
                        "More Variables (",
                        availableVariables.length - 15,
                        ")"
                      ]
                    }
                  )
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { style: { position: "relative" }, children: [
                /* @__PURE__ */ jsxs("div", { style: { position: "absolute", bottom: 12, right: 6, zIndex: 99, display: "flex", gap: "4px", flexWrap: "wrap" }, children: [
                  /* @__PURE__ */ jsx(ButtonGroup, { variant: "segmented", children: /* @__PURE__ */ jsx(EmojiPicker, { onEmojiSelect: insertEmoji, buttonSize: "micro" }) }),
                  /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Bold",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘B" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bold"), accessibilityLabel: "Bold", children: /* @__PURE__ */ jsx(Text, { fontWeight: "bold", children: "B" }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Italic",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘I" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("italic"), accessibilityLabel: "Italic", children: /* @__PURE__ */ jsx(Text, { as: "em", children: "I" }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Strikethrough",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘S" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("strikethrough"), accessibilityLabel: "Strikethrough", children: /* @__PURE__ */ jsx(Text, { as: "s", children: "S" }) }) })
                  ] }),
                  /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Monospace",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘M" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("monospace"), accessibilityLabel: "Monospace", children: /* @__PURE__ */ jsxs(Text, { as: "code", children: [
                      " ",
                      "</>"
                    ] }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Inline Code",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘K" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("inline-code"), accessibilityLabel: "Inline Code", children: /* @__PURE__ */ jsx(Text, { as: "code", children: "<>" }) }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Quote",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘Q" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("quote"), accessibilityLabel: "Quote", children: '"' }) })
                  ] }),
                  /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Bullet List",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘L" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bullet-list"), accessibilityLabel: "Bullet List", children: "•" }) }),
                    /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                      "Numbered List",
                      /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘N" })
                    ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("numbered-list"), accessibilityLabel: "Numbered List", children: "1." }) })
                  ] })
                ] }),
                /* @__PURE__ */ jsx(
                  TextField,
                  {
                    id: "body-text-field",
                    label: "Message Body",
                    value: bodyText,
                    onChange: setBodyText,
                    onSelect: handleTextSelection,
                    multiline: 8,
                    maxLength: 1024,
                    placeholder: "Type your message body here... Formatting options: *bold*, _italic_, ~strikethrough~, ```monospace```, `inline code`, > quote, * bullet list, 1. numbered list. Use keyboard shortcuts or click buttons above.",
                    helpText: `${bodyText.length}/1024 characters`,
                    showCharacterCount: true,
                    autoComplete: "off"
                  }
                )
              ] }),
              bodyVariables.length > 0 && /* @__PURE__ */ jsxs("div", { children: [
                /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "semibold", tone: "subdued", children: "Body Variable Mapping" }),
                /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", style: { marginBottom: "12px" }, children: "Map the variables in your body text to actual data fields:" }),
                /* @__PURE__ */ jsx(BlockStack, { gap: "300", children: bodyVariables.map((variable, index2) => /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
                  /* @__PURE__ */ jsx(
                    TextField,
                    {
                      label: `Variable: {{${variable}}}`,
                      value: `{{${variable}}}`,
                      disabled: true,
                      helpText: "Template variable"
                    }
                  ),
                  /* @__PURE__ */ jsx(
                    Autocomplete,
                    {
                      options: availableVariables.filter((av) => {
                        const searchValue = variableInputValues[variable] || "";
                        return searchValue === "" || av.label.toLowerCase().includes(searchValue.toLowerCase());
                      }).map((av) => ({
                        value: av.value,
                        label: av.label
                      })),
                      selected: bodyVariableMapping[index2] ? [bodyVariableMapping[index2]] : [],
                      onSelect: (selected) => {
                        const value = selected.length > 0 ? selected[0] : "";
                        handleVariableSelectionChange(variable, value);
                        if (value) {
                          const selectedVar = availableVariables.find((av) => av.value === value);
                          setVariableInputValues((prev) => ({
                            ...prev,
                            [variable]: (selectedVar == null ? void 0 : selectedVar.label) || ""
                          }));
                        } else {
                          setVariableInputValues((prev) => ({
                            ...prev,
                            [variable]: ""
                          }));
                        }
                      },
                      textField: /* @__PURE__ */ jsx(
                        Autocomplete.TextField,
                        {
                          label: "Map to",
                          value: variableInputValues[variable] || "",
                          onChange: (value) => {
                            setVariableInputValues((prev) => ({
                              ...prev,
                              [variable]: value
                            }));
                          },
                          placeholder: "Search and choose data field",
                          autoComplete: "off"
                        }
                      ),
                      loading: loadingVariables,
                      emptyState: loadingVariables ? "Loading variables..." : "No variables found",
                      preferredPosition: "below"
                    }
                  )
                ] }, variable)) })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Footer" }),
                /* @__PURE__ */ jsx(
                  Button,
                  {
                    variant: hasFooter ? "primary" : "plain",
                    onClick: () => setHasFooter(!hasFooter),
                    size: "slim",
                    children: hasFooter ? "Remove Footer" : "Add Footer"
                  }
                )
              ] }),
              hasFooter && /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Footer Text",
                  value: footerText,
                  onChange: setFooterText,
                  placeholder: "Enter footer text",
                  maxLength: 60,
                  showCharacterCount: true,
                  helpText: "Footer text appears at the bottom of the message",
                  autoComplete: "off"
                }
              )
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Buttons" }),
                /* @__PURE__ */ jsx(
                  Button,
                  {
                    variant: hasButtons ? "primary" : "plain",
                    onClick: () => setHasButtons(!hasButtons),
                    size: "slim",
                    children: hasButtons ? "Remove Buttons" : "Add Buttons"
                  }
                )
              ] }),
              hasButtons && /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                buttons.map((button2, index2) => /* @__PURE__ */ jsx(Card, { background: "bg-surface-secondary", children: /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                  /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                    /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", fontWeight: "semibold", children: [
                      "Button ",
                      index2 + 1
                    ] }),
                    buttons.length > 1 && /* @__PURE__ */ jsx(
                      Button,
                      {
                        variant: "plain",
                        tone: "critical",
                        onClick: () => removeButton(index2),
                        size: "slim",
                        children: "Remove"
                      }
                    )
                  ] }),
                  /* @__PURE__ */ jsxs(FormLayout, { children: [
                    /* @__PURE__ */ jsx(
                      Select,
                      {
                        label: "Button Type",
                        options: buttonTypeOptions,
                        value: button2.type,
                        onChange: (value) => handleButtonChange(index2, "type", value)
                      }
                    ),
                    /* @__PURE__ */ jsx(
                      TextField,
                      {
                        label: "Button Text",
                        value: button2.text,
                        onChange: (value) => handleButtonChange(index2, "text", value),
                        placeholder: "Enter button text",
                        maxLength: 20,
                        showCharacterCount: true,
                        autoComplete: "off"
                      }
                    ),
                    button2.type === "URL" && /* @__PURE__ */ jsxs(Fragment, { children: [
                      /* @__PURE__ */ jsx(
                        TextField,
                        {
                          label: "URL",
                          value: button2.url || "",
                          onChange: (value) => {
                            handleButtonChange(index2, "url", value);
                            const validation = validateUrlButton(value);
                            if (!validation.isValid && value) {
                              handleButtonChange(index2, "urlError", validation.error);
                            } else {
                              handleButtonChange(index2, "urlError", null);
                            }
                          },
                          placeholder: "https://example.com/{{1}}",
                          error: button2.urlError,
                          helpText: "URL can contain a variable in {{1}} format at the end (optional for custom templates)",
                          autoComplete: "off"
                        }
                      ),
                      button2.url && checkUrlVariables(button2.url) && /* @__PURE__ */ jsx(
                        TextField,
                        {
                          label: "URL Variable Value",
                          value: urlVariables[index2] || "",
                          onChange: (value) => handleUrlVariableChange(index2, value),
                          placeholder: "Enter value for {{1}} variable",
                          helpText: "This value will replace the {{1}} variable in the URL when sending",
                          autoComplete: "off"
                        }
                      )
                    ] }),
                    button2.type === "PHONE_NUMBER" && /* @__PURE__ */ jsxs(Fragment, { children: [
                      /* @__PURE__ */ jsx(
                        Select,
                        {
                          label: "Country Code",
                          options: phoneCountryOptions,
                          value: button2.phone_country_code || "+91",
                          onChange: (value) => handleButtonChange(index2, "phone_country_code", value.startsWith("+1-") ? "+1" : value)
                        }
                      ),
                      /* @__PURE__ */ jsx(
                        TextField,
                        {
                          label: "Phone Number",
                          value: button2.phone_number || "",
                          onChange: (value) => handleButtonChange(index2, "phone_number", value),
                          placeholder: "Enter phone number",
                          autoComplete: "off"
                        }
                      )
                    ] })
                  ] })
                ] }) }, index2)),
                buttons.length < 8 && /* @__PURE__ */ jsx(Button, { onClick: addButton, variant: "plain", children: "Add Another Button" }),
                /* @__PURE__ */ jsxs(Text, { variant: "bodySm", tone: "subdued", children: [
                  "You can add up to 8 buttons per template. URL variables in ",
                  "{{1}}",
                  " format are optional for custom templates."
                ] })
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(InlineStack, { gap: "300", align: "end", children: [
              /* @__PURE__ */ jsx(
                Button,
                {
                  variant: "secondary",
                  onClick: handleCancel,
                  children: "Cancel"
                }
              ),
              /* @__PURE__ */ jsx(
                Button,
                {
                  variant: "primary",
                  onClick: handleSave,
                  disabled: !templateName || !bodyText || templateNameAvailability !== true || checkingTemplateName,
                  loading: isCreating,
                  children: "Save Template"
                }
              )
            ] }) })
          ] }) }) }),
          /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 4, lg: 4, xl: 4 }, children: /* @__PURE__ */ jsx("div", { style: { position: "sticky", top: "20px" }, children: /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Template Preview" }),
            generateTemplateJSON && (bodyText || hasHeader && (headerContent || headerMediaUrl) || hasFooter && footerText || hasButtons && buttons.some((btn) => btn.text)) ? /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", children: [
                "Template: ",
                templateName ? templateName.toLowerCase().replace(/\s+/g, "_") : "untitled_template"
              ] }),
              /* @__PURE__ */ jsx(
                WhatsAppPreview,
                {
                  template: generateTemplateJSON,
                  variant: "full",
                  maxWidth: "280px",
                  showWhatsAppHeader: false
                }
              ),
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                "Variables like ",
                `{{customer_name}}`,
                " or ",
                `{{1}}`,
                " will be replaced with actual data when sent."
              ] })
            ] }) : /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
              /* @__PURE__ */ jsx(Text, { as: "p", tone: "subdued", children: "Enter template details to see the preview" }),
              /* @__PURE__ */ jsx(LegacyCard, { sectioned: true, children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Your template preview will appear here once you add template content (header, body text, footer, or buttons)." }) })
            ] })
          ] }) }) }) })
        ] }),
        /* @__PURE__ */ jsx(
          Modal,
          {
            open: showVariablesModal,
            onClose: () => {
              setShowVariablesModal(false);
              setVariableSearchQuery("");
            },
            title: "All Available Variables",
            primaryAction: {
              content: "Close",
              onAction: () => {
                setShowVariablesModal(false);
                setVariableSearchQuery("");
              }
            },
            size: "large",
            children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", tone: "subdued", children: "Click on any variable to insert it into your template:" }),
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Search Variables",
                  value: variableSearchQuery,
                  onChange: setVariableSearchQuery,
                  placeholder: "Type to search variables...",
                  clearButton: true,
                  onClearButtonClick: () => setVariableSearchQuery(""),
                  autoComplete: "off"
                }
              ),
              /* @__PURE__ */ jsx(InlineStack, { gap: "200", wrap: true, children: availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).map((variable) => /* @__PURE__ */ jsx(
                Button,
                {
                  size: "medium",
                  variant: "tertiary",
                  onClick: () => {
                    insertVariable(variable.value);
                    setShowVariablesModal(false);
                    setVariableSearchQuery("");
                  },
                  children: variable.label
                },
                variable.value
              )) }),
              availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).length === 0 && variableSearchQuery && /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", tone: "subdued", alignment: "center", children: [
                'No variables found matching "',
                variableSearchQuery,
                '"'
              ] }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", tone: "subdued", children: [
                "You can also create custom variables using the format: ",
                "{{variable_name}}"
              ] })
            ] }) })
          }
        )
      ]
    }
  );
}
const route17 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: CreateCustomTemplatePage
}, Symbol.toStringTag, { value: "Module" }));
function CreateTemplateIndex() {
  const navigate = useNavigate();
  useEffect(() => {
    navigate("/app/create-template/custom", { replace: true });
  }, [navigate]);
  return null;
}
const route18 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: CreateTemplateIndex
}, Symbol.toStringTag, { value: "Module" }));
function AutoTriggersLayout() {
  return /* @__PURE__ */ jsx(Outlet, {});
}
const route19 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: AutoTriggersLayout
}, Symbol.toStringTag, { value: "Module" }));
const fetchProductList = async (options = {}) => {
  const {
    page = 1,
    perPageData = 20
  } = options;
  try {
    const url = new URL(buildApiUrl(`${ENDPOINTS.PRODUCT.BASE}/${ENDPOINTS.PRODUCT.GET_PRODUCT_LIST}`));
    url.searchParams.append("page", page.toString());
    url.searchParams.append("perPageData", perPageData.toString());
    url.searchParams.append("token", API_TOKEN);
    const response = await fetch(url.toString(), {
      method: "GET",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json"
      }
    });
    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }
    const data = await response.json();
    return data;
  } catch (error) {
    console.error("Error fetching product list:", error);
    throw error;
  }
};
const fetchallCategoryList = async (options = {}) => {
  const {
    page = 1,
    perPageData = 200
  } = options;
  try {
    const url = new URL(buildApiUrl(`${ENDPOINTS.CATEGORY.BASE}/${ENDPOINTS.CATEGORY.GET_CATEGORY_LIST}`));
    url.searchParams.append("page", page.toString());
    url.searchParams.append("perPageData", perPageData.toString());
    url.searchParams.append("token", API_TOKEN);
    const response = await fetch(url.toString(), {
      method: "GET",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json"
      }
    });
    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }
    const data = await response.json();
    return data;
  } catch (error) {
    console.error("Error fetching category list:", error);
    throw error;
  }
};
function CreateOrderConfirmationTriggerPage() {
  var _a2, _b;
  const navigate = useNavigate();
  const [triggerName, setTriggerName] = useState("");
  const [selectedTemplate, setSelectedTemplate] = useState("");
  const [selectedTemplateId, setSelectedTemplateId] = useState("");
  const [templateInputValue, setTemplateInputValue] = useState("");
  const [messageTemplate, setMessageTemplate] = useState("");
  const [delayTime, setDelayTime] = useState("5");
  const [delayUnit, setDelayUnit] = useState("minutes");
  const [isActive, setIsActive] = useState(true);
  const [variableSelections, setVariableSelections] = useState({});
  const [filterByCollection, setFilterByCollection] = useState(false);
  const [selectedCollections, setSelectedCollections] = useState([]);
  const [collectionInputValue, setCollectionInputValue] = useState("");
  const [apiCollections, setApiCollections] = useState([]);
  const [loadingCollections, setLoadingCollections] = useState(false);
  const [collectionsError, setCollectionsError] = useState(null);
  const [apiTemplates, setApiTemplates] = useState([]);
  const [loadingTemplates, setLoadingTemplates] = useState(false);
  const [templateError, setTemplateError] = useState(null);
  const [selectedTemplateData, setSelectedTemplateData] = useState(null);
  const [loadingTemplateDetails, setLoadingTemplateDetails] = useState(false);
  const [mediaMapping, setMediaMapping] = useState({});
  const [uploadingMedia, setUploadingMedia] = useState({});
  const [urlButtonVariables, setUrlButtonVariables] = useState({});
  const [creatingTrigger, setCreatingTrigger] = useState(false);
  const [triggerError, setTriggerError] = useState(null);
  const availableVariables = [
    { label: "order_confirmation_id", value: "order_confirmation_id" },
    { label: "order_confirmation_date", value: "order_confirmation_date" },
    { label: "order_confirmation_total_price", value: "order_confirmation_total_price" },
    { label: "order_confirmation_currency", value: "order_confirmation_currency" },
    { label: "order_confirmation_payment_status", value: "order_confirmation_payment_status" },
    { label: "order_confirmation_fulfillment_status", value: "order_confirmation_fulfillment_status" },
    { label: "order_confirmation_status", value: "order_confirmation_status" },
    { label: "order_confirmation_number", value: "order_confirmation_number" },
    { label: "order_confirmation_customer_id", value: "order_confirmation_customer_id" },
    { label: "order_confirmation_first_name", value: "order_confirmation_first_name" },
    { label: "order_confirmation_last_name", value: "order_confirmation_last_name" },
    { label: "order_confirmation_email", value: "order_confirmation_email" },
    { label: "order_confirmation_phone", value: "order_confirmation_phone" },
    { label: "order_confirmation_default_address", value: "order_confirmation_default_address" },
    { label: "order_confirmation_billing_address", value: "order_confirmation_billing_address" },
    { label: "order_confirmation_shipping_method", value: "order_confirmation_shipping_method" },
    { label: "order_confirmation_shipping_price", value: "order_confirmation_shipping_price" },
    { label: "order_confirmation_tracking_number", value: "order_confirmation_tracking_number" },
    { label: "order_confirmation_tracking_url", value: "order_confirmation_tracking_url" },
    { label: "order_confirmation_item_id", value: "order_confirmation_item_id" },
    { label: "order_confirmation_item_title", value: "order_confirmation_item_title" },
    { label: "order_confirmation_item_quantity", value: "order_confirmation_item_quantity" },
    { label: "order_confirmation_item_price", value: "order_confirmation_item_price" },
    { label: "order_confirmation_item_variant_title", value: "order_confirmation_item_variant_title" },
    { label: "order_confirmation_item_variant_image", value: "order_confirmation_item_variant_image" },
    { label: "order_confirmation_subtotal", value: "order_confirmation_subtotal" },
    { label: "order_confirmation_total_discounts", value: "order_confirmation_total_discounts" },
    { label: "order_confirmation_total_tax", value: "order_confirmation_total_tax" }
  ];
  const fetchApiTemplates2 = useCallback(async () => {
    try {
      setLoadingTemplates(true);
      setTemplateError(null);
      const response = await getAllTemplateListForOrderConfirmation();
      if (response.status && response.data && response.data.customtemplates) {
        const transformedTemplates = response.data.customtemplates.map((template) => ({
          id: template.template_id ? template.template_id.toString() : "unknown",
          name: template.template_name || "Unknown Template",
          templateId: template.template_id,
          userId: template.user_id,
          label: template.template_name || "Unknown Template",
          value: template.template_id ? template.template_id.toString() : "unknown"
        }));
        setApiTemplates(transformedTemplates);
      } else {
        console.error("Invalid API response format:", response);
        setApiTemplates([]);
      }
    } catch (error) {
      console.error("Error fetching templates:", error);
      setTemplateError(`Failed to load templates: ${error.message}`);
      setApiTemplates([]);
    } finally {
      setLoadingTemplates(false);
    }
  }, []);
  useEffect(() => {
    fetchApiTemplates2();
  }, [fetchApiTemplates2]);
  const fetchApiCollections = useCallback(async () => {
    try {
      setLoadingCollections(true);
      setCollectionsError(null);
      const response = await fetchallCategoryList({ perPageData: 200 });
      if (response.status && response.data && response.data.data) {
        const transformedCollections = response.data.data.filter((category) => category.status === 1).map((category) => ({
          id: category.id,
          label: category.category_name,
          value: category.id.toString()
          // Use ID as value for selection
        }));
        setApiCollections(transformedCollections);
      } else {
        console.error("Invalid collections API response format:", response);
        setCollectionsError("Invalid API response format");
        setApiCollections([]);
      }
    } catch (error) {
      console.error("Error fetching collections:", error);
      setCollectionsError(`Failed to load collections: ${error.message}`);
      setApiCollections([]);
    } finally {
      setLoadingCollections(false);
    }
  }, []);
  useEffect(() => {
    fetchApiCollections();
  }, [fetchApiCollections]);
  useEffect(() => {
    if (filterByCollection && apiCollections.length === 0 && !loadingCollections) {
      fetchApiCollections();
    }
  }, [filterByCollection, apiCollections.length, loadingCollections, fetchApiCollections]);
  const allTemplateOptions = useMemo(() => {
    console.log("Template options:", {
      api: apiTemplates.length,
      total: apiTemplates.length,
      apiTemplates
    });
    return apiTemplates;
  }, [apiTemplates]);
  const filteredTemplateOptions = useMemo(() => {
    if (!templateInputValue.trim()) return allTemplateOptions;
    const searchLower = templateInputValue.toLowerCase();
    return allTemplateOptions.filter(
      (template) => {
        var _a3, _b2;
        return ((_a3 = template.label) == null ? void 0 : _a3.toLowerCase().includes(searchLower)) || ((_b2 = template.name) == null ? void 0 : _b2.toLowerCase().includes(searchLower));
      }
    );
  }, [allTemplateOptions, templateInputValue]);
  const handleTriggerNameChange = useCallback((value) => setTriggerName(value), []);
  const handleTemplateChange = useCallback(async (value) => {
    setSelectedTemplateId(value);
    const selectedTemplate2 = allTemplateOptions.find((t) => t.id === value || t.value === value);
    if (selectedTemplate2) {
      setTemplateInputValue(selectedTemplate2.label);
      setSelectedTemplate(selectedTemplate2.value);
      try {
        setLoadingTemplateDetails(true);
        setTemplateError(null);
        const response = await getSelectedTemplatebyName(selectedTemplate2.name);
        if (response.data && response.data.length > 0) {
          const templateData = response.data[0];
          setSelectedTemplateData(templateData);
          let templateContent = "";
          if (templateData.components) {
            templateData.components.forEach((component) => {
              if (component.type === "HEADER" && component.text) {
                templateContent += component.text + "\n\n";
              } else if (component.type === "BODY" && component.text) {
                templateContent += component.text + "\n\n";
              } else if (component.type === "FOOTER" && component.text) {
                templateContent += component.text;
              }
            });
          }
          setMessageTemplate(templateContent.trim());
        } else {
          console.error("No template data found");
          setTemplateError("Template not found or invalid");
          setSelectedTemplateData(null);
        }
      } catch (error) {
        console.error("Error fetching template details:", error);
        setTemplateError(`Failed to load template: ${error.message}`);
        setSelectedTemplateData(null);
      } finally {
        setLoadingTemplateDetails(false);
      }
    } else {
      setTemplateInputValue("");
      setSelectedTemplate("");
      setMessageTemplate("");
      setSelectedTemplateData(null);
    }
    setVariableSelections({});
    setMediaMapping({});
    setUrlButtonVariables({});
  }, [allTemplateOptions]);
  useCallback((value) => setMessageTemplate(value), []);
  const handleDelayTimeChange = useCallback((value) => setDelayTime(value), []);
  const handleDelayUnitChange = useCallback((value) => setDelayUnit(value), []);
  useCallback((value) => setIsActive(value), []);
  const handleVariableSelectionChange = useCallback((variable, value) => {
    setVariableSelections((prev) => ({
      ...prev,
      [variable]: value
    }));
  }, []);
  const handleUrlButtonVariableChange = useCallback((buttonIndex, value) => {
    setUrlButtonVariables((prev) => ({
      ...prev,
      [buttonIndex]: value
    }));
  }, []);
  const handleFilterByCollectionChange = useCallback((value) => {
    setFilterByCollection(value);
    if (!value) {
      setSelectedCollections([]);
      setCollectionInputValue("");
    }
  }, []);
  useCallback((value) => {
    setSelectedCollections(value);
  }, []);
  const handleCollectionInputChange = useCallback((value) => {
    setCollectionInputValue(value);
  }, []);
  const handleCollectionSelect = useCallback((selectedValue) => {
    if (selectedValue && !selectedCollections.includes(selectedValue) && selectedCollections.length < 5) {
      setSelectedCollections([...selectedCollections, selectedValue]);
    }
    setCollectionInputValue("");
  }, [selectedCollections]);
  const handleCollectionRemove = useCallback((collectionToRemove) => {
    setSelectedCollections(selectedCollections.filter((collection) => collection !== collectionToRemove));
  }, [selectedCollections]);
  const handleMediaMappingChange = useCallback(async (mediaKey, file) => {
    if (file) {
      setUploadingMedia((prev) => ({ ...prev, [mediaKey]: true }));
      try {
        const reader = new FileReader();
        reader.onload = async () => {
          try {
            const base64String = reader.result.split(",")[1];
            let fileType = "image";
            if (file.type.startsWith("video/")) {
              fileType = "video";
            } else if (file.type.startsWith("audio/")) {
              fileType = "audio";
            } else if (file.type.includes("pdf") || file.type.includes("document") || file.type.includes("text")) {
              fileType = "document";
            }
            const filePayload = {
              fileName: file.name,
              fileSrc: `data:${file.type};base64,${base64String}`,
              fileType
            };
            const uploadResponse = await saveTemporaryFile(filePayload);
            if (uploadResponse.status && uploadResponse.filename) {
              const getGabsUrl = `https://app.getgabs.com/customers/mediafile/newfiles/uploads/${uploadResponse.filename}`;
              setMediaMapping((prev) => ({
                ...prev,
                [mediaKey]: {
                  ...prev[mediaKey],
                  file,
                  fileUrl: getGabsUrl,
                  fileName: uploadResponse.filename,
                  uploaded: true,
                  uploadError: null
                }
              }));
            } else {
              throw new Error(uploadResponse.message || "Failed to upload file");
            }
          } catch (error) {
            console.error("Error uploading file:", error);
            setMediaMapping((prev) => ({
              ...prev,
              [mediaKey]: {
                ...prev[mediaKey],
                uploadError: error.message
              }
            }));
            setTemplateError(`Failed to upload file: ${error.message}`);
          } finally {
            setUploadingMedia((prev) => ({ ...prev, [mediaKey]: false }));
          }
        };
        reader.onerror = () => {
          setTemplateError("Failed to read file");
          setUploadingMedia((prev) => ({ ...prev, [mediaKey]: false }));
        };
        reader.readAsDataURL(file);
      } catch (error) {
        console.error("Error uploading file:", error);
        setTemplateError(`Failed to upload file: ${error.message}`);
        setUploadingMedia((prev) => ({ ...prev, [mediaKey]: false }));
      }
    } else {
      setMediaMapping((prev) => ({
        ...prev,
        [mediaKey]: {
          ...prev[mediaKey],
          file: null,
          fileUrl: null,
          fileName: null,
          uploaded: false,
          uploadError: null
        }
      }));
    }
  }, []);
  const handleSave = useCallback(async () => {
    try {
      setCreatingTrigger(true);
      setTriggerError(null);
      if (!triggerName.trim()) {
        throw new Error("Please enter a trigger name");
      }
      if (!selectedTemplateData) {
        throw new Error("Please select a template");
      }
      const components = [];
      if (selectedTemplateData.components) {
        selectedTemplateData.components.forEach((component, index2) => {
          var _a3, _b2;
          if (component.type === "HEADER") {
            if (component.format === "IMAGE" || component.format === "VIDEO" || component.format === "DOCUMENT") {
              const mediaKey = `header_${index2}`;
              const mediaFile = mediaMapping[mediaKey];
              components.push({
                type: "HEADER",
                parameters: [{
                  type: component.format,
                  [component.format.toLowerCase()]: {
                    link: (mediaFile == null ? void 0 : mediaFile.fileUrl) || ((_b2 = (_a3 = component.example) == null ? void 0 : _a3.header_handle) == null ? void 0 : _b2[0]) || ""
                  }
                }]
              });
            } else if (component.text) {
              const headerVariables = extractVariablesFromWhatsAppMessage(component.text);
              if (headerVariables.length > 0) {
                components.push({
                  type: "HEADER",
                  parameters: headerVariables.map((variable) => ({
                    type: "text",
                    parameter_name: variableSelections[variable],
                    text: `{${variableSelections[variable]}}`
                  }))
                });
              }
            }
          } else if (component.type === "BODY" && component.text) {
            const bodyVariables = extractVariablesFromWhatsAppMessage(component.text);
            if (bodyVariables.length > 0) {
              components.push({
                type: "BODY",
                parameters: bodyVariables.map((variable) => ({
                  type: "text",
                  parameter_name: variableSelections[variable],
                  text: `{${variableSelections[variable]}}`
                }))
              });
            }
          } else if (component.type === "BUTTONS" && component.buttons) {
            const buttonParameters = [];
            component.buttons.forEach((button2, index22) => {
              var _a4;
              if (button2.type === "URL" && button2.url && /\{\{\d+\}\}/.test(button2.url)) {
                buttonParameters.push({
                  type: "button",
                  sub_type: "URL",
                  index: index22,
                  parameters: [{
                    type: "text",
                    text: urlButtonVariables[index22] || ((_a4 = button2.example) == null ? void 0 : _a4[0]) || ""
                  }]
                });
              }
            });
            if (buttonParameters.length > 0) {
              components.push({
                type: "BUTTONS",
                parameters: buttonParameters
              });
            }
          }
        });
      }
      const payload = {
        _token: autoReplyToken,
        template_type: "template",
        formId: "orderConfirmationTemplateForm",
        templateJson: {
          to: "receiver_number",
          type: "template",
          template: {
            name: selectedTemplateData.name || "template_name",
            language: {
              code: selectedTemplateData.language || "en_US"
            },
            components
          },
          recipient_type: "individual",
          messaging_product: "whatsapp"
        },
        currentChoosedTemplateJson: {
          choosedTemplate: {
            name: selectedTemplateData.name || "template_name",
            parameter_format: selectedTemplateData.parameter_format || "POSITIONAL",
            components: selectedTemplateData.components || [],
            language: selectedTemplateData.language || "en_US",
            status: selectedTemplateData.status || "APPROVED",
            category: selectedTemplateData.category || "MARKETING",
            id: selectedTemplateData.id || selectedTemplateData.template_id || ""
          }
        },
        triggerName,
        triggerType: "order_confirmation",
        delayTime,
        delayUnit,
        selectedCollections: filterByCollection ? JSON.stringify(selectedCollections) : "[All]"
      };
      console.log("Creating order confirmation trigger with payload:", payload);
      const response = await createAbandonedCartTrigger(payload);
      console.log("Order confirmation trigger created successfully:", response);
      navigate("/app/auto-triggers/order-confirmation");
    } catch (error) {
      console.error("Error creating order confirmation trigger:", error);
      setTriggerError(error.message || "Failed to create order confirmation trigger");
    } finally {
      setCreatingTrigger(false);
    }
  }, [triggerName, messageTemplate, selectedTemplateData, mediaMapping, variableSelections, urlButtonVariables, delayTime, delayUnit, filterByCollection, selectedCollections, navigate]);
  const handleCancel = useCallback(() => {
    navigate("/app/auto-triggers/order-confirmation");
  }, [navigate]);
  const delayUnitOptions = [
    { label: "Minutes", value: "minutes" },
    { label: "Hours", value: "hours" },
    { label: "Days", value: "days" }
  ];
  const collectionOptions = useMemo(() => {
    return apiCollections;
  }, [apiCollections]);
  const filteredCollectionOptions = useMemo(() => {
    if (selectedCollections.length >= 5) return [];
    if (!collectionInputValue) return collectionOptions.filter((option) => !selectedCollections.includes(option.value));
    return collectionOptions.filter(
      (option) => option.label.toLowerCase().includes(collectionInputValue.toLowerCase()) && !selectedCollections.includes(option.value)
    );
  }, [collectionOptions, collectionInputValue, selectedCollections]);
  const extractVariables = useMemo(() => {
    return extractVariablesFromWhatsAppMessage(messageTemplate);
  }, [messageTemplate]);
  const templateMedia = useMemo(() => {
    if (!selectedTemplateData || !selectedTemplateData.components) return {};
    const media = {};
    selectedTemplateData.components.forEach((component, index2) => {
      var _a3, _b2;
      if (component.type === "HEADER" && (component.format === "IMAGE" || component.format === "VIDEO" || component.format === "DOCUMENT")) {
        const mediaKey = `header_${index2}`;
        media[mediaKey] = {
          type: component.format.toLowerCase(),
          url: ((_b2 = (_a3 = component.example) == null ? void 0 : _a3.header_handle) == null ? void 0 : _b2[0]) || null,
          required: true
        };
      }
    });
    return media;
  }, [selectedTemplateData]);
  const templateUrlButtons = useMemo(() => {
    if (!selectedTemplateData || !selectedTemplateData.components) return [];
    const urlButtons = [];
    selectedTemplateData.components.forEach((component) => {
      if (component.type === "BUTTONS" && component.buttons) {
        component.buttons.forEach((button2, index2) => {
          var _a3;
          if (button2.type === "URL" && button2.url) {
            const hasVariable = /\{\{\d+\}\}/.test(button2.url);
            if (hasVariable) {
              urlButtons.push({
                index: index2,
                text: button2.text,
                url: button2.url,
                example: ((_a3 = button2.example) == null ? void 0 : _a3[0]) || ""
              });
            }
          }
        });
      }
    });
    return urlButtons;
  }, [selectedTemplateData]);
  useEffect(() => {
    if (templateUrlButtons.length > 0) {
      const initialUrlVariables = {};
      templateUrlButtons.forEach((button2) => {
        if (!urlButtonVariables[button2.index]) {
          initialUrlVariables[button2.index] = button2.example;
        }
      });
      if (Object.keys(initialUrlVariables).length > 0) {
        setUrlButtonVariables((prev) => ({ ...prev, ...initialUrlVariables }));
      }
    }
  }, [templateUrlButtons]);
  const isFormValid = useMemo(() => {
    if (!triggerName.trim()) return false;
    if (!messageTemplate) return false;
    if (creatingTrigger) return false;
    if (templateUrlButtons.length > 0) {
      for (const button2 of templateUrlButtons) {
        if (!urlButtonVariables[button2.index] || urlButtonVariables[button2.index].trim() === "") {
          return false;
        }
      }
    }
    return true;
  }, [triggerName, messageTemplate, creatingTrigger, templateUrlButtons, urlButtonVariables]);
  return /* @__PURE__ */ jsx(
    Page,
    {
      title: "Create Order Confirmation Trigger",
      subtitle: "Set up automated messages for order confirmations and updates",
      backAction: {
        content: "Order Confirmation Triggers",
        onAction: () => navigate("/app/auto-triggers/order-confirmation")
      },
      primaryAction: {
        content: "Save Trigger",
        onAction: handleSave,
        disabled: !isFormValid,
        loading: creatingTrigger
      },
      secondaryActions: [
        {
          content: "Cancel",
          onAction: handleCancel
        }
      ],
      fullWidth: true,
      children: /* @__PURE__ */ jsxs(Grid, { children: [
        /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 8, lg: 8, xl: 8 }, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "500", children: [
          /* @__PURE__ */ jsx(Banner, { status: "info", children: /* @__PURE__ */ jsx(Text, { as: "p", children: "Create automated messages to keep customers informed about their orders. Set up confirmations, shipping updates, and delivery notifications." }) }),
          templateError && /* @__PURE__ */ jsx(Banner, { status: "critical", onDismiss: () => setTemplateError(null), children: /* @__PURE__ */ jsx(Text, { as: "p", children: templateError }) }),
          triggerError && /* @__PURE__ */ jsx(Banner, { status: "critical", onDismiss: () => setTriggerError(null), children: /* @__PURE__ */ jsx(Text, { as: "p", children: triggerError }) }),
          /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Basic Information" }),
            /* @__PURE__ */ jsxs(FormLayout, { children: [
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Trigger Name",
                  value: triggerName,
                  onChange: handleTriggerNameChange,
                  placeholder: "e.g., Order Confirmation - Immediate",
                  helpText: "Give your trigger a descriptive name",
                  requiredIndicator: true
                }
              ),
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Trigger Type",
                  value: "Order Confirmation",
                  disabled: true,
                  helpText: "This trigger is specifically for order confirmations and updates"
                }
              )
            ] })
          ] }) }),
          /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Template Selection" }),
            /* @__PURE__ */ jsxs(FormLayout, { children: [
              loadingTemplates ? /* @__PURE__ */ jsxs("div", { style: { display: "flex", alignItems: "center", gap: "8px", padding: "12px" }, children: [
                /* @__PURE__ */ jsx(Spinner, { size: "small" }),
                /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", children: "Loading templates..." })
              ] }) : allTemplateOptions.length > 0 ? /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsx(
                  Autocomplete,
                  {
                    label: "Search and select template",
                    options: filteredTemplateOptions.map((template) => ({
                      value: template.id || template.value,
                      label: template.label
                    })),
                    selected: selectedTemplateId ? [selectedTemplateId] : [],
                    onSelect: (selected) => {
                      const selectedValue = selected[0];
                      if (selectedValue) {
                        handleTemplateChange(selectedValue);
                      }
                    },
                    textField: /* @__PURE__ */ jsx(
                      Autocomplete.TextField,
                      {
                        onChange: (value) => setTemplateInputValue(value),
                        label: "Search and select template",
                        value: templateInputValue,
                        placeholder: "Type to search templates...",
                        autoComplete: "off"
                      }
                    ),
                    loading: loadingTemplates || loadingTemplateDetails,
                    emptyState: loadingTemplates ? "Loading templates..." : "No templates found",
                    preferredPosition: "below",
                    willLoadMoreResults: false
                  }
                ),
                /* @__PURE__ */ jsxs(Text, { variant: "bodySm", tone: "subdued", children: [
                  "Found ",
                  allTemplateOptions.length,
                  " templates from API"
                ] }),
                selectedTemplateData && /* @__PURE__ */ jsx(Banner, { status: "info", children: /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                  "Template selected: ",
                  /* @__PURE__ */ jsx("strong", { children: (_a2 = allTemplateOptions.find((t) => t.id === selectedTemplateId || t.value === selectedTemplateId)) == null ? void 0 : _a2.label }),
                  loadingTemplateDetails && /* @__PURE__ */ jsx("span", { children: " (Loading details...)" })
                ] }) })
              ] }) : /* @__PURE__ */ jsx("div", { style: { padding: "12px", textAlign: "center" }, children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", children: "No templates available. Please check your API connection." }) }),
              /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", children: "Search and select from available templates" })
            ] })
          ] }) }),
          extractVariables.length > 0 && /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Variable Mapping" }),
            /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Map the template variables to actual data fields:" }),
            /* @__PURE__ */ jsx(FormLayout, { children: extractVariables.map((variable, index2) => /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: `Variable: {{${variable}}}`,
                  value: `{{${variable}}}`,
                  disabled: true,
                  helpText: "Template variable"
                }
              ),
              /* @__PURE__ */ jsx(
                Select,
                {
                  label: "Map to",
                  options: [
                    { label: "Select mapping...", value: "" },
                    ...availableVariables
                  ],
                  value: variableSelections[variable] || "",
                  onChange: (value) => handleVariableSelectionChange(variable, value),
                  placeholder: `${variable}`
                }
              )
            ] }, variable)) })
          ] }) }),
          Object.keys(templateMedia).length > 0 && /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Media Files" }),
            /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Upload media files required by this template:" }),
            /* @__PURE__ */ jsx(BlockStack, { gap: "400", children: Object.entries(templateMedia).map(([mediaKey, mediaData]) => {
              var _a3, _b2, _c, _d;
              const uploadedFile = (_a3 = mediaMapping[mediaKey]) == null ? void 0 : _a3.file;
              const fileUrl = ((_b2 = mediaMapping[mediaKey]) == null ? void 0 : _b2.fileUrl) || mediaData.url;
              const isUploading = uploadingMedia[mediaKey];
              const uploadError = (_c = mediaMapping[mediaKey]) == null ? void 0 : _c.uploadError;
              const isUploaded = (_d = mediaMapping[mediaKey]) == null ? void 0 : _d.uploaded;
              return /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsxs(InlineStack, { gap: "200", align: "space-between", blockAlign: "center", children: [
                  /* @__PURE__ */ jsxs(InlineStack, { gap: "200", blockAlign: "center", children: [
                    /* @__PURE__ */ jsx(
                      Thumbnail,
                      {
                        source: uploadedFile ? fileUrl : mediaData.url || (mediaData.type === "document" ? "📄" : "📁"),
                        alt: (uploadedFile == null ? void 0 : uploadedFile.name) || `Header ${mediaData.type}`,
                        size: "small"
                      }
                    ),
                    /* @__PURE__ */ jsxs(BlockStack, { gap: "050", children: [
                      /* @__PURE__ */ jsxs(InlineStack, { gap: "200", blockAlign: "center", children: [
                        /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: uploadedFile ? uploadedFile.name : `Header ${mediaData.type}` }),
                        isUploading && /* @__PURE__ */ jsx(Badge, { tone: "info", children: "Uploading..." }),
                        isUploaded && !isUploading && /* @__PURE__ */ jsx(Badge, { tone: "success", children: "Uploaded" })
                      ] }),
                      /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: uploadedFile ? `${(uploadedFile.size / 1024 / 1024).toFixed(2)} MB` : `Original ${mediaData.type}` }),
                      uploadError && /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "critical", children: [
                        "Error: ",
                        uploadError
                      ] })
                    ] })
                  ] }),
                  uploadedFile ? /* @__PURE__ */ jsxs(InlineStack, { gap: "100", children: [
                    /* @__PURE__ */ jsx(
                      Button,
                      {
                        variant: "plain",
                        tone: "critical",
                        size: "slim",
                        onClick: () => handleMediaMappingChange(mediaKey, null),
                        disabled: isUploading,
                        children: "Remove"
                      }
                    ),
                    /* @__PURE__ */ jsx(
                      Button,
                      {
                        variant: "plain",
                        size: "slim",
                        onClick: () => document.getElementById(`upload-${mediaKey}`).click(),
                        disabled: isUploading,
                        children: "Replace"
                      }
                    )
                  ] }) : /* @__PURE__ */ jsxs(
                    Button,
                    {
                      variant: "plain",
                      size: "slim",
                      onClick: () => document.getElementById(`upload-${mediaKey}`).click(),
                      disabled: isUploading,
                      loading: isUploading,
                      children: [
                        "Upload ",
                        mediaData.type
                      ]
                    }
                  )
                ] }),
                /* @__PURE__ */ jsx(
                  "input",
                  {
                    id: `upload-${mediaKey}`,
                    type: "file",
                    accept: mediaData.type === "image" ? "image/*" : mediaData.type === "video" ? "video/*" : "application/pdf,.doc,.docx,.txt",
                    style: { display: "none" },
                    onChange: (e) => {
                      var _a4;
                      if (((_a4 = e.target.files) == null ? void 0 : _a4.length) > 0) {
                        handleMediaMappingChange(mediaKey, e.target.files[0]);
                      }
                    }
                  }
                )
              ] }, mediaKey);
            }) })
          ] }) }),
          templateUrlButtons.length > 0 && /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "URL Button Variables" }),
            /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Configure the default values for URL button variables:" }),
            /* @__PURE__ */ jsx(FormLayout, { children: templateUrlButtons.map((button2, index2) => /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: `Button: ${button2.text}`,
                  value: button2.url,
                  disabled: true,
                  helpText: "URL template with variable placeholder"
                }
              ),
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Variable value",
                  value: urlButtonVariables[button2.index] || button2.example,
                  onChange: (value) => handleUrlButtonVariableChange(button2.index, value),
                  placeholder: "Enter default URL value",
                  helpText: "This value will replace the variable in the URL"
                }
              )
            ] }, `url_button_${button2.index}`)) })
          ] }) }),
          /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Timing Settings" }),
            /* @__PURE__ */ jsx(FormLayout, { children: /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Delay Time",
                  type: "number",
                  value: delayTime,
                  onChange: handleDelayTimeChange,
                  min: "0",
                  helpText: "How long to wait after order is placed before sending (0 for immediate)"
                }
              ),
              /* @__PURE__ */ jsx(
                Select,
                {
                  label: "Delay Unit",
                  options: delayUnitOptions,
                  value: delayUnit,
                  onChange: handleDelayUnitChange
                }
              )
            ] }) })
          ] }) }),
          /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Target Audience" }),
            /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
              /* @__PURE__ */ jsx(Text, { as: "p", tone: "subdued", children: "This trigger will target customers who place orders." }),
              /* @__PURE__ */ jsx(
                Checkbox,
                {
                  label: "Order Confirmation Customers",
                  checked: true,
                  disabled: true,
                  helpText: "This audience is automatically selected for order confirmation triggers"
                }
              ),
              /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                /* @__PURE__ */ jsx(
                  Checkbox,
                  {
                    label: "Do you want to filter target customers based on your product category/collection?",
                    checked: filterByCollection,
                    onChange: handleFilterByCollectionChange,
                    helpText: "Filter customers based on the products they have ordered"
                  }
                ),
                filterByCollection && /* @__PURE__ */ jsxs(FormLayout, { children: [
                  collectionsError && /* @__PURE__ */ jsx(
                    Banner,
                    {
                      title: "Collections Error",
                      tone: "critical",
                      onDismiss: () => setCollectionsError(null),
                      children: /* @__PURE__ */ jsx("p", { children: collectionsError })
                    }
                  ),
                  loadingCollections && /* @__PURE__ */ jsxs(InlineStack, { gap: "200", align: "center", children: [
                    /* @__PURE__ */ jsx(Spinner, { accessibilityLabel: "Loading collections", size: "small" }),
                    /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Loading collections..." })
                  ] }),
                  /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                    /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                      /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "h3", children: "Select Collections (Maximum 5)" }),
                      /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: selectedCollections.length >= 5 ? "critical" : "subdued", children: [
                        selectedCollections.length,
                        "/5 selected"
                      ] })
                    ] }),
                    selectedCollections.length > 0 && /* @__PURE__ */ jsx(InlineStack, { gap: "100", wrap: true, children: selectedCollections.map((collectionValue, index2) => {
                      const collectionOption = collectionOptions.find((opt) => opt.value === collectionValue);
                      const displayLabel = collectionOption ? collectionOption.label : collectionValue;
                      return /* @__PURE__ */ jsx(
                        Tag,
                        {
                          onRemove: () => handleCollectionRemove(collectionValue),
                          children: displayLabel
                        },
                        collectionValue
                      );
                    }) }),
                    /* @__PURE__ */ jsx(
                      Combobox,
                      {
                        activator: /* @__PURE__ */ jsx(
                          Combobox.TextField,
                          {
                            onChange: handleCollectionInputChange,
                            label: "",
                            labelHidden: true,
                            value: collectionInputValue,
                            placeholder: loadingCollections ? "Loading collections..." : selectedCollections.length >= 5 ? "Maximum 5 collections selected" : "Search and select collections...",
                            autoComplete: "off",
                            disabled: selectedCollections.length >= 5 || loadingCollections
                          }
                        ),
                        children: filteredCollectionOptions.length > 0 ? /* @__PURE__ */ jsx(Listbox, { onSelect: handleCollectionSelect, children: filteredCollectionOptions.map((option) => /* @__PURE__ */ jsx(
                          Listbox.Option,
                          {
                            value: option.value,
                            selected: selectedCollections.includes(option.value),
                            disabled: selectedCollections.includes(option.value),
                            children: option.label
                          },
                          option.value
                        )) }) : /* @__PURE__ */ jsx(Listbox, { children: /* @__PURE__ */ jsx(Listbox.Option, { value: "", disabled: true, children: loadingCollections ? "Loading collections..." : selectedCollections.length >= 5 ? "Maximum collections selected" : "No collections found" }) })
                      }
                    ),
                    /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Only customers who order products from the selected collections will receive this trigger. Maximum 5 collections allowed." })
                  ] })
                ] })
              ] })
            ] })
          ] }) }),
          /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsx(InlineStack, { align: "end", children: /* @__PURE__ */ jsxs(ButtonGroup, { children: [
            /* @__PURE__ */ jsx(Button, { onClick: handleCancel, children: "Cancel" }),
            /* @__PURE__ */ jsx(
              Button,
              {
                variant: "primary",
                onClick: handleSave,
                disabled: !isFormValid,
                loading: creatingTrigger,
                children: "Save Trigger"
              }
            )
          ] }) }) })
        ] }) }),
        /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 4, lg: 4, xl: 4 }, children: /* @__PURE__ */ jsx("div", { style: {
          position: "sticky",
          top: "20px",
          alignSelf: "flex-start",
          zIndex: 10
        }, children: /* @__PURE__ */ jsx(BlockStack, { gap: "500", children: /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Message Preview" }),
          messageTemplate ? /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
            /* @__PURE__ */ jsx(Text, { as: "p", tone: "", children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", children: (_b = allTemplateOptions.find((t) => t.id === selectedTemplateId || t.value === selectedTemplateId)) == null ? void 0 : _b.label }) }),
            /* @__PURE__ */ jsx(Card, { sectioned: true, background: "bg-surface-secondary", children: /* @__PURE__ */ jsx(
              WhatsAppPreview,
              {
                template: selectedTemplateData || messageTemplate,
                variant: "bubble",
                maxWidth: "280px",
                mediaMapping
              }
            ) }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
              "Variables like ",
              `{`,
              `{`,
              `customer_name`,
              `}`,
              `}`,
              " or ",
              `{`,
              `{`,
              `1`,
              `}`,
              `}`,
              " will be replaced with actual customer data when sent."
            ] })
          ] }) : /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
            /* @__PURE__ */ jsx(Text, { as: "p", tone: "subdued", children: "Select a template to see the preview" }),
            /* @__PURE__ */ jsx(LegacyCard, { sectioned: true, children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Your message preview will appear here once you select a template." }) })
          ] })
        ] }) }) }) }) })
      ] })
    }
  );
}
const route20 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: CreateOrderConfirmationTriggerPage
}, Symbol.toStringTag, { value: "Module" }));
function CreateAbandonedCartTriggerPage() {
  var _a2, _b;
  const navigate = useNavigate();
  const [triggerName, setTriggerName] = useState("");
  const [selectedTemplate, setSelectedTemplate] = useState("");
  const [selectedTemplateId, setSelectedTemplateId] = useState("");
  const [templateInputValue, setTemplateInputValue] = useState("");
  const [messageTemplate, setMessageTemplate] = useState("");
  const [delayTime, setDelayTime] = useState("30");
  const [delayUnit, setDelayUnit] = useState("minutes");
  const [isActive, setIsActive] = useState(true);
  const [variableSelections, setVariableSelections] = useState({});
  const [filterByCollection, setFilterByCollection] = useState(false);
  const [selectedCollections, setSelectedCollections] = useState([]);
  const [collectionInputValue, setCollectionInputValue] = useState("");
  const [apiCollections, setApiCollections] = useState([]);
  const [loadingCollections, setLoadingCollections] = useState(false);
  const [collectionsError, setCollectionsError] = useState(null);
  const [apiTemplates, setApiTemplates] = useState([]);
  const [loadingTemplates, setLoadingTemplates] = useState(false);
  const [templateError, setTemplateError] = useState(null);
  const [selectedTemplateData, setSelectedTemplateData] = useState(null);
  const [loadingTemplateDetails, setLoadingTemplateDetails] = useState(false);
  const [mediaMapping, setMediaMapping] = useState({});
  const [uploadingMedia, setUploadingMedia] = useState({});
  const [urlButtonVariables, setUrlButtonVariables] = useState({});
  const [creatingTrigger, setCreatingTrigger] = useState(false);
  const [triggerError, setTriggerError] = useState(null);
  const availableVariables = [
    { label: "abandoned_cart_last_id", value: "abandoned_cart_last_id" },
    { label: "abandoned_cart_created_at", value: "abandoned_cart_created_at" },
    { label: "abandoned_cart_completed_at", value: "abandoned_cart_completed_at" },
    { label: "abandoned_cart_total_price", value: "abandoned_cart_total_price" },
    { label: "abandoned_cart_currency", value: "abandoned_cart_currency" },
    { label: "abandoned_cart_customer_id", value: "abandoned_cart_customer_id" },
    { label: "abandoned_cart_customer_first_name", value: "abandoned_cart_customer_first_name" },
    { label: "abandoned_cart_customer_last_name", value: "abandoned_cart_customer_last_name" },
    { label: "abandoned_cart_customer_email", value: "abandoned_cart_customer_email" },
    { label: "abandoned_cart_customer_phone", value: "abandoned_cart_customer_phone" },
    { label: "abandoned_cart_customer_number_of_orders", value: "abandoned_cart_customer_number_of_orders" },
    { label: "abandoned_cart_customer_lifetime_duration", value: "abandoned_cart_customer_lifetime_duration" },
    { label: "abandoned_cart_customer_default_address", value: "abandoned_cart_customer_default_address" },
    { label: "abandoned_cart_line_item_id", value: "abandoned_cart_line_item_id" },
    { label: "abandoned_cart_line_item_title", value: "abandoned_cart_line_item_title" },
    { label: "abandoned_cart_line_item_quantity", value: "abandoned_cart_line_item_quantity" },
    { label: "abandoned_cart_line_item_variant_title", value: "abandoned_cart_line_item_variant_title" },
    { label: "support_email", value: "support_email" },
    { label: "support_phone", value: "support_phone" }
  ];
  const fetchApiTemplates2 = useCallback(async () => {
    try {
      setLoadingTemplates(true);
      setTemplateError(null);
      const response = await getAllTemplateListForAbandonedCart();
      if (response.status && response.data && response.data.customtemplates) {
        const transformedTemplates = response.data.customtemplates.map((template) => ({
          id: template.template_id ? template.template_id.toString() : "unknown",
          name: template.template_name || "Unknown Template",
          templateId: template.template_id,
          userId: template.user_id,
          label: template.template_name || "Unknown Template",
          value: template.template_id ? template.template_id.toString() : "unknown"
        }));
        setApiTemplates(transformedTemplates);
      } else {
        console.error("Invalid API response format:", response);
        setApiTemplates([]);
      }
    } catch (error) {
      console.error("Error fetching templates:", error);
      setTemplateError(`Failed to load templates: ${error.message}`);
      setApiTemplates([]);
    } finally {
      setLoadingTemplates(false);
    }
  }, []);
  useEffect(() => {
    fetchApiTemplates2();
  }, [fetchApiTemplates2]);
  const fetchApiCollections = useCallback(async () => {
    try {
      setLoadingCollections(true);
      setCollectionsError(null);
      const response = await fetchallCategoryList({ perPageData: 200 });
      if (response.status && response.data && response.data.data) {
        const transformedCollections = response.data.data.filter((category) => category.status === 1).map((category) => ({
          id: category.id,
          label: category.category_name,
          value: category.id.toString()
          // Use ID as value for selection
        }));
        setApiCollections(transformedCollections);
      } else {
        console.error("Invalid collections API response format:", response);
        setCollectionsError("Invalid API response format");
        setApiCollections([]);
      }
    } catch (error) {
      console.error("Error fetching collections:", error);
      setCollectionsError(`Failed to load collections: ${error.message}`);
      setApiCollections([]);
    } finally {
      setLoadingCollections(false);
    }
  }, []);
  useEffect(() => {
    fetchApiCollections();
  }, [fetchApiCollections]);
  useEffect(() => {
    if (filterByCollection && apiCollections.length === 0 && !loadingCollections) {
      fetchApiCollections();
    }
  }, [filterByCollection, apiCollections.length, loadingCollections, fetchApiCollections]);
  const allTemplateOptions = useMemo(() => {
    console.log("Template options:", {
      api: apiTemplates.length,
      total: apiTemplates.length,
      apiTemplates
    });
    return apiTemplates;
  }, [apiTemplates]);
  const filteredTemplateOptions = useMemo(() => {
    if (!templateInputValue.trim()) return allTemplateOptions;
    const searchLower = templateInputValue.toLowerCase();
    return allTemplateOptions.filter(
      (template) => {
        var _a3, _b2;
        return ((_a3 = template.label) == null ? void 0 : _a3.toLowerCase().includes(searchLower)) || ((_b2 = template.name) == null ? void 0 : _b2.toLowerCase().includes(searchLower));
      }
    );
  }, [allTemplateOptions, templateInputValue]);
  const handleTriggerNameChange = useCallback((value) => setTriggerName(value), []);
  const handleTemplateChange = useCallback(async (value) => {
    setSelectedTemplateId(value);
    const selectedTemplate2 = allTemplateOptions.find((t) => t.id === value || t.value === value);
    if (selectedTemplate2) {
      setTemplateInputValue(selectedTemplate2.label);
      setSelectedTemplate(selectedTemplate2.value);
      try {
        setLoadingTemplateDetails(true);
        setTemplateError(null);
        const response = await getSelectedTemplatebyName(selectedTemplate2.name);
        if (response.data && response.data.length > 0) {
          const templateData = response.data[0];
          setSelectedTemplateData(templateData);
          let templateContent = "";
          if (templateData.components) {
            templateData.components.forEach((component) => {
              if (component.type === "HEADER" && component.text) {
                templateContent += component.text + "\n\n";
              } else if (component.type === "BODY" && component.text) {
                templateContent += component.text + "\n\n";
              } else if (component.type === "FOOTER" && component.text) {
                templateContent += component.text;
              }
            });
          }
          setMessageTemplate(templateContent.trim());
        } else {
          console.error("No template data found");
          setTemplateError("Template not found or invalid");
          setSelectedTemplateData(null);
        }
      } catch (error) {
        console.error("Error fetching template details:", error);
        setTemplateError(`Failed to load template: ${error.message}`);
        setSelectedTemplateData(null);
      } finally {
        setLoadingTemplateDetails(false);
      }
    } else {
      setTemplateInputValue("");
      setSelectedTemplate("");
      setMessageTemplate("");
      setSelectedTemplateData(null);
    }
    setVariableSelections({});
    setMediaMapping({});
    setUrlButtonVariables({});
  }, [allTemplateOptions]);
  useCallback((value) => setMessageTemplate(value), []);
  const handleDelayTimeChange = useCallback((value) => setDelayTime(value), []);
  const handleDelayUnitChange = useCallback((value) => setDelayUnit(value), []);
  useCallback((value) => setIsActive(value), []);
  const handleVariableSelectionChange = useCallback((variable, value) => {
    setVariableSelections((prev) => ({
      ...prev,
      [variable]: value
    }));
  }, []);
  const handleUrlButtonVariableChange = useCallback((buttonIndex, value) => {
    setUrlButtonVariables((prev) => ({
      ...prev,
      [buttonIndex]: value
    }));
  }, []);
  const handleFilterByCollectionChange = useCallback((value) => {
    setFilterByCollection(value);
    if (!value) {
      setSelectedCollections([]);
      setCollectionInputValue("");
    }
  }, []);
  useCallback((value) => {
    setSelectedCollections(value);
  }, []);
  const handleCollectionInputChange = useCallback((value) => {
    setCollectionInputValue(value);
  }, []);
  const handleCollectionSelect = useCallback((selectedValue) => {
    if (selectedValue && !selectedCollections.includes(selectedValue) && selectedCollections.length < 5) {
      setSelectedCollections([...selectedCollections, selectedValue]);
    }
    setCollectionInputValue("");
  }, [selectedCollections]);
  const handleCollectionRemove = useCallback((collectionToRemove) => {
    setSelectedCollections(selectedCollections.filter((collection) => collection !== collectionToRemove));
  }, [selectedCollections]);
  const handleMediaMappingChange = useCallback(async (mediaKey, file) => {
    if (file) {
      setUploadingMedia((prev) => ({ ...prev, [mediaKey]: true }));
      try {
        const reader = new FileReader();
        reader.onload = async () => {
          try {
            const base64String = reader.result.split(",")[1];
            let fileType = "image";
            if (file.type.startsWith("video/")) {
              fileType = "video";
            } else if (file.type.startsWith("audio/")) {
              fileType = "audio";
            } else if (file.type.includes("pdf") || file.type.includes("document") || file.type.includes("text")) {
              fileType = "document";
            }
            const filePayload = {
              fileName: file.name,
              fileSrc: `data:${file.type};base64,${base64String}`,
              fileType
            };
            const uploadResponse = await saveTemporaryFile(filePayload);
            if (uploadResponse.status && uploadResponse.filename) {
              const getGabsUrl = `https://app.getgabs.com/customers/mediafile/newfiles/uploads/${uploadResponse.filename}`;
              setMediaMapping((prev) => ({
                ...prev,
                [mediaKey]: {
                  ...prev[mediaKey],
                  file,
                  fileUrl: getGabsUrl,
                  fileName: uploadResponse.filename,
                  uploaded: true,
                  uploadError: null
                }
              }));
            } else {
              throw new Error(uploadResponse.message || "Failed to upload file");
            }
          } catch (error) {
            console.error("Error uploading file:", error);
            setMediaMapping((prev) => ({
              ...prev,
              [mediaKey]: {
                ...prev[mediaKey],
                uploadError: error.message
              }
            }));
            setTemplateError(`Failed to upload file: ${error.message}`);
          } finally {
            setUploadingMedia((prev) => ({ ...prev, [mediaKey]: false }));
          }
        };
        reader.onerror = () => {
          setTemplateError("Failed to read file");
          setUploadingMedia((prev) => ({ ...prev, [mediaKey]: false }));
        };
        reader.readAsDataURL(file);
      } catch (error) {
        console.error("Error uploading file:", error);
        setTemplateError(`Failed to upload file: ${error.message}`);
        setUploadingMedia((prev) => ({ ...prev, [mediaKey]: false }));
      }
    } else {
      setMediaMapping((prev) => ({
        ...prev,
        [mediaKey]: {
          ...prev[mediaKey],
          file: null,
          fileUrl: null,
          fileName: null,
          uploaded: false,
          uploadError: null
        }
      }));
    }
  }, []);
  const handleSave = useCallback(async () => {
    try {
      setCreatingTrigger(true);
      setTriggerError(null);
      if (!triggerName.trim()) {
        throw new Error("Please enter a trigger name");
      }
      if (!selectedTemplateData) {
        throw new Error("Please select a template");
      }
      const components = [];
      if (selectedTemplateData.components) {
        selectedTemplateData.components.forEach((component, index2) => {
          var _a3, _b2;
          if (component.type === "HEADER") {
            if (component.format === "IMAGE" || component.format === "VIDEO" || component.format === "DOCUMENT") {
              const mediaKey = `header_${index2}`;
              const mediaFile = mediaMapping[mediaKey];
              components.push({
                type: "HEADER",
                parameters: [{
                  type: component.format,
                  [component.format.toLowerCase()]: {
                    link: (mediaFile == null ? void 0 : mediaFile.fileUrl) || ((_b2 = (_a3 = component.example) == null ? void 0 : _a3.header_handle) == null ? void 0 : _b2[0]) || ""
                  }
                }]
              });
            } else if (component.text) {
              const headerVariables = extractVariablesFromWhatsAppMessage(component.text);
              if (headerVariables.length > 0) {
                components.push({
                  type: "HEADER",
                  parameters: headerVariables.map((variable) => ({
                    type: "text",
                    parameter_name: variableSelections[variable],
                    text: `{${variableSelections[variable]}}`
                  }))
                });
              }
            }
          } else if (component.type === "BODY" && component.text) {
            const bodyVariables = extractVariablesFromWhatsAppMessage(component.text);
            if (bodyVariables.length > 0) {
              components.push({
                type: "BODY",
                parameters: bodyVariables.map((variable) => ({
                  type: "text",
                  parameter_name: variableSelections[variable],
                  text: `{${variableSelections[variable]}}`
                }))
              });
            }
          } else if (component.type === "BUTTONS" && component.buttons) {
            const buttonParameters = [];
            component.buttons.forEach((button2, index22) => {
              var _a4;
              if (button2.type === "URL" && button2.url && /\{\{\d+\}\}/.test(button2.url)) {
                buttonParameters.push({
                  type: "button",
                  sub_type: "URL",
                  index: index22,
                  parameters: [{
                    type: "text",
                    text: urlButtonVariables[index22] || ((_a4 = button2.example) == null ? void 0 : _a4[0]) || ""
                  }]
                });
              }
            });
            if (buttonParameters.length > 0) {
              components.push({
                type: "BUTTONS",
                parameters: buttonParameters
              });
            }
          }
        });
      }
      const payload = {
        _token: autoReplyToken,
        template_type: "template",
        formId: "abandonedCartTemplateForm",
        templateJson: {
          to: "receiver_number",
          type: "template",
          template: {
            name: selectedTemplateData.name || "template_name",
            language: {
              code: selectedTemplateData.language || "en_US"
            },
            components
          },
          recipient_type: "individual",
          messaging_product: "whatsapp"
        },
        currentChoosedTemplateJson: {
          choosedTemplate: {
            name: selectedTemplateData.name || "template_name",
            parameter_format: selectedTemplateData.parameter_format || "POSITIONAL",
            components: selectedTemplateData.components || [],
            language: selectedTemplateData.language || "en_US",
            status: selectedTemplateData.status || "APPROVED",
            category: selectedTemplateData.category || "MARKETING",
            id: selectedTemplateData.id || selectedTemplateData.template_id || ""
          }
        },
        triggerName,
        triggerType: "abandoned_cart",
        delayTime,
        delayUnit,
        selectedCollections: filterByCollection ? JSON.stringify(selectedCollections) : "[All]"
      };
      console.log("Creating abandoned cart trigger with payload:", payload);
      const response = await createAbandonedCartTrigger(payload);
      console.log("Abandoned cart trigger created successfully:", response);
      navigate("/app/auto-triggers/abandoned-cart");
    } catch (error) {
      console.error("Error creating abandoned cart trigger:", error);
      setTriggerError(error.message || "Failed to create abandoned cart trigger");
    } finally {
      setCreatingTrigger(false);
    }
  }, [triggerName, messageTemplate, selectedTemplateData, mediaMapping, variableSelections, urlButtonVariables, delayTime, delayUnit, filterByCollection, selectedCollections, navigate]);
  const handleCancel = useCallback(() => {
    navigate("/app/auto-triggers/abandoned-cart");
  }, [navigate]);
  const delayUnitOptions = [
    { label: "Minutes", value: "minutes" },
    { label: "Hours", value: "hours" },
    { label: "Days", value: "days" }
  ];
  const collectionOptions = useMemo(() => {
    return apiCollections;
  }, [apiCollections]);
  const filteredCollectionOptions = useMemo(() => {
    if (selectedCollections.length >= 5) return [];
    if (!collectionInputValue) return collectionOptions.filter((option) => !selectedCollections.includes(option.value));
    return collectionOptions.filter(
      (option) => option.label.toLowerCase().includes(collectionInputValue.toLowerCase()) && !selectedCollections.includes(option.value)
    );
  }, [collectionOptions, collectionInputValue, selectedCollections]);
  const extractVariables = useMemo(() => {
    return extractVariablesFromWhatsAppMessage(messageTemplate);
  }, [messageTemplate]);
  const templateMedia = useMemo(() => {
    if (!selectedTemplateData || !selectedTemplateData.components) return {};
    const media = {};
    selectedTemplateData.components.forEach((component, index2) => {
      var _a3, _b2;
      if (component.type === "HEADER" && (component.format === "IMAGE" || component.format === "VIDEO" || component.format === "DOCUMENT")) {
        const mediaKey = `header_${index2}`;
        media[mediaKey] = {
          type: component.format.toLowerCase(),
          url: ((_b2 = (_a3 = component.example) == null ? void 0 : _a3.header_handle) == null ? void 0 : _b2[0]) || null,
          required: true
        };
      }
    });
    return media;
  }, [selectedTemplateData]);
  const templateUrlButtons = useMemo(() => {
    if (!selectedTemplateData || !selectedTemplateData.components) return [];
    const urlButtons = [];
    selectedTemplateData.components.forEach((component) => {
      if (component.type === "BUTTONS" && component.buttons) {
        component.buttons.forEach((button2, index2) => {
          var _a3;
          if (button2.type === "URL" && button2.url) {
            const hasVariable = /\{\{\d+\}\}/.test(button2.url);
            if (hasVariable) {
              urlButtons.push({
                index: index2,
                text: button2.text,
                url: button2.url,
                example: ((_a3 = button2.example) == null ? void 0 : _a3[0]) || ""
              });
            }
          }
        });
      }
    });
    return urlButtons;
  }, [selectedTemplateData]);
  useEffect(() => {
    if (templateUrlButtons.length > 0) {
      const initialUrlVariables = {};
      templateUrlButtons.forEach((button2) => {
        if (!urlButtonVariables[button2.index]) {
          initialUrlVariables[button2.index] = button2.example;
        }
      });
      if (Object.keys(initialUrlVariables).length > 0) {
        setUrlButtonVariables((prev) => ({ ...prev, ...initialUrlVariables }));
      }
    }
  }, [templateUrlButtons]);
  const isFormValid = useMemo(() => {
    if (!triggerName.trim()) return false;
    if (!messageTemplate) return false;
    if (creatingTrigger) return false;
    if (templateUrlButtons.length > 0) {
      for (const button2 of templateUrlButtons) {
        if (!urlButtonVariables[button2.index] || urlButtonVariables[button2.index].trim() === "") {
          return false;
        }
      }
    }
    return true;
  }, [triggerName, messageTemplate, creatingTrigger, templateUrlButtons, urlButtonVariables]);
  return /* @__PURE__ */ jsx(
    Page,
    {
      title: "Create Abandoned Cart Trigger",
      subtitle: "Set up automated messages to recover abandoned shopping carts",
      backAction: {
        content: "Abandoned Cart Triggers",
        onAction: () => navigate("/app/auto-triggers/abandoned-cart")
      },
      primaryAction: {
        content: "Save Trigger",
        onAction: handleSave,
        disabled: !isFormValid,
        loading: creatingTrigger
      },
      secondaryActions: [
        {
          content: "Cancel",
          onAction: handleCancel
        }
      ],
      fullWidth: true,
      children: /* @__PURE__ */ jsxs(Grid, { children: [
        /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 8, lg: 8, xl: 8 }, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "500", children: [
          /* @__PURE__ */ jsx(Banner, { status: "info", children: /* @__PURE__ */ jsx(Text, { as: "p", children: "Create automated messages to recover abandoned shopping carts. Set up when and how messages are sent to customers who leave items in their cart." }) }),
          templateError && /* @__PURE__ */ jsx(Banner, { status: "critical", onDismiss: () => setTemplateError(null), children: /* @__PURE__ */ jsx(Text, { as: "p", children: templateError }) }),
          triggerError && /* @__PURE__ */ jsx(Banner, { status: "critical", onDismiss: () => setTriggerError(null), children: /* @__PURE__ */ jsx(Text, { as: "p", children: triggerError }) }),
          /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Basic Information" }),
            /* @__PURE__ */ jsxs(FormLayout, { children: [
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Trigger Name",
                  value: triggerName,
                  onChange: handleTriggerNameChange,
                  placeholder: "e.g., Abandoned Cart Recovery - 30 minutes",
                  helpText: "Give your trigger a descriptive name",
                  requiredIndicator: true
                }
              ),
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Trigger Type",
                  value: "Abandoned Cart Recovery",
                  disabled: true,
                  helpText: "This trigger is specifically for abandoned cart recovery"
                }
              )
            ] })
          ] }) }),
          /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Template Selection" }),
            /* @__PURE__ */ jsxs(FormLayout, { children: [
              loadingTemplates ? /* @__PURE__ */ jsxs("div", { style: { display: "flex", alignItems: "center", gap: "8px", padding: "12px" }, children: [
                /* @__PURE__ */ jsx(Spinner, { size: "small" }),
                /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", children: "Loading templates..." })
              ] }) : allTemplateOptions.length > 0 ? /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsx(
                  Autocomplete,
                  {
                    label: "Search and select template",
                    options: filteredTemplateOptions.map((template) => ({
                      value: template.id || template.value,
                      label: template.label
                    })),
                    selected: selectedTemplateId ? [selectedTemplateId] : [],
                    onSelect: (selected) => {
                      const selectedValue = selected[0];
                      if (selectedValue) {
                        handleTemplateChange(selectedValue);
                      }
                    },
                    textField: /* @__PURE__ */ jsx(
                      Autocomplete.TextField,
                      {
                        onChange: (value) => setTemplateInputValue(value),
                        label: "Search and select template",
                        value: templateInputValue,
                        placeholder: "Type to search templates...",
                        autoComplete: "off"
                      }
                    ),
                    loading: loadingTemplates || loadingTemplateDetails,
                    emptyState: loadingTemplates ? "Loading templates..." : "No templates found",
                    preferredPosition: "below",
                    willLoadMoreResults: false
                  }
                ),
                /* @__PURE__ */ jsxs(Text, { variant: "bodySm", tone: "subdued", children: [
                  "Found ",
                  allTemplateOptions.length,
                  " templates from API"
                ] }),
                selectedTemplateData && /* @__PURE__ */ jsx(Banner, { status: "info", children: /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                  "Template selected: ",
                  /* @__PURE__ */ jsx("strong", { children: (_a2 = allTemplateOptions.find((t) => t.id === selectedTemplateId || t.value === selectedTemplateId)) == null ? void 0 : _a2.label }),
                  loadingTemplateDetails && /* @__PURE__ */ jsx("span", { children: " (Loading details...)" })
                ] }) })
              ] }) : /* @__PURE__ */ jsx("div", { style: { padding: "12px", textAlign: "center" }, children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", children: "No templates available. Please check your API connection." }) }),
              /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", children: "Search and select from available templates" })
            ] })
          ] }) }),
          extractVariables.length > 0 && /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Variable Mapping" }),
            /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Map the template variables to actual data fields:" }),
            /* @__PURE__ */ jsx(FormLayout, { children: extractVariables.map((variable, index2) => /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: `Variable: {{${variable}}}`,
                  value: `{{${variable}}}`,
                  disabled: true,
                  helpText: "Template variable"
                }
              ),
              /* @__PURE__ */ jsx(
                Select,
                {
                  label: "Map to",
                  options: [
                    { label: "Select mapping...", value: "" },
                    ...availableVariables
                  ],
                  value: variableSelections[variable] || "",
                  onChange: (value) => handleVariableSelectionChange(variable, value),
                  placeholder: `${variable}`
                }
              )
            ] }, variable)) })
          ] }) }),
          Object.keys(templateMedia).length > 0 && /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Media Files" }),
            /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Upload media files required by this template:" }),
            /* @__PURE__ */ jsx(BlockStack, { gap: "400", children: Object.entries(templateMedia).map(([mediaKey, mediaData]) => {
              var _a3, _b2, _c, _d;
              const uploadedFile = (_a3 = mediaMapping[mediaKey]) == null ? void 0 : _a3.file;
              const fileUrl = ((_b2 = mediaMapping[mediaKey]) == null ? void 0 : _b2.fileUrl) || mediaData.url;
              const isUploading = uploadingMedia[mediaKey];
              const uploadError = (_c = mediaMapping[mediaKey]) == null ? void 0 : _c.uploadError;
              const isUploaded = (_d = mediaMapping[mediaKey]) == null ? void 0 : _d.uploaded;
              return /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsxs(InlineStack, { gap: "200", align: "space-between", blockAlign: "center", children: [
                  /* @__PURE__ */ jsxs(InlineStack, { gap: "200", blockAlign: "center", children: [
                    /* @__PURE__ */ jsx(
                      Thumbnail,
                      {
                        source: uploadedFile ? fileUrl : mediaData.url || (mediaData.type === "document" ? "📄" : "📁"),
                        alt: (uploadedFile == null ? void 0 : uploadedFile.name) || `Header ${mediaData.type}`,
                        size: "small"
                      }
                    ),
                    /* @__PURE__ */ jsxs(BlockStack, { gap: "050", children: [
                      /* @__PURE__ */ jsxs(InlineStack, { gap: "200", blockAlign: "center", children: [
                        /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: uploadedFile ? uploadedFile.name : `Header ${mediaData.type}` }),
                        isUploading && /* @__PURE__ */ jsx(Badge, { tone: "info", children: "Uploading..." }),
                        isUploaded && !isUploading && /* @__PURE__ */ jsx(Badge, { tone: "success", children: "Uploaded" })
                      ] }),
                      /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: uploadedFile ? `${(uploadedFile.size / 1024 / 1024).toFixed(2)} MB` : `Original ${mediaData.type}` }),
                      uploadError && /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "critical", children: [
                        "Error: ",
                        uploadError
                      ] })
                    ] })
                  ] }),
                  uploadedFile ? /* @__PURE__ */ jsxs(InlineStack, { gap: "100", children: [
                    /* @__PURE__ */ jsx(
                      Button,
                      {
                        variant: "plain",
                        tone: "critical",
                        size: "slim",
                        onClick: () => handleMediaMappingChange(mediaKey, null),
                        disabled: isUploading,
                        children: "Remove"
                      }
                    ),
                    /* @__PURE__ */ jsx(
                      Button,
                      {
                        variant: "plain",
                        size: "slim",
                        onClick: () => document.getElementById(`upload-${mediaKey}`).click(),
                        disabled: isUploading,
                        children: "Replace"
                      }
                    )
                  ] }) : /* @__PURE__ */ jsxs(
                    Button,
                    {
                      variant: "plain",
                      size: "slim",
                      onClick: () => document.getElementById(`upload-${mediaKey}`).click(),
                      disabled: isUploading,
                      loading: isUploading,
                      children: [
                        "Upload ",
                        mediaData.type
                      ]
                    }
                  )
                ] }),
                /* @__PURE__ */ jsx(
                  "input",
                  {
                    id: `upload-${mediaKey}`,
                    type: "file",
                    accept: mediaData.type === "image" ? "image/*" : mediaData.type === "video" ? "video/*" : "application/pdf,.doc,.docx,.txt",
                    style: { display: "none" },
                    onChange: (e) => {
                      var _a4;
                      if (((_a4 = e.target.files) == null ? void 0 : _a4.length) > 0) {
                        handleMediaMappingChange(mediaKey, e.target.files[0]);
                      }
                    }
                  }
                )
              ] }, mediaKey);
            }) })
          ] }) }),
          templateUrlButtons.length > 0 && /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "URL Button Variables" }),
            /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Configure the default values for URL button variables:" }),
            /* @__PURE__ */ jsx(FormLayout, { children: templateUrlButtons.map((button2, index2) => /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: `Button: ${button2.text}`,
                  value: button2.url,
                  disabled: true,
                  helpText: "URL template with variable placeholder"
                }
              ),
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Default Value",
                  value: urlButtonVariables[button2.index] || button2.example,
                  onChange: (value) => handleUrlButtonVariableChange(button2.index, value),
                  placeholder: "Enter default URL value",
                  helpText: "This value will replace the variable in the URL"
                }
              )
            ] }, `url_button_${button2.index}`)) })
          ] }) }),
          /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Timing Settings" }),
            /* @__PURE__ */ jsx(FormLayout, { children: /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Delay Time",
                  type: "number",
                  value: delayTime,
                  onChange: handleDelayTimeChange,
                  min: "1",
                  helpText: "How long to wait before sending the message"
                }
              ),
              /* @__PURE__ */ jsx(
                Select,
                {
                  label: "Delay Unit",
                  options: delayUnitOptions,
                  value: delayUnit,
                  onChange: handleDelayUnitChange
                }
              )
            ] }) })
          ] }) }),
          /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Target Audience" }),
            /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
              /* @__PURE__ */ jsx(Text, { as: "p", tone: "subdued", children: "This trigger will target customers who abandon their shopping carts." }),
              /* @__PURE__ */ jsx(
                Checkbox,
                {
                  label: "Abandoned Cart Customers",
                  checked: true,
                  disabled: true,
                  helpText: "This audience is automatically selected for abandoned cart triggers"
                }
              ),
              /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                /* @__PURE__ */ jsx(
                  Checkbox,
                  {
                    label: "Do you want to filter target customers based on your product category/collection?",
                    checked: filterByCollection,
                    onChange: handleFilterByCollectionChange,
                    helpText: "Filter customers based on the products they have in their abandoned cart"
                  }
                ),
                filterByCollection && /* @__PURE__ */ jsxs(FormLayout, { children: [
                  collectionsError && /* @__PURE__ */ jsx(
                    Banner,
                    {
                      title: "Collections Error",
                      tone: "critical",
                      onDismiss: () => setCollectionsError(null),
                      children: /* @__PURE__ */ jsx("p", { children: collectionsError })
                    }
                  ),
                  loadingCollections && /* @__PURE__ */ jsxs(InlineStack, { gap: "200", align: "center", children: [
                    /* @__PURE__ */ jsx(Spinner, { accessibilityLabel: "Loading collections", size: "small" }),
                    /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Loading collections..." })
                  ] }),
                  /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                    /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                      /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "h3", children: "Select Collections (Maximum 5)" }),
                      /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: selectedCollections.length >= 5 ? "critical" : "subdued", children: [
                        selectedCollections.length,
                        "/5 selected"
                      ] })
                    ] }),
                    selectedCollections.length > 0 && /* @__PURE__ */ jsx(InlineStack, { gap: "100", wrap: true, children: selectedCollections.map((collectionValue, index2) => {
                      const collectionOption = collectionOptions.find((opt) => opt.value === collectionValue);
                      const displayLabel = collectionOption ? collectionOption.label : collectionValue;
                      return /* @__PURE__ */ jsx(
                        Tag,
                        {
                          onRemove: () => handleCollectionRemove(collectionValue),
                          children: displayLabel
                        },
                        collectionValue
                      );
                    }) }),
                    /* @__PURE__ */ jsx(
                      Combobox,
                      {
                        activator: /* @__PURE__ */ jsx(
                          Combobox.TextField,
                          {
                            onChange: handleCollectionInputChange,
                            label: "",
                            labelHidden: true,
                            value: collectionInputValue,
                            placeholder: loadingCollections ? "Loading collections..." : selectedCollections.length >= 5 ? "Maximum 5 collections selected" : "Search and select collections...",
                            autoComplete: "off",
                            disabled: selectedCollections.length >= 5 || loadingCollections
                          }
                        ),
                        children: filteredCollectionOptions.length > 0 ? /* @__PURE__ */ jsx(Listbox, { onSelect: handleCollectionSelect, children: filteredCollectionOptions.map((option) => /* @__PURE__ */ jsx(
                          Listbox.Option,
                          {
                            value: option.value,
                            selected: selectedCollections.includes(option.value),
                            disabled: selectedCollections.includes(option.value),
                            children: option.label
                          },
                          option.value
                        )) }) : /* @__PURE__ */ jsx(Listbox, { children: /* @__PURE__ */ jsx(Listbox.Option, { value: "", disabled: true, children: loadingCollections ? "Loading collections..." : selectedCollections.length >= 5 ? "Maximum collections selected" : "No collections found" }) })
                      }
                    ),
                    /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Only customers who have products from the selected collections in their cart will receive this trigger. Maximum 5 collections allowed." })
                  ] })
                ] })
              ] })
            ] })
          ] }) }),
          /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsx(InlineStack, { align: "end", children: /* @__PURE__ */ jsxs(ButtonGroup, { children: [
            /* @__PURE__ */ jsx(Button, { onClick: handleCancel, disabled: creatingTrigger, children: "Cancel" }),
            /* @__PURE__ */ jsx(
              Button,
              {
                variant: "primary",
                onClick: handleSave,
                disabled: !isFormValid,
                loading: creatingTrigger,
                children: "Save Trigger"
              }
            )
          ] }) }) })
        ] }) }),
        /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 4, lg: 4, xl: 4 }, children: /* @__PURE__ */ jsx("div", { style: {
          position: "sticky",
          top: "20px",
          alignSelf: "flex-start",
          zIndex: 10
        }, children: /* @__PURE__ */ jsx(BlockStack, { gap: "500", children: /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Message Preview" }),
          messageTemplate ? /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
            /* @__PURE__ */ jsx(Text, { as: "p", tone: "", children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", children: ((_b = allTemplateOptions == null ? void 0 : allTemplateOptions.find((option) => option.value === selectedTemplate || option.id === selectedTemplateId)) == null ? void 0 : _b.label) || "Selected Template" }) }),
            /* @__PURE__ */ jsx(Card, { sectioned: true, background: "bg-surface-secondary", children: /* @__PURE__ */ jsx(
              WhatsAppPreview,
              {
                template: selectedTemplateData || messageTemplate,
                variant: "bubble",
                maxWidth: "280px",
                mediaMapping
              }
            ) }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
              "Variables like ",
              `{`,
              `{`,
              `customer_name`,
              `}`,
              `}`,
              " or ",
              `{`,
              `{`,
              `1`,
              `}`,
              `}`,
              " will be replaced with actual customer data when sent."
            ] })
          ] }) : /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
            /* @__PURE__ */ jsx(Text, { as: "p", tone: "subdued", children: "Select a template to see the preview" }),
            /* @__PURE__ */ jsx(LegacyCard, { sectioned: true, children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Your message preview will appear here once you select a template." }) })
          ] })
        ] }) }) }) }) })
      ] })
    }
  );
}
const route21 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: CreateAbandonedCartTriggerPage
}, Symbol.toStringTag, { value: "Module" }));
const fetchOrderConfirmationTriggerList = async (options = {}) => {
  const {
    page = 1,
    perPageData = 20,
    TriggerCategory = 2
  } = options;
  try {
    const url = new URL(buildApiUrl(`${ENDPOINTS.ORDER_CONFIRMATION.BASE}/${ENDPOINTS.ORDER_CONFIRMATION.GET_ORDER_CONFIRMATION_LIST}`));
    url.searchParams.append("page", page.toString());
    url.searchParams.append("perPageData", perPageData.toString());
    url.searchParams.append("TriggerCategory", TriggerCategory.toString());
    url.searchParams.append("token", API_TOKEN);
    const response = await fetch(url.toString(), {
      method: "GET",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json"
      }
    });
    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }
    const data = await response.json();
    return data;
  } catch (error) {
    console.error("Error fetching order confirmation list:", error);
    throw error;
  }
};
const transformTriggerData = (apiTrigger) => {
  return {
    id: apiTrigger.id.toString(),
    triggerName: apiTrigger.triggerName || "Unnamed Trigger",
    templateName: apiTrigger.template_name || "Unnamed Template",
    collections: ["All products"],
    lastUpdated: new Date(apiTrigger.updated_at).toLocaleDateString("en-US", {
      year: "numeric",
      month: "2-digit",
      day: "2-digit"
    }),
    isActive: apiTrigger.status === 1,
    originalData: apiTrigger
    // Store original API data for reference
  };
};
function TriggerIndexTable$2({ triggers, onToggleStatus, onViewTemplate, loading }) {
  useNavigate();
  const resourceName = {
    singular: "trigger",
    plural: "triggers"
  };
  const { selectedResources, allResourcesSelected, handleSelectionChange } = useIndexResourceState(triggers);
  const handleToggleActive = useCallback((triggerId, event) => {
    event.stopPropagation();
    onToggleStatus(triggerId);
  }, [onToggleStatus]);
  const handleViewTemplateTrigger = useCallback((triggerId, event) => {
    event.stopPropagation();
    onViewTemplate(triggerId);
  }, [onViewTemplate]);
  if (loading) {
    return /* @__PURE__ */ jsxs("div", { style: { padding: "40px", textAlign: "center" }, children: [
      /* @__PURE__ */ jsx(Spinner, { size: "large" }),
      /* @__PURE__ */ jsx(Text, { variant: "bodyMd", color: "subdued", as: "p", alignment: "center", children: "Loading order confirmation triggers..." })
    ] });
  }
  if (triggers.length === 0) {
    return /* @__PURE__ */ jsx("div", { style: { padding: "40px", textAlign: "center" }, children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", color: "subdued", as: "p", alignment: "center", children: "No order confirmation triggers found matching your search criteria." }) });
  }
  const rowMarkup = triggers.map(
    ({ id, triggerName, templateName, collections, lastUpdated: lastUpdated2, isActive }, index2) => /* @__PURE__ */ jsxs(
      IndexTable.Row,
      {
        id,
        selected: selectedResources.includes(id),
        position: index2,
        children: [
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", fontWeight: "bold", children: triggerName }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: templateName }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: lastUpdated2 }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Badge, { tone: isActive ? "success" : "critical", children: isActive ? "Active" : "Inactive" }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: collections.join(", ").length > 15 ? collections.join(", ").slice(0, 15) + "..." : collections.join(", ") }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(InlineStack, { children: /* @__PURE__ */ jsx(
            Button,
            {
              size: "slim",
              onClick: (event) => handleToggleActive(id, event),
              children: isActive ? "Deactivate" : "Activate"
            }
          ) }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(InlineStack, { align: "end", children: /* @__PURE__ */ jsx(Tooltip, { content: "view template", children: /* @__PURE__ */ jsx(
            Button,
            {
              size: "slim",
              icon: ViewIcon,
              onClick: (event) => handleViewTemplateTrigger(id, event)
            }
          ) }) }) })
        ]
      },
      id
    )
  );
  return /* @__PURE__ */ jsx(
    IndexTable,
    {
      resourceName,
      itemCount: triggers.length,
      selectedItemsCount: allResourcesSelected ? "All" : selectedResources.length,
      onSelectionChange: handleSelectionChange,
      headings: [
        { title: "Trigger Name" },
        { title: "Template Name" },
        { title: "Last Updated" },
        { title: "Status" },
        { title: "Collections" },
        { title: "Actions" },
        { title: "" }
      ],
      children: rowMarkup
    }
  );
}
function OrderConfirmationTriggersPage() {
  const navigate = useNavigate();
  const [orderConfirmationData, setOrderConfirmationData] = useState([]);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);
  const [selectedTrigger, setSelectedTrigger] = useState(null);
  const [previewModalActive, setPreviewModalActive] = useState(false);
  const [selectedTemplateData, setSelectedTemplateData] = useState(null);
  const [loadingTemplateDetails, setLoadingTemplateDetails] = useState(false);
  const [templateError, setTemplateError] = useState(null);
  const [queryValue, setQueryValue] = useState("");
  const [sortSelected, setSortSelected] = useState(["triggerName asc"]);
  const [statusFilter, setStatusFilter2] = useState([]);
  const [collectionFilter, setCollectionFilter] = useState([]);
  const [pagination, setPagination] = useState({
    currentPage: 1,
    totalPages: 1,
    total: 0,
    perPage: 20
  });
  const { mode: mode2, setMode } = useSetIndexFiltersMode();
  const fetchTriggers = useCallback(async (page = 1) => {
    try {
      setLoading(true);
      setError(null);
      const response = await fetchOrderConfirmationTriggerList({
        page,
        perPageData: 20,
        TriggerCategory: 2
      });
      if (response.status && response.data) {
        const transformedTriggers = response.data.data.map(transformTriggerData);
        setOrderConfirmationData(transformedTriggers);
        setPagination({
          currentPage: response.data.current_page,
          totalPages: response.data.last_page,
          total: response.data.total,
          perPage: response.data.per_page
        });
      } else {
        throw new Error("Invalid API response format");
      }
    } catch (err) {
      console.error("Error fetching order confirmation triggers:", err);
      setError("Failed to load order confirmation triggers. Please try again.");
      setOrderConfirmationData([]);
    } finally {
      setLoading(false);
    }
  }, []);
  useEffect(() => {
    fetchTriggers();
  }, [fetchTriggers]);
  const fetchTemplateDetails = useCallback(async (templateName) => {
    if (!templateName || templateName === "No Template") {
      return null;
    }
    try {
      setLoadingTemplateDetails(true);
      setTemplateError(null);
      const templateData = await getSelectedTemplatebyName(templateName);
      setSelectedTemplateData(templateData);
      return templateData;
    } catch (error2) {
      console.error("Error fetching template details:", error2);
      setTemplateError(error2.message || "Failed to fetch template details");
      return null;
    } finally {
      setLoadingTemplateDetails(false);
    }
  }, []);
  const handleFiltersQueryChange = useCallback((value) => {
    setQueryValue(value);
  }, []);
  const handleQueryValueRemove = useCallback(() => setQueryValue(""), []);
  const handleStatusChange = useCallback((value) => {
    setStatusFilter2(value);
  }, []);
  const handleCollectionChange = useCallback((value) => {
    setCollectionFilter(value);
  }, []);
  const handleStatusRemove = useCallback(() => setStatusFilter2([]), []);
  const handleCollectionRemove = useCallback(() => setCollectionFilter([]), []);
  const handleFiltersClearAll = useCallback(() => {
    handleStatusRemove();
    handleCollectionRemove();
    handleQueryValueRemove();
  }, [handleStatusRemove, handleCollectionRemove, handleQueryValueRemove]);
  const filteredTriggers = useMemo(() => {
    if (!Array.isArray(orderConfirmationData)) return [];
    return orderConfirmationData.filter((trigger) => {
      var _a2, _b, _c, _d;
      const matchesSearch = !queryValue.trim() || (((_a2 = trigger.triggerName) == null ? void 0 : _a2.toLowerCase().includes(queryValue.toLowerCase())) || ((_b = trigger.templateName) == null ? void 0 : _b.toLowerCase().includes(queryValue.toLowerCase())) || ((_c = trigger.collections) == null ? void 0 : _c.some(
        (collection) => collection.toLowerCase().includes(queryValue.toLowerCase())
      )));
      const matchesStatus = !Array.isArray(statusFilter) || statusFilter.length === 0 || statusFilter.includes(trigger.isActive ? "active" : "inactive");
      const matchesCollection = !Array.isArray(collectionFilter) || collectionFilter.length === 0 || ((_d = trigger.collections) == null ? void 0 : _d.some((collection) => collectionFilter.includes(collection.toLowerCase())));
      return matchesSearch && matchesStatus && matchesCollection;
    });
  }, [orderConfirmationData, queryValue, statusFilter, collectionFilter]);
  const sortOptions = [
    { label: "Trigger Name", value: "triggerName asc", directionLabel: "A-Z" },
    { label: "Trigger Name", value: "triggerName desc", directionLabel: "Z-A" },
    { label: "Template Name", value: "templateName asc", directionLabel: "A-Z" },
    { label: "Template Name", value: "templateName desc", directionLabel: "Z-A" },
    { label: "Last Updated", value: "lastUpdated asc", directionLabel: "Oldest first" },
    { label: "Last Updated", value: "lastUpdated desc", directionLabel: "Newest first" }
  ];
  const filters = [
    {
      key: "status",
      label: "Status",
      filter: /* @__PURE__ */ jsx(
        ChoiceList,
        {
          title: "Status",
          titleHidden: true,
          choices: [
            { label: "Active", value: "active" },
            { label: "Inactive", value: "inactive" }
          ],
          selected: statusFilter || [],
          onChange: handleStatusChange,
          allowMultiple: true
        }
      ),
      shortcut: true
    },
    {
      key: "collection",
      label: "Collection",
      filter: /* @__PURE__ */ jsx(
        ChoiceList,
        {
          title: "Collection",
          titleHidden: true,
          choices: [
            { label: "All Products", value: "all products" },
            { label: "Electronics", value: "electronics" },
            { label: "Clothing", value: "clothing" },
            { label: "Home & Garden", value: "home & garden" }
          ],
          selected: collectionFilter || [],
          onChange: handleCollectionChange,
          allowMultiple: true
        }
      ),
      shortcut: true
    }
  ];
  const appliedFilters = [];
  if (Array.isArray(statusFilter) && statusFilter.length > 0) {
    appliedFilters.push({
      key: "status",
      label: `Status: ${statusFilter.map((s) => s.charAt(0).toUpperCase() + s.slice(1)).join(", ")}`,
      onRemove: handleStatusRemove
    });
  }
  if (Array.isArray(collectionFilter) && collectionFilter.length > 0) {
    appliedFilters.push({
      key: "collection",
      label: `Collection: ${collectionFilter.map((c) => c.charAt(0).toUpperCase() + c.slice(1)).join(", ")}`,
      onRemove: handleCollectionRemove
    });
  }
  const handleCreateTrigger = useCallback(() => {
    navigate("/app/auto-triggers/create-order-confirmation");
  }, [navigate]);
  const handlePageChange = useCallback((page) => {
    fetchTriggers(page);
  }, [fetchTriggers]);
  const handleRefresh = useCallback(() => {
    fetchTriggers(pagination.currentPage);
  }, [fetchTriggers, pagination.currentPage]);
  const dismissError = useCallback(() => {
    setError(null);
  }, []);
  const handleViewTemplateTrigger = useCallback(async (triggerId) => {
    const trigger = orderConfirmationData.find((t) => t.id === triggerId);
    if (!trigger) return;
    setSelectedTrigger(trigger);
    setSelectedTemplateData(null);
    setTemplateError(null);
    setPreviewModalActive(true);
    if (trigger.templateName && trigger.templateName !== "No Template") {
      await fetchTemplateDetails(trigger.templateName);
    }
  }, [orderConfirmationData, fetchTemplateDetails]);
  const handleModalClose = useCallback(() => {
    setPreviewModalActive(false);
    setSelectedTrigger(null);
    setSelectedTemplateData(null);
    setTemplateError(null);
    setLoadingTemplateDetails(false);
  }, []);
  const handleToggleStatus = useCallback((triggerId) => {
    setOrderConfirmationData(
      (prev) => prev.map((trigger) => {
        if (trigger.id === triggerId) {
          return { ...trigger, isActive: !trigger.isActive };
        } else {
          const clickedTrigger = prev.find((t) => t.id === triggerId);
          if (clickedTrigger && !clickedTrigger.isActive) {
            return { ...trigger, isActive: false };
          }
          return trigger;
        }
      })
    );
  }, []);
  return /* @__PURE__ */ jsxs(
    Page,
    {
      title: "Order Confirmation Triggers",
      subtitle: "Send automated order updates and confirmations via WhatsApp",
      fullWidth: true,
      primaryAction: {
        content: /* @__PURE__ */ jsx(InlineStack, { alignment: "center", children: /* @__PURE__ */ jsx(Text, { as: "span", children: "Create Order Trigger" }) }),
        onAction: handleCreateTrigger
      },
      secondaryActions: [
        {
          content: "Refresh",
          onAction: handleRefresh
        },
        {
          content: "Back to Auto Triggers",
          onAction: () => navigate("/app/auto-triggers")
        }
      ],
      children: [
        error && /* @__PURE__ */ jsx(
          Banner,
          {
            title: "Error loading triggers",
            tone: "critical",
            onDismiss: dismissError,
            children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: error })
          }
        ),
        /* @__PURE__ */ jsxs(LegacyCard, { children: [
          /* @__PURE__ */ jsx(
            IndexFilters,
            {
              sortOptions,
              sortSelected,
              queryValue,
              queryPlaceholder: "Search triggers by name, template, collection...",
              onQueryChange: handleFiltersQueryChange,
              onQueryClear: handleQueryValueRemove,
              onSort: setSortSelected,
              filters,
              appliedFilters,
              onClearAll: handleFiltersClearAll,
              mode: mode2,
              setMode,
              tabs: [],
              selected: 0,
              onSelect: () => {
              }
            }
          ),
          /* @__PURE__ */ jsx(
            TriggerIndexTable$2,
            {
              triggers: filteredTriggers,
              onToggleStatus: handleToggleStatus,
              onViewTemplate: handleViewTemplateTrigger,
              loading
            }
          ),
          !loading && pagination.totalPages > 1 && /* @__PURE__ */ jsx(LegacyCard.Section, { children: /* @__PURE__ */ jsx(InlineStack, { align: "center", children: /* @__PURE__ */ jsx(
            Pagination,
            {
              hasPrevious: pagination.currentPage > 1,
              onPrevious: () => handlePageChange(pagination.currentPage - 1),
              hasNext: pagination.currentPage < pagination.totalPages,
              onNext: () => handlePageChange(pagination.currentPage + 1),
              label: `Page ${pagination.currentPage} of ${pagination.totalPages}`
            }
          ) }) })
        ] }),
        selectedTrigger && /* @__PURE__ */ jsx(
          Modal,
          {
            open: previewModalActive,
            onClose: handleModalClose,
            title: `Preview: ${selectedTrigger.triggerName}`,
            primaryAction: {
              content: "Close",
              onAction: handleModalClose
            },
            children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsx(InlineStack, { gap: "200", children: /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: selectedTrigger.triggerName }),
                  /* @__PURE__ */ jsxs(Text, { variant: "bodyLg", as: "p", children: [
                    "Template: ",
                    selectedTrigger.templateName
                  ] })
                ] }) }),
                /* @__PURE__ */ jsx(InlineStack, { gap: "200", children: /* @__PURE__ */ jsx(Badge, { tone: selectedTrigger.isActive ? "success" : "critical", children: selectedTrigger.isActive ? "Active" : "Inactive" }) })
              ] }),
              /* @__PURE__ */ jsxs(TextContainer, { children: [
                /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                  /* @__PURE__ */ jsx("strong", { children: "Collections:" }),
                  " ",
                  selectedTrigger.collections.join(", ")
                ] }),
                /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                  /* @__PURE__ */ jsx("strong", { children: "Last Updated:" }),
                  " ",
                  selectedTrigger.lastUpdated
                ] })
              ] }),
              templateError && /* @__PURE__ */ jsx(
                Banner,
                {
                  title: "Template Loading Error",
                  tone: "critical",
                  onDismiss: () => setTemplateError(null),
                  children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: templateError })
                }
              ),
              /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h4", children: "WhatsApp Template Preview" }),
                loadingTemplateDetails ? /* @__PURE__ */ jsxs("div", { style: { textAlign: "center", padding: "40px 20px" }, children: [
                  /* @__PURE__ */ jsx(Spinner, { accessibilityLabel: "Loading template details", size: "large" }),
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", alignment: "center", children: "Loading template details..." })
                ] }) : selectedTemplateData ? /* @__PURE__ */ jsx(
                  WhatsAppPreview,
                  {
                    template: selectedTemplateData,
                    variant: "full",
                    showWhatsAppHeader: true
                  }
                ) : /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: selectedTrigger.templateName === "No Template" ? "No template assigned to this trigger" : `Template preview not available for "${selectedTrigger.templateName}"` })
              ] })
            ] }) })
          }
        )
      ]
    }
  );
}
const route22 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: OrderConfirmationTriggersPage
}, Symbol.toStringTag, { value: "Module" }));
const createAutoReply = async (createAutoReplyPayload) => {
  try {
    const url = `https://app.getgabs.com/partners/automation/autoreply/create`;
    const response = await fetch(url, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json",
        "Authorization": `Bearer ${API_TOKEN}`,
        "X-Requested-With": "XMLHttpRequest"
      },
      body: JSON.stringify(createAutoReplyPayload)
    });
    const maybeJson = await response.json().catch(() => null);
    if (!response.ok) {
      const message = maybeJson && (maybeJson.message || maybeJson.error) || `HTTP ${response.status}`;
      throw new Error(message);
    }
    const data = maybeJson ?? {};
    const success = (data == null ? void 0 : data.status) === true || (data == null ? void 0 : data.success) === true || (data == null ? void 0 : data.status) === "success";
    if (!success) {
      throw new Error((data == null ? void 0 : data.message) || "Create auto reply failed");
    }
    console.log("create auto reply", data);
    return data;
  } catch (error) {
    console.error("Error creating auto reply:", error);
    throw error;
  }
};
const fetchAutoReplyList = async (options = {}) => {
  const {
    statusType = "All",
    page = 1,
    perPageData = 10,
    search = "",
    token = API_TOKEN
  } = options;
  try {
    const url = new URL("https://app.getgabs.com/partners/automation/autoreply/fetchautoreplies");
    url.searchParams.append("statusType", statusType);
    url.searchParams.append("perPageData", perPageData.toString());
    url.searchParams.append("search", search);
    url.searchParams.append("token", token);
    if (page) url.searchParams.append("page", page.toString());
    const response = await fetch(url.toString(), {
      method: "GET",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json"
      }
    });
    if (!response.ok) {
      throw new Error(`HTTP error! Status: ${response.status}`);
    }
    const data = await response.json();
    return data;
  } catch (error) {
    console.error("Error fetching auto reply list:", error);
    throw error;
  }
};
const deleteAutoReply = async (autoReplyId) => {
  try {
    const url = `https://app.getgabs.com/partners/automation/delete/Autoreply`;
    const response = await fetch(url, {
      method: "POST",
      headers: {
        "Accept": "application/json",
        "Authorization": `Bearer ${API_TOKEN}`,
        "X-Requested-With": "XMLHttpRequest"
      },
      body: JSON.stringify({ id: autoReplyId })
    });
    const maybeJson = await response.json().catch(() => null);
    if (!response.ok) {
      const message = maybeJson && (maybeJson.message || maybeJson.error) || `HTTP ${response.status}`;
      throw new Error(message);
    }
    const data = maybeJson ?? {};
    const success = (data == null ? void 0 : data.status) === true || (data == null ? void 0 : data.success) === true || (data == null ? void 0 : data.status) === "success";
    if (!success) {
      throw new Error((data == null ? void 0 : data.message) || "Delete failed");
    }
    console.log("delete auto reply", data);
    return data;
  } catch (error) {
    console.error("Error deleting auto reply:", error);
    throw error;
  }
};
function CreateAutoReplyTriggerPage() {
  var _a2, _b;
  const navigate = useNavigate();
  const [selectedTemplate, setSelectedTemplate] = useState("");
  const [selectedTemplateId, setSelectedTemplateId] = useState("");
  const [templateInputValue, setTemplateInputValue] = useState("");
  const [messageTemplate, setMessageTemplate] = useState("");
  const [isActive, setIsActive] = useState(true);
  const [keywords, setKeywords] = useState("");
  const [variableSelections, setVariableSelections] = useState({});
  const [messageType, setMessageType] = useState("");
  const [customServiceMessage, setCustomServiceMessage] = useState("");
  const [selectedText, setSelectedText] = useState("");
  const [cursorPosition, setCursorPosition] = useState(0);
  const [apiTemplates, setApiTemplates] = useState([]);
  const [loadingTemplates, setLoadingTemplates] = useState(false);
  const [templateError, setTemplateError] = useState(null);
  const [selectedTemplateData, setSelectedTemplateData] = useState(null);
  const [loadingTemplateDetails, setLoadingTemplateDetails] = useState(false);
  const [mediaMapping, setMediaMapping] = useState({});
  const [uploadingMedia, setUploadingMedia] = useState({});
  const [urlButtonVariables, setUrlButtonVariables] = useState({});
  const [creatingAutoReply, setCreatingAutoReply] = useState(false);
  const [autoReplyError, setAutoReplyError] = useState(null);
  const [conditionType, setConditionType] = useState("Equal");
  const [availableVariables, setAvailableVariables] = useState([]);
  const [loadingVariables, setLoadingVariables] = useState(true);
  const [showVariablesModal, setShowVariablesModal] = useState(false);
  const [variableSearchQuery, setVariableSearchQuery] = useState("");
  const [variableInputValues, setVariableInputValues] = useState({});
  const fetchApiTemplates2 = useCallback(async () => {
    try {
      setLoadingTemplates(true);
      setTemplateError(null);
      const response = await getAllTemplateList();
      if (response.status && response.data && response.data.customtemplates) {
        const transformedTemplates = response.data.customtemplates.map((template) => ({
          id: template.template_id ? template.template_id.toString() : "unknown",
          name: template.template_name || "Unknown Template",
          templateId: template.template_id,
          userId: template.user_id,
          label: template.template_name || "Unknown Template",
          value: template.template_id ? template.template_id.toString() : "unknown"
        }));
        setApiTemplates(transformedTemplates);
      } else {
        console.error("Invalid API response format:", response);
        setApiTemplates([]);
      }
    } catch (error) {
      console.error("Error fetching templates:", error);
      setTemplateError(`Failed to load templates: ${error.message}`);
      setApiTemplates([]);
    } finally {
      setLoadingTemplates(false);
    }
  }, []);
  useEffect(() => {
    fetchApiTemplates2();
  }, [fetchApiTemplates2]);
  const allTemplateOptions = useMemo(() => {
    console.log("Template options:", {
      api: apiTemplates.length,
      total: apiTemplates.length,
      apiTemplates
    });
    return apiTemplates;
  }, [apiTemplates]);
  const filteredTemplateOptions = useMemo(() => {
    if (!templateInputValue.trim()) return allTemplateOptions;
    const searchLower = templateInputValue.toLowerCase();
    return allTemplateOptions.filter(
      (template) => {
        var _a3, _b2;
        return ((_a3 = template.label) == null ? void 0 : _a3.toLowerCase().includes(searchLower)) || ((_b2 = template.name) == null ? void 0 : _b2.toLowerCase().includes(searchLower));
      }
    );
  }, [allTemplateOptions, templateInputValue]);
  const handleTemplateChange = useCallback(async (value) => {
    setSelectedTemplateId(value);
    const selectedTemplate2 = allTemplateOptions.find((t) => t.id === value || t.value === value);
    if (selectedTemplate2) {
      setTemplateInputValue(selectedTemplate2.label);
      setSelectedTemplate(selectedTemplate2.value);
      try {
        setLoadingTemplateDetails(true);
        setTemplateError(null);
        const response = await getSelectedTemplatebyName(selectedTemplate2.name);
        if (response.data && response.data.length > 0) {
          const templateData = response.data[0];
          setSelectedTemplateData(templateData);
          let templateContent = "";
          if (templateData.components) {
            templateData.components.forEach((component) => {
              if (component.type === "HEADER" && component.text) {
                templateContent += component.text + "\n\n";
              } else if (component.type === "BODY" && component.text) {
                templateContent += component.text + "\n\n";
              } else if (component.type === "FOOTER" && component.text) {
                templateContent += component.text;
              }
            });
          }
          setMessageTemplate(templateContent.trim());
        } else {
          console.error("No template data found");
          setTemplateError("Template not found or invalid");
          setSelectedTemplateData(null);
        }
      } catch (error) {
        console.error("Error fetching template details:", error);
        setTemplateError(`Failed to load template: ${error.message}`);
        setSelectedTemplateData(null);
      } finally {
        setLoadingTemplateDetails(false);
      }
    } else {
      setTemplateInputValue("");
      setSelectedTemplate("");
      setMessageTemplate("");
      setSelectedTemplateData(null);
    }
    setVariableSelections({});
    setVariableInputValues({});
    setMediaMapping({});
    setUrlButtonVariables({});
  }, [allTemplateOptions]);
  const handleMediaMappingChange = useCallback(async (mediaKey, file) => {
    if (file) {
      setUploadingMedia((prev) => ({ ...prev, [mediaKey]: true }));
      try {
        const reader = new FileReader();
        reader.onload = async () => {
          try {
            const base64String = reader.result.split(",")[1];
            let fileType = "image";
            if (file.type.startsWith("video/")) {
              fileType = "video";
            } else if (file.type.startsWith("audio/")) {
              fileType = "audio";
            } else if (file.type.includes("pdf") || file.type.includes("document") || file.type.includes("text")) {
              fileType = "document";
            }
            const filePayload = {
              fileName: file.name,
              fileSrc: `data:${file.type};base64,${base64String}`,
              fileType
            };
            const uploadResponse = await saveTemporaryFile(filePayload);
            if (uploadResponse.status && uploadResponse.filename) {
              const getGabsUrl = `https://app.getgabs.com/customers/mediafile/newfiles/uploads/${uploadResponse.filename}`;
              setMediaMapping((prev) => ({
                ...prev,
                [mediaKey]: {
                  ...prev[mediaKey],
                  file,
                  fileUrl: getGabsUrl,
                  fileName: uploadResponse.filename,
                  uploaded: true,
                  uploadError: null
                }
              }));
            } else {
              throw new Error(uploadResponse.message || "Failed to upload file");
            }
          } catch (error) {
            console.error("Error uploading file:", error);
            setMediaMapping((prev) => ({
              ...prev,
              [mediaKey]: {
                ...prev[mediaKey],
                uploadError: error.message
              }
            }));
            setTemplateError(`Failed to upload file: ${error.message}`);
          } finally {
            setUploadingMedia((prev) => ({ ...prev, [mediaKey]: false }));
          }
        };
        reader.onerror = () => {
          setTemplateError("Failed to read file");
          setUploadingMedia((prev) => ({ ...prev, [mediaKey]: false }));
        };
        reader.readAsDataURL(file);
      } catch (error) {
        console.error("Error uploading file:", error);
        setTemplateError(`Failed to upload file: ${error.message}`);
        setUploadingMedia((prev) => ({ ...prev, [mediaKey]: false }));
      }
    } else {
      setMediaMapping((prev) => ({
        ...prev,
        [mediaKey]: {
          ...prev[mediaKey],
          file: null,
          fileUrl: null,
          fileName: null,
          uploaded: false,
          uploadError: null
        }
      }));
    }
  }, []);
  useCallback((value) => setMessageTemplate(value), []);
  useCallback((value) => setIsActive(value), []);
  const handleKeywordsChange = useCallback((value) => setKeywords(value), []);
  const handleVariableSelectionChange = useCallback((variable, value) => {
    setVariableSelections((prev) => ({
      ...prev,
      [variable]: value
    }));
  }, []);
  const handleUrlButtonVariableChange = useCallback((buttonIndex, value) => {
    setUrlButtonVariables((prev) => ({
      ...prev,
      [buttonIndex]: value
    }));
  }, []);
  const handleMessageTypeChange = useCallback((value) => {
    setMessageType(value);
    setSelectedTemplate("");
    setCustomServiceMessage("");
    setMessageTemplate("");
  }, []);
  const handleCustomServiceMessageChange = useCallback((value) => {
    setCustomServiceMessage(value);
    setMessageTemplate(value);
  }, []);
  const handleConditionTypeChange = useCallback((value) => {
    setConditionType(value);
  }, []);
  const handleTextSelection = useCallback((event) => {
    const textarea = event.target;
    setSelectedText(textarea.value.substring(textarea.selectionStart, textarea.selectionEnd));
    setCursorPosition(textarea.selectionStart);
  }, []);
  const applyFormatting = useCallback((format) => {
    const textarea = document.querySelector("#custom-service-message");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const end = textarea.selectionEnd;
    const selectedText2 = textarea.value.substring(start, end);
    let formattedText = "";
    let cursorOffset = 0;
    if (selectedText2) {
      switch (format) {
        case "bold":
          formattedText = `*${selectedText2}*`;
          cursorOffset = formattedText.length;
          break;
        case "italic":
          formattedText = `_${selectedText2}_`;
          cursorOffset = formattedText.length;
          break;
        case "strikethrough":
          formattedText = `~${selectedText2}~`;
          cursorOffset = formattedText.length;
          break;
        case "monospace":
          formattedText = `\`\`\`${selectedText2}\`\`\``;
          cursorOffset = formattedText.length;
          break;
        case "inline-code":
          formattedText = `\`${selectedText2}\``;
          cursorOffset = formattedText.length;
          break;
        case "quote":
          const needsNewLineBeforeQuote = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfterQuote = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBeforeQuote ? "\n" : "") + `> ${selectedText2}` + (needsNewLineAfterQuote ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        case "bullet-list":
          const bulletLines = selectedText2.split("\n").map((line) => line.trim() ? `* ${line}` : line).join("\n");
          const needsNewLineBefore = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfter = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBefore ? "\n" : "") + bulletLines + (needsNewLineAfter ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        case "numbered-list":
          const numberedLines = selectedText2.split("\n").filter((line) => line.trim()).map((line, index2) => `${index2 + 1}. ${line}`).join("\n");
          const needsNewLineBeforeNum = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          const needsNewLineAfterNum = end < textarea.value.length && textarea.value.charAt(end) !== "\n";
          formattedText = (needsNewLineBeforeNum ? "\n" : "") + numberedLines + (needsNewLineAfterNum ? "\n" : "");
          cursorOffset = formattedText.length;
          break;
        default:
          formattedText = selectedText2;
          cursorOffset = formattedText.length;
      }
    } else {
      switch (format) {
        case "bold":
          formattedText = "**";
          cursorOffset = 1;
          break;
        case "italic":
          formattedText = "__";
          cursorOffset = 1;
          break;
        case "strikethrough":
          formattedText = "~~";
          cursorOffset = 1;
          break;
        case "monospace":
          formattedText = "```\n\n```";
          cursorOffset = 4;
          break;
        case "inline-code":
          formattedText = "``";
          cursorOffset = 1;
          break;
        case "quote":
          const needsNewLineBeforeQuoteEmpty = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeQuoteEmpty ? "\n> " : "> ";
          cursorOffset = formattedText.length;
          break;
        case "bullet-list":
          const needsNewLineBeforeBullet = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeBullet ? "\n* " : "* ";
          cursorOffset = formattedText.length;
          break;
        case "numbered-list":
          const needsNewLineBeforeNumber = start > 0 && textarea.value.charAt(start - 1) !== "\n";
          formattedText = needsNewLineBeforeNumber ? "\n1. " : "1. ";
          cursorOffset = formattedText.length;
          break;
        default:
          formattedText = "";
          cursorOffset = 0;
      }
    }
    const newValue = textarea.value.substring(0, start) + formattedText + textarea.value.substring(end);
    setCustomServiceMessage(newValue);
    setMessageTemplate(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + cursorOffset, start + cursorOffset);
    }, 0);
  }, []);
  useEffect(() => {
    const handleKeyDown = (event) => {
      if ((event.ctrlKey || event.metaKey) && event.target.id === "custom-service-message") {
        switch (event.key.toLowerCase()) {
          case "b":
            event.preventDefault();
            applyFormatting("bold");
            break;
          case "i":
            event.preventDefault();
            applyFormatting("italic");
            break;
          case "s":
            event.preventDefault();
            applyFormatting("strikethrough");
            break;
          case "m":
            event.preventDefault();
            applyFormatting("monospace");
            break;
          case "k":
            event.preventDefault();
            applyFormatting("inline-code");
            break;
          case "q":
            event.preventDefault();
            applyFormatting("quote");
            break;
          case "l":
            event.preventDefault();
            applyFormatting("bullet-list");
            break;
          case "n":
            event.preventDefault();
            applyFormatting("numbered-list");
            break;
        }
      }
    };
    document.addEventListener("keydown", handleKeyDown);
    return () => document.removeEventListener("keydown", handleKeyDown);
  }, [applyFormatting]);
  const insertVariable = useCallback((variable) => {
    const textarea = document.querySelector("#custom-service-message");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const variableText = `{{${variable}}}`;
    const newValue = textarea.value.substring(0, start) + variableText + textarea.value.substring(start);
    setCustomServiceMessage(newValue);
    setMessageTemplate(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + variableText.length, start + variableText.length);
    }, 0);
  }, []);
  const insertEmoji = useCallback((emoji) => {
    const textarea = document.querySelector("#custom-service-message");
    if (!textarea) return;
    const start = textarea.selectionStart;
    const newValue = textarea.value.substring(0, start) + emoji + textarea.value.substring(start);
    setCustomServiceMessage(newValue);
    setMessageTemplate(newValue);
    setTimeout(() => {
      textarea.focus();
      textarea.setSelectionRange(start + emoji.length, start + emoji.length);
    }, 0);
  }, []);
  const handleSave = useCallback(async () => {
    try {
      setCreatingAutoReply(true);
      setAutoReplyError(null);
      const keywordArray = keywords.split(",").map((k) => k.trim()).filter((k) => k.length > 0);
      if (keywordArray.length === 0) {
        throw new Error("Please enter at least one keyword");
      }
      let payload;
      if (messageType === "template") {
        if (!selectedTemplateData) {
          throw new Error("Please select a template");
        }
        const components = [];
        if (selectedTemplateData.components) {
          selectedTemplateData.components.forEach((component, index2) => {
            var _a3, _b2;
            if (component.type === "HEADER") {
              if (component.format === "IMAGE" || component.format === "VIDEO" || component.format === "DOCUMENT") {
                const mediaKey = `header_${index2}`;
                const mediaFile = mediaMapping[mediaKey];
                components.push({
                  type: "HEADER",
                  parameters: [{
                    type: component.format,
                    [component.format.toLowerCase()]: {
                      link: (mediaFile == null ? void 0 : mediaFile.fileUrl) || ((_b2 = (_a3 = component.example) == null ? void 0 : _a3.header_handle) == null ? void 0 : _b2[0]) || ""
                    }
                  }]
                });
              } else if (component.text) {
                const headerVariables = extractVariablesFromWhatsAppMessage(component.text);
                if (headerVariables.length > 0) {
                  components.push({
                    type: "HEADER",
                    parameters: headerVariables.map((variable) => ({
                      type: "text",
                      text: variableSelections[variable] || `{{${variable}}}`
                    }))
                  });
                }
              }
            } else if (component.type === "BODY" && component.text) {
              const bodyVariables = extractVariablesFromWhatsAppMessage(component.text);
              if (bodyVariables.length > 0) {
                components.push({
                  type: "BODY",
                  parameters: bodyVariables.map((variable) => ({
                    type: "text",
                    text: variableSelections[variable] || `{{${variable}}}`
                  }))
                });
              }
            } else if (component.type === "FOOTER" && component.text) {
              const footerVariables = extractVariablesFromWhatsAppMessage(component.text);
              if (footerVariables.length > 0) {
                components.push({
                  type: "FOOTER",
                  parameters: footerVariables.map((variable) => ({
                    type: "text",
                    text: variableSelections[variable] || `{{${variable}}}`
                  }))
                });
              }
            } else if (component.type === "BUTTONS" && component.buttons) {
              const buttonParameters = [];
              component.buttons.forEach((button2, index22) => {
                var _a4;
                if (button2.type === "URL" && button2.url && /\{\{\d+\}\}/.test(button2.url)) {
                  buttonParameters.push({
                    type: "button",
                    sub_type: "URL",
                    index: index22,
                    parameters: [{
                      type: "text",
                      text: urlButtonVariables[index22] || ((_a4 = button2.example) == null ? void 0 : _a4[0]) || ""
                    }]
                  });
                }
              });
              if (buttonParameters.length > 0) {
                components.push({
                  type: "BUTTONS",
                  parameters: buttonParameters
                });
              }
            }
          });
        }
        payload = {
          _token: autoReplyToken,
          template_type: "template",
          formId: "autoReplytemplateTypeSelectform",
          templateJsonData: JSON.stringify({
            to: "receiver_number",
            type: "template",
            template: {
              name: selectedTemplateData.name || "template_name",
              language: {
                code: selectedTemplateData.language || "en_US"
              },
              components
            },
            recipient_type: "individual",
            messaging_product: "whatsapp"
          }),
          keyWordType: conditionType,
          keyWordValues: JSON.stringify(keywordArray)
        };
      } else if (messageType === "service") {
        if (!customServiceMessage.trim()) {
          throw new Error("Please enter a service message");
        }
        payload = {
          _token: autoReplyToken,
          template_type: "text",
          body: customServiceMessage,
          formId: "autoReplytextTypeSelectform",
          keyWordType: conditionType,
          keyWordValues: JSON.stringify(keywordArray)
        };
      } else {
        throw new Error("Please select a message type");
      }
      console.log("Creating auto reply with payload:", payload);
      const response = await createAutoReply(payload);
      console.log("Auto reply created successfully:", response);
      navigate("/app/auto-triggers/auto-reply");
    } catch (error) {
      console.error("Error creating auto reply:", error);
      setAutoReplyError(error.message || "Failed to create auto reply trigger");
    } finally {
      setCreatingAutoReply(false);
    }
  }, [messageTemplate, messageType, keywords, selectedTemplateData, customServiceMessage, mediaMapping, variableSelections, urlButtonVariables, navigate]);
  const handleCancel = useCallback(() => {
    navigate("/app/auto-triggers/auto-reply");
  }, [navigate]);
  const extractVariables = useMemo(() => {
    return extractVariablesFromWhatsAppMessage(messageTemplate);
  }, [messageTemplate]);
  useEffect(() => {
    if (extractVariables.length > 0) {
      const initialInputValues = {};
      extractVariables.forEach((variable) => {
        if (!variableInputValues[variable]) {
          const selectedVar = availableVariables.find((av) => av.value === variableSelections[variable]);
          initialInputValues[variable] = (selectedVar == null ? void 0 : selectedVar.label) || "";
        }
      });
      if (Object.keys(initialInputValues).length > 0) {
        setVariableInputValues((prev) => ({ ...prev, ...initialInputValues }));
      }
    }
  }, [extractVariables, variableSelections, availableVariables]);
  useEffect(() => {
    const fetchVariables = async () => {
      try {
        setLoadingVariables(true);
        const variables = await getTemplateVariables();
        setAvailableVariables(variables);
      } catch (error) {
        console.error("Error fetching variables:", error);
        setAvailableVariables([]);
      } finally {
        setLoadingVariables(false);
      }
    };
    fetchVariables();
  }, []);
  const templateMedia = useMemo(() => {
    if (!selectedTemplateData || !selectedTemplateData.components) return {};
    const media = {};
    selectedTemplateData.components.forEach((component, index2) => {
      var _a3, _b2;
      if (component.type === "HEADER" && (component.format === "IMAGE" || component.format === "VIDEO" || component.format === "DOCUMENT")) {
        const mediaKey = `header_${index2}`;
        media[mediaKey] = {
          type: component.format.toLowerCase(),
          url: ((_b2 = (_a3 = component.example) == null ? void 0 : _a3.header_handle) == null ? void 0 : _b2[0]) || null,
          required: true
        };
      }
    });
    return media;
  }, [selectedTemplateData]);
  const templateUrlButtons = useMemo(() => {
    if (!selectedTemplateData || !selectedTemplateData.components) return [];
    const urlButtons = [];
    selectedTemplateData.components.forEach((component) => {
      if (component.type === "BUTTONS" && component.buttons) {
        component.buttons.forEach((button2, index2) => {
          var _a3;
          if (button2.type === "URL" && button2.url) {
            const hasVariable = /\{\{\d+\}\}/.test(button2.url);
            if (hasVariable) {
              urlButtons.push({
                index: index2,
                text: button2.text,
                url: button2.url,
                example: ((_a3 = button2.example) == null ? void 0 : _a3[0]) || ""
              });
            }
          }
        });
      }
    });
    return urlButtons;
  }, [selectedTemplateData]);
  useEffect(() => {
    if (templateUrlButtons.length > 0) {
      const initialUrlVariables = {};
      templateUrlButtons.forEach((button2) => {
        if (!urlButtonVariables[button2.index]) {
          initialUrlVariables[button2.index] = button2.example;
        }
      });
      if (Object.keys(initialUrlVariables).length > 0) {
        setUrlButtonVariables((prev) => ({ ...prev, ...initialUrlVariables }));
      }
    }
  }, [templateUrlButtons]);
  const isFormValid = useMemo(() => {
    if (!keywords.trim()) return false;
    if (messageType === "template" && !messageTemplate) return false;
    if (messageType === "service" && !customServiceMessage.trim()) return false;
    if (creatingAutoReply) return false;
    if (templateUrlButtons.length > 0) {
      for (const button2 of templateUrlButtons) {
        if (!urlButtonVariables[button2.index] || urlButtonVariables[button2.index].trim() === "") {
          return false;
        }
      }
    }
    return true;
  }, [keywords, messageType, messageTemplate, customServiceMessage, creatingAutoReply, templateUrlButtons, urlButtonVariables]);
  const messageTypeOptions = [
    { label: "Select Template", value: "template" },
    { label: "Create Service Message", value: "service" }
  ];
  const conditionTypeOptions = [
    { label: "Equal", value: "Equal" },
    { label: "Contains", value: "Contains" }
  ];
  return /* @__PURE__ */ jsxs(
    Page,
    {
      title: "Create Auto Reply Trigger",
      subtitle: "Set up automated keyword-based responses for customer inquiries",
      backAction: {
        content: "Auto Reply Triggers",
        onAction: () => navigate("/app/auto-triggers/auto-reply")
      },
      primaryAction: {
        content: "Save Trigger",
        onAction: handleSave,
        disabled: !isFormValid,
        loading: creatingAutoReply
      },
      secondaryActions: [
        {
          content: "Cancel",
          onAction: handleCancel
        }
      ],
      fullWidth: true,
      children: [
        /* @__PURE__ */ jsxs(Grid, { children: [
          /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 8, lg: 8, xl: 8 }, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "500", children: [
            /* @__PURE__ */ jsx(Banner, { status: "info", children: /* @__PURE__ */ jsx(Text, { as: "p", children: "Create automated responses to customer inquiries based on keywords. Provide instant support and information to your customers." }) }),
            templateError && /* @__PURE__ */ jsx(Banner, { status: "critical", onDismiss: () => setTemplateError(null), children: /* @__PURE__ */ jsx(Text, { as: "p", children: templateError }) }),
            autoReplyError && /* @__PURE__ */ jsx(Banner, { status: "critical", onDismiss: () => setAutoReplyError(null), children: /* @__PURE__ */ jsx(Text, { as: "p", children: autoReplyError }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Basic Information" }),
              /* @__PURE__ */ jsx(FormLayout, { children: /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Trigger Type",
                  value: "Keywords Auto Reply",
                  disabled: true,
                  helpText: "This trigger responds to specific keywords in customer messages"
                }
              ) })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Keywords Configuration" }),
              /* @__PURE__ */ jsxs(FormLayout, { children: [
                /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: "Keywords",
                    value: keywords,
                    onChange: handleKeywordsChange,
                    placeholder: "e.g., help, support, refund",
                    helpText: "Enter keywords separated by commas",
                    multiline: 2,
                    requiredIndicator: true
                  }
                ),
                /* @__PURE__ */ jsx(
                  Select,
                  {
                    label: "Condition",
                    options: conditionTypeOptions,
                    value: conditionType,
                    onChange: handleConditionTypeChange,
                    placeholder: "Choose condition",
                    helpText: "Select whether to use a equal or contains condition",
                    requiredIndicator: true
                  }
                ),
                /* @__PURE__ */ jsx(
                  Select,
                  {
                    label: "Message Type",
                    options: messageTypeOptions,
                    value: messageType,
                    onChange: handleMessageTypeChange,
                    placeholder: "Choose message type",
                    helpText: "Select whether to use a template or service message",
                    requiredIndicator: true
                  }
                )
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Message Settings" }),
              /* @__PURE__ */ jsxs(FormLayout, { children: [
                messageType === "template" && /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                  loadingTemplates ? /* @__PURE__ */ jsxs("div", { style: { display: "flex", alignItems: "center", gap: "8px", padding: "12px" }, children: [
                    /* @__PURE__ */ jsx(Spinner, { size: "small" }),
                    /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", children: "Loading templates..." })
                  ] }) : allTemplateOptions.length > 0 ? /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                    /* @__PURE__ */ jsx(
                      Autocomplete,
                      {
                        label: "Search and select template",
                        options: filteredTemplateOptions.map((template) => ({
                          value: template.id || template.value,
                          label: template.label
                        })),
                        selected: selectedTemplateId ? [selectedTemplateId] : [],
                        onSelect: (selected) => {
                          const selectedValue = selected[0];
                          if (selectedValue) {
                            handleTemplateChange(selectedValue);
                          }
                        },
                        textField: /* @__PURE__ */ jsx(
                          Autocomplete.TextField,
                          {
                            onChange: (value) => setTemplateInputValue(value),
                            label: "Search and select template",
                            value: templateInputValue,
                            placeholder: "Type to search templates...",
                            autoComplete: "off"
                          }
                        ),
                        loading: loadingTemplates || loadingTemplateDetails,
                        emptyState: loadingTemplates ? "Loading templates..." : "No templates found",
                        preferredPosition: "below",
                        willLoadMoreResults: false
                      }
                    ),
                    /* @__PURE__ */ jsxs(Text, { variant: "bodySm", tone: "subdued", children: [
                      "Found ",
                      allTemplateOptions.length,
                      " templates from API"
                    ] }),
                    selectedTemplateData && /* @__PURE__ */ jsx(Banner, { status: "info", children: /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                      "Template selected: ",
                      /* @__PURE__ */ jsx("strong", { children: (_a2 = allTemplateOptions.find((t) => t.id === selectedTemplateId || t.value === selectedTemplateId)) == null ? void 0 : _a2.label }),
                      loadingTemplateDetails && /* @__PURE__ */ jsx("span", { children: " (Loading details...)" })
                    ] }) })
                  ] }) : /* @__PURE__ */ jsx("div", { style: { padding: "12px", textAlign: "center" }, children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", children: "No templates available. Please check your API connection." }) }),
                  /* @__PURE__ */ jsx(Text, { variant: "bodySm", tone: "subdued", children: "Search and select from available templates" })
                ] }),
                messageType === "service" && /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "h3", children: "Custom Service Message" }),
                  /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                    /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Click to insert variables:" }),
                    /* @__PURE__ */ jsxs(InlineStack, { gap: "100", wrap: true, children: [
                      availableVariables.slice(0, 15).map((variable) => /* @__PURE__ */ jsx(
                        Button,
                        {
                          size: "micro",
                          variant: "tertiary",
                          onClick: () => insertVariable(variable.value),
                          children: variable.label
                        },
                        variable.value
                      )),
                      availableVariables.length > 15 && /* @__PURE__ */ jsxs(
                        Button,
                        {
                          size: "micro",
                          variant: "primary",
                          onClick: () => setShowVariablesModal(true),
                          children: [
                            "More Variables (",
                            availableVariables.length - 15,
                            ")"
                          ]
                        }
                      )
                    ] })
                  ] }),
                  /* @__PURE__ */ jsxs("div", { style: { position: "relative" }, children: [
                    /* @__PURE__ */ jsxs("div", { style: { position: "absolute", bottom: 12, right: 6, zIndex: 99, display: "flex", gap: "4px", flexWrap: "wrap" }, children: [
                      /* @__PURE__ */ jsx(ButtonGroup, { variant: "segmented", children: /* @__PURE__ */ jsx(EmojiPicker, { onEmojiSelect: insertEmoji, buttonSize: "micro" }) }),
                      /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Bold",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘B" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bold"), accessibilityLabel: "Bold", children: /* @__PURE__ */ jsx(Text, { fontWeight: "bold", children: "B" }) }) }),
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Italic",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘I" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("italic"), accessibilityLabel: "Italic", children: /* @__PURE__ */ jsx(Text, { as: "em", children: "I" }) }) }),
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Strikethrough",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘S" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("strikethrough"), accessibilityLabel: "Strikethrough", children: /* @__PURE__ */ jsx(Text, { as: "s", children: "S" }) }) })
                      ] }),
                      /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Monospace",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘M" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("monospace"), accessibilityLabel: "Monospace", children: /* @__PURE__ */ jsxs(Text, { as: "code", children: [
                          " ",
                          "</>"
                        ] }) }) }),
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Inline Code",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘K" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("inline-code"), accessibilityLabel: "Inline Code", children: /* @__PURE__ */ jsx(Text, { as: "code", children: "<>" }) }) }),
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Quote",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘Q" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("quote"), accessibilityLabel: "Quote", children: '"' }) })
                      ] }),
                      /* @__PURE__ */ jsxs(ButtonGroup, { variant: "segmented", children: [
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Bullet List",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘L" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("bullet-list"), accessibilityLabel: "Bullet List", children: "•" }) }),
                        /* @__PURE__ */ jsx(Tooltip, { content: /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
                          "Numbered List",
                          /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", tone: "subdued", children: "⌘N" })
                        ] }), children: /* @__PURE__ */ jsx(Button, { size: "micro", onClick: () => applyFormatting("numbered-list"), accessibilityLabel: "Numbered List", children: "1." }) })
                      ] })
                    ] }),
                    /* @__PURE__ */ jsx(
                      TextField,
                      {
                        id: "custom-service-message",
                        label: "Message Content",
                        value: customServiceMessage,
                        onChange: handleCustomServiceMessageChange,
                        onSelect: handleTextSelection,
                        multiline: 8,
                        maxLength: 4096,
                        placeholder: "Type your custom service message here... Formatting options: *bold*, _italic_, ~strikethrough~, ```monospace```, `inline code`, > quote, * bullet list, 1. numbered list. Use keyboard shortcuts or click buttons above.",
                        helpText: `${customServiceMessage.length}/4096 characters`
                      }
                    )
                  ] })
                ] }),
                extractVariables.length > 0 && /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "h3", children: "Variable Mapping" }),
                  /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Map the template variables to actual data fields:" }),
                  extractVariables.map((variable, index2) => /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
                    /* @__PURE__ */ jsx(
                      TextField,
                      {
                        label: `Variable: {{${variable}}}`,
                        value: `{{${variable}}}`,
                        disabled: true,
                        helpText: "Template variable"
                      }
                    ),
                    /* @__PURE__ */ jsx(
                      Autocomplete,
                      {
                        options: availableVariables.filter((av) => {
                          const searchValue = variableInputValues[variable] || "";
                          return searchValue === "" || av.label.toLowerCase().includes(searchValue.toLowerCase());
                        }).map((av) => ({
                          value: av.value,
                          label: av.label
                        })),
                        selected: variableSelections[variable] ? [variableSelections[variable]] : [],
                        onSelect: (selected) => {
                          const value = selected.length > 0 ? selected[0] : "";
                          handleVariableSelectionChange(variable, value);
                          if (value) {
                            const selectedVar = availableVariables.find((av) => av.value === value);
                            setVariableInputValues((prev) => ({
                              ...prev,
                              [variable]: (selectedVar == null ? void 0 : selectedVar.label) || ""
                            }));
                          } else {
                            setVariableInputValues((prev) => ({
                              ...prev,
                              [variable]: ""
                            }));
                          }
                        },
                        textField: /* @__PURE__ */ jsx(
                          Autocomplete.TextField,
                          {
                            label: "Map to",
                            value: variableInputValues[variable] || "",
                            onChange: (value) => {
                              setVariableInputValues((prev) => ({
                                ...prev,
                                [variable]: value
                              }));
                            },
                            placeholder: "Search and choose data field",
                            autoComplete: "off",
                            clearButton: true,
                            onClearButtonClick: () => {
                              setVariableInputValues((prev) => ({
                                ...prev,
                                [variable]: ""
                              }));
                              handleVariableSelectionChange(variable, "");
                            }
                          }
                        )
                      }
                    )
                  ] }, variable))
                ] }),
                messageType === "template" && Object.keys(templateMedia).length > 0 && /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "h3", children: "Media Files" }),
                  /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Upload media files required by this template:" }),
                  /* @__PURE__ */ jsx(BlockStack, { gap: "400", children: Object.entries(templateMedia).map(([mediaKey, mediaData]) => {
                    var _a3, _b2, _c, _d;
                    const uploadedFile = (_a3 = mediaMapping[mediaKey]) == null ? void 0 : _a3.file;
                    const fileUrl = ((_b2 = mediaMapping[mediaKey]) == null ? void 0 : _b2.fileUrl) || mediaData.url;
                    const isUploading = uploadingMedia[mediaKey];
                    const uploadError = (_c = mediaMapping[mediaKey]) == null ? void 0 : _c.uploadError;
                    const isUploaded = (_d = mediaMapping[mediaKey]) == null ? void 0 : _d.uploaded;
                    return /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                      /* @__PURE__ */ jsxs(InlineStack, { gap: "200", align: "space-between", blockAlign: "center", children: [
                        /* @__PURE__ */ jsxs(InlineStack, { gap: "200", blockAlign: "center", children: [
                          /* @__PURE__ */ jsx(
                            Thumbnail,
                            {
                              source: uploadedFile ? fileUrl : mediaData.url || (mediaData.type === "document" ? "📄" : "📁"),
                              alt: (uploadedFile == null ? void 0 : uploadedFile.name) || `Header ${mediaData.type}`,
                              size: "small"
                            }
                          ),
                          /* @__PURE__ */ jsxs(BlockStack, { gap: "050", children: [
                            /* @__PURE__ */ jsxs(InlineStack, { gap: "200", blockAlign: "center", children: [
                              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: uploadedFile ? uploadedFile.name : `Header ${mediaData.type}` }),
                              isUploading && /* @__PURE__ */ jsx(Badge, { tone: "info", children: "Uploading..." }),
                              isUploaded && !isUploading && /* @__PURE__ */ jsx(Badge, { tone: "success", children: "Uploaded" })
                            ] }),
                            /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: uploadedFile ? `${(uploadedFile.size / 1024 / 1024).toFixed(2)} MB` : `Original ${mediaData.type}` }),
                            uploadError && /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "critical", children: [
                              "Error: ",
                              uploadError
                            ] })
                          ] })
                        ] }),
                        uploadedFile ? /* @__PURE__ */ jsxs(InlineStack, { gap: "100", children: [
                          /* @__PURE__ */ jsx(
                            Button,
                            {
                              variant: "plain",
                              tone: "critical",
                              size: "slim",
                              onClick: () => handleMediaMappingChange(mediaKey, null),
                              disabled: isUploading,
                              children: "Remove"
                            }
                          ),
                          /* @__PURE__ */ jsx(
                            Button,
                            {
                              variant: "plain",
                              size: "slim",
                              onClick: () => document.getElementById(`upload-${mediaKey}`).click(),
                              disabled: isUploading,
                              children: "Replace"
                            }
                          )
                        ] }) : /* @__PURE__ */ jsxs(
                          Button,
                          {
                            variant: "plain",
                            size: "slim",
                            onClick: () => document.getElementById(`upload-${mediaKey}`).click(),
                            disabled: isUploading,
                            loading: isUploading,
                            children: [
                              "Upload ",
                              mediaData.type
                            ]
                          }
                        )
                      ] }),
                      /* @__PURE__ */ jsx(
                        "input",
                        {
                          id: `upload-${mediaKey}`,
                          type: "file",
                          accept: mediaData.type === "image" ? "image/*" : mediaData.type === "video" ? "video/*" : "application/pdf,.doc,.docx,.txt",
                          style: { display: "none" },
                          onChange: (e) => {
                            var _a4;
                            if (((_a4 = e.target.files) == null ? void 0 : _a4.length) > 0) {
                              handleMediaMappingChange(mediaKey, e.target.files[0]);
                            }
                          }
                        }
                      )
                    ] }, mediaKey);
                  }) })
                ] })
              ] })
            ] }) }),
            templateUrlButtons.length > 0 && /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "URL Button Variables" }),
              /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Configure the default values for URL button variables:" }),
              /* @__PURE__ */ jsx(FormLayout, { children: templateUrlButtons.map((button2, index2) => /* @__PURE__ */ jsxs(FormLayout.Group, { children: [
                /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: `Button: ${button2.text}`,
                    value: button2.url,
                    disabled: true,
                    helpText: "URL template with variable placeholder"
                  }
                ),
                /* @__PURE__ */ jsx(
                  TextField,
                  {
                    label: "Default Value",
                    value: urlButtonVariables[button2.index] || button2.example,
                    onChange: (value) => handleUrlButtonVariableChange(button2.index, value),
                    placeholder: "Enter default URL value",
                    helpText: "This value will replace the variable in the URL"
                  }
                )
              ] }, `url_button_${button2.index}`)) })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Target Audience" }),
              /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
                /* @__PURE__ */ jsx(Text, { as: "p", tone: "subdued", children: "This trigger will respond to all customers who send messages containing the specified keywords." }),
                /* @__PURE__ */ jsx(
                  Checkbox,
                  {
                    label: "All Customers",
                    checked: true,
                    disabled: true,
                    helpText: "This audience is automatically selected for auto reply triggers"
                  }
                )
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsx(InlineStack, { align: "end", children: /* @__PURE__ */ jsxs(ButtonGroup, { children: [
              /* @__PURE__ */ jsx(Button, { onClick: handleCancel, disabled: creatingAutoReply, children: "Cancel" }),
              /* @__PURE__ */ jsx(
                Button,
                {
                  variant: "primary",
                  onClick: handleSave,
                  disabled: !isFormValid,
                  loading: creatingAutoReply,
                  children: "Save Trigger"
                }
              )
            ] }) }) })
          ] }) }),
          /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 6, md: 4, lg: 4, xl: 4 }, children: /* @__PURE__ */ jsx("div", { style: {
            position: "sticky",
            top: "20px",
            alignSelf: "flex-start",
            zIndex: 10
          }, children: /* @__PURE__ */ jsx(BlockStack, { gap: "500", children: /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Message Preview" }),
            messageTemplate ? /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
              /* @__PURE__ */ jsx(Text, { as: "p", tone: "", children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", children: ((_b = allTemplateOptions == null ? void 0 : allTemplateOptions.find((option) => option.value === selectedTemplate || option.id === selectedTemplateId)) == null ? void 0 : _b.label) || "Custom Service Message" }) }),
              /* @__PURE__ */ jsx(Card, { sectioned: true, background: "bg-surface-secondary", children: /* @__PURE__ */ jsx(
                WhatsAppPreview,
                {
                  template: selectedTemplateData || messageTemplate,
                  variant: "bubble",
                  maxWidth: "280px",
                  mediaMapping
                }
              ) }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                "Variables like ",
                `{`,
                `{`,
                `customer_name`,
                `}`,
                `}`,
                " or ",
                `{`,
                `{`,
                `1`,
                `}`,
                `}`,
                " will be replaced with actual customer data when sent."
              ] })
            ] }) : /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
              /* @__PURE__ */ jsx(Text, { as: "p", tone: "subdued", children: "Select a message type and template to see the preview" }),
              /* @__PURE__ */ jsx(LegacyCard, { sectioned: true, children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Your message preview will appear here once you select a message type and template." }) })
            ] })
          ] }) }) }) }) })
        ] }),
        /* @__PURE__ */ jsx(
          Modal,
          {
            open: showVariablesModal,
            onClose: () => {
              setShowVariablesModal(false);
              setVariableSearchQuery("");
            },
            title: "All Available Variables",
            primaryAction: {
              content: "Close",
              onAction: () => {
                setShowVariablesModal(false);
                setVariableSearchQuery("");
              }
            },
            size: "large",
            children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", tone: "subdued", children: "Click on any variable to insert it into your template:" }),
              /* @__PURE__ */ jsx(
                TextField,
                {
                  label: "Search Variables",
                  value: variableSearchQuery,
                  onChange: setVariableSearchQuery,
                  placeholder: "Type to search variables...",
                  clearButton: true,
                  onClearButtonClick: () => setVariableSearchQuery(""),
                  autoComplete: "off"
                }
              ),
              /* @__PURE__ */ jsx(InlineStack, { gap: "200", wrap: true, children: availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).map((variable) => /* @__PURE__ */ jsx(
                Button,
                {
                  size: "medium",
                  variant: "tertiary",
                  onClick: () => {
                    insertVariable(variable.value);
                    setShowVariablesModal(false);
                    setVariableSearchQuery("");
                  },
                  children: variable.label
                },
                variable.value
              )) }),
              availableVariables.filter(
                (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
              ).length === 0 && variableSearchQuery && /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", tone: "subdued", alignment: "center", children: [
                'No variables found matching "',
                variableSearchQuery,
                '"'
              ] }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", tone: "subdued", children: [
                "You can also create custom variables using the format: ",
                "{{variable_name}}"
              ] })
            ] }) })
          }
        )
      ]
    }
  );
}
const route23 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: CreateAutoReplyTriggerPage
}, Symbol.toStringTag, { value: "Module" }));
const transformAbandonedCartData = (apiData) => {
  return apiData.map((item) => ({
    id: item.id.toString(),
    triggerName: item.triggerName || "Unnamed Trigger",
    templateName: item.template_name || "No Template",
    collectionName: [item.selectedCollections || "All Products"],
    lastUpdated: new Date(item.updated_at).toLocaleDateString("en-US", {
      year: "numeric",
      month: "2-digit",
      day: "2-digit"
    }),
    isActive: item.status === 1,
    originalData: item
  }));
};
function TriggerIndexTable$1({ triggers, onToggleStatus, onViewTemplate }) {
  useNavigate();
  const resourceName = {
    singular: "trigger",
    plural: "triggers"
  };
  const { selectedResources, allResourcesSelected, handleSelectionChange } = useIndexResourceState(triggers);
  const handleToggleActive = useCallback((triggerId, event) => {
    event.stopPropagation();
    onToggleStatus(triggerId);
  }, [onToggleStatus]);
  const handleViewTemplateTrigger = useCallback((triggerId, event) => {
    event.stopPropagation();
    onViewTemplate(triggerId);
  }, [onViewTemplate]);
  const rowMarkup = triggers.map(
    ({ id, triggerName, templateName, collectionName, lastUpdated: lastUpdated2, isActive }, index2) => /* @__PURE__ */ jsxs(
      IndexTable.Row,
      {
        id,
        selected: selectedResources.includes(id),
        position: index2,
        children: [
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", fontWeight: "bold", children: triggerName }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: templateName }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: lastUpdated2 }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Badge, { tone: isActive ? "success" : "critical", children: isActive ? "Active" : "Inactive" }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: collectionName.join(", ").length > 20 ? collectionName.join(", ").slice(0, 20) + "..." : collectionName.join(", ") }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(InlineStack, { children: /* @__PURE__ */ jsx(
            Button,
            {
              size: "slim",
              onClick: (event) => handleToggleActive(id, event),
              children: isActive ? "Deactivate" : "Activate"
            }
          ) }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(InlineStack, { align: "end", children: /* @__PURE__ */ jsx(Tooltip, { content: "Preview Template", children: /* @__PURE__ */ jsx(
            Button,
            {
              size: "slim",
              icon: ViewIcon,
              onClick: (event) => handleViewTemplateTrigger(id, event)
            }
          ) }) }) })
        ]
      },
      id
    )
  );
  return /* @__PURE__ */ jsx(
    IndexTable,
    {
      resourceName,
      itemCount: triggers.length,
      selectedItemsCount: allResourcesSelected ? "All" : selectedResources.length,
      onSelectionChange: handleSelectionChange,
      headings: [
        { title: "Trigger Name" },
        { title: "Template Name" },
        { title: "Last Updated" },
        { title: "Status" },
        { title: "Collections" },
        { title: "Actions" },
        { title: "" }
      ],
      children: rowMarkup
    }
  );
}
function AbandonedCartTriggersPage() {
  const navigate = useNavigate();
  const [abandonedCartData, setAbandonedCartData] = useState([]);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);
  const [selectedTrigger, setSelectedTrigger] = useState(null);
  const [previewModalActive, setPreviewModalActive] = useState(false);
  const [selectedTemplateData, setSelectedTemplateData] = useState(null);
  const [loadingTemplateDetails, setLoadingTemplateDetails] = useState(false);
  const [templateError, setTemplateError] = useState(null);
  const [queryValue, setQueryValue] = useState("");
  const [sortSelected, setSortSelected] = useState(["triggerName asc"]);
  const [statusFilter, setStatusFilter2] = useState([]);
  const [collectionFilter, setCollectionFilter] = useState([]);
  const [currentPage, setCurrentPage] = useState(1);
  const [pagination, setPagination] = useState({
    current_page: 1,
    last_page: 1,
    per_page: 20,
    total: 0,
    from: 0,
    to: 0
  });
  const { mode: mode2, setMode } = useSetIndexFiltersMode();
  const fetchTriggers = useCallback(async (page = 1) => {
    try {
      setLoading(true);
      setError(null);
      const response = await fetchAbandonedCartTriggerList({
        page,
        perPageData: 20,
        TriggerCategory: 1
      });
      if (response.status && response.data) {
        const transformedData = transformAbandonedCartData(response.data.data);
        setAbandonedCartData(transformedData);
        setPagination({
          current_page: response.data.current_page,
          last_page: response.data.last_page,
          per_page: response.data.per_page,
          total: response.data.total,
          from: response.data.from,
          to: response.data.to
        });
        setCurrentPage(response.data.current_page);
      } else {
        throw new Error("Invalid API response format");
      }
    } catch (err) {
      console.error("Error fetching abandoned cart triggers:", err);
      setError(err.message || "Failed to fetch abandoned cart triggers");
      setAbandonedCartData([]);
    } finally {
      setLoading(false);
    }
  }, []);
  useEffect(() => {
    fetchTriggers(1);
  }, [fetchTriggers]);
  const handleFiltersQueryChange = useCallback((value) => {
    setQueryValue(value);
  }, []);
  const handleQueryValueRemove = useCallback(() => setQueryValue(""), []);
  const handleStatusChange = useCallback((value) => {
    setStatusFilter2(value);
  }, []);
  const handleCollectionChange = useCallback((value) => {
    setCollectionFilter(value);
  }, []);
  const handleStatusRemove = useCallback(() => setStatusFilter2([]), []);
  const handleCollectionRemove = useCallback(() => setCollectionFilter([]), []);
  const handleFiltersClearAll = useCallback(() => {
    handleStatusRemove();
    handleCollectionRemove();
    handleQueryValueRemove();
  }, [handleStatusRemove, handleCollectionRemove, handleQueryValueRemove]);
  const filteredTriggers = useMemo(() => {
    if (!Array.isArray(abandonedCartData)) return [];
    return abandonedCartData.filter((trigger) => {
      var _a2, _b, _c, _d;
      const matchesSearch = !queryValue.trim() || (((_a2 = trigger.triggerName) == null ? void 0 : _a2.toLowerCase().includes(queryValue.toLowerCase())) || ((_b = trigger.templateName) == null ? void 0 : _b.toLowerCase().includes(queryValue.toLowerCase())) || ((_c = trigger.collectionName) == null ? void 0 : _c.some(
        (collection) => collection.toLowerCase().includes(queryValue.toLowerCase())
      )));
      const matchesStatus = !Array.isArray(statusFilter) || statusFilter.length === 0 || statusFilter.includes(trigger.isActive ? "active" : "inactive");
      const matchesCollection = !Array.isArray(collectionFilter) || collectionFilter.length === 0 || ((_d = trigger.collectionName) == null ? void 0 : _d.some((collection) => collectionFilter.includes(collection.toLowerCase())));
      return matchesSearch && matchesStatus && matchesCollection;
    });
  }, [abandonedCartData, queryValue, statusFilter, collectionFilter]);
  const sortOptions = [
    { label: "Trigger Name", value: "triggerName asc", directionLabel: "A-Z" },
    { label: "Trigger Name", value: "triggerName desc", directionLabel: "Z-A" },
    { label: "Template Name", value: "templateName asc", directionLabel: "A-Z" },
    { label: "Template Name", value: "templateName desc", directionLabel: "Z-A" },
    { label: "Last Updated", value: "lastUpdated asc", directionLabel: "Oldest first" },
    { label: "Last Updated", value: "lastUpdated desc", directionLabel: "Newest first" }
  ];
  const filters = [
    {
      key: "status",
      label: "Status",
      filter: /* @__PURE__ */ jsx(
        ChoiceList,
        {
          title: "Status",
          titleHidden: true,
          choices: [
            { label: "Active", value: "active" },
            { label: "Inactive", value: "inactive" }
          ],
          selected: statusFilter || [],
          onChange: handleStatusChange,
          allowMultiple: true
        }
      ),
      shortcut: true
    },
    {
      key: "collection",
      label: "Collection",
      filter: /* @__PURE__ */ jsx(
        ChoiceList,
        {
          title: "Collection",
          titleHidden: true,
          choices: [
            { label: "All Products", value: "all products" },
            { label: "Electronics", value: "electronics" },
            { label: "Clothing", value: "clothing" },
            { label: "Home & Garden", value: "home & garden" }
          ],
          selected: collectionFilter || [],
          onChange: handleCollectionChange,
          allowMultiple: true
        }
      ),
      shortcut: true
    }
  ];
  const appliedFilters = [];
  if (Array.isArray(statusFilter) && statusFilter.length > 0) {
    appliedFilters.push({
      key: "status",
      label: `Status: ${statusFilter.map((s) => s.charAt(0).toUpperCase() + s.slice(1)).join(", ")}`,
      onRemove: handleStatusRemove
    });
  }
  if (Array.isArray(collectionFilter) && collectionFilter.length > 0) {
    appliedFilters.push({
      key: "collection",
      label: `Collection: ${collectionFilter.map((c) => c.charAt(0).toUpperCase() + c.slice(1)).join(", ")}`,
      onRemove: handleCollectionRemove
    });
  }
  const handleCreateTrigger = useCallback(() => {
    navigate("/app/auto-triggers/create-abandoned-cart");
  }, [navigate]);
  const fetchTemplateDetails = useCallback(async (templateName) => {
    if (!templateName || templateName === "No Template") {
      return null;
    }
    try {
      setLoadingTemplateDetails(true);
      setTemplateError(null);
      const templateData = await getSelectedTemplatebyName(templateName);
      setSelectedTemplateData(templateData);
      return templateData;
    } catch (error2) {
      console.error("Error fetching template details:", error2);
      setTemplateError(error2.message || "Failed to fetch template details");
      return null;
    } finally {
      setLoadingTemplateDetails(false);
    }
  }, []);
  const handleViewTemplateTrigger = useCallback(async (triggerId) => {
    const trigger = abandonedCartData.find((t) => t.id === triggerId);
    if (!trigger) return;
    setSelectedTrigger(trigger);
    setSelectedTemplateData(null);
    setTemplateError(null);
    setPreviewModalActive(true);
    if (trigger.templateName && trigger.templateName !== "No Template") {
      await fetchTemplateDetails(trigger.templateName);
    }
  }, [abandonedCartData, fetchTemplateDetails]);
  const handleModalClose = useCallback(() => {
    setPreviewModalActive(false);
    setSelectedTrigger(null);
    setSelectedTemplateData(null);
    setTemplateError(null);
    setLoadingTemplateDetails(false);
  }, []);
  const handleToggleStatus = useCallback((triggerId) => {
    setAbandonedCartData(
      (prev) => prev.map((trigger) => {
        if (trigger.id === triggerId) {
          return { ...trigger, isActive: !trigger.isActive };
        } else {
          const clickedTrigger = prev.find((t) => t.id === triggerId);
          if (clickedTrigger && !clickedTrigger.isActive) {
            return { ...trigger, isActive: false };
          }
          return trigger;
        }
      })
    );
  }, []);
  const handlePreviousPage = useCallback(() => {
    if (currentPage > 1) {
      fetchTriggers(currentPage - 1);
    }
  }, [currentPage, fetchTriggers]);
  const handleNextPage = useCallback(() => {
    if (currentPage < pagination.last_page) {
      fetchTriggers(currentPage + 1);
    }
  }, [currentPage, pagination.last_page, fetchTriggers]);
  const handleDismissError = useCallback(() => {
    setError(null);
  }, []);
  if (loading) {
    return /* @__PURE__ */ jsx(
      Page,
      {
        title: "Abandoned Cart Triggers",
        subtitle: "Recover abandoned carts with automated WhatsApp messages",
        fullWidth: true,
        children: /* @__PURE__ */ jsx(LegacyCard, { children: /* @__PURE__ */ jsx(LegacyCard.Section, { children: /* @__PURE__ */ jsx("div", { style: { display: "flex", justifyContent: "center", padding: "2rem" }, children: /* @__PURE__ */ jsx(Spinner, { accessibilityLabel: "Loading abandoned cart triggers", size: "large" }) }) }) })
      }
    );
  }
  return /* @__PURE__ */ jsxs(
    Page,
    {
      title: "Abandoned Cart Triggers",
      subtitle: "Recover abandoned carts with automated WhatsApp messages",
      fullWidth: true,
      primaryAction: {
        content: /* @__PURE__ */ jsx(InlineStack, { alignment: "center", children: /* @__PURE__ */ jsx(Text, { as: "span", children: "Create Abandoned Cart Trigger" }) }),
        onAction: handleCreateTrigger
      },
      secondaryActions: [
        {
          content: "Back to Auto Triggers",
          onAction: () => navigate("/app/auto-triggers")
        }
      ],
      children: [
        error && /* @__PURE__ */ jsxs(
          Banner,
          {
            title: "Error loading abandoned cart triggers",
            tone: "critical",
            onDismiss: handleDismissError,
            children: [
              /* @__PURE__ */ jsx("p", { children: error }),
              /* @__PURE__ */ jsx(Button, { onClick: () => fetchTriggers(currentPage), children: "Try Again" })
            ]
          }
        ),
        /* @__PURE__ */ jsxs(LegacyCard, { children: [
          /* @__PURE__ */ jsx(
            IndexFilters,
            {
              sortOptions,
              sortSelected,
              queryValue,
              queryPlaceholder: "Search triggers by name, template, collection...",
              onQueryChange: handleFiltersQueryChange,
              onQueryClear: handleQueryValueRemove,
              onSort: setSortSelected,
              filters,
              appliedFilters,
              onClearAll: handleFiltersClearAll,
              mode: mode2,
              setMode,
              tabs: [],
              selected: 0,
              onSelect: () => {
              }
            }
          ),
          filteredTriggers.length > 0 ? /* @__PURE__ */ jsxs(Fragment, { children: [
            /* @__PURE__ */ jsx(
              TriggerIndexTable$1,
              {
                triggers: filteredTriggers,
                onToggleStatus: handleToggleStatus,
                onViewTemplate: handleViewTemplateTrigger
              }
            ),
            pagination.last_page > 1 && /* @__PURE__ */ jsx(LegacyCard.Section, { children: /* @__PURE__ */ jsx(InlineStack, { align: "center", children: /* @__PURE__ */ jsx(
              Pagination,
              {
                hasPrevious: currentPage > 1,
                onPrevious: handlePreviousPage,
                hasNext: currentPage < pagination.last_page,
                onNext: handleNextPage
              }
            ) }) })
          ] }) : /* @__PURE__ */ jsx(LegacyCard.Section, { children: /* @__PURE__ */ jsx("div", { style: { textAlign: "center", padding: "2rem" }, children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", color: "subdued", children: loading ? "Loading..." : "No abandoned cart triggers found matching your search criteria." }) }) })
        ] }),
        selectedTrigger && /* @__PURE__ */ jsx(
          Modal,
          {
            open: previewModalActive,
            onClose: handleModalClose,
            title: `Preview: ${selectedTrigger.triggerName}`,
            primaryAction: {
              content: "Close",
              onAction: handleModalClose
            },
            children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
              /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsx(InlineStack, { gap: "200", children: /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: selectedTrigger.triggerName }),
                  /* @__PURE__ */ jsxs(Text, { variant: "bodyLg", as: "p", children: [
                    "Template: ",
                    selectedTrigger.templateName
                  ] })
                ] }) }),
                /* @__PURE__ */ jsx(InlineStack, { gap: "200", children: /* @__PURE__ */ jsx(Badge, { tone: selectedTrigger.isActive ? "success" : "critical", children: selectedTrigger.isActive ? "Active" : "Inactive" }) })
              ] }),
              /* @__PURE__ */ jsxs(TextContainer, { children: [
                /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                  /* @__PURE__ */ jsx("strong", { children: "Collections:" }),
                  " ",
                  selectedTrigger.collectionName.join(", ")
                ] }),
                /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                  /* @__PURE__ */ jsx("strong", { children: "Last Updated:" }),
                  " ",
                  selectedTrigger.lastUpdated
                ] })
              ] }),
              templateError && /* @__PURE__ */ jsx(
                Banner,
                {
                  title: "Template Loading Error",
                  tone: "critical",
                  onDismiss: () => setTemplateError(null),
                  children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: templateError })
                }
              ),
              /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h4", children: "WhatsApp Template Preview" }),
                loadingTemplateDetails ? /* @__PURE__ */ jsxs("div", { style: { textAlign: "center", padding: "40px 20px" }, children: [
                  /* @__PURE__ */ jsx(Spinner, { accessibilityLabel: "Loading template details", size: "large" }),
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", alignment: "center", children: "Loading template details..." })
                ] }) : selectedTemplateData ? /* @__PURE__ */ jsx(
                  WhatsAppPreview,
                  {
                    template: selectedTemplateData,
                    variant: "full",
                    showWhatsAppHeader: true
                  }
                ) : /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: selectedTrigger.templateName === "No Template" ? "No template assigned to this trigger" : `Template preview not available for "${selectedTrigger.templateName}"` })
              ] })
            ] }) })
          }
        )
      ]
    }
  );
}
const route24 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: AbandonedCartTriggersPage
}, Symbol.toStringTag, { value: "Module" }));
const transformAutoReplyData = (apiData) => {
  if (!apiData || !apiData.data) return [];
  return apiData.data.map((item) => {
    let replyContent = "";
    let templateName = "";
    let replyType = item.type || "text";
    try {
      const replyData = JSON.parse(item.reply || "{}");
    } catch (error) {
      console.error("Error parsing reply data:", error);
      replyContent = "Invalid reply format";
    }
    return {
      id: item.id.toString(),
      keyword: item.keyword || "",
      condition: item.type_keyword === "Equal" ? "equals" : "contains",
      templateName,
      replyContent,
      type: item.template_sub_type || replyType,
      isActive: true,
      createdAt: item.created_at,
      updatedAt: item.updated_at,
      rawData: item
    };
  });
};
function TriggerIndexTable({ triggers, onToggleStatus, onDeleteTrigger, loading, deletingTriggers = [] }) {
  const navigate = useNavigate();
  const [deletePopoverActive, setDeletePopoverActive] = useState(null);
  const resourceName = {
    singular: "trigger",
    plural: "triggers"
  };
  const { selectedResources, allResourcesSelected, handleSelectionChange } = useIndexResourceState(triggers);
  useCallback((triggerId, event) => {
    event.stopPropagation();
    onToggleStatus(triggerId);
  }, [onToggleStatus]);
  useCallback((triggerId, event) => {
    event.stopPropagation();
    navigate(`/app/edit-auto-trigger/${triggerId}`);
  }, [navigate]);
  const handleViewTrigger = useCallback((triggerId, event) => {
    event.stopPropagation();
    console.log("View trigger:", triggerId);
  }, []);
  const handleDeleteTrigger = useCallback((triggerId, event) => {
    event.stopPropagation();
    setDeletePopoverActive(triggerId);
  }, []);
  const handleConfirmDelete = useCallback((triggerId) => {
    onDeleteTrigger(triggerId);
    setDeletePopoverActive(null);
  }, [onDeleteTrigger]);
  const handleCancelDelete = useCallback(() => {
    setDeletePopoverActive(null);
  }, []);
  if (loading) {
    return /* @__PURE__ */ jsxs("div", { style: { padding: "2rem", textAlign: "center" }, children: [
      /* @__PURE__ */ jsx(Spinner, { size: "large" }),
      /* @__PURE__ */ jsx(Text, { variant: "bodyMd", color: "subdued", as: "p", alignment: "center", children: "Loading auto reply triggers..." })
    ] });
  }
  if (triggers.length === 0) {
    return /* @__PURE__ */ jsx("div", { style: { padding: "2rem", textAlign: "center" }, children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", color: "subdued", as: "p", alignment: "center", children: "No auto reply triggers found. Create your first trigger to get started." }) });
  }
  const rowMarkup = triggers.map(
    ({ id, keyword, condition, type, isActive, createdAt }, index2) => /* @__PURE__ */ jsxs(
      IndexTable.Row,
      {
        id,
        selected: selectedResources.includes(id),
        position: index2,
        children: [
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", fontWeight: "medium", children: "If keyword" }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Badge, { tone: condition === "equals" ? "info" : "attention", children: condition === "equals" ? "Exact Match" : "Contains" }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", fontWeight: "medium", children: keyword }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: type }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Badge, { tone: isActive ? "success" : "critical", children: isActive ? "Active" : "Inactive" }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", color: "subdued", children: new Date(createdAt).toLocaleDateString() }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsxs(InlineStack, { align: "end", gap: "200", children: [
            /* @__PURE__ */ jsx(Tooltip, { content: "View Message Preview", children: /* @__PURE__ */ jsx(
              Button,
              {
                size: "slim",
                icon: ViewIcon,
                onClick: (event) => handleViewTrigger(id, event)
              }
            ) }),
            /* @__PURE__ */ jsx(
              Popover,
              {
                active: deletePopoverActive === id,
                activator: /* @__PURE__ */ jsx(Tooltip, { content: "Delete Trigger", children: /* @__PURE__ */ jsx(
                  Button,
                  {
                    size: "slim",
                    icon: DeleteIcon,
                    onClick: (event) => handleDeleteTrigger(id, event),
                    loading: deletingTriggers.includes(id),
                    disabled: deletingTriggers.includes(id)
                  }
                ) }),
                onClose: handleCancelDelete,
                ariaHaspopup: false,
                sectioned: true,
                children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: "Delete Auto Reply Trigger" }),
                  /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                    'Are you sure you want to delete the auto reply trigger for keyword "',
                    keyword,
                    '"? This action cannot be undone.'
                  ] }),
                  /* @__PURE__ */ jsxs(InlineStack, { gap: "200", align: "end", children: [
                    /* @__PURE__ */ jsx(Button, { onClick: handleCancelDelete, children: "Cancel" }),
                    /* @__PURE__ */ jsx(
                      Button,
                      {
                        variant: "primary",
                        tone: "critical",
                        onClick: () => handleConfirmDelete(id),
                        loading: deletingTriggers.includes(id),
                        children: "Delete Trigger"
                      }
                    )
                  ] })
                ] })
              }
            )
          ] }) })
        ]
      },
      id
    )
  );
  return /* @__PURE__ */ jsx(
    IndexTable,
    {
      resourceName,
      itemCount: triggers.length,
      selectedItemsCount: allResourcesSelected ? "All" : selectedResources.length,
      onSelectionChange: handleSelectionChange,
      headings: [
        { title: "If keyword" },
        { title: "Condition" },
        { title: "Keyword" },
        { title: "Type" },
        { title: "Status" },
        { title: "Created" },
        { title: "Actions", alignment: "end" }
      ],
      children: rowMarkup
    }
  );
}
function AutoReplyTriggersPage() {
  const navigate = useNavigate();
  const [autoReplyData, setAutoReplyData] = useState([]);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);
  const [deletingTriggers, setDeletingTriggers] = useState([]);
  const [queryValue, setQueryValue] = useState("");
  const [sortSelected, setSortSelected] = useState(["keyword asc"]);
  const [statusFilter, setStatusFilter2] = useState([]);
  const [typeFilter, setTypeFilter] = useState([]);
  const [pagination, setPagination] = useState({
    currentPage: 1,
    totalPages: 1,
    totalItems: 0,
    perPage: 20
  });
  const { mode: mode2, setMode } = useSetIndexFiltersMode();
  const fetchAutoReplies = useCallback(async (page = 1) => {
    try {
      setLoading(true);
      setError(null);
      const response = await fetchAutoReplyList({
        statusType: "All",
        page,
        perPageData: pagination.perPage
      });
      if (response.status && response.WhatsappBusinessAutoReply) {
        const transformedData = transformAutoReplyData(response.WhatsappBusinessAutoReply);
        setAutoReplyData(transformedData);
        setPagination({
          currentPage: response.WhatsappBusinessAutoReply.current_page || 1,
          totalPages: response.WhatsappBusinessAutoReply.last_page || 1,
          totalItems: response.WhatsappBusinessAutoReply.total || 0,
          perPage: parseInt(response.WhatsappBusinessAutoReply.per_page) || 10
        });
      } else {
        throw new Error("Invalid API response format");
      }
    } catch (err) {
      console.error("Error fetching auto replies:", err);
      setError(err.message || "Failed to fetch auto reply triggers");
      setAutoReplyData([]);
    } finally {
      setLoading(false);
    }
  }, [pagination.perPage]);
  useEffect(() => {
    fetchAutoReplies(1);
  }, []);
  const handleCreateTrigger = useCallback(() => {
    navigate("/app/auto-triggers/create-auto-reply");
  }, [navigate]);
  const handleToggleStatus = useCallback((triggerId) => {
    setAutoReplyData(
      (prev) => prev.map(
        (trigger) => trigger.id === triggerId ? { ...trigger, isActive: !trigger.isActive } : trigger
      )
    );
  }, []);
  const handleDeleteTrigger = useCallback(async (triggerId) => {
    try {
      setDeletingTriggers((prev) => [...prev, triggerId]);
      await deleteAutoReply(triggerId);
      setAutoReplyData((prev) => prev.filter((trigger) => trigger.id !== triggerId));
      console.log("Auto reply trigger deleted successfully");
    } catch (error2) {
      console.error("Error deleting auto reply trigger:", error2);
      setError(error2.message || "Failed to delete auto reply trigger");
    } finally {
      setDeletingTriggers((prev) => prev.filter((id) => id !== triggerId));
    }
  }, []);
  const handlePageChange = useCallback((page) => {
    fetchAutoReplies(page);
  }, [fetchAutoReplies]);
  const handleRefresh = useCallback(() => {
    fetchAutoReplies(pagination.currentPage);
  }, [fetchAutoReplies, pagination.currentPage]);
  const handleDismissError = useCallback(() => {
    setError(null);
  }, []);
  const handleFiltersQueryChange = useCallback((value) => {
    setQueryValue(value);
  }, []);
  const handleQueryValueRemove = useCallback(() => setQueryValue(""), []);
  const handleStatusChange = useCallback((value) => {
    setStatusFilter2(value);
  }, []);
  const handleTypeChange = useCallback((value) => {
    setTypeFilter(value);
  }, []);
  const handleStatusRemove = useCallback(() => setStatusFilter2([]), []);
  const handleTypeRemove = useCallback(() => setTypeFilter([]), []);
  const handleFiltersClearAll = useCallback(() => {
    handleStatusRemove();
    handleTypeRemove();
    handleQueryValueRemove();
  }, [handleStatusRemove, handleTypeRemove, handleQueryValueRemove]);
  const filteredTriggers = useMemo(() => {
    if (!Array.isArray(autoReplyData)) return [];
    return autoReplyData.filter((trigger) => {
      var _a2, _b, _c, _d, _e;
      const matchesSearch = !queryValue.trim() || (((_a2 = trigger.keyword) == null ? void 0 : _a2.toLowerCase().includes(queryValue.toLowerCase())) || ((_b = trigger.templateName) == null ? void 0 : _b.toLowerCase().includes(queryValue.toLowerCase())) || ((_c = trigger.type) == null ? void 0 : _c.toLowerCase().includes(queryValue.toLowerCase())) || ((_d = trigger.condition) == null ? void 0 : _d.toLowerCase().includes(queryValue.toLowerCase())));
      const matchesStatus = !Array.isArray(statusFilter) || statusFilter.length === 0 || statusFilter.includes(trigger.isActive ? "active" : "inactive");
      const matchesType = !Array.isArray(typeFilter) || typeFilter.length === 0 || typeFilter.includes((_e = trigger.type) == null ? void 0 : _e.toLowerCase());
      return matchesSearch && matchesStatus && matchesType;
    });
  }, [autoReplyData, queryValue, statusFilter, typeFilter]);
  const sortOptions = [
    { label: "Keyword", value: "keyword asc", directionLabel: "A-Z" },
    { label: "Keyword", value: "keyword desc", directionLabel: "Z-A" },
    { label: "Type", value: "type asc", directionLabel: "A-Z" },
    { label: "Type", value: "type desc", directionLabel: "Z-A" },
    { label: "Created Date", value: "created asc", directionLabel: "Oldest first" },
    { label: "Created Date", value: "created desc", directionLabel: "Newest first" }
  ];
  const filters = [
    {
      key: "status",
      label: "Status",
      filter: /* @__PURE__ */ jsx(
        ChoiceList,
        {
          title: "Status",
          titleHidden: true,
          choices: [
            { label: "Active", value: "active" },
            { label: "Inactive", value: "inactive" }
          ],
          selected: statusFilter || [],
          onChange: handleStatusChange,
          allowMultiple: true
        }
      ),
      shortcut: true
    },
    {
      key: "type",
      label: "Reply Type",
      filter: /* @__PURE__ */ jsx(
        ChoiceList,
        {
          title: "Reply Type",
          titleHidden: true,
          choices: [
            { label: "Text", value: "text" },
            { label: "Template", value: "template" }
          ],
          selected: typeFilter || [],
          onChange: handleTypeChange,
          allowMultiple: true
        }
      ),
      shortcut: true
    }
  ];
  const appliedFilters = [];
  if (Array.isArray(statusFilter) && statusFilter.length > 0) {
    appliedFilters.push({
      key: "status",
      label: `Status: ${statusFilter.map((s) => s.charAt(0).toUpperCase() + s.slice(1)).join(", ")}`,
      onRemove: handleStatusRemove
    });
  }
  if (Array.isArray(typeFilter) && typeFilter.length > 0) {
    appliedFilters.push({
      key: "type",
      label: `Type: ${typeFilter.map((t) => t.charAt(0).toUpperCase() + t.slice(1)).join(", ")}`,
      onRemove: handleTypeRemove
    });
  }
  return /* @__PURE__ */ jsxs(
    Page,
    {
      title: "Auto Reply Triggers",
      subtitle: "Set up keyword-based automatic replies for customer inquiries",
      fullWidth: true,
      primaryAction: {
        content: /* @__PURE__ */ jsx(InlineStack, { alignment: "center", children: /* @__PURE__ */ jsx(Text, { as: "span", children: "Create Auto Reply Trigger" }) }),
        onAction: handleCreateTrigger
      },
      secondaryActions: [
        {
          content: "Refresh",
          onAction: handleRefresh,
          loading
        },
        {
          content: "Back to Auto Triggers",
          onAction: () => navigate("/app/auto-triggers")
        }
      ],
      children: [
        error && /* @__PURE__ */ jsx(
          Banner,
          {
            title: "Error loading auto reply triggers",
            tone: "critical",
            onDismiss: handleDismissError,
            children: /* @__PURE__ */ jsx("p", { children: error })
          }
        ),
        /* @__PURE__ */ jsxs(LegacyCard, { children: [
          /* @__PURE__ */ jsx(
            IndexFilters,
            {
              sortOptions,
              sortSelected,
              queryValue,
              queryPlaceholder: "Search triggers by keyword, template, type...",
              onQueryChange: handleFiltersQueryChange,
              onQueryClear: handleQueryValueRemove,
              onSort: setSortSelected,
              filters,
              appliedFilters,
              onClearAll: handleFiltersClearAll,
              mode: mode2,
              setMode,
              tabs: [],
              selected: 0,
              onSelect: () => {
              }
            }
          ),
          /* @__PURE__ */ jsx(
            TriggerIndexTable,
            {
              triggers: filteredTriggers,
              onToggleStatus: handleToggleStatus,
              onDeleteTrigger: handleDeleteTrigger,
              loading,
              deletingTriggers
            }
          ),
          !loading && pagination.totalPages > 1 && /* @__PURE__ */ jsx(LegacyCard.Section, { children: /* @__PURE__ */ jsx(InlineStack, { align: "center", children: /* @__PURE__ */ jsx(
            Pagination,
            {
              hasPrevious: pagination.currentPage > 1,
              onPrevious: () => handlePageChange(pagination.currentPage - 1),
              hasNext: pagination.currentPage < pagination.totalPages,
              onNext: () => handlePageChange(pagination.currentPage + 1),
              label: `Page ${pagination.currentPage} of ${pagination.totalPages}`
            }
          ) }) })
        ] })
      ]
    }
  );
}
const route25 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: AutoReplyTriggersPage
}, Symbol.toStringTag, { value: "Module" }));
function AutoTriggersIndexPage() {
  const navigate = useNavigate();
  useCallback(() => {
    navigate("/app/auto-triggers/create-abandoned-cart");
  }, [navigate]);
  const triggerTypes = [
    {
      title: "Abandoned Cart Recovery",
      description: "Recover lost sales by sending automated messages to customers who abandon their shopping carts.",
      icon: CartIcon,
      route: "/app/auto-triggers/abandoned-cart",
      createRoute: "/app/auto-triggers/create-abandoned-cart",
      stats: "3 triggers configured",
      color: "warning"
    },
    {
      title: "Order Confirmation",
      description: "Keep customers informed with automated order confirmations, shipping updates, and delivery notifications.",
      icon: OrderIcon,
      route: "/app/auto-triggers/order-confirmation",
      createRoute: "/app/auto-triggers/create-order-confirmation",
      stats: "3 triggers configured",
      color: "success"
    },
    {
      title: "Auto Reply",
      description: "Provide instant responses to customer inquiries based on keywords and common questions.",
      icon: ChatIcon,
      route: "/app/auto-triggers/auto-reply",
      createRoute: "/app/auto-triggers/create-auto-reply",
      stats: "3 triggers configured",
      color: "info"
    }
  ];
  return /* @__PURE__ */ jsx(
    Page,
    {
      title: "Auto Triggers",
      subtitle: "Setup automated WhatsApp messages based on customer behavior and keywords",
      fullWidth: true,
      children: /* @__PURE__ */ jsxs(BlockStack, { gap: "600", children: [
        /* @__PURE__ */ jsx(LegacyCard, { sectioned: true, children: /* @__PURE__ */ jsx(BlockStack, { gap: "400", children: /* @__PURE__ */ jsx(Banner, { status: "info", children: "Select the type of automated trigger you want to manage. Each trigger type serves different customer engagement purposes." }) }) }),
        /* @__PURE__ */ jsx(Grid, { children: triggerTypes.map((triggerType) => /* @__PURE__ */ jsx(Grid.Cell, { columnSpan: { xs: 6, sm: 3, md: 3, lg: 4, xl: 4 }, children: /* @__PURE__ */ jsx(LegacyCard, { children: /* @__PURE__ */ jsx(LegacyCard.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsx(InlineStack, { align: "left", children: /* @__PURE__ */ jsx(Icon, { source: triggerType.icon, tone: triggerType.color }) }),
          /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingSm", fontWeight: "semibold", children: triggerType.title }),
            /* @__PURE__ */ jsx(Text, { variant: "bodyMd", color: "subdued", children: triggerType.description })
          ] }),
          /* @__PURE__ */ jsx(InlineStack, { align: "right", children: /* @__PURE__ */ jsx(
            Button,
            {
              onClick: () => navigate(triggerType.route),
              icon: ArrowRightIcon,
              iconAlignment: "end",
              variant: "primary",
              children: "Manage Triggers"
            }
          ) })
        ] }) }) }) }, triggerType.title)) }),
        /* @__PURE__ */ jsx(LegacyCard, { sectioned: true, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsx(Text, { variant: "headingMd", children: "Getting Started" }),
          /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", children: [
              "• ",
              /* @__PURE__ */ jsx("strong", { children: "Abandoned Cart Recovery:" }),
              " Set up triggers to send reminders when customers leave items in their cart"
            ] }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", children: [
              "• ",
              /* @__PURE__ */ jsx("strong", { children: "Order Confirmation:" }),
              " Automatically notify customers about order status changes"
            ] }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", children: [
              "• ",
              /* @__PURE__ */ jsx("strong", { children: "Auto Reply:" }),
              " Create keyword-based responses for common customer inquiries"
            ] })
          ] })
        ] }) })
      ] })
    }
  );
}
const route26 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: AutoTriggersIndexPage
}, Symbol.toStringTag, { value: "Module" }));
function ContactListLayout() {
  return /* @__PURE__ */ jsx(Outlet, {});
}
const route27 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: ContactListLayout
}, Symbol.toStringTag, { value: "Module" }));
function LiveSegmentContactsPage() {
  const navigate = useNavigate();
  const { name } = useParams();
  const decodedName = decodeURIComponent(name);
  const [selectedContact, setSelectedContact] = useState(null);
  const [editModalActive, setEditModalActive] = useState(false);
  const [refreshing, setRefreshing] = useState(false);
  const [itemStrings, setItemStrings] = useState([
    "All",
    "Recently Added",
    "High Engagement",
    "Active Orders"
  ]);
  const [selected, setSelected] = useState(0);
  const [queryValue, setQueryValue] = useState("");
  const [sortSelected, setSortSelected] = useState(["name asc"]);
  const [statusFilter, setStatusFilter2] = useState([]);
  const [locationFilter, setLocationFilter] = useState("");
  const [engagementFilter, setEngagementFilter] = useState([0, 100]);
  const { mode: mode2, setMode } = useSetIndexFiltersMode();
  const [currentPage, setCurrentPage] = useState(1);
  const itemsPerPage = 20;
  const contacts = [
    { id: "1", customerName: "John Smith", phone: "+1 (555) 123-4567", email: "john.smith@email.com", status: "Active", location: "New York, NY", orderValue: 1250, lastOrder: "2024-01-15", joinDate: "2023-08-10", tags: ["VIP", "Newsletter"], totalOrders: 8, company: "Tech Corp", engagementRate: 92.5 },
    { id: "2", customerName: "Sarah Johnson", phone: "+1 (555) 234-5678", email: "sarah.j@email.com", status: "Active", location: "Los Angeles, CA", orderValue: 890.5, lastOrder: "2024-01-14", joinDate: "2023-09-15", tags: ["Regular"], totalOrders: 5, company: "Design Studio", engagementRate: 87.3 },
    { id: "3", customerName: "Mike Wilson", phone: "+1 (555) 345-6789", email: "mike.wilson@email.com", status: "Inactive", location: "Chicago, IL", orderValue: 2340.75, lastOrder: "2023-12-20", joinDate: "2023-06-22", tags: ["VIP", "Bulk Buyer"], totalOrders: 12, company: "Wilson & Co", engagementRate: 78.9 }
  ];
  const sleep = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
  const deleteView = (index2) => {
    const newItemStrings = [...itemStrings];
    newItemStrings.splice(index2, 1);
    setItemStrings(newItemStrings);
    setSelected(0);
  };
  const duplicateView = async (name2) => {
    setItemStrings([...itemStrings, name2]);
    setSelected(itemStrings.length);
    await sleep(1);
    return true;
  };
  const onCreateNewView = async (value) => {
    await sleep(500);
    setItemStrings([...itemStrings, value]);
    setSelected(itemStrings.length);
    return true;
  };
  const tabs = itemStrings.map((item, index2) => ({
    content: item,
    index: index2,
    onAction: () => {
    },
    id: `${item}-${index2}`,
    isLocked: index2 === 0,
    actions: index2 === 0 ? [] : [
      {
        type: "rename",
        onAction: () => {
        },
        onPrimaryAction: async (value) => {
          const newItemsStrings = tabs.map((item2, idx) => idx === index2 ? value : item2.content);
          await sleep(1);
          setItemStrings(newItemsStrings);
          return true;
        }
      },
      { type: "duplicate", onPrimaryAction: async (value) => {
        await sleep(1);
        duplicateView(value);
        return true;
      } },
      { type: "edit" },
      { type: "delete", onPrimaryAction: async () => {
        await sleep(1);
        deleteView(index2);
        return true;
      } }
    ]
  }));
  const filteredContacts = useMemo(() => {
    let filtered = contacts;
    if (selected === 1) {
      const sevenDaysAgo = /* @__PURE__ */ new Date();
      sevenDaysAgo.setDate(sevenDaysAgo.getDate() - 7);
      filtered = filtered.filter((contact) => new Date(contact.joinDate) >= sevenDaysAgo);
    } else if (selected === 2) {
      filtered = filtered.filter((contact) => contact.engagementRate >= 90);
    } else if (selected === 3) {
      const thirtyDaysAgo = /* @__PURE__ */ new Date();
      thirtyDaysAgo.setDate(thirtyDaysAgo.getDate() - 30);
      filtered = filtered.filter((contact) => new Date(contact.lastOrder) >= thirtyDaysAgo);
    }
    return filtered.filter((contact) => {
      const matchesSearch = contact.customerName.toLowerCase().includes(queryValue.toLowerCase()) || contact.email.toLowerCase().includes(queryValue.toLowerCase()) || contact.phone.includes(queryValue) || contact.company.toLowerCase().includes(queryValue.toLowerCase());
      const matchesStatus = statusFilter.length === 0 || statusFilter.includes(contact.status.toLowerCase());
      const matchesLocation = locationFilter === "" || contact.location.toLowerCase().includes(locationFilter.toLowerCase());
      const matchesMetric = contact.engagementRate >= engagementFilter[0] && contact.engagementRate <= engagementFilter[1];
      return matchesSearch && matchesStatus && matchesLocation && matchesMetric;
    });
  }, [contacts, queryValue, statusFilter, locationFilter, engagementFilter, selected]);
  const sortedContacts = useMemo(() => {
    const sorted = [...filteredContacts];
    const [sortKey, sortDirection] = sortSelected[0].split(" ");
    sorted.sort((a, b) => {
      let aValue, bValue;
      switch (sortKey) {
        case "name":
          aValue = a.customerName.toLowerCase();
          bValue = b.customerName.toLowerCase();
          break;
        case "email":
          aValue = a.email.toLowerCase();
          bValue = b.email.toLowerCase();
          break;
        case "engagement":
          aValue = a.engagementRate;
          bValue = b.engagementRate;
          break;
        default:
          return 0;
      }
      if (aValue < bValue) return sortDirection === "asc" ? -1 : 1;
      if (aValue > bValue) return sortDirection === "asc" ? 1 : -1;
      return 0;
    });
    return sorted;
  }, [filteredContacts, sortSelected]);
  const paginatedContacts = useMemo(() => {
    const startIndex = (currentPage - 1) * itemsPerPage;
    const endIndex = startIndex + itemsPerPage;
    return sortedContacts.slice(startIndex, endIndex);
  }, [sortedContacts, currentPage, itemsPerPage]);
  const totalItems = sortedContacts.length;
  const totalPages = Math.ceil(totalItems / itemsPerPage);
  const startItem = (currentPage - 1) * itemsPerPage + 1;
  const endItem = Math.min(currentPage * itemsPerPage, totalItems);
  const hasNext = currentPage < totalPages;
  const hasPrevious = currentPage > 1;
  const handlePreviousPage = useCallback(() => {
    setCurrentPage((prev) => Math.max(1, prev - 1));
  }, []);
  const handleNextPage = useCallback(() => {
    const totalPages2 = Math.ceil(sortedContacts.length / itemsPerPage);
    setCurrentPage((prev) => Math.min(totalPages2, prev + 1));
  }, [sortedContacts.length, itemsPerPage]);
  const sortOptions = [
    { label: "Customer Name", value: "name asc", directionLabel: "A-Z" },
    { label: "Customer Name", value: "name desc", directionLabel: "Z-A" },
    { label: "Email", value: "email asc", directionLabel: "A-Z" },
    { label: "Email", value: "email desc", directionLabel: "Z-A" },
    { label: "Engagement Rate", value: "engagement asc", directionLabel: "Low to High" },
    { label: "Engagement Rate", value: "engagement desc", directionLabel: "High to Low" }
  ];
  const handleEditClick = useCallback((contact) => {
    setSelectedContact(contact);
    setEditModalActive(true);
  }, []);
  const handleRefreshSegment = useCallback(async () => {
    setRefreshing(true);
    setTimeout(() => setRefreshing(false), 2e3);
  }, []);
  const handleModalClose = useCallback(() => {
    setEditModalActive(false);
    setSelectedContact(null);
  }, []);
  const getStatusBadge = (status) => {
    var _a2;
    const statusConfig = { "Active": { tone: "success" }, "Inactive": { tone: "subdued" }, "Pending": { tone: "attention" }, "Blocked": { tone: "critical" } };
    return /* @__PURE__ */ jsx(Badge, { tone: ((_a2 = statusConfig[status]) == null ? void 0 : _a2.tone) || "info", children: status });
  };
  const getEngagementBadge = (rate) => {
    if (rate >= 90) return /* @__PURE__ */ jsxs(Badge, { tone: "success", children: [
      rate,
      "%"
    ] });
    if (rate >= 70) return /* @__PURE__ */ jsxs(Badge, { tone: "info", children: [
      rate,
      "%"
    ] });
    if (rate >= 50) return /* @__PURE__ */ jsxs(Badge, { tone: "attention", children: [
      rate,
      "%"
    ] });
    return /* @__PURE__ */ jsxs(Badge, { tone: "critical", children: [
      rate,
      "%"
    ] });
  };
  const filters = [
    { key: "status", label: "Status", filter: /* @__PURE__ */ jsx(ChoiceList, { title: "Status", titleHidden: true, choices: [{ label: "Active", value: "active" }, { label: "Inactive", value: "inactive" }, { label: "Pending", value: "pending" }, { label: "Blocked", value: "blocked" }], selected: statusFilter || [], onChange: setStatusFilter2, allowMultiple: true }), shortcut: true },
    { key: "location", label: "Location", filter: /* @__PURE__ */ jsx(TextField, { label: "Location", value: locationFilter, onChange: setLocationFilter, autoComplete: "off", labelHidden: true }), shortcut: true },
    { key: "engagement", label: "Engagement Rate", filter: /* @__PURE__ */ jsx(RangeSlider, { label: "Engagement rate", labelHidden: true, value: engagementFilter || [0, 100], suffix: "%", output: true, min: 0, max: 100, step: 5, onChange: setEngagementFilter }) }
  ];
  const appliedFilters = [];
  if (statusFilter.length > 0) appliedFilters.push({ key: "status", label: `Status: ${statusFilter.map((s) => s.charAt(0).toUpperCase() + s.slice(1)).join(", ")}`, onRemove: () => setStatusFilter2([]) });
  if (locationFilter) appliedFilters.push({ key: "location", label: `Location contains "${locationFilter}"`, onRemove: () => setLocationFilter("") });
  const resourceName = { singular: "contact", plural: "contacts" };
  const { selectedResources, allResourcesSelected, handleSelectionChange } = useIndexResourceState(paginatedContacts);
  const tableHeadings = [
    { title: "Customer Name" },
    { title: "Phone" },
    { title: "Email" },
    { title: "Location" },
    { title: "Status" },
    { title: "Engagement" },
    { title: "Order Value" },
    { title: "Last Order" },
    { title: "Actions", alignment: "end" }
  ];
  const rowMarkup = paginatedContacts.map((contact, index2) => /* @__PURE__ */ jsxs(IndexTable.Row, { id: contact.id, selected: selectedResources.includes(contact.id), position: index2, children: [
    /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "100", children: [
      /* @__PURE__ */ jsx(Text, { variant: "bodyMd", fontWeight: "semibold", as: "span", children: contact.customerName }),
      /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "span", tone: "subdued", children: contact.company })
    ] }) }),
    /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(InlineStack, { gap: "200", alignment: "center", children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "span", children: contact.phone }) }) }),
    /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(InlineStack, { gap: "200", alignment: "center", children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "span", children: contact.email }) }) }),
    /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "span", children: contact.location }) }),
    /* @__PURE__ */ jsx(IndexTable.Cell, { children: getStatusBadge(contact.status) }),
    /* @__PURE__ */ jsx(IndexTable.Cell, { children: getEngagementBadge(contact.engagementRate) }),
    /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsxs(Text, { as: "span", numeric: true, children: [
      "$",
      contact.orderValue.toLocaleString()
    ] }) }),
    /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "span", children: contact.lastOrder }) }),
    /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(InlineStack, { align: "end", gap: "200", children: /* @__PURE__ */ jsx(Tooltip, { content: "View contact details", children: /* @__PURE__ */ jsx(Button, { size: "slim", onClick: (event) => {
      event.stopPropagation();
      handleEditClick(contact);
    }, children: /* @__PURE__ */ jsx(Icon, { source: EditIcon }) }) }) }) })
  ] }, contact.id));
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      Page,
      {
        title: `Live Segment: ${decodedName}`,
        subtitle: `${totalItems} contacts currently match this segment criteria`,
        fullWidth: true,
        breadcrumbs: [{ content: "Contact Lists", onAction: () => navigate("/app/contact-list/live-segment") }],
        primaryAction: { content: /* @__PURE__ */ jsx(InlineStack, { alignment: "center", children: /* @__PURE__ */ jsx(Text, { as: "span", children: "Export Contacts" }) }), onAction: () => console.log("Export contacts clicked") },
        secondaryActions: [{ content: "Refresh Segment", icon: RefreshIcon, loading: refreshing, onAction: handleRefreshSegment }, { content: "Back to Segments", icon: ArrowLeftIcon, onAction: () => navigate("/app/contact-list/live-segment") }],
        children: /* @__PURE__ */ jsx(BlockStack, { gap: "400", children: /* @__PURE__ */ jsxs(LegacyCard, { children: [
          /* @__PURE__ */ jsx(
            IndexFilters,
            {
              sortOptions,
              sortSelected,
              queryValue,
              queryPlaceholder: "Search contacts...",
              onQueryChange: setQueryValue,
              onQueryClear: () => setQueryValue(""),
              onSort: setSortSelected,
              cancelAction: { onAction: () => {
              }, disabled: false, loading: false },
              tabs,
              selected,
              onSelect: setSelected,
              canCreateNewView: true,
              onCreateNewView,
              filters,
              appliedFilters,
              onClearAll: () => {
                setStatusFilter2([]);
                setLocationFilter("");
                setQueryValue("");
                setEngagementFilter([0, 100]);
              },
              mode: mode2,
              setMode
            }
          ),
          /* @__PURE__ */ jsx(
            IndexTable,
            {
              resourceName,
              itemCount: paginatedContacts.length,
              selectedItemsCount: allResourcesSelected ? "All" : selectedResources.length,
              onSelectionChange: handleSelectionChange,
              headings: tableHeadings,
              emptyState: /* @__PURE__ */ jsxs("div", { style: { textAlign: "center", padding: "60px 20px" }, children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: "No contacts found" }),
                /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: `No contacts currently match this segment criteria.` })
              ] }),
              children: rowMarkup
            }
          ),
          totalItems > itemsPerPage && /* @__PURE__ */ jsx("div", { style: { maxWidth: "700px", margin: "auto", border: "1px solid var(--p-color-border)", marginTop: "16px" }, children: /* @__PURE__ */ jsx(Pagination, { onPrevious: hasPrevious ? handlePreviousPage : void 0, onNext: hasNext ? handleNextPage : void 0, type: "table", hasNext, hasPrevious, label: `${startItem}-${endItem} of ${totalItems} contacts` }) })
        ] }) })
      }
    ),
    selectedContact && /* @__PURE__ */ jsx(Modal, { open: editModalActive, onClose: handleModalClose, title: `Contact Details: ${selectedContact.customerName}`, primaryAction: { content: "Close", onAction: handleModalClose }, children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
      /* @__PURE__ */ jsxs(TextContainer, { children: [
        /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
          /* @__PURE__ */ jsx("strong", { children: "Name:" }),
          " ",
          selectedContact.customerName
        ] }),
        /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
          /* @__PURE__ */ jsx("strong", { children: "Email:" }),
          " ",
          selectedContact.email
        ] }),
        /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
          /* @__PURE__ */ jsx("strong", { children: "Phone:" }),
          " ",
          selectedContact.phone
        ] }),
        /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
          /* @__PURE__ */ jsx("strong", { children: "Company:" }),
          " ",
          selectedContact.company
        ] }),
        /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
          /* @__PURE__ */ jsx("strong", { children: "Location:" }),
          " ",
          selectedContact.location
        ] }),
        /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
          /* @__PURE__ */ jsx("strong", { children: "Status:" }),
          " ",
          selectedContact.status
        ] }),
        /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
          /* @__PURE__ */ jsx("strong", { children: "Engagement Rate:" }),
          " ",
          selectedContact.engagementRate,
          "%"
        ] }),
        /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
          /* @__PURE__ */ jsx("strong", { children: "Total Orders:" }),
          " ",
          selectedContact.totalOrders
        ] }),
        /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
          /* @__PURE__ */ jsx("strong", { children: "Order Value:" }),
          " $",
          selectedContact.orderValue.toLocaleString()
        ] }),
        /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
          /* @__PURE__ */ jsx("strong", { children: "Last Order:" }),
          " ",
          selectedContact.lastOrder
        ] }),
        /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
          /* @__PURE__ */ jsx("strong", { children: "Join Date:" }),
          " ",
          selectedContact.joinDate
        ] })
      ] }),
      /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
        /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h4", children: "Tags" }),
        /* @__PURE__ */ jsx(InlineStack, { gap: "200", children: selectedContact.tags.map((tag, index2) => /* @__PURE__ */ jsx(Badge, { tone: "info", children: tag }, index2)) })
      ] })
    ] }) }) })
  ] });
}
const route28 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: LiveSegmentContactsPage
}, Symbol.toStringTag, { value: "Module" }));
function StaticListContactsPage() {
  const navigate = useNavigate();
  const { name } = useParams();
  const [searchParams] = useSearchParams();
  const decodedName = decodeURIComponent(name);
  const listId = searchParams.get("id");
  const [selectedContact, setSelectedContact] = useState(null);
  const [editModalActive, setEditModalActive] = useState(false);
  const [savingEdit, setSavingEdit] = useState(false);
  const [editName, setEditName] = useState("");
  const [editCountryCode, setEditCountryCode] = useState("");
  const [editPhone, setEditPhone] = useState("");
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);
  const [addModalActive, setAddModalActive] = useState(false);
  const [addingContact, setAddingContact] = useState(false);
  const [addName, setAddName] = useState("");
  const [addCountryCode, setAddCountryCode] = useState("");
  const [addPhone, setAddPhone] = useState("");
  const [itemStrings, setItemStrings] = useState([
    "All",
    "Recently Added",
    "High Value",
    "Active"
  ]);
  const [selected, setSelected] = useState(0);
  const [queryValue, setQueryValue] = useState("");
  const [sortSelected, setSortSelected] = useState(["updated desc"]);
  const [statusFilter, setStatusFilter2] = useState([]);
  const [locationFilter, setLocationFilter] = useState("");
  const [orderValueFilter, setOrderValueFilter] = useState([0, 1e4]);
  const { mode: mode2, setMode } = useSetIndexFiltersMode();
  const [currentPage, setCurrentPage] = useState(1);
  const itemsPerPage = 20;
  const [contacts, setContacts] = useState([]);
  const [totalItems, setTotalItems] = useState(0);
  const [serverPagination, setServerPagination] = useState({ current_page: 1, last_page: 1, per_page: itemsPerPage });
  useEffect(() => {
    const loadContacts = async () => {
      try {
        setLoading(true);
        setError(null);
        const response = await fetchStaticContactListContacts({ page: currentPage, perPageData: itemsPerPage, contactListId: Number(listId || 0) });
        if (response.status && response.WhatsAppBusinessContact) {
          const { data, total, per_page, current_page, last_page } = response.WhatsAppBusinessContact;
          const transformed = data.map((item) => ({
            id: item.id.toString(),
            name: item.name || "Unknown",
            number: item.number || "",
            createdOn: item.created_at ? new Date(item.created_at).toISOString().slice(0, 10) : ""
          }));
          setContacts(transformed);
          setTotalItems(total || transformed.length);
          setServerPagination({ current_page: current_page || 1, last_page: last_page || 1, per_page: per_page || itemsPerPage });
        } else {
          setContacts([]);
          setTotalItems(0);
        }
      } catch (err) {
        setError(err.message);
        setContacts([]);
        setTotalItems(0);
      } finally {
        setLoading(false);
      }
    };
    loadContacts();
  }, [currentPage, itemsPerPage, listId]);
  const sleep = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
  const deleteView = (index2) => {
    const newItemStrings = [...itemStrings];
    newItemStrings.splice(index2, 1);
    setItemStrings(newItemStrings);
    setSelected(0);
  };
  const duplicateView = async (name2) => {
    setItemStrings([...itemStrings, name2]);
    setSelected(itemStrings.length);
    await sleep(1);
    return true;
  };
  const onCreateNewView = async (value) => {
    await sleep(500);
    setItemStrings([...itemStrings, value]);
    setSelected(itemStrings.length);
    return true;
  };
  const tabs = itemStrings.map((item, index2) => ({
    content: item,
    index: index2,
    onAction: () => {
    },
    id: `${item}-${index2}`,
    isLocked: index2 === 0,
    actions: index2 === 0 ? [] : [
      {
        type: "rename",
        onAction: () => {
        },
        onPrimaryAction: async (value) => {
          const newItemsStrings = tabs.map((item2, idx) => idx === index2 ? value : item2.content);
          await sleep(1);
          setItemStrings(newItemsStrings);
          return true;
        }
      },
      { type: "duplicate", onPrimaryAction: async (value) => {
        await sleep(1);
        duplicateView(value);
        return true;
      } },
      { type: "edit" },
      { type: "delete", onPrimaryAction: async () => {
        await sleep(1);
        deleteView(index2);
        return true;
      } }
    ]
  }));
  const filteredContacts = useMemo(() => {
    let filtered = contacts;
    return filtered.filter((contact) => {
      const matchesSearch = (contact.name || "").toLowerCase().includes(queryValue.toLowerCase()) || (contact.number || "").includes(queryValue);
      return matchesSearch;
    });
  }, [contacts, queryValue]);
  const sortedContacts = useMemo(() => {
    const sorted = [...filteredContacts];
    const [sortKey, sortDirection] = sortSelected[0].split(" ");
    sorted.sort((a, b) => {
      let aValue, bValue;
      switch (sortKey) {
        case "name":
          aValue = (a.name || "").toLowerCase();
          bValue = (b.name || "").toLowerCase();
          break;
        default:
          return 0;
      }
      if (aValue < bValue) return sortDirection === "asc" ? -1 : 1;
      if (aValue > bValue) return sortDirection === "asc" ? 1 : -1;
      return 0;
    });
    return sorted;
  }, [filteredContacts, sortSelected]);
  const paginatedContacts = useMemo(() => {
    return sortedContacts;
  }, [sortedContacts]);
  const totalPages = serverPagination.last_page || Math.ceil((totalItems || 0) / (serverPagination.per_page || itemsPerPage));
  const startItem = (serverPagination.current_page - 1) * (serverPagination.per_page || itemsPerPage) + 1;
  const endItem = Math.min(serverPagination.current_page * (serverPagination.per_page || itemsPerPage), totalItems);
  const hasNext = serverPagination.current_page < (serverPagination.last_page || totalPages);
  const hasPrevious = serverPagination.current_page > 1;
  const handlePreviousPage = useCallback(() => {
    setCurrentPage((prev) => Math.max(1, prev - 1));
  }, []);
  const handleNextPage = useCallback(() => {
    setCurrentPage((prev) => Math.min(serverPagination.last_page || 1, prev + 1));
  }, [serverPagination.last_page]);
  const sortOptions = [
    { label: "Name", value: "name asc", directionLabel: "A-Z" },
    { label: "Name", value: "name desc", directionLabel: "Z-A" },
    { lable: "Updated On", value: "updated asc", directionLabel: "Oldest First" },
    { lable: "Updated On", value: "updated desc", directionLabel: "Newest First" }
  ];
  const handleEditClick = useCallback((contact) => {
    setSelectedContact(contact);
    setEditModalActive(true);
  }, []);
  const handleModalClose = useCallback(() => {
    setEditModalActive(false);
    setSelectedContact(null);
  }, []);
  useEffect(() => {
    if (selectedContact) {
      const originalNumber = selectedContact.number || "";
      let derivedCountry = "";
      let derivedPhone = "";
      const digitsOnly = (originalNumber || "").replace(/\D/g, "");
      if (digitsOnly.length > 10) {
        derivedCountry = digitsOnly.slice(0, digitsOnly.length - 10);
        derivedPhone = digitsOnly.slice(-10);
      } else {
        derivedPhone = digitsOnly;
      }
      setEditName(selectedContact.name || "");
      setEditCountryCode(derivedCountry);
      setEditPhone(derivedPhone);
    } else {
      setEditName("");
      setEditCountryCode("");
      setEditPhone("");
    }
  }, [selectedContact]);
  const handleEditSave = useCallback(async () => {
    if (!selectedContact) return;
    try {
      setSavingEdit(true);
      const payload = {
        tag: Number(listId || 0),
        contactid: Number(selectedContact.id),
        allNewTagsAdd: [],
        name: editName,
        countrycode: editCountryCode,
        phone: editPhone
      };
      const res = await updateSingleContact(payload);
      const updatedNumber = `${editCountryCode ? `+${editCountryCode} ` : ""}${editPhone}`.trim();
      setContacts((prev) => prev.map((c) => c.id === selectedContact.id ? { ...c, name: editName, number: updatedNumber } : c));
      setEditModalActive(false);
      setSelectedContact(null);
    } catch (e) {
      console.error("Failed to update contact", e);
      setError((e == null ? void 0 : e.message) || "Failed to update contact");
    } finally {
      setSavingEdit(false);
    }
  }, [selectedContact, listId, editName, editCountryCode, editPhone]);
  const filters = [];
  const appliedFilters = [];
  const resourceName = { singular: "contact", plural: "contacts" };
  const { selectedResources, allResourcesSelected, handleSelectionChange } = useIndexResourceState(paginatedContacts);
  const tableHeadings = [
    { title: "Name" },
    { title: "Number" },
    { title: "Created On" },
    { title: "Actions", alignment: "end" }
  ];
  const rowMarkup = paginatedContacts.map((contact, index2) => /* @__PURE__ */ jsxs(IndexTable.Row, { id: contact.id, selected: selectedResources.includes(contact.id), position: index2, children: [
    /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", fontWeight: "semibold", as: "span", children: contact.name }) }),
    /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "span", children: contact.number }) }),
    /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "span", children: contact.createdOn }) }),
    /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(InlineStack, { align: "end", gap: "200", children: /* @__PURE__ */ jsx(Tooltip, { content: "Edit contact", children: /* @__PURE__ */ jsx(Button, { size: "slim", onClick: (event) => {
      event.stopPropagation();
      handleEditClick(contact);
    }, children: /* @__PURE__ */ jsx(Icon, { source: EditIcon }) }) }) }) })
  ] }, contact.id));
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      Page,
      {
        title: `Static List: ${decodedName}`,
        subtitle: `${totalItems} contacts in this list`,
        fullWidth: true,
        breadcrumbs: [{ content: "Contact Lists", onAction: () => navigate("/app/contact-list/static-list") }],
        primaryAction: { content: /* @__PURE__ */ jsx(InlineStack, { alignment: "center", children: /* @__PURE__ */ jsx(Text, { as: "span", children: "Add single contact" }) }), onAction: () => setAddModalActive(true) },
        secondaryActions: [{ content: "Back to Lists", icon: ArrowLeftIcon, onAction: () => navigate("/app/contact-list/static-list") }],
        children: /* @__PURE__ */ jsx(BlockStack, { gap: "400", children: /* @__PURE__ */ jsxs(LegacyCard, { children: [
          /* @__PURE__ */ jsx(
            IndexFilters,
            {
              sortOptions,
              sortSelected,
              queryValue,
              queryPlaceholder: "Search contacts...",
              onQueryChange: setQueryValue,
              onQueryClear: () => setQueryValue(""),
              onSort: setSortSelected,
              cancelAction: { onAction: () => {
              }, disabled: false, loading: false },
              tabs,
              selected,
              onSelect: setSelected,
              canCreateNewView: true,
              onCreateNewView,
              filters,
              appliedFilters,
              onClearAll: () => {
                setQueryValue("");
              },
              mode: mode2,
              setMode
            }
          ),
          /* @__PURE__ */ jsx(
            IndexTable,
            {
              resourceName,
              itemCount: paginatedContacts.length,
              selectedItemsCount: allResourcesSelected ? "All" : selectedResources.length,
              onSelectionChange: handleSelectionChange,
              headings: tableHeadings,
              emptyState: /* @__PURE__ */ jsxs("div", { style: { textAlign: "center", padding: "60px 20px" }, children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: loading ? "Loading contacts..." : error ? "Error loading contacts" : "No contacts found" }),
                /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: loading ? "Please wait while we fetch the contacts." : error ? `Error: ${error}` : "Try adjusting your filters to see more results." })
              ] }),
              children: rowMarkup
            }
          ),
          totalItems > itemsPerPage && /* @__PURE__ */ jsx("div", { style: { maxWidth: "700px", margin: "auto", border: "1px solid var(--p-color-border)", marginTop: "16px" }, children: /* @__PURE__ */ jsx(Pagination, { onPrevious: hasPrevious ? handlePreviousPage : void 0, onNext: hasNext ? handleNextPage : void 0, type: "table", hasNext, hasPrevious, label: `${startItem}-${endItem} of ${totalItems} contacts` }) })
        ] }) })
      }
    ),
    /* @__PURE__ */ jsx(
      Modal,
      {
        open: addModalActive,
        onClose: () => {
          setAddModalActive(false);
        },
        title: "Add contact",
        primaryAction: {
          content: "Add contact",
          loading: addingContact,
          onAction: async () => {
            try {
              setAddingContact(true);
              setError(null);
              const digitsInLabel = (addCountryCode || "").match(/\d+/g);
              const countryDigits = digitsInLabel ? digitsInLabel.join("") : (addCountryCode || "").replace(/\D/g, "");
              const phoneDigits = (addPhone || "").replace(/\D/g, "");
              const fullNumber = `${countryDigits}${phoneDigits}`;
              const payload = {
                tag: Number(listId || 0),
                number: fullNumber,
                messageType: "on",
                countrycode: addCountryCode,
                phone: phoneDigits,
                name: addName
              };
              await addSingleContact(payload);
              const displayNumber = `${countryDigits ? `+${countryDigits} ` : ""}${phoneDigits}`.trim();
              setContacts((prev) => [{ id: `new-${Date.now()}`, name: addName, number: displayNumber, createdOn: (/* @__PURE__ */ new Date()).toISOString().slice(0, 10) }, ...prev]);
              setTotalItems((prev) => (prev || 0) + 1);
              setAddModalActive(false);
              setAddName("");
              setAddCountryCode("");
              setAddPhone("");
            } catch (e) {
              console.error("Failed to add contact", e);
              setError((e == null ? void 0 : e.message) || "Failed to add contact");
            } finally {
              setAddingContact(false);
            }
          }
        },
        secondaryActions: [{ content: "Cancel", onAction: () => setAddModalActive(false) }],
        children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsx(
            TextField,
            {
              label: "Name",
              value: addName,
              onChange: setAddName,
              autoComplete: "off"
            }
          ),
          /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
            /* @__PURE__ */ jsx(
              TextField,
              {
                label: "Country Code",
                value: addCountryCode,
                onChange: setAddCountryCode,
                autoComplete: "off",
                placeholder: "India (+91)"
              }
            ),
            /* @__PURE__ */ jsx(
              TextField,
              {
                label: "Phone",
                value: addPhone,
                onChange: setAddPhone,
                autoComplete: "off",
                placeholder: "xxxxxxx9999"
              }
            )
          ] })
        ] }) })
      }
    ),
    selectedContact && /* @__PURE__ */ jsx(
      Modal,
      {
        open: editModalActive,
        onClose: handleModalClose,
        title: `Edit Contact: ${selectedContact.name}`,
        primaryAction: { content: "Update", onAction: handleEditSave, loading: savingEdit },
        secondaryActions: [{ content: "Cancel", onAction: handleModalClose }],
        children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsx(
            TextField,
            {
              label: "Name",
              value: editName,
              onChange: setEditName,
              autoComplete: "off"
            }
          ),
          /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
            /* @__PURE__ */ jsx(
              TextField,
              {
                label: "Country Code",
                value: editCountryCode,
                onChange: setEditCountryCode,
                autoComplete: "off",
                placeholder: "91"
              }
            ),
            /* @__PURE__ */ jsx(
              TextField,
              {
                label: "Phone",
                value: editPhone,
                onChange: setEditPhone,
                autoComplete: "off",
                placeholder: "7678696517"
              }
            )
          ] })
        ] }) })
      }
    )
  ] });
}
const route29 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: StaticListContactsPage
}, Symbol.toStringTag, { value: "Module" }));
function LiveSegmentPage() {
  const sleep = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
  const navigate = useNavigate();
  useLocation();
  const [selectedTab, setSelectedTab] = useState(1);
  const navigationTabs = [
    {
      id: "static-list",
      content: "Static List",
      accessibilityLabel: "Static List tab",
      panelID: "static-list-panel"
    },
    {
      id: "live-segment",
      content: "Live Segment",
      accessibilityLabel: "Live Segment tab",
      panelID: "live-segment-panel"
    }
  ];
  const handleTabChange = useCallback((selectedTabIndex) => {
    setSelectedTab(selectedTabIndex);
    if (selectedTabIndex === 0) {
      navigate("/app/contact-list/static-list");
    }
  }, [navigate]);
  const [selectedSegment, setSelectedSegment] = useState(null);
  const [previewModalActive, setPreviewModalActive] = useState(false);
  const [deleteModalActive, setDeleteModalActive] = useState(false);
  const [itemStrings, setItemStrings] = useState([
    "All",
    "Recently Created",
    "High Engagement",
    "Large Segments"
  ]);
  const [selected, setSelected] = useState(0);
  const [queryValue, setQueryValue] = useState("");
  const [sortSelected, setSortSelected] = useState(["name asc"]);
  const [audienceSizeFilter, setAudienceSizeFilter] = useState([0, 1e5]);
  const [engagementFilter, setEngagementFilter] = useState("");
  const { mode: mode2, setMode } = useSetIndexFiltersMode();
  const [currentPage, setCurrentPage] = useState(1);
  const itemsPerPage = 20;
  const liveSegments = [
    {
      id: "1",
      name: "High Value Customers",
      description: "Customers with orders above $500 in last 30 days",
      status: "Active",
      audienceSize: 2456,
      engagementRate: 85.2,
      lastUpdated: "2024-01-15",
      criteria: {
        orderValue: { min: 500, period: 30 },
        location: ["US", "CA"],
        tags: ["VIP", "Premium"]
      },
      createdAt: "2024-01-10"
    },
    {
      id: "2",
      name: "Abandoned Cart Users",
      description: "Users who abandoned cart in last 7 days",
      status: "Active",
      audienceSize: 8934,
      engagementRate: 62.8,
      lastUpdated: "2024-01-15",
      criteria: {
        cartAbandonment: { period: 7 },
        excludePurchased: true
      },
      createdAt: "2024-01-12"
    },
    {
      id: "3",
      name: "New Subscribers",
      description: "Recently subscribed users in last 14 days",
      status: "Active",
      audienceSize: 1247,
      engagementRate: 91.5,
      lastUpdated: "2024-01-15",
      criteria: {
        subscriptionDate: { period: 14 },
        source: ["website", "social"]
      },
      createdAt: "2024-01-13"
    },
    {
      id: "4",
      name: "Inactive Customers",
      description: "No purchase in last 90 days",
      status: "Inactive",
      audienceSize: 5678,
      engagementRate: 23.4,
      lastUpdated: "2024-01-10",
      criteria: {
        lastPurchase: { period: 90, operator: "greater_than" },
        previousOrders: { min: 1 }
      },
      createdAt: "2024-01-05"
    },
    {
      id: "5",
      name: "Birthday Campaign",
      description: "Customers with birthdays this month",
      status: "Active",
      audienceSize: 892,
      engagementRate: 78.9,
      lastUpdated: "2024-01-15",
      criteria: {
        birthday: { month: "current" },
        optedIn: true
      },
      createdAt: "2024-01-01"
    }
  ];
  const deleteView = (index2) => {
    const newItemStrings = [...itemStrings];
    newItemStrings.splice(index2, 1);
    setItemStrings(newItemStrings);
    setSelected(0);
  };
  const duplicateView = async (name) => {
    setItemStrings([...itemStrings, name]);
    setSelected(itemStrings.length);
    await sleep(1);
    return true;
  };
  const onCreateNewView = async (value) => {
    await sleep(500);
    setItemStrings([...itemStrings, value]);
    setSelected(itemStrings.length);
    return true;
  };
  const tabs = itemStrings.map((item, index2) => ({
    content: item,
    index: index2,
    onAction: () => {
    },
    id: `${item}-${index2}`,
    isLocked: index2 === 0,
    actions: index2 === 0 ? [] : [
      {
        type: "rename",
        onAction: () => {
        },
        onPrimaryAction: async (value) => {
          const newItemsStrings = tabs.map((item2, idx) => {
            if (idx === index2) {
              return value;
            }
            return item2.content;
          });
          await sleep(1);
          setItemStrings(newItemsStrings);
          return true;
        }
      },
      {
        type: "duplicate",
        onPrimaryAction: async (value) => {
          await sleep(1);
          duplicateView(value);
          return true;
        }
      },
      {
        type: "edit"
      },
      {
        type: "delete",
        onPrimaryAction: async () => {
          await sleep(1);
          deleteView(index2);
          return true;
        }
      }
    ]
  }));
  const filteredSegments = useMemo(() => {
    let filtered = liveSegments;
    if (selected === 1) {
      const sevenDaysAgo = /* @__PURE__ */ new Date();
      sevenDaysAgo.setDate(sevenDaysAgo.getDate() - 7);
      filtered = filtered.filter((segment) => new Date(segment.createdAt) >= sevenDaysAgo);
    } else if (selected === 2) {
      filtered = filtered.filter((segment) => segment.engagementRate >= 80);
    } else if (selected === 3) {
      filtered = filtered.filter((segment) => segment.audienceSize >= 1e4);
    }
    return filtered.filter((segment) => {
      const matchesSearch = segment.name.toLowerCase().includes(queryValue.toLowerCase()) || segment.description.toLowerCase().includes(queryValue.toLowerCase());
      const matchesAudienceSize = segment.audienceSize >= audienceSizeFilter[0] && segment.audienceSize <= audienceSizeFilter[1];
      const matchesEngagement = engagementFilter === "" || segment.engagementRate >= parseFloat(engagementFilter);
      return matchesSearch && matchesAudienceSize && matchesEngagement;
    });
  }, [liveSegments, queryValue, audienceSizeFilter, engagementFilter, selected]);
  const sortedSegments = useMemo(() => {
    const sorted = [...filteredSegments];
    const [sortKey, sortDirection] = sortSelected[0].split(" ");
    sorted.sort((a, b) => {
      let aValue, bValue;
      switch (sortKey) {
        case "name":
          aValue = a.name.toLowerCase();
          bValue = b.name.toLowerCase();
          break;
        case "status":
          aValue = a.status.toLowerCase();
          bValue = b.status.toLowerCase();
          break;
        case "audience":
          aValue = a.audienceSize;
          bValue = b.audienceSize;
          break;
        case "engagement":
          aValue = a.engagementRate;
          bValue = b.engagementRate;
          break;
        case "updated":
          aValue = new Date(a.lastUpdated);
          bValue = new Date(b.lastUpdated);
          break;
        default:
          return 0;
      }
      if (aValue < bValue) return sortDirection === "asc" ? -1 : 1;
      if (aValue > bValue) return sortDirection === "asc" ? 1 : -1;
      return 0;
    });
    return sorted;
  }, [filteredSegments, sortSelected]);
  const paginatedSegments = useMemo(() => {
    const startIndex = (currentPage - 1) * itemsPerPage;
    const endIndex = startIndex + itemsPerPage;
    return sortedSegments.slice(startIndex, endIndex);
  }, [sortedSegments, currentPage, itemsPerPage]);
  const handlePreviousPage = useCallback(() => {
    setCurrentPage((prev) => Math.max(1, prev - 1));
  }, []);
  const handleNextPage = useCallback(() => {
    const totalPages2 = Math.ceil(sortedSegments.length / itemsPerPage);
    setCurrentPage((prev) => Math.min(totalPages2, prev + 1));
  }, [sortedSegments.length, itemsPerPage]);
  const totalItems = sortedSegments.length;
  const totalPages = Math.ceil(totalItems / itemsPerPage);
  const startItem = (currentPage - 1) * itemsPerPage + 1;
  const endItem = Math.min(currentPage * itemsPerPage, totalItems);
  const hasNext = currentPage < totalPages;
  const hasPrevious = currentPage > 1;
  const sortOptions = [
    { label: "Segment Name", value: "name asc", directionLabel: "A-Z" },
    { label: "Segment Name", value: "name desc", directionLabel: "Z-A" },
    { label: "Status", value: "status asc", directionLabel: "A-Z" },
    { label: "Status", value: "status desc", directionLabel: "Z-A" },
    { label: "Audience Size", value: "audience asc", directionLabel: "Low to High" },
    { label: "Audience Size", value: "audience desc", directionLabel: "High to Low" },
    { label: "Engagement Rate", value: "engagement asc", directionLabel: "Low to High" },
    { label: "Engagement Rate", value: "engagement desc", directionLabel: "High to Low" },
    { label: "Last Updated", value: "updated asc", directionLabel: "Oldest First" },
    { label: "Last Updated", value: "updated desc", directionLabel: "Newest First" }
  ];
  const handlePreviewClick = useCallback((segment) => {
    navigate(`/app/contact-list/contacts/live-segment/${encodeURIComponent(segment.name)}`);
  }, [navigate]);
  const handleDeleteClick = useCallback((segment) => {
    setSelectedSegment(segment);
    setDeleteModalActive(true);
  }, []);
  const handleModalClose = useCallback(() => {
    setPreviewModalActive(false);
    setDeleteModalActive(false);
    setSelectedSegment(null);
  }, []);
  const handleFiltersQueryChange = useCallback((value) => {
    setQueryValue(value);
  }, []);
  const handleQueryValueRemove = useCallback(() => setQueryValue(""), []);
  useCallback((value) => {
    setStatusFilter(value);
  }, []);
  const handleAudienceSizeChange = useCallback((value) => {
    setAudienceSizeFilter(value);
  }, []);
  const handleEngagementChange = useCallback((value) => {
    setEngagementFilter(value);
  }, []);
  const handleStatusRemove = useCallback(() => setStatusFilter([]), []);
  const handleAudienceSizeRemove = useCallback(() => setAudienceSizeFilter([0, 1e5]), []);
  const handleEngagementRemove = useCallback(() => setEngagementFilter(""), []);
  const handleFiltersClearAll = useCallback(() => {
    handleStatusRemove();
    handleAudienceSizeRemove();
    handleEngagementRemove();
    handleQueryValueRemove();
  }, [handleStatusRemove, handleAudienceSizeRemove, handleEngagementRemove, handleQueryValueRemove]);
  const onHandleCancel = () => {
  };
  const getStatusBadge = (status) => {
    var _a2;
    const statusConfig = {
      "Active": { tone: "success" },
      "Inactive": { tone: "subdued" },
      "Draft": { tone: "attention" },
      "Error": { tone: "critical" }
    };
    return /* @__PURE__ */ jsx(Badge, { tone: ((_a2 = statusConfig[status]) == null ? void 0 : _a2.tone) || "info", children: status });
  };
  const filters = [
    {
      key: "audienceSize",
      label: "Audience Size",
      filter: /* @__PURE__ */ jsx(
        RangeSlider,
        {
          label: "Audience size",
          labelHidden: true,
          value: audienceSizeFilter || [0, 1e5],
          suffix: " contacts",
          output: true,
          min: 0,
          max: 1e5,
          step: 100,
          onChange: handleAudienceSizeChange
        }
      )
    },
    {
      key: "engagement",
      label: "Min Engagement Rate",
      filter: /* @__PURE__ */ jsx(
        TextField,
        {
          label: "Minimum engagement rate",
          value: engagementFilter,
          onChange: handleEngagementChange,
          autoComplete: "off",
          labelHidden: true,
          suffix: "%",
          type: "number"
        }
      ),
      shortcut: true
    }
  ];
  const appliedFilters = [];
  if (audienceSizeFilter && (audienceSizeFilter[0] !== 0 || audienceSizeFilter[1] !== 1e5)) {
    appliedFilters.push({
      key: "audienceSize",
      label: disambiguateLabel("audienceSize", audienceSizeFilter),
      onRemove: handleAudienceSizeRemove
    });
  }
  if (!isEmpty(engagementFilter)) {
    appliedFilters.push({
      key: "engagement",
      label: disambiguateLabel("engagement", engagementFilter),
      onRemove: handleEngagementRemove
    });
  }
  const resourceName = {
    singular: "segment",
    plural: "segments"
  };
  const { selectedResources, allResourcesSelected, handleSelectionChange } = useIndexResourceState(paginatedSegments);
  function disambiguateLabel(key, value) {
    switch (key) {
      case "audienceSize":
        return `Audience size: ${value[0].toLocaleString()}-${value[1].toLocaleString()}`;
      case "engagement":
        return `Min engagement: ${value}%`;
      case "status":
        return value.map((val) => `Status: ${val.charAt(0).toUpperCase() + val.slice(1)}`).join(", ");
      default:
        return value;
    }
  }
  function isEmpty(value) {
    if (Array.isArray(value)) {
      return value.length === 0;
    } else {
      return value === "" || value == null;
    }
  }
  const rowMarkup = paginatedSegments.map(
    (segment, index2) => /* @__PURE__ */ jsxs(
      IndexTable.Row,
      {
        id: segment.id,
        selected: selectedResources.includes(segment.id),
        position: index2,
        children: [
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "100", children: [
            /* @__PURE__ */ jsx(Text, { variant: "bodyMd", fontWeight: "semibold", as: "span", children: segment.name }),
            /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "span", tone: "subdued", children: segment.description })
          ] }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { as: "span", numeric: true, children: segment.audienceSize.toLocaleString() }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "span", children: segment.lastUpdated }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsxs(InlineStack, { align: "end", gap: "200", children: [
            /* @__PURE__ */ jsx(Tooltip, { content: "View segment details", children: /* @__PURE__ */ jsx(
              Button,
              {
                size: "slim",
                onClick: (event) => {
                  event.stopPropagation();
                  handlePreviewClick(segment);
                },
                children: /* @__PURE__ */ jsx(Icon, { source: ViewIcon })
              }
            ) }),
            /* @__PURE__ */ jsx(Tooltip, { content: "Delete segment", children: /* @__PURE__ */ jsx(
              Button,
              {
                size: "slim",
                tone: "critical",
                onClick: (event) => {
                  event.stopPropagation();
                  handleDeleteClick(segment);
                },
                children: /* @__PURE__ */ jsx(Icon, { source: DeleteIcon })
              }
            ) })
          ] }) })
        ]
      },
      segment.id
    )
  );
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      Page,
      {
        title: "Contact List",
        subtitle: "Manage your customer segments and contact lists",
        fullWidth: true,
        children: /* @__PURE__ */ jsx(BlockStack, { gap: "400", children: /* @__PURE__ */ jsx(Tabs, { tabs: navigationTabs, selected: selectedTab, onSelect: handleTabChange, children: /* @__PURE__ */ jsxs("div", { id: "live-segment-panel", children: [
          /* @__PURE__ */ jsx(Banner, { title: "Coming Soon", onDismiss: () => {
          }, children: /* @__PURE__ */ jsx("p", { children: "This feature is coming soon. now showing demo data" }) }),
          /* @__PURE__ */ jsxs(LegacyCard, { children: [
            /* @__PURE__ */ jsx(
              IndexFilters,
              {
                sortOptions,
                sortSelected,
                queryValue,
                queryPlaceholder: "Search segments...",
                onQueryChange: handleFiltersQueryChange,
                onQueryClear: () => setQueryValue(""),
                onSort: setSortSelected,
                cancelAction: {
                  onAction: onHandleCancel,
                  disabled: false,
                  loading: false
                },
                tabs,
                selected,
                onSelect: setSelected,
                canCreateNewView: true,
                onCreateNewView,
                filters,
                appliedFilters,
                onClearAll: handleFiltersClearAll,
                mode: mode2,
                setMode
              }
            ),
            /* @__PURE__ */ jsx(
              IndexTable,
              {
                resourceName,
                itemCount: paginatedSegments.length,
                selectedItemsCount: allResourcesSelected ? "All" : selectedResources.length,
                onSelectionChange: handleSelectionChange,
                headings: [
                  { title: "Segment Name" },
                  { title: "Audience Size" },
                  { title: "Last Updated" },
                  { title: "Actions", alignment: "end" }
                ],
                emptyState: /* @__PURE__ */ jsxs("div", { style: { textAlign: "center", padding: "60px 20px" }, children: [
                  /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: "No live segments found" }),
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: filteredSegments.length === 0 && liveSegments.length > 0 ? "Try adjusting your filters to see more results." : "Create your first live segment to start targeting customers dynamically." })
                ] }),
                children: rowMarkup
              }
            ),
            totalItems > itemsPerPage && /* @__PURE__ */ jsx(
              "div",
              {
                style: {
                  maxWidth: "700px",
                  margin: "auto",
                  border: "1px solid var(--p-color-border)",
                  marginTop: "16px"
                },
                children: /* @__PURE__ */ jsx(
                  Pagination,
                  {
                    onPrevious: hasPrevious ? handlePreviousPage : void 0,
                    onNext: hasNext ? handleNextPage : void 0,
                    type: "table",
                    hasNext,
                    hasPrevious,
                    label: `${startItem}-${endItem} of ${totalItems} segments`
                  }
                )
              }
            )
          ] })
        ] }) }) })
      }
    ),
    selectedSegment && /* @__PURE__ */ jsx(
      Modal,
      {
        open: previewModalActive,
        onClose: handleModalClose,
        title: `Live Segment: ${selectedSegment.name}`,
        primaryAction: {
          content: "Close",
          onAction: handleModalClose
        },
        secondaryActions: [
          {
            content: "Edit Segment",
            onAction: () => {
              console.log("Edit segment:", selectedSegment.id);
              handleModalClose();
            }
          }
        ],
        children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: selectedSegment.name }),
            /* @__PURE__ */ jsx(Text, { variant: "bodyLg", as: "p", children: selectedSegment.description }),
            /* @__PURE__ */ jsx(InlineStack, { gap: "200", children: getStatusBadge(selectedSegment.status) })
          ] }),
          /* @__PURE__ */ jsxs(TextContainer, { children: [
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Audience Size:" }),
              " ",
              selectedSegment.audienceSize.toLocaleString(),
              " contacts"
            ] }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Engagement Rate:" }),
              " ",
              selectedSegment.engagementRate,
              "%"
            ] }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Last Updated:" }),
              " ",
              selectedSegment.lastUpdated
            ] }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Created:" }),
              " ",
              selectedSegment.createdAt
            ] })
          ] }),
          /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h4", children: "Segment Criteria" }),
            /* @__PURE__ */ jsx("div", { style: {
              backgroundColor: "var(--p-color-bg-surface-secondary)",
              padding: "16px",
              borderRadius: "8px"
            }, children: /* @__PURE__ */ jsx("pre", { style: {
              fontFamily: "monospace",
              fontSize: "12px",
              margin: 0,
              whiteSpace: "pre-wrap"
            }, children: JSON.stringify(selectedSegment.criteria, null, 2) }) })
          ] })
        ] }) })
      }
    ),
    selectedSegment && /* @__PURE__ */ jsx(
      Modal,
      {
        open: deleteModalActive,
        onClose: handleModalClose,
        title: "Delete Live Segment",
        primaryAction: {
          content: "Delete",
          destructive: true,
          onAction: () => {
            console.log("Delete segment:", selectedSegment.id);
            handleModalClose();
          }
        },
        secondaryActions: [
          {
            content: "Cancel",
            onAction: handleModalClose
          }
        ],
        children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(TextContainer, { children: [
          /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
            'Are you sure you want to delete the segment "',
            selectedSegment.name,
            '"? This action cannot be undone and will affect any active campaigns using this segment.'
          ] }),
          /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: [
            "Current audience size: ",
            selectedSegment.audienceSize.toLocaleString(),
            " contacts"
          ] })
        ] }) })
      }
    )
  ] });
}
const route30 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: LiveSegmentPage
}, Symbol.toStringTag, { value: "Module" }));
function StaticListPage() {
  const sleep = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
  const navigate = useNavigate();
  useLocation();
  const [selectedTab, setSelectedTab] = useState(0);
  const navigationTabs = [
    {
      id: "static-list",
      content: "Static List",
      accessibilityLabel: "Static List tab",
      panelID: "static-list-panel"
    },
    {
      id: "live-segment",
      content: "Live Segment",
      accessibilityLabel: "Live Segment tab",
      panelID: "live-segment-panel"
    }
  ];
  const handleTabChange = useCallback((selectedTabIndex) => {
    setSelectedTab(selectedTabIndex);
    if (selectedTabIndex === 1) {
      navigate("/app/contact-list/live-segment");
    }
  }, [navigate]);
  const [selectedList, setSelectedList] = useState(null);
  const [previewModalActive, setPreviewModalActive] = useState(false);
  const [deleteModalActive, setDeleteModalActive] = useState(false);
  const [importModalActive, setImportModalActive] = useState(false);
  const [createListModalActive, setCreateListModalActive] = useState(false);
  const [createVariableModalActive, setCreateVariableModalActive] = useState(false);
  const [files, setFiles] = useState([]);
  const [listName, setListName] = useState("");
  const [variableName, setVariableName] = useState("");
  const [isCreating, setIsCreating] = useState(false);
  const [isDeleting, setIsDeleting] = useState(false);
  const [successMessage, setSuccessMessage] = useState("");
  const [csvColumns, setCsvColumns] = useState([]);
  const [columnMappings, setColumnMappings] = useState({});
  const [showColumnMapping, setShowColumnMapping] = useState(false);
  const [mappingColumnIndex, setMappingColumnIndex] = useState(null);
  const [csvFile, setCsvFile] = useState(null);
  const [processingCsv, setProcessingCsv] = useState(false);
  const [csvErrorType, setCsvErrorType] = useState(null);
  const [availableVariables, setAvailableVariables] = useState([]);
  const [loadingVariables, setLoadingVariables] = useState(true);
  const [showVariablesModal, setShowVariablesModal] = useState(false);
  const [variableSearchQuery, setVariableSearchQuery] = useState("");
  const [itemStrings, setItemStrings] = useState([
    "All",
    "Recently Created",
    "Large Lists",
    "By Source"
  ]);
  const [selected, setSelected] = useState(0);
  const [queryValue, setQueryValue] = useState("");
  const [sortSelected, setSortSelected] = useState(["updated desc"]);
  const [sizeFilter, setSizeFilter] = useState([0, 5e4]);
  const [sourceFilter, setSourceFilter] = useState("");
  const { mode: mode2, setMode } = useSetIndexFiltersMode();
  const [currentPage, setCurrentPage] = useState(1);
  const itemsPerPage = 20;
  const [staticLists, setStaticLists] = useState([]);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);
  const [paginationData, setPaginationData] = useState({
    current_page: 1,
    last_page: 1,
    total: 0,
    per_page: 20
  });
  useEffect(() => {
    const fetchData = async () => {
      try {
        setLoading(true);
        setError(null);
        const response = await fetchStaticContactList({
          page: currentPage,
          perPageData: itemsPerPage
        });
        if (response.status && response.WhatsAppBusinessTag) {
          const { data, current_page, last_page, total, per_page } = response.WhatsAppBusinessTag;
          const transformedData = data.map((item) => ({
            id: item.id.toString(),
            name: item.name,
            description: `Contact list with ${item.totalcontatspertag_count} contacts`,
            status: "Active",
            // Default status since API doesn't provide this
            contactCount: item.totalcontatspertag_count,
            source: "Manual Upload",
            // Set as requested
            lastUpdated: new Date(item.updated_at).toLocaleDateString(),
            createdAt: new Date(item.created_at).toLocaleDateString(),
            importedFrom: "Manual Upload"
          }));
          setStaticLists(transformedData);
          setPaginationData({
            current_page,
            last_page,
            total,
            per_page
          });
        } else {
          throw new Error("Invalid API response format");
        }
      } catch (err) {
        console.error("Error fetching static contact lists:", err);
        setError(err.message);
        setStaticLists([]);
      } finally {
        setLoading(false);
      }
    };
    fetchData();
  }, [currentPage, itemsPerPage]);
  useEffect(() => {
    const fetchVariables = async () => {
      try {
        setLoadingVariables(true);
        const variables = await getTemplateVariables();
        setAvailableVariables(variables);
      } catch (error2) {
        console.error("Error fetching variables:", error2);
        setAvailableVariables([]);
      } finally {
        setLoadingVariables(false);
      }
    };
    fetchVariables();
  }, []);
  const deleteView = (index2) => {
    const newItemStrings = [...itemStrings];
    newItemStrings.splice(index2, 1);
    setItemStrings(newItemStrings);
    setSelected(0);
  };
  const duplicateView = async (name) => {
    setItemStrings([...itemStrings, name]);
    setSelected(itemStrings.length);
    await sleep(1);
    return true;
  };
  const onCreateNewView = async (value) => {
    await sleep(500);
    setItemStrings([...itemStrings, value]);
    setSelected(itemStrings.length);
    return true;
  };
  const tabs = itemStrings.map((item, index2) => ({
    content: item,
    index: index2,
    onAction: () => {
    },
    id: `${item}-${index2}`,
    isLocked: index2 === 0,
    actions: index2 === 0 ? [] : [
      {
        type: "rename",
        onAction: () => {
        },
        onPrimaryAction: async (value) => {
          const newItemsStrings = tabs.map((item2, idx) => {
            if (idx === index2) {
              return value;
            }
            return item2.content;
          });
          await sleep(1);
          setItemStrings(newItemsStrings);
          return true;
        }
      },
      {
        type: "duplicate",
        onPrimaryAction: async (value) => {
          await sleep(1);
          duplicateView(value);
          return true;
        }
      },
      {
        type: "edit"
      },
      {
        type: "delete",
        onPrimaryAction: async () => {
          await sleep(1);
          deleteView(index2);
          return true;
        }
      }
    ]
  }));
  const filteredLists = useMemo(() => {
    let filtered = staticLists;
    if (selected === 1) {
      const sevenDaysAgo = /* @__PURE__ */ new Date();
      sevenDaysAgo.setDate(sevenDaysAgo.getDate() - 7);
      filtered = filtered.filter((list2) => new Date(list2.createdAt) >= sevenDaysAgo);
    } else if (selected === 2) {
      filtered = filtered.filter((list2) => list2.contactCount >= 1e4);
    } else if (selected === 3) {
      filtered = filtered.filter((list2) => sourceFilter !== "" && list2.source.toLowerCase().includes(sourceFilter.toLowerCase()));
    }
    return filtered.filter((list2) => {
      const matchesSearch = list2.name.toLowerCase().includes(queryValue.toLowerCase()) || list2.description.toLowerCase().includes(queryValue.toLowerCase());
      const matchesSize = list2.contactCount >= sizeFilter[0] && list2.contactCount <= sizeFilter[1];
      const matchesSource = selected !== 3 && (sourceFilter === "" || list2.source.toLowerCase().includes(sourceFilter.toLowerCase()));
      return matchesSearch && matchesSize && (selected === 3 || matchesSource);
    });
  }, [staticLists, queryValue, sizeFilter, sourceFilter, selected]);
  const sortedLists = useMemo(() => {
    const sorted = [...filteredLists];
    const [sortKey, sortDirection] = sortSelected[0].split(" ");
    sorted.sort((a, b) => {
      let aValue, bValue;
      switch (sortKey) {
        case "name":
          aValue = a.name.toLowerCase();
          bValue = b.name.toLowerCase();
          break;
        case "status":
          aValue = a.status.toLowerCase();
          bValue = b.status.toLowerCase();
          break;
        case "size":
          aValue = a.contactCount;
          bValue = b.contactCount;
          break;
        case "source":
          aValue = a.source.toLowerCase();
          bValue = b.source.toLowerCase();
          break;
        case "updated":
          aValue = new Date(a.lastUpdated);
          bValue = new Date(b.lastUpdated);
          break;
        default:
          return 0;
      }
      if (aValue < bValue) return sortDirection === "asc" ? -1 : 1;
      if (aValue > bValue) return sortDirection === "asc" ? 1 : -1;
      return 0;
    });
    return sorted;
  }, [filteredLists, sortSelected]);
  const paginatedLists = useMemo(() => {
    return sortedLists;
  }, [sortedLists]);
  const handlePreviousPage = useCallback(() => {
    setCurrentPage((prev) => Math.max(1, prev - 1));
  }, []);
  const handleNextPage = useCallback(() => {
    setCurrentPage((prev) => Math.min(paginationData.last_page, prev + 1));
  }, [paginationData.last_page]);
  const totalItems = paginationData.total;
  paginationData.last_page;
  const startItem = paginationData.current_page === 1 ? 1 : (paginationData.current_page - 1) * paginationData.per_page + 1;
  const endItem = Math.min(paginationData.current_page * paginationData.per_page, totalItems);
  const hasNext = paginationData.current_page < paginationData.last_page;
  const hasPrevious = paginationData.current_page > 1;
  const sortOptions = [
    { label: "List Name", value: "name asc", directionLabel: "A-Z" },
    { label: "List Name", value: "name desc", directionLabel: "Z-A" },
    { label: "Status", value: "status asc", directionLabel: "A-Z" },
    { label: "Status", value: "status desc", directionLabel: "Z-A" },
    { label: "Contact Count", value: "size asc", directionLabel: "Low to High" },
    { label: "Contact Count", value: "size desc", directionLabel: "High to Low" },
    { label: "Source", value: "source asc", directionLabel: "A-Z" },
    { label: "Source", value: "source desc", directionLabel: "Z-A" },
    { label: "Last Updated", value: "updated asc", directionLabel: "Oldest First" },
    { label: "Last Updated", value: "updated desc", directionLabel: "Newest First" }
  ];
  const handlePreviewClick = useCallback((list2) => {
    navigate(`/app/contact-list/contacts/static-list/${encodeURIComponent(list2.name)}?id=${encodeURIComponent(list2.id)}`);
  }, [navigate]);
  const handleDeleteClick = useCallback((list2) => {
    setSelectedList(list2);
    setDeleteModalActive(true);
  }, []);
  useCallback(() => {
    setImportModalActive(true);
  }, []);
  const handleCreateListClick = useCallback(() => {
    setCreateListModalActive(true);
  }, []);
  const handleCreateVariableListClick = useCallback(() => {
    setCreateVariableModalActive(true);
  }, []);
  const handleCreateContactList = useCallback(async () => {
    if (!listName || !files.length) return;
    setIsCreating(true);
    try {
      const contactListPayload = {
        name: listName,
        description: `Contact list created on ${(/* @__PURE__ */ new Date()).toLocaleDateString()}`
      };
      const result = await addNewContactListName(contactListPayload, files[0], columnMappings);
      if (result.contactListResponse && result.csvUploadResponse) {
        window.location.reload();
      } else {
        throw new Error("Failed to create contact list");
      }
    } catch (error2) {
      console.error("Error creating contact list:", error2);
      alert(`Error creating contact list: ${error2.message}`);
    } finally {
      setIsCreating(false);
    }
  }, [listName, files, columnMappings]);
  const handleCreateVariables = useCallback(async () => {
    if (!variableName) return;
    setIsCreating(true);
    function formatToCamelCase(variableName2) {
      return variableName2.split("_").map(
        (word) => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()
      ).join("");
    }
    const FormattedvariableName = formatToCamelCase(variableName);
    try {
      const CreateVariablePayload = {
        name: FormattedvariableName
      };
      const result = await addNewVariable(CreateVariablePayload);
      if (result.success === true) {
        setSuccessMessage(result.message || "Label created successfully!");
        setVariableName("");
        try {
          setLoadingVariables(true);
          const variables = await getTemplateVariables();
          setAvailableVariables(variables);
        } catch (error2) {
          console.error("Error reloading variables:", error2);
          setAvailableVariables([]);
        } finally {
          setLoadingVariables(false);
        }
        setTimeout(() => {
          setSuccessMessage("");
        }, 2e3);
      } else {
        throw new Error("Failed to create variable");
      }
    } catch (error2) {
      console.error("Error creating variable:", error2);
      alert(`Error creating variable: ${error2.message}`);
    } finally {
      setIsCreating(false);
    }
  }, [variableName]);
  const insertVariable = useCallback((variable) => {
    const input2 = document.querySelector("#variable-name-field");
    if (!input2) return;
    const start = input2.selectionStart;
    const variableText = `{{${variable}}}`;
    const newValue = input2.value.substring(0, start) + variableText + input2.value.substring(start);
    setVariableName(newValue);
    setTimeout(() => {
      input2.focus();
      input2.setSelectionRange(start + variableText.length, start + variableText.length);
    }, 0);
  }, []);
  const handleMapColumn = useCallback((columnIndex) => {
    setMappingColumnIndex(columnIndex);
    setShowVariablesModal(true);
  }, []);
  const handleVariableSelect = useCallback((variable) => {
    if (mappingColumnIndex !== null) {
      setColumnMappings((prev) => ({
        ...prev,
        [mappingColumnIndex]: variable.value
      }));
    }
    setShowVariablesModal(false);
    setMappingColumnIndex(null);
    setVariableSearchQuery("");
  }, [mappingColumnIndex]);
  useCallback((columnIndex, value) => {
    setColumnMappings((prev) => ({
      ...prev,
      [columnIndex]: value
    }));
  }, []);
  const handleRemoveColumnMapping = useCallback((columnIndex) => {
    setColumnMappings((prev) => {
      const newMappings = { ...prev };
      delete newMappings[columnIndex];
      return newMappings;
    });
  }, []);
  const handleModalClose = useCallback(() => {
    setPreviewModalActive(false);
    setDeleteModalActive(false);
    setImportModalActive(false);
    setCreateListModalActive(false);
    setCreateVariableModalActive(false);
    setShowVariablesModal(false);
    setSelectedList(null);
    setFiles([]);
    setListName("");
    setVariableName("");
    setIsCreating(false);
    setSuccessMessage("");
    setVariableSearchQuery("");
    setCsvColumns([]);
    setColumnMappings({});
    setShowColumnMapping(false);
    setMappingColumnIndex(null);
    setCsvFile(null);
    setProcessingCsv(false);
    setCsvErrorType(null);
  }, []);
  const handleConfirmDelete = useCallback(async () => {
    if (!selectedList || isDeleting) return;
    setIsDeleting(true);
    try {
      await deleteContactList(selectedList.id);
      setStaticLists((prev) => prev.filter((list2) => list2.id !== selectedList.id));
      setDeleteModalActive(false);
      setSelectedList(null);
    } catch (error2) {
      console.error("Error deleting contact list:", error2);
      alert(`Failed to delete list: ${error2.message || "Unknown error"}`);
    } finally {
      setIsDeleting(false);
    }
  }, [selectedList, isDeleting]);
  const handleFiltersQueryChange = useCallback((value) => {
    setQueryValue(value);
  }, []);
  const handleQueryValueRemove = useCallback(() => setQueryValue(""), []);
  useCallback((value) => {
    setStatusFilter(value);
  }, []);
  const handleSizeChange = useCallback((value) => {
    setSizeFilter(value);
  }, []);
  const handleSourceChange = useCallback((value) => {
    setSourceFilter(value);
  }, []);
  const handleStatusRemove = useCallback(() => setStatusFilter([]), []);
  const handleSizeRemove = useCallback(() => setSizeFilter([0, 5e4]), []);
  const handleSourceRemove = useCallback(() => setSourceFilter(""), []);
  const handleFiltersClearAll = useCallback(() => {
    handleStatusRemove();
    handleSizeRemove();
    handleSourceRemove();
    handleQueryValueRemove();
  }, [handleStatusRemove, handleSizeRemove, handleSourceRemove, handleQueryValueRemove]);
  const onHandleCancel = () => {
  };
  const getStatusBadge = (status) => {
    var _a2;
    const statusConfig = {
      "Active": { tone: "success" },
      "Archived": { tone: "subdued" },
      "Draft": { tone: "attention" },
      "Error": { tone: "critical" }
    };
    return /* @__PURE__ */ jsx(Badge, { tone: ((_a2 = statusConfig[status]) == null ? void 0 : _a2.tone) || "info", children: status });
  };
  const handleDropZoneDrop = useCallback(
    (_dropFiles, acceptedFiles, _rejectedFiles) => {
      setFiles((files2) => [...files2, ...acceptedFiles]);
    },
    []
  );
  const handleCreateListDropZoneDrop = useCallback(
    async (_dropFiles, acceptedFiles, _rejectedFiles) => {
      const file = acceptedFiles[0];
      if (file && file.type === "text/csv") {
        setFiles([file]);
        setCsvFile(file);
        await processCsvFile(file);
      }
    },
    []
  );
  const processCsvFile = useCallback(async (file) => {
    setProcessingCsv(true);
    setCsvErrorType(null);
    try {
      const text2 = await file.text();
      const lines = text2.split("\n").filter((line) => line.trim());
      if (lines.length > 0) {
        const headers2 = lines[0].split(",").map((header) => header.trim().replace(/"/g, ""));
        if (headers2.length < 2) {
          setCsvErrorType("column_format");
          throw new Error("CSV must have at least 2 columns");
        }
        if (lines.length > 1) {
          const secondRow = lines[1].split(",").map((cell) => cell.trim().replace(/"/g, ""));
          if (secondRow.length > 1) {
            const secondColumnValue = secondRow[1];
            if (!/^\d+$/.test(secondColumnValue)) {
              setCsvErrorType("number_format");
              throw new Error(`Second column must contain only integer numbers (phone numbers). Found: "${secondColumnValue}"`);
            }
          }
        }
        const columns = headers2.slice(2).map((header, index2) => ({
          index: index2 + 2,
          name: `Column ${index2 + 3}`,
          firstRowValue: header || `Column ${index2 + 3}`,
          displayName: `Column ${index2 + 3} (${header || `Column ${index2 + 3}`})`
        }));
        setCsvColumns(columns);
        setColumnMappings({});
        setShowColumnMapping(true);
      }
    } catch (error2) {
      console.error("Error processing CSV:", error2);
      alert(`CSV Validation Error: ${error2.message}`);
      setFiles([]);
      setCsvFile(null);
      setCsvColumns([]);
      setColumnMappings({});
      setShowColumnMapping(false);
    } finally {
      setProcessingCsv(false);
    }
  }, []);
  const validImageTypes = ["image/gif", "image/jpeg", "image/png"];
  const fileUpload = !files.length && /* @__PURE__ */ jsx(DropZone.FileUpload, {});
  const uploadedFiles = files.length > 0 && /* @__PURE__ */ jsx("div", { style: { padding: "16px" }, children: /* @__PURE__ */ jsx(BlockStack, { gap: "200", children: files.map((file, index2) => /* @__PURE__ */ jsxs(InlineStack, { alignment: "center", children: [
    /* @__PURE__ */ jsx("div", { children: validImageTypes.includes(file.type) ? /* @__PURE__ */ jsx(
      "img",
      {
        alt: file.name,
        width: "50",
        height: "50",
        style: { objectFit: "cover", borderRadius: "4px" },
        src: validImageTypes.includes(file.type) ? window.URL.createObjectURL(file) : ""
      }
    ) : /* @__PURE__ */ jsx("div", { style: {
      width: "50px",
      height: "50px",
      backgroundColor: "var(--p-color-bg-surface-secondary)",
      borderRadius: "4px",
      display: "flex",
      alignItems: "center",
      justifyContent: "center"
    }, children: "📄" }) }),
    /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: file.name }),
      /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
        file.size,
        " bytes"
      ] })
    ] })
  ] }, index2)) }) });
  const filters = [
    {
      key: "size",
      label: "Contact Count",
      filter: /* @__PURE__ */ jsx(
        RangeSlider,
        {
          label: "Contact count",
          labelHidden: true,
          value: sizeFilter || [0, 5e4],
          suffix: " contacts",
          output: true,
          min: 0,
          max: 5e4,
          step: 100,
          onChange: handleSizeChange
        }
      )
    },
    {
      key: "source",
      label: "Source",
      filter: /* @__PURE__ */ jsx(
        TextField,
        {
          label: "Source",
          value: sourceFilter,
          onChange: handleSourceChange,
          autoComplete: "off",
          labelHidden: true
        }
      ),
      shortcut: true
    }
  ];
  const appliedFilters = [];
  if (sizeFilter && (sizeFilter[0] !== 0 || sizeFilter[1] !== 5e4)) {
    appliedFilters.push({
      key: "size",
      label: disambiguateLabel("size", sizeFilter),
      onRemove: handleSizeRemove
    });
  }
  if (!isEmpty(sourceFilter)) {
    appliedFilters.push({
      key: "source",
      label: disambiguateLabel("source", sourceFilter),
      onRemove: handleSourceRemove
    });
  }
  const resourceName = {
    singular: "list",
    plural: "lists"
  };
  const { selectedResources, allResourcesSelected, handleSelectionChange } = useIndexResourceState(paginatedLists);
  function disambiguateLabel(key, value) {
    switch (key) {
      case "size":
        return `Contact count: ${value[0].toLocaleString()}-${value[1].toLocaleString()}`;
      case "source":
        return `Source contains "${value}"`;
      case "status":
        return value.map((val) => `Status: ${val.charAt(0).toUpperCase() + val.slice(1)}`).join(", ");
      default:
        return value;
    }
  }
  function isEmpty(value) {
    if (Array.isArray(value)) {
      return value.length === 0;
    } else {
      return value === "" || value == null;
    }
  }
  const rowMarkup = paginatedLists.map(
    (list2, index2) => /* @__PURE__ */ jsxs(
      IndexTable.Row,
      {
        id: list2.id,
        selected: selectedResources.includes(list2.id),
        position: index2,
        children: [
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "100", children: [
            /* @__PURE__ */ jsx(Text, { variant: "bodyMd", fontWeight: "semibold", as: "span", children: list2.name }),
            /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "span", tone: "subdued", children: list2.description })
          ] }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { as: "span", numeric: true, children: list2.contactCount.toLocaleString() }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "span", children: list2.source }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "span", children: list2.lastUpdated }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsxs(InlineStack, { align: "end", gap: "200", children: [
            /* @__PURE__ */ jsx(Tooltip, { content: "View list details", children: /* @__PURE__ */ jsx(
              Button,
              {
                size: "slim",
                onClick: (event) => {
                  event.stopPropagation();
                  handlePreviewClick(list2);
                },
                children: /* @__PURE__ */ jsx(Icon, { source: ViewIcon })
              }
            ) }),
            /* @__PURE__ */ jsx(Tooltip, { content: "Export list", children: /* @__PURE__ */ jsx(
              Button,
              {
                size: "slim",
                onClick: (event) => {
                  event.stopPropagation();
                  console.log("Export list:", list2.id);
                  window.open(`https://app.getgabs.com/partners/broadcast/export/exportMultipleContactLists?ids=${list2.id}&token=${API_TOKEN}`, "_blank");
                },
                children: /* @__PURE__ */ jsx(Icon, { source: ExportIcon })
              }
            ) }),
            /* @__PURE__ */ jsx(Tooltip, { content: "Delete list", children: /* @__PURE__ */ jsx(
              Button,
              {
                size: "slim",
                tone: "critical",
                onClick: (event) => {
                  event.stopPropagation();
                  handleDeleteClick(list2);
                },
                children: /* @__PURE__ */ jsx(Icon, { source: DeleteIcon })
              }
            ) })
          ] }) })
        ]
      },
      list2.id
    )
  );
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      Page,
      {
        title: "Contact List",
        subtitle: "Manage your customer segments and contact lists",
        fullWidth: true,
        primaryAction: {
          content: /* @__PURE__ */ jsx(InlineStack, { alignment: "center", children: /* @__PURE__ */ jsx(Text, { as: "span", children: "Create Contact List" }) }),
          onAction: handleCreateListClick
        },
        secondaryActions: [
          {
            content: /* @__PURE__ */ jsx(InlineStack, { alignment: "center", children: /* @__PURE__ */ jsx(Text, { as: "span", children: "Create Variables" }) }),
            onAction: handleCreateVariableListClick
          }
        ],
        children: /* @__PURE__ */ jsx(BlockStack, { gap: "400", children: /* @__PURE__ */ jsx(Tabs, { tabs: navigationTabs, selected: selectedTab, onSelect: handleTabChange, children: /* @__PURE__ */ jsx("div", { id: "static-list-panel", children: /* @__PURE__ */ jsxs(LegacyCard, { children: [
          /* @__PURE__ */ jsx(
            IndexFilters,
            {
              sortOptions,
              sortSelected,
              queryValue,
              queryPlaceholder: "Search lists...",
              onQueryChange: handleFiltersQueryChange,
              onQueryClear: () => setQueryValue(""),
              onSort: setSortSelected,
              cancelAction: {
                onAction: onHandleCancel,
                disabled: false,
                loading: false
              },
              tabs,
              selected,
              onSelect: setSelected,
              canCreateNewView: true,
              onCreateNewView,
              filters,
              appliedFilters,
              onClearAll: handleFiltersClearAll,
              mode: mode2,
              setMode
            }
          ),
          /* @__PURE__ */ jsx(
            IndexTable,
            {
              resourceName,
              itemCount: paginatedLists.length,
              selectedItemsCount: allResourcesSelected ? "All" : selectedResources.length,
              onSelectionChange: handleSelectionChange,
              headings: [
                { title: "List Name" },
                { title: "Contact Count" },
                { title: "Source" },
                { title: "Last Updated" },
                { title: "Actions", alignment: "end" }
              ],
              emptyState: /* @__PURE__ */ jsxs("div", { style: { textAlign: "center", padding: "60px 20px" }, children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: loading ? "Loading contact lists..." : error ? "Error loading contact lists" : filteredLists.length === 0 && staticLists.length > 0 ? "No static lists found" : "No static lists available" }),
                /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: loading ? "Please wait while we fetch your contact lists." : error ? `Error: ${error}` : filteredLists.length === 0 && staticLists.length > 0 ? "Try adjusting your filters to see more results." : "Create your first static list or import contacts to get started." })
              ] }),
              children: rowMarkup
            }
          ),
          totalItems > itemsPerPage && /* @__PURE__ */ jsx(
            "div",
            {
              style: {
                maxWidth: "700px",
                margin: "auto",
                border: "1px solid var(--p-color-border)",
                marginTop: "16px"
              },
              children: /* @__PURE__ */ jsx(
                Pagination,
                {
                  onPrevious: hasPrevious ? handlePreviousPage : void 0,
                  onNext: hasNext ? handleNextPage : void 0,
                  type: "table",
                  hasNext,
                  hasPrevious,
                  label: `${startItem}-${endItem} of ${totalItems} lists`
                }
              )
            }
          )
        ] }) }) }) })
      }
    ),
    selectedList && /* @__PURE__ */ jsx(
      Modal,
      {
        open: previewModalActive,
        onClose: handleModalClose,
        title: `Static List: ${selectedList.name}`,
        primaryAction: {
          content: "Close",
          onAction: handleModalClose
        },
        secondaryActions: [
          {
            content: "Edit List",
            onAction: () => {
              console.log("Edit list:", selectedList.id);
              handleModalClose();
            }
          },
          {
            content: "Export List",
            onAction: () => {
              console.log("Export list:", selectedList.id);
              handleModalClose();
            }
          }
        ],
        children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: selectedList.name }),
            /* @__PURE__ */ jsx(Text, { variant: "bodyLg", as: "p", children: selectedList.description }),
            /* @__PURE__ */ jsx(InlineStack, { gap: "200", children: getStatusBadge(selectedList.status) })
          ] }),
          /* @__PURE__ */ jsxs(TextContainer, { children: [
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Contact Count:" }),
              " ",
              selectedList.contactCount.toLocaleString(),
              " contacts"
            ] }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Source:" }),
              " ",
              selectedList.source
            ] }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Imported From:" }),
              " ",
              selectedList.importedFrom
            ] }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Last Updated:" }),
              " ",
              selectedList.lastUpdated
            ] }),
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Created:" }),
              " ",
              selectedList.createdAt
            ] })
          ] })
        ] }) })
      }
    ),
    selectedList && /* @__PURE__ */ jsx(
      Modal,
      {
        open: deleteModalActive,
        onClose: handleModalClose,
        title: "Delete Static List",
        primaryAction: {
          content: isDeleting ? "Deleting..." : "Delete",
          destructive: true,
          onAction: handleConfirmDelete,
          disabled: isDeleting,
          loading: isDeleting
        },
        secondaryActions: [
          {
            content: "Cancel",
            onAction: handleModalClose
          }
        ],
        children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(TextContainer, { children: [
          /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
            'Are you sure you want to delete the list "',
            selectedList.name,
            '"? This action cannot be undone and will remove all ',
            selectedList.contactCount.toLocaleString(),
            " contacts from this list."
          ] }),
          /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: "Any active campaigns using this list will be affected." })
        ] }) })
      }
    ),
    /* @__PURE__ */ jsx(
      Modal,
      {
        open: importModalActive,
        onClose: handleModalClose,
        title: "Import Contacts",
        primaryAction: {
          content: "Import",
          onAction: () => {
            console.log("Import contacts:", files);
            handleModalClose();
          },
          disabled: files.length === 0
        },
        secondaryActions: [
          {
            content: "Cancel",
            onAction: handleModalClose
          }
        ],
        children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsxs(TextContainer, { children: [
            /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: "Upload a CSV file with your contacts. The file should include columns for name, phone number, and email." }),
            /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Supported formats: CSV, Excel (.xlsx), JSON" })
          ] }),
          /* @__PURE__ */ jsxs(DropZone, { onDrop: handleDropZoneDrop, children: [
            uploadedFiles,
            fileUpload
          ] }),
          files.length > 0 && /* @__PURE__ */ jsxs(TextContainer, { children: [
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Selected files:" }),
              " ",
              files.length,
              " file(s)"
            ] }),
            /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: 'Click "Import" to process these files and add contacts to a new static list.' })
          ] })
        ] }) })
      }
    ),
    /* @__PURE__ */ jsx(
      Modal,
      {
        open: createListModalActive,
        onClose: handleModalClose,
        title: "Create Contact List",
        primaryAction: {
          content: isCreating ? "Creating..." : "Create List",
          onAction: handleCreateContactList,
          disabled: !listName || !files.length || isCreating,
          loading: isCreating
        },
        secondaryActions: [
          {
            content: "Cancel",
            onAction: handleModalClose
          }
        ],
        children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsx(
            TextField,
            {
              label: "Contact List Name",
              value: listName,
              onChange: setListName,
              placeholder: "Enter a name for your contact list",
              autoComplete: "off",
              helpText: "Choose a descriptive name for your contact list"
            }
          ),
          /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h4", children: "Upload CSV File" }),
            /* @__PURE__ */ jsxs(TextContainer, { children: [
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: "Upload a CSV file with your contact data. The system will automatically process the file and create your contact list." }),
              /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: "Supported format: CSV files only" }),
              /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "info", children: 'Required format: First two columns must be "Name" and "Number", mapping starts from third column' }),
              csvErrorType === "number_format" && /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "critical", children: "Number column must contain only integer values (no decimals, and country code without +)" }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                "Example format:  ",
                /* @__PURE__ */ jsx(Link$1, { href: "https://app.getgabs.com/betaversion/templatedesign/template_design/csv/Contact Upload example.csv", target: "_blank", children: "Download Example CSV" })
              ] })
            ] }),
            /* @__PURE__ */ jsx(
              DropZone,
              {
                onDrop: handleCreateListDropZoneDrop,
                accept: ".csv,text/csv",
                type: "file",
                disabled: processingCsv,
                children: files.length > 0 ? /* @__PURE__ */ jsx("div", { style: { padding: "16px" }, children: /* @__PURE__ */ jsxs(InlineStack, { alignment: "center", gap: "200", children: [
                  /* @__PURE__ */ jsx("div", { style: {
                    width: "40px",
                    height: "40px",
                    backgroundColor: "var(--p-color-bg-success)",
                    borderRadius: "4px",
                    display: "flex",
                    alignItems: "center",
                    justifyContent: "center"
                  }, children: "📄" }),
                  /* @__PURE__ */ jsxs(BlockStack, { gap: "100", children: [
                    /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "semibold", children: files[0].name }),
                    /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                      (files[0].size / 1024).toFixed(1),
                      " KB"
                    ] })
                  ] })
                ] }) }) : /* @__PURE__ */ jsx(DropZone.FileUpload, { actionTitle: processingCsv ? "Processing CSV..." : "Upload CSV", actionHint: "or drag and drop" })
              }
            )
          ] }),
          showColumnMapping && csvColumns.length > 0 && /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h4", children: "Map CSV Columns" }),
            /* @__PURE__ */ jsxs(TextContainer, { children: [
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: "Map each CSV column to a variable for your contact list." }),
              /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: 'Click "Map" to select a variable, or type a variable name directly.' })
            ] }),
            /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
              /* @__PURE__ */ jsx("div", { style: {
                backgroundColor: "#008060",
                color: "white",
                padding: "12px 16px",
                borderRadius: "4px",
                fontSize: "14px"
              }, children: /* @__PURE__ */ jsx(InlineStack, { align: "space-between", blockAlign: "center", children: /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                "You can’t map Column1 and Column2 variable because it is always ",
                "{{name}} and {{number}}"
              ] }) }) }),
              csvColumns.map((column) => /* @__PURE__ */ jsx("div", { style: {
                border: "1px solid var(--p-color-border)",
                borderRadius: "8px",
                padding: "16px",
                backgroundColor: "var(--p-color-bg-surface-secondary)"
              }, children: /* @__PURE__ */ jsxs(InlineStack, { alignment: "center", gap: "200", blockAlign: "start", children: [
                /* @__PURE__ */ jsxs("div", { style: { flex: 1 }, children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", fontWeight: "semibold", children: column.displayName }),
                  /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
                    'First row value: "',
                    column.firstRowValue,
                    '"'
                  ] })
                ] }),
                /* @__PURE__ */ jsx("div", { style: { flex: 2 }, children: /* @__PURE__ */ jsxs(InlineStack, { alignment: "center", gap: "200", children: [
                  /* @__PURE__ */ jsx(
                    TextField,
                    {
                      label: "",
                      placeholder: "Select variable using Map button",
                      value: columnMappings[column.index] || "",
                      onChange: () => {
                      },
                      autoComplete: "off",
                      readOnly: true,
                      helpText: "Click 'Map' button to select a variable"
                    }
                  ),
                  /* @__PURE__ */ jsx(
                    Button,
                    {
                      size: "medium",
                      variant: "secondary",
                      onClick: () => handleMapColumn(column.index),
                      children: "Map"
                    }
                  ),
                  columnMappings[column.index] && /* @__PURE__ */ jsx(
                    Button,
                    {
                      size: "medium",
                      variant: "plain",
                      tone: "critical",
                      onClick: () => handleRemoveColumnMapping(column.index),
                      children: "Clear"
                    }
                  )
                ] }) })
              ] }) }, column.index))
            ] }),
            /* @__PURE__ */ jsx(TextContainer, { children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", tone: "subdued", children: '💡 Tip: First two columns (Name, Number) are automatically handled. Map additional columns starting from Column 3 (e.g., "Email" to email, "City" to city)' }) })
          ] }),
          files.length > 0 && listName && /* @__PURE__ */ jsx("div", { style: {
            backgroundColor: "var(--p-color-bg-success-subdued)",
            padding: "16px",
            borderRadius: "8px"
          }, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              'Ready to create contact list "',
              listName,
              '" with the uploaded CSV file.'
            ] }),
            showColumnMapping && Object.keys(columnMappings).length > 0 && /* @__PURE__ */ jsxs(Text, { variant: "bodySm", as: "p", tone: "subdued", children: [
              Object.keys(columnMappings).length,
              " column(s) mapped: ",
              Object.entries(columnMappings).map(([col, varName]) => `Column ${parseInt(col) + 1} → ${varName}`).join(", ")
            ] })
          ] }) })
        ] }) })
      }
    ),
    /* @__PURE__ */ jsx(
      Modal,
      {
        open: createVariableModalActive,
        onClose: handleModalClose,
        title: "Create Contact List Variable",
        primaryAction: {
          content: isCreating ? "Creating..." : "Create Variable",
          onAction: handleCreateVariables,
          disabled: !variableName || isCreating,
          loading: isCreating
        },
        secondaryActions: [
          {
            content: "Cancel",
            onAction: handleModalClose
          }
        ],
        children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsx("div", { style: {
            backgroundColor: "#008060",
            color: "white",
            padding: "12px 16px",
            borderRadius: "4px",
            fontSize: "14px"
          }, children: /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", blockAlign: "center", children: [
            /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: "See All Created Variables 👉" }),
            /* @__PURE__ */ jsx(
              Button,
              {
                size: "micro",
                variant: "secondary",
                onClick: () => setShowVariablesModal(true),
                disabled: loadingVariables,
                children: loadingVariables ? "Loading..." : `Variables (${availableVariables.length})`
              }
            )
          ] }) }),
          /* @__PURE__ */ jsx(
            TextField,
            {
              id: "variable-name-field",
              label: "Contact List Variable Name",
              value: variableName,
              onChange: (value) => setVariableName(value.replace(/\s+/g, "_")),
              placeholder: "Enter a variable name for your contact list",
              autoComplete: "off",
              helpText: "Choose a descriptive name for your contact list (max 20 characters)",
              maxLength: 20
            }
          ),
          successMessage && /* @__PURE__ */ jsxs("div", { style: {
            backgroundColor: "#008060",
            color: "white",
            padding: "12px 16px",
            borderRadius: "4px",
            fontSize: "14px",
            display: "flex",
            alignItems: "center",
            gap: "8px"
          }, children: [
            /* @__PURE__ */ jsx("span", { children: "✓" }),
            /* @__PURE__ */ jsx("span", { children: successMessage })
          ] })
        ] }) })
      }
    ),
    /* @__PURE__ */ jsx(
      Modal,
      {
        open: showVariablesModal,
        onClose: () => {
          setShowVariablesModal(false);
          setVariableSearchQuery("");
        },
        title: "All Available Variables",
        primaryAction: {
          content: "Close",
          onAction: () => {
            setShowVariablesModal(false);
            setVariableSearchQuery("");
          }
        },
        size: "large",
        children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsx(Text, { variant: "bodyMd", tone: "subdued", children: "Click on any variable to insert it into your variable name:" }),
          /* @__PURE__ */ jsx(
            TextField,
            {
              label: "Search Variables",
              value: variableSearchQuery,
              onChange: setVariableSearchQuery,
              placeholder: "Type to search variables...",
              clearButton: true,
              onClearButtonClick: () => setVariableSearchQuery(""),
              autoComplete: "off"
            }
          ),
          /* @__PURE__ */ jsx(InlineStack, { gap: "200", wrap: true, children: availableVariables.filter(
            (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
          ).map((variable) => /* @__PURE__ */ jsx(
            Button,
            {
              size: "medium",
              variant: "tertiary",
              onClick: () => {
                if (mappingColumnIndex !== null) {
                  handleVariableSelect(variable);
                } else {
                  insertVariable(variable.value);
                  setShowVariablesModal(false);
                  setVariableSearchQuery("");
                }
              },
              children: variable.label
            },
            variable.value
          )) }),
          availableVariables.filter(
            (variable) => variable.label.toLowerCase().includes(variableSearchQuery.toLowerCase()) || variable.value.toLowerCase().includes(variableSearchQuery.toLowerCase())
          ).length === 0 && variableSearchQuery && /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", tone: "subdued", alignment: "center", children: [
            'No variables found matching "',
            variableSearchQuery,
            '"'
          ] }),
          /* @__PURE__ */ jsxs(Text, { variant: "bodySm", tone: "subdued", children: [
            "You can also create custom variables using the format: ",
            "{{variable_name}}"
          ] })
        ] }) })
      }
    )
  ] });
}
const route31 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: StaticListPage
}, Symbol.toStringTag, { value: "Module" }));
const loader$1 = async () => {
  return redirect("/app/contact-list/static-list");
};
const route32 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  loader: loader$1
}, Symbol.toStringTag, { value: "Module" }));
const getPricingPlanLink = async (plan_id) => {
  const response = await fetch(`https://app.getgabs.com/partners/shopify/plan/purchase`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      "Authorization": `Bearer ${API_TOKEN}`
    },
    body: JSON.stringify({
      plan_id,
      token: API_TOKEN
    })
  });
  if (!response.ok) throw new Error("Failed to fetch PRICING LINK");
  const data = await response.json();
  console.log("PRICING LINK", data);
  return data;
};
function PricingPlanPage() {
  var _a2;
  const getAccountDetails2 = () => {
    try {
      const userData = localStorage.getItem("getgabs_user_data");
      if (userData) {
        const parsedData = JSON.parse(userData);
        if (!parsedData.userAllInfo) {
          return null;
        }
        const mapAccessValueTypeToPlanKey = (accessValueType) => {
          const planMapping = {
            0: null,
            // No plan
            1: "basic",
            // Basic Monthly
            11: "basic",
            // Basic Annually
            2: "pro",
            // Pro Monthly
            22: "pro",
            // Pro Annually
            4: "plus",
            // Plus Monthly
            44: "plus"
            // Plus Annually
          };
          return planMapping[accessValueType] || null;
        };
        return {
          isplanpurchased: parsedData.userAllInfo.access_value_type > 0,
          planKey: mapAccessValueTypeToPlanKey(parsedData.userAllInfo.access_value_type),
          accessValueType: parsedData.userAllInfo.access_value_type
        };
      }
    } catch (error) {
      console.error("Error getting account details:", error);
    }
    return null;
  };
  const plans = {
    basic: {
      name: "Basic",
      price: { monthly: 5, yearly: 50 },
      description: "Ideal for Startup",
      features: [
        { name: "Setup / Onboarding Fee", value: "No Cost" },
        { name: "Broadcast", value: "30,000/month" },
        { name: "Team Inbox", included: true },
        { name: "Chatbot Flow", value: "Unlimited" },
        { name: "AI Support Agent", included: false },
        { name: "Chat Widget", value: "3,000 Views/month" },
        { name: "WhatsApp Form", value: "1" },
        { name: "Catalog / Commerce", included: false },
        { name: "Webhooks", included: false },
        { name: "REST APIs", value: "50 calls/minutes" },
        { name: "Support", value: "Email + Chat" }
      ],
      limits: {
        messages: 3e4,
        templates: "Unlimited",
        contacts: "Unlimited",
        broadcasts: 3e4
      },
      popular: false,
      color: "success"
    },
    plus: {
      name: "Plus",
      price: { monthly: 11, yearly: 110 },
      description: "Ideal for Growing Business",
      features: [
        { name: "Setup / Onboarding Fee", value: "No Cost" },
        { name: "Broadcast", value: "5,00,000/month" },
        { name: "Team Inbox", included: true },
        { name: "Chatbot Flow", value: "Unlimited" },
        { name: "AI Support Agent", included: true },
        { name: "Chat Widget", value: "30,000 Views/month" },
        { name: "WhatsApp Form", value: "5" },
        { name: "Catalog / Commerce", included: true },
        { name: "Webhooks", included: true },
        { name: "REST APIs", value: "180 calls/minutes" },
        { name: "Support", value: "Priority Support" }
      ],
      limits: {
        messages: 5e5,
        templates: "Unlimited",
        contacts: "Unlimited",
        broadcasts: 5e5
      },
      popular: true,
      color: "success",
      badge: "Bestseller"
    },
    pro: {
      name: "Pro",
      price: { monthly: 59, yearly: 590 },
      description: "Ideal for Mid and Large Business",
      features: [
        { name: "Setup / Onboarding Fee", value: "No Cost" },
        { name: "Broadcast", value: "Unlimited" },
        { name: "Team Inbox", included: true },
        { name: "Chatbot Flow", value: "Unlimited" },
        { name: "AI Support Agent", included: true },
        { name: "Chat Widget", value: "10,00,000 Views/month" },
        { name: "WhatsApp Form", value: "50" },
        { name: "Catalog / Commerce", included: true },
        { name: "Webhooks", included: true },
        { name: "REST APIs", value: "360 calls/minutes" },
        { name: "Support", value: "Dedicated Support" }
      ],
      limits: {
        messages: "Unlimited",
        templates: "Unlimited",
        contacts: "Unlimited",
        broadcasts: "Unlimited"
      },
      popular: false,
      color: "info"
    }
  };
  const accountDetails2 = getAccountDetails2();
  const [planPurchased, setPlanPurchased] = useState(() => (accountDetails2 == null ? void 0 : accountDetails2.isplanpurchased) || false);
  const [currentPlan, setCurrentPlan] = useState(() => {
    if ((accountDetails2 == null ? void 0 : accountDetails2.planKey) && plans[accountDetails2.planKey]) {
      return accountDetails2.planKey;
    }
    const planName = getPlanName();
    return planName && plans[planName] ? planName : "plus";
  });
  const [billingCycle, setBillingCycle] = useState("monthly");
  const [showUpgradeModal, setShowUpgradeModal] = useState(false);
  const [selectedPlan, setSelectedPlan] = useState("");
  const [showUsageModal, setShowUsageModal] = useState(false);
  const [loadingPlan, setLoadingPlan] = useState("");
  const [usageData] = useState({
    messages: { used: 1250, limit: 2e3 },
    templates: { used: 8, limit: 15 },
    contacts: { used: 450, limit: 1e3 },
    broadcasts: { used: 12, limit: 25 }
  });
  useEffect(() => {
    const updatePlanStatus = () => {
      const details = getAccountDetails2();
      if (details) {
        setPlanPurchased(details.isplanpurchased);
        if (details.planKey && plans[details.planKey]) {
          setCurrentPlan(details.planKey);
        }
      }
    };
    window.addEventListener("storage", updatePlanStatus);
    return () => {
      window.removeEventListener("storage", updatePlanStatus);
    };
  }, []);
  const handlePlanSelect = useCallback(async (planKey) => {
    try {
      setLoadingPlan(planKey);
      const planIdMapping = {
        basic: billingCycle === "monthly" ? 1 : 11,
        pro: billingCycle === "monthly" ? 2 : 22,
        plus: billingCycle === "monthly" ? 4 : 44
      };
      const planId = planIdMapping[planKey];
      if (!planId) {
        console.error("Invalid plan key:", planKey);
        return;
      }
      const response = await getPricingPlanLink(planId);
      if (response.status && response.redirect_url) {
        window.open(response.redirect_url, "_blank", "noopener,noreferrer");
      } else {
        console.error("Invalid API response:", response);
        const fallbackUrls = {
          basic: "https://getgabs.com/pricing-basic",
          plus: "https://getgabs.com/pricing-plus",
          pro: "https://getgabs.com/pricing-pro"
        };
        const fallbackUrl = fallbackUrls[planKey];
        if (fallbackUrl) {
          window.open(fallbackUrl, "_blank", "noopener,noreferrer");
        }
      }
    } catch (error) {
      console.error("Error fetching pricing link:", error);
      const fallbackUrls = {
        basic: "https://getgabs.com/pricing-basic",
        plus: "https://getgabs.com/pricing-plus",
        pro: "https://getgabs.com/pricing-pro"
      };
      const fallbackUrl = fallbackUrls[planKey];
      if (fallbackUrl) {
        window.open(fallbackUrl, "_blank", "noopener,noreferrer");
      }
    } finally {
      setLoadingPlan("");
    }
  }, [billingCycle]);
  const handleUpgrade = useCallback(() => {
    console.log(`Upgrading to ${selectedPlan} plan...`);
    setCurrentPlan(selectedPlan);
    setShowUpgradeModal(false);
  }, [selectedPlan]);
  const calculateSavings = (plan) => {
    const monthly = plan.price.monthly * 12;
    const yearly = plan.price.yearly;
    return monthly - yearly;
  };
  const getUsagePercentage = (used, limit) => {
    if (limit === "Unlimited") return 0;
    return Math.min(used / limit * 100, 100);
  };
  const renderPlanCard = (planKey, plan) => {
    const isCurrentPlan = currentPlan === planKey;
    const isPurchasedPlan = planPurchased && isCurrentPlan;
    const price = plan.price[billingCycle];
    billingCycle === "yearly" ? calculateSavings(plan) : 0;
    const discountPercentage = billingCycle === "yearly" ? "(0% Markup)" : "";
    return /* @__PURE__ */ jsxs("div", { style: { position: "relative" }, children: [
      plan.badge && /* @__PURE__ */ jsx("div", { style: {
        position: "absolute",
        top: "-10px",
        left: "50%",
        transform: "translateX(-50%)",
        backgroundColor: "#F7E96C",
        padding: "8px 24px",
        borderRadius: "20px",
        fontSize: "14px",
        fontWeight: "bold",
        zIndex: 1
      }, children: plan.badge }),
      isPurchasedPlan && /* @__PURE__ */ jsx("div", { style: {
        position: "absolute",
        top: "10px",
        right: "10px",
        backgroundColor: "#008060",
        color: "white",
        padding: "4px 12px",
        borderRadius: "12px",
        fontSize: "12px",
        fontWeight: "bold",
        zIndex: 1
      }, children: "Current Plan" }),
      /* @__PURE__ */ jsx(Card, { sectioned: true, children: /* @__PURE__ */ jsxs("div", { style: { display: "flex", flexDirection: "column", gap: "20px", height: "100%", padding: "20px 0" }, children: [
        /* @__PURE__ */ jsxs("div", { style: { textAlign: "left" }, children: [
          /* @__PURE__ */ jsxs("div", { style: { display: "flex", alignItems: "center", gap: "8px", marginBottom: "4px" }, children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingLg", fontWeight: "bold", children: plan.name }),
            /* @__PURE__ */ jsx(Text, { variant: "bodySm", color: "subdued", children: discountPercentage })
          ] }),
          /* @__PURE__ */ jsx(Text, { variant: "bodyMd", color: "subdued", children: plan.description })
        ] }),
        /* @__PURE__ */ jsxs("div", { style: { display: "flex", alignItems: "baseline", gap: "4px" }, children: [
          /* @__PURE__ */ jsx(Text, { variant: "bodyLg", color: "subdued", children: "$" }),
          /* @__PURE__ */ jsx(Text, { variant: "heading2xl", fontWeight: "bold", children: price.toLocaleString() }),
          /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", color: "subdued", children: [
            "/",
            billingCycle === "monthly" ? "month" : "year"
          ] })
        ] }),
        /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(
          Button,
          {
            fullWidth: true,
            primary: !isPurchasedPlan,
            variant: isPurchasedPlan ? "plain" : "primary",
            disabled: isPurchasedPlan || loadingPlan === planKey,
            loading: loadingPlan === planKey,
            style: {
              backgroundColor: isPurchasedPlan ? "#f6f6f7" : planKey === "basic" ? "#1a5f3f" : planKey === "plus" ? "#90EE90" : "#1a5f3f",
              color: isPurchasedPlan ? "#6d7175" : planKey === "plus" ? "#000" : "#fff",
              border: isPurchasedPlan ? "1px solid #c9cccf" : "none",
              padding: "12px",
              fontWeight: "bold"
            },
            onClick: () => !isPurchasedPlan && handlePlanSelect(planKey),
            children: isPurchasedPlan ? "Current Plan" : loadingPlan === planKey ? "Getting Link..." : "Buy Now"
          }
        ) }),
        /* @__PURE__ */ jsx("div", { style: { display: "flex", flexDirection: "column", gap: "12px", flex: 1 }, children: plan.features.map((feature, index2) => /* @__PURE__ */ jsxs("div", { style: { display: "flex", justifyContent: "space-between", alignItems: "center", padding: "4px 0" }, children: [
          /* @__PURE__ */ jsxs("div", { style: { display: "flex", alignItems: "center", gap: "8px" }, children: [
            /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: feature.name }),
            /* @__PURE__ */ jsx(Icon, { source: InfoIcon, color: "subdued" })
          ] }),
          /* @__PURE__ */ jsxs("div", { style: { display: "flex", alignItems: "center" }, children: [
            feature.included === true && /* @__PURE__ */ jsx(Icon, { source: CheckIcon, color: "success" }),
            feature.included === false && /* @__PURE__ */ jsx("div", { style: {
              width: "20px",
              height: "20px",
              borderRadius: "50%",
              border: "2px solid #ccc",
              display: "flex",
              alignItems: "center",
              justifyContent: "center"
            }, children: /* @__PURE__ */ jsx("span", { style: { color: "#ccc", fontSize: "14px" }, children: "×" }) }),
            feature.value && /* @__PURE__ */ jsx(Text, { variant: "bodySm", color: "subdued", style: { fontStyle: "italic" }, children: feature.value })
          ] })
        ] }, index2)) })
      ] }) })
    ] }, planKey);
  };
  return /* @__PURE__ */ jsxs(
    Page,
    {
      title: "Pricing & Plans",
      subtitle: "Choose the perfect plan for your business needs",
      fullWidth: true,
      children: [
        /* @__PURE__ */ jsxs("div", { style: { padding: "0 24px", maxWidth: "1200px", margin: "0 auto" }, children: [
          planPurchased && currentPlan && plans[currentPlan] && /* @__PURE__ */ jsx("div", { style: { marginBottom: "24px" }, children: /* @__PURE__ */ jsx(Banner, { status: "success", children: /* @__PURE__ */ jsx("div", { style: { display: "flex", alignItems: "center", justifyContent: "space-between" }, children: /* @__PURE__ */ jsxs("div", { children: [
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", fontWeight: "bold", children: [
              "You are currently on the ",
              plans[currentPlan].name,
              " plan"
            ] }),
            (accountDetails2 == null ? void 0 : accountDetails2.accessValueType) && /* @__PURE__ */ jsxs(Text, { variant: "bodySm", color: "subdued", children: [
              "|",
              accountDetails2.accessValueType % 10 === 1 || accountDetails2.accessValueType % 10 === 2 || accountDetails2.accessValueType % 10 === 4 ? " Monthly" : " Annual",
              " billing"
            ] })
          ] }) }) }) }),
          !planPurchased && /* @__PURE__ */ jsx("div", { style: { marginBottom: "24px" }, children: /* @__PURE__ */ jsx(Banner, { status: "warning", children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: "You don't have an active plan. Choose a plan below to get started with all features." }) }) }),
          /* @__PURE__ */ jsx("div", { style: { marginBottom: "24px" }, children: /* @__PURE__ */ jsx(Card, { sectioned: true, children: /* @__PURE__ */ jsx("div", { style: { display: "flex", justifyContent: "center" }, children: /* @__PURE__ */ jsxs(ButtonGroup, { segmented: true, children: [
            /* @__PURE__ */ jsx(
              Button,
              {
                pressed: billingCycle === "monthly",
                onClick: () => setBillingCycle("monthly"),
                children: "Monthly"
              }
            ),
            /* @__PURE__ */ jsxs(
              Button,
              {
                pressed: billingCycle === "yearly",
                onClick: () => setBillingCycle("yearly"),
                children: [
                  "Yearly ",
                  " ",
                  /* @__PURE__ */ jsx(Badge, { status: "success", children: "+ 2 months free" })
                ]
              }
            )
          ] }) }) }) }),
          /* @__PURE__ */ jsxs("div", { style: {
            display: "grid",
            gridTemplateColumns: "repeat(3, 1fr)",
            gap: "24px",
            marginBottom: "40px",
            "@media (max-width: 768px)": {
              gridTemplateColumns: "1fr"
            }
          }, children: [
            renderPlanCard("basic", plans.basic),
            renderPlanCard("plus", plans.plus),
            renderPlanCard("pro", plans.pro)
          ] }),
          /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(Card, { sectioned: true, children: /* @__PURE__ */ jsxs("div", { style: { display: "flex", flexDirection: "column", gap: "16px", textAlign: "center" }, children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", children: "Need a custom solution?" }),
            /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: "Looking for a custom plan with specific features or higher limits? Our sales team can create a tailored solution for your business needs." }),
            /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(Button, { primary: true, url: "mailto:sales@yourbusiness.com", children: "Contact Sales" }) })
          ] }) }) })
        ] }),
        /* @__PURE__ */ jsx(
          Modal,
          {
            open: showUpgradeModal,
            onClose: () => setShowUpgradeModal(false),
            title: `Upgrade to ${(_a2 = plans[selectedPlan]) == null ? void 0 : _a2.name} Plan`,
            primaryAction: {
              content: "Confirm Upgrade",
              onAction: handleUpgrade
            },
            secondaryActions: [
              {
                content: "Cancel",
                onAction: () => setShowUpgradeModal(false)
              }
            ],
            children: /* @__PURE__ */ jsx(Modal.Section, { children: selectedPlan && plans[selectedPlan] && /* @__PURE__ */ jsxs(TextContainer, { children: [
              /* @__PURE__ */ jsxs("p", { children: [
                "You're about to upgrade to the ",
                /* @__PURE__ */ jsx("strong", { children: plans[selectedPlan].name }),
                " plan."
              ] }),
              /* @__PURE__ */ jsxs("p", { children: [
                /* @__PURE__ */ jsx("strong", { children: "Price:" }),
                " $",
                plans[selectedPlan].price[billingCycle],
                " per ",
                billingCycle === "monthly" ? "month" : "year"
              ] }),
              billingCycle === "yearly" && calculateSavings(plans[selectedPlan]) > 0 && /* @__PURE__ */ jsxs(Banner, { status: "success", children: [
                "You'll save $",
                calculateSavings(plans[selectedPlan]),
                " per year with yearly billing!"
              ] }),
              /* @__PURE__ */ jsx("p", { children: "Your new plan will be active immediately, and you'll be charged on your next billing cycle." })
            ] }) })
          }
        ),
        /* @__PURE__ */ jsx(
          Modal,
          {
            open: showUsageModal,
            onClose: () => setShowUsageModal(false),
            title: "Usage Details",
            large: true,
            children: /* @__PURE__ */ jsx(Modal.Section, { children: plans[currentPlan] && /* @__PURE__ */ jsxs("div", { style: { display: "grid", gridTemplateColumns: "1fr 1fr", gap: "20px" }, children: [
              /* @__PURE__ */ jsx(Card, { sectioned: true, title: "Messages", children: /* @__PURE__ */ jsxs("div", { style: { display: "flex", flexDirection: "column", gap: "16px" }, children: [
                /* @__PURE__ */ jsxs("div", { style: { display: "flex", justifyContent: "space-between" }, children: [
                  /* @__PURE__ */ jsx(Text, { children: "Used this month" }),
                  /* @__PURE__ */ jsx(Text, { fontWeight: "bold", children: usageData.messages.used.toLocaleString() })
                ] }),
                /* @__PURE__ */ jsxs("div", { style: { display: "flex", justifyContent: "space-between" }, children: [
                  /* @__PURE__ */ jsx(Text, { children: "Plan limit" }),
                  /* @__PURE__ */ jsx(Text, { children: plans[currentPlan].limits.messages.toLocaleString() })
                ] }),
                /* @__PURE__ */ jsx("div", { style: {
                  width: "100%",
                  height: "8px",
                  backgroundColor: "#f0f0f0",
                  borderRadius: "4px",
                  overflow: "hidden"
                }, children: /* @__PURE__ */ jsx("div", { style: {
                  width: `${getUsagePercentage(usageData.messages.used, plans[currentPlan].limits.messages)}%`,
                  height: "100%",
                  backgroundColor: getUsagePercentage(usageData.messages.used, plans[currentPlan].limits.messages) >= 90 ? "#d73502" : getUsagePercentage(usageData.messages.used, plans[currentPlan].limits.messages) >= 75 ? "#bf5000" : "#008060",
                  transition: "width 0.3s ease"
                } }) })
              ] }) }),
              /* @__PURE__ */ jsx(Card, { sectioned: true, title: "Templates", children: /* @__PURE__ */ jsxs("div", { style: { display: "flex", flexDirection: "column", gap: "16px" }, children: [
                /* @__PURE__ */ jsxs("div", { style: { display: "flex", justifyContent: "space-between" }, children: [
                  /* @__PURE__ */ jsx(Text, { children: "Created" }),
                  /* @__PURE__ */ jsx(Text, { fontWeight: "bold", children: usageData.templates.used })
                ] }),
                /* @__PURE__ */ jsxs("div", { style: { display: "flex", justifyContent: "space-between" }, children: [
                  /* @__PURE__ */ jsx(Text, { children: "Plan limit" }),
                  /* @__PURE__ */ jsx(Text, { children: plans[currentPlan].limits.templates })
                ] }),
                /* @__PURE__ */ jsx("div", { style: {
                  width: "100%",
                  height: "8px",
                  backgroundColor: "#f0f0f0",
                  borderRadius: "4px",
                  overflow: "hidden"
                }, children: /* @__PURE__ */ jsx("div", { style: {
                  width: `${getUsagePercentage(usageData.templates.used, plans[currentPlan].limits.templates)}%`,
                  height: "100%",
                  backgroundColor: getUsagePercentage(usageData.templates.used, plans[currentPlan].limits.templates) >= 90 ? "#d73502" : getUsagePercentage(usageData.templates.used, plans[currentPlan].limits.templates) >= 75 ? "#bf5000" : "#008060",
                  transition: "width 0.3s ease"
                } }) })
              ] }) })
            ] }) })
          }
        )
      ]
    }
  );
}
const route33 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: PricingPlanPage
}, Symbol.toStringTag, { value: "Module" }));
function BroadcastPage() {
  const navigate = useNavigate();
  const sleep = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
  const [selectedBroadcast, setSelectedBroadcast] = useState(null);
  const [previewModalActive, setPreviewModalActive] = useState(false);
  const [broadcasts, setBroadcasts] = useState([]);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);
  const [syncing, setSyncing] = useState(false);
  const [syncMessage, setSyncMessage] = useState(null);
  const [selectedTemplateData, setSelectedTemplateData] = useState(null);
  const [loadingTemplateDetails, setLoadingTemplateDetails] = useState(false);
  const [templateError, setTemplateError] = useState(null);
  const [itemStrings, setItemStrings] = useState([
    "All",
    "In Progress",
    "Waiting",
    "Paused",
    "Finished",
    "Payment Issues"
  ]);
  const [selected, setSelected] = useState(0);
  const [queryValue, setQueryValue] = useState("");
  const [sortSelected, setSortSelected] = useState([""]);
  const [statusFilter, setStatusFilter2] = useState([]);
  const [campaignFilter, setCampaignFilter] = useState("");
  const [dateRange, setDateRange] = useState([0, 30]);
  const { mode: mode2, setMode } = useSetIndexFiltersMode();
  const [currentPage, setCurrentPage] = useState(1);
  const [paginationData, setPaginationData] = useState({
    current_page: 1,
    last_page: 1,
    per_page: 20,
    total: 0,
    from: 0,
    to: 0
  });
  const itemsPerPage = 20;
  const transformApiData = (apiData) => {
    if (!apiData || !apiData.WhatsAppBusinessCampaign || !apiData.WhatsAppBusinessCampaign.data) {
      return [];
    }
    return apiData.WhatsAppBusinessCampaign.data.map((campaign) => ({
      id: campaign.id.toString(),
      broadcastName: campaign.name,
      campaignId: campaign.id.toString(),
      status: campaign.status.charAt(0).toUpperCase() + campaign.status.slice(1),
      scheduledOn: new Date(campaign.schedule).toLocaleDateString() + " " + new Date(campaign.schedule).toLocaleTimeString([], { hour: "2-digit", minute: "2-digit" }),
      targetAudience: campaign.failed + campaign.pending + campaign.totalsent + campaign.totaldelivered + campaign.totalread,
      executed: campaign.executed,
      failed: campaign.failed,
      templateId: campaign.template_name || "unknown",
      templateName: campaign.template_name || "Unknown Template",
      templateType: "campaign",
      createdAt: campaign.created_at.split("T")[0],
      message: campaign.message,
      totalread: campaign.totalread,
      totaldelivered: campaign.totaldelivered,
      totalsent: campaign.totalsent,
      pending: campaign.pending
    }));
  };
  useEffect(() => {
    const loadBroadcasts = async () => {
      try {
        setLoading(true);
        setError(null);
        const statusMap = {
          0: "All",
          1: "processing",
          2: "waiting",
          3: "paused",
          4: "finished",
          5: "payment-issue"
        };
        const statusType = statusMap[selected] || "All";
        const response = await fetchBroadcastList({
          statusType,
          page: currentPage,
          perPageData: itemsPerPage
        });
        if (response.status && response.WhatsAppBusinessCampaign) {
          const transformedData = transformApiData(response);
          setBroadcasts(transformedData);
          const apiPagination = response.WhatsAppBusinessCampaign;
          setPaginationData({
            current_page: apiPagination.current_page || 1,
            last_page: apiPagination.last_page || 1,
            per_page: parseInt(apiPagination.per_page) || 20,
            total: apiPagination.total || 0,
            from: apiPagination.from || 0,
            to: apiPagination.to || 0
          });
        } else {
          throw new Error("Invalid API response format");
        }
      } catch (err) {
        console.error("Error loading broadcasts:", err);
        setError(err.message);
        setBroadcasts([]);
      } finally {
        setLoading(false);
      }
    };
    loadBroadcasts();
  }, [selected, currentPage, itemsPerPage]);
  const handleSync = useCallback(async () => {
    try {
      setSyncing(true);
      setSyncMessage(null);
      setError(null);
      setBroadcasts([]);
      const statusMap = {
        0: "All",
        1: "processing",
        2: "waiting",
        3: "paused",
        4: "finished",
        5: "payment-issue"
      };
      const statusType = statusMap[selected] || "All";
      const response = await fetchBroadcastList({
        statusType,
        page: currentPage,
        perPageData: itemsPerPage
      });
      if (response.status && response.WhatsAppBusinessCampaign) {
        const transformedData = transformApiData(response);
        setBroadcasts(transformedData);
        const apiPagination = response.WhatsAppBusinessCampaign;
        setPaginationData({
          current_page: apiPagination.current_page || 1,
          last_page: apiPagination.last_page || 1,
          per_page: parseInt(apiPagination.per_page) || 20,
          total: apiPagination.total || 0,
          from: apiPagination.from || 0,
          to: apiPagination.to || 0
        });
        setSyncMessage("Broadcast data synchronized successfully!");
        setTimeout(() => {
          setSyncMessage(null);
        }, 3e3);
      } else {
        throw new Error("Invalid API response format");
      }
    } catch (err) {
      console.error("Error syncing broadcasts:", err);
      setError(err.message);
      setSyncMessage("Failed to sync broadcast data. Please try again.");
      setTimeout(() => {
        setSyncMessage(null);
      }, 5e3);
    } finally {
      setSyncing(false);
    }
  }, [selected, currentPage, itemsPerPage]);
  const deleteView = (index2) => {
    const newItemStrings = [...itemStrings];
    newItemStrings.splice(index2, 1);
    setItemStrings(newItemStrings);
    setSelected(0);
  };
  const duplicateView = async (name) => {
    setItemStrings([...itemStrings, name]);
    setSelected(itemStrings.length);
    await sleep(1);
    return true;
  };
  const onCreateNewView = async (value) => {
    await sleep(500);
    setItemStrings([...itemStrings, value]);
    setSelected(itemStrings.length);
    return true;
  };
  const tabs = itemStrings.map((item, index2) => ({
    content: item,
    index: index2,
    onAction: () => {
    },
    id: `${item}-${index2}`,
    isLocked: index2 === 0,
    actions: index2 === 0 ? [] : [
      {
        type: "rename",
        onAction: () => {
        },
        onPrimaryAction: async (value) => {
          const newItemsStrings = tabs.map((item2, idx) => {
            if (idx === index2) {
              return value;
            }
            return item2.content;
          });
          await sleep(1);
          setItemStrings(newItemsStrings);
          return true;
        }
      },
      {
        type: "duplicate",
        onPrimaryAction: async (value) => {
          await sleep(1);
          duplicateView(value);
          return true;
        }
      },
      {
        type: "edit"
      },
      {
        type: "delete",
        onPrimaryAction: async () => {
          await sleep(1);
          deleteView(index2);
          return true;
        }
      }
    ]
  }));
  const filteredBroadcasts = useMemo(() => {
    return broadcasts.filter((broadcast) => {
      const matchesSearch = broadcast.broadcastName.toLowerCase().includes(queryValue.toLowerCase()) || broadcast.campaignId.toLowerCase().includes(queryValue.toLowerCase());
      const matchesStatus = statusFilter.length === 0 || statusFilter.includes(broadcast.status.toLowerCase());
      const matchesCampaign = campaignFilter === "" || broadcast.campaignId.toLowerCase().includes(campaignFilter.toLowerCase());
      let matchesDate = true;
      if (dateRange && (dateRange[0] !== 0 || dateRange[1] !== 30)) {
        const createdDate = new Date(broadcast.createdAt);
        const today = /* @__PURE__ */ new Date();
        const daysSinceCreated = Math.floor((today - createdDate) / (1e3 * 60 * 60 * 24));
        matchesDate = daysSinceCreated >= dateRange[0] && daysSinceCreated <= dateRange[1];
      }
      return matchesSearch && matchesStatus && matchesCampaign && matchesDate;
    });
  }, [broadcasts, queryValue, statusFilter, campaignFilter, dateRange]);
  const sortedBroadcasts = useMemo(() => {
    const sorted = [...filteredBroadcasts];
    const [sortKey, sortDirection] = sortSelected[0].split(" ");
    sorted.sort((a, b) => {
      let aValue, bValue;
      switch (sortKey) {
        case "name":
          aValue = a.broadcastName.toLowerCase();
          bValue = b.broadcastName.toLowerCase();
          break;
        case "status":
          aValue = a.status.toLowerCase();
          bValue = b.status.toLowerCase();
          break;
        case "campaign":
          aValue = a.campaignId.toLowerCase();
          bValue = b.campaignId.toLowerCase();
          break;
        case "audience":
          aValue = a.targetAudience;
          bValue = b.targetAudience;
          break;
        case "scheduled":
          aValue = new Date(a.scheduledOn);
          bValue = new Date(b.scheduledOn);
          break;
        case "executed":
          aValue = a.executed;
          bValue = b.executed;
          break;
        default:
          return 0;
      }
      if (aValue < bValue) return sortDirection === "asc" ? -1 : 1;
      if (aValue > bValue) return sortDirection === "asc" ? 1 : -1;
      return 0;
    });
    return sorted;
  }, [filteredBroadcasts, sortSelected]);
  const paginatedBroadcasts = sortedBroadcasts;
  const handlePreviousPage = useCallback(() => {
    setCurrentPage((prev) => Math.max(1, prev - 1));
  }, []);
  const handleNextPage = useCallback(() => {
    setCurrentPage((prev) => Math.min(paginationData.last_page, prev + 1));
  }, [paginationData.last_page]);
  const totalItems = paginationData.total;
  paginationData.last_page;
  const startItem = paginationData.from;
  const endItem = paginationData.to;
  const hasNext = currentPage < paginationData.last_page;
  const hasPrevious = currentPage > 1;
  const sortOptions = [
    { label: "Broadcast Name", value: "name asc", directionLabel: "A-Z" },
    { label: "Broadcast Name", value: "name desc", directionLabel: "Z-A" },
    { label: "Status", value: "status asc", directionLabel: "A-Z" },
    { label: "Status", value: "status desc", directionLabel: "Z-A" },
    { label: "Campaign ID", value: "campaign asc", directionLabel: "A-Z" },
    { label: "Campaign ID", value: "campaign desc", directionLabel: "Z-A" },
    { label: "Target Audience", value: "audience asc", directionLabel: "Low to High" },
    { label: "Target Audience", value: "audience desc", directionLabel: "High to Low" },
    { label: "Scheduled Date", value: "scheduled asc", directionLabel: "Earliest First" },
    { label: "Scheduled Date", value: "scheduled desc", directionLabel: "Latest First" },
    { label: "Executed Count", value: "executed asc", directionLabel: "Low to High" },
    { label: "Executed Count", value: "executed desc", directionLabel: "High to Low" }
  ];
  const fetchTemplateDetails = useCallback(async (templateName) => {
    if (!templateName || templateName === "unknown" || templateName === "Unknown Template") {
      return null;
    }
    try {
      setLoadingTemplateDetails(true);
      setTemplateError(null);
      const templateData = await getSelectedTemplatebyName(templateName);
      setSelectedTemplateData(templateData);
      return templateData;
    } catch (error2) {
      console.error("Error fetching template details:", error2);
      setTemplateError(error2.message || "Failed to fetch template details");
      return null;
    } finally {
      setLoadingTemplateDetails(false);
    }
  }, []);
  const handlePreviewClick = useCallback(async (broadcast) => {
    setSelectedBroadcast(broadcast);
    setSelectedTemplateData(null);
    setTemplateError(null);
    setPreviewModalActive(true);
    if (broadcast.templateName && broadcast.templateName !== "Unknown Template") {
      await fetchTemplateDetails(broadcast.templateName);
    }
  }, [fetchTemplateDetails]);
  const handleModalClose = useCallback(() => {
    setPreviewModalActive(false);
    setSelectedBroadcast(null);
    setSelectedTemplateData(null);
    setTemplateError(null);
    setLoadingTemplateDetails(false);
  }, []);
  const handleCreateBroadcast = useCallback(() => {
    console.log("Create broadcast button clicked");
    try {
      navigate("/app/create-broadcast");
    } catch (error2) {
      console.error("Navigation error:", error2);
      window.location.href = "/app/create-broadcast";
    }
  }, [navigate]);
  const handleFiltersQueryChange = useCallback((value) => {
    setQueryValue(value);
  }, []);
  const handleQueryValueRemove = useCallback(() => setQueryValue(""), []);
  const handleStatusChange = useCallback((value) => {
    setStatusFilter2(value);
  }, []);
  const handleCampaignChange = useCallback((value) => {
    setCampaignFilter(value);
  }, []);
  const handleDateRangeChange = useCallback((value) => {
    setDateRange(value);
  }, []);
  const handleStatusRemove = useCallback(() => setStatusFilter2([]), []);
  const handleCampaignRemove = useCallback(() => setCampaignFilter(""), []);
  const handleDateRangeRemove = useCallback(() => setDateRange([0, 30]), []);
  const handleFiltersClearAll = useCallback(() => {
    handleStatusRemove();
    handleCampaignRemove();
    handleDateRangeRemove();
    handleQueryValueRemove();
  }, [handleStatusRemove, handleCampaignRemove, handleDateRangeRemove, handleQueryValueRemove]);
  const onHandleCancel = () => {
  };
  const getStatusBadge = (status) => {
    var _a2;
    const statusConfig = {
      "Inprogress": { tone: "info" },
      "In Progress": { tone: "info" },
      "Waiting": { tone: "attention" },
      "Paused": { tone: "warning" },
      "Finished": { tone: "success" },
      "Payment Issue": { tone: "critical" },
      "Payment Issues": { tone: "critical" },
      "Active": { tone: "info" },
      "Scheduled": { tone: "attention" },
      "Completed": { tone: "success" },
      "Draft": { tone: "subdued" },
      "Failed": { tone: "critical" }
    };
    return /* @__PURE__ */ jsx(Badge, { tone: ((_a2 = statusConfig[status]) == null ? void 0 : _a2.tone) || "info", children: status });
  };
  const filters = [
    {
      key: "status",
      label: "Campaign Status",
      filter: /* @__PURE__ */ jsx(
        ChoiceList,
        {
          title: "Campaign Status",
          titleHidden: true,
          choices: [
            { label: "In Progress", value: "inprogress" },
            { label: "Waiting", value: "waiting" },
            { label: "Paused", value: "paused" },
            { label: "Finished", value: "finished" },
            { label: "Payment Issue", value: "payment issue" },
            { label: "Active", value: "active" },
            { label: "Scheduled", value: "scheduled" },
            { label: "Completed", value: "completed" },
            { label: "Draft", value: "draft" },
            { label: "Failed", value: "failed" }
          ],
          selected: statusFilter || [],
          onChange: handleStatusChange,
          allowMultiple: true
        }
      ),
      shortcut: true
    },
    {
      key: "campaign",
      label: "Campaign ID",
      filter: /* @__PURE__ */ jsx(
        TextField,
        {
          label: "Campaign ID",
          value: campaignFilter,
          onChange: handleCampaignChange,
          autoComplete: "off",
          labelHidden: true
        }
      ),
      shortcut: true
    },
    {
      key: "dateRange",
      label: "Days Since Created",
      filter: /* @__PURE__ */ jsx(
        RangeSlider,
        {
          label: "Days since created",
          labelHidden: true,
          value: dateRange || [0, 30],
          suffix: " days",
          output: true,
          min: 0,
          max: 30,
          step: 1,
          onChange: handleDateRangeChange
        }
      )
    }
  ];
  const appliedFilters = [];
  if (statusFilter && !isEmpty(statusFilter)) {
    appliedFilters.push({
      key: "status",
      label: disambiguateLabel("status", statusFilter),
      onRemove: handleStatusRemove
    });
  }
  if (dateRange && (dateRange[0] !== 0 || dateRange[1] !== 30)) {
    appliedFilters.push({
      key: "dateRange",
      label: disambiguateLabel("dateRange", dateRange),
      onRemove: handleDateRangeRemove
    });
  }
  if (!isEmpty(campaignFilter)) {
    appliedFilters.push({
      key: "campaign",
      label: disambiguateLabel("campaign", campaignFilter),
      onRemove: handleCampaignRemove
    });
  }
  const resourceName = {
    singular: "broadcast",
    plural: "broadcasts"
  };
  const { selectedResources, allResourcesSelected, handleSelectionChange } = useIndexResourceState(paginatedBroadcasts);
  function disambiguateLabel(key, value) {
    switch (key) {
      case "dateRange":
        return `Created ${value[0]}-${value[1]} days ago`;
      case "campaign":
        return `Campaign ID contains "${value}"`;
      case "status":
        return value.map((val) => `Status: ${val.charAt(0).toUpperCase() + val.slice(1)}`).join(", ");
      default:
        return value;
    }
  }
  function isEmpty(value) {
    if (Array.isArray(value)) {
      return value.length === 0;
    } else {
      return value === "" || value == null;
    }
  }
  const rowMarkup = paginatedBroadcasts.map(
    (broadcast, index2) => /* @__PURE__ */ jsxs(
      IndexTable.Row,
      {
        id: broadcast.id,
        selected: selectedResources.includes(broadcast.id),
        position: index2,
        children: [
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", fontWeight: "semibold", as: "span", children: broadcast.broadcastName }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "span", children: broadcast.campaignId }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { as: "span", numeric: true, children: broadcast.targetAudience.toLocaleString() }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: getStatusBadge(broadcast.status) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "span", children: broadcast.scheduledOn }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { as: "span", numeric: true, children: broadcast.executed.toLocaleString() }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { as: "span", numeric: true, children: (broadcast.totalsent + broadcast.totalread + broadcast.totaldelivered).toLocaleString() }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { as: "span", numeric: true, tone: broadcast.failed > 0 ? "critical" : "subdued", children: broadcast.failed.toLocaleString() }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(InlineStack, { align: "end", children: /* @__PURE__ */ jsx(Tooltip, { content: "Preview template", children: /* @__PURE__ */ jsx(
            Button,
            {
              size: "slim",
              onClick: (event) => {
                event.stopPropagation();
                handlePreviewClick(broadcast);
              },
              children: /* @__PURE__ */ jsx(Icon, { source: ViewIcon })
            }
          ) }) }) })
        ]
      },
      broadcast.id
    )
  );
  console.log("Debug Info:", {
    totalBroadcasts: broadcasts.length,
    filteredBroadcasts: filteredBroadcasts.length,
    sortedBroadcasts: sortedBroadcasts.length,
    paginatedBroadcasts: paginatedBroadcasts.length,
    selectedTab: selected,
    queryValue,
    statusFilter,
    dateRange,
    currentPage,
    paginationData
  });
  if (loading) {
    return /* @__PURE__ */ jsx(
      Page,
      {
        title: "Broadcast Campaigns",
        subtitle: "Manage your WhatsApp broadcast campaigns",
        fullWidth: true,
        children: /* @__PURE__ */ jsx(LegacyCard, { children: /* @__PURE__ */ jsx("div", { style: { textAlign: "center", padding: "60px 20px" }, children: /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: "Loading broadcast campaigns..." }) }) })
      }
    );
  }
  if (error) {
    return /* @__PURE__ */ jsx(
      Page,
      {
        title: "Broadcast Campaigns",
        subtitle: "Manage your WhatsApp broadcast campaigns",
        fullWidth: true,
        children: /* @__PURE__ */ jsx(LegacyCard, { children: /* @__PURE__ */ jsxs("div", { style: { textAlign: "center", padding: "60px 20px" }, children: [
          /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", tone: "critical", children: "Error loading broadcasts" }),
          /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: error })
        ] }) })
      }
    );
  }
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(
      Page,
      {
        title: "Broadcast Campaigns",
        subtitle: "Manage your WhatsApp broadcast campaigns",
        fullWidth: true,
        primaryAction: {
          content: /* @__PURE__ */ jsx(InlineStack, { alignment: "center", children: /* @__PURE__ */ jsx(Text, { as: "span", children: "Create Broadcast" }) }),
          onAction: handleCreateBroadcast
        },
        secondaryActions: [
          {
            content: /* @__PURE__ */ jsxs(InlineStack, { alignment: "center", children: [
              /* @__PURE__ */ jsx(Icon, { source: RefreshIcon }),
              /* @__PURE__ */ jsx(Text, { as: "span", children: "Sync" })
            ] }),
            onAction: handleSync,
            disabled: syncing,
            loading: syncing
          }
        ],
        children: [
          syncMessage && /* @__PURE__ */ jsx("div", { style: { marginBottom: "16px" }, children: /* @__PURE__ */ jsx(
            Banner,
            {
              title: syncMessage.includes("successfully") ? "Success" : "Sync Error",
              tone: syncMessage.includes("successfully") ? "success" : "critical",
              onDismiss: () => setSyncMessage(null),
              children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: syncMessage })
            }
          ) }),
          /* @__PURE__ */ jsxs(LegacyCard, { children: [
            /* @__PURE__ */ jsx(
              IndexFilters,
              {
                sortOptions,
                sortSelected,
                queryValue,
                queryPlaceholder: "Search broadcasts...",
                onQueryChange: handleFiltersQueryChange,
                onQueryClear: () => setQueryValue(""),
                onSort: setSortSelected,
                cancelAction: {
                  onAction: onHandleCancel,
                  disabled: false,
                  loading: false
                },
                tabs,
                selected,
                onSelect: setSelected,
                canCreateNewView: true,
                onCreateNewView,
                filters,
                appliedFilters,
                onClearAll: handleFiltersClearAll,
                mode: mode2,
                setMode
              }
            ),
            /* @__PURE__ */ jsxs("div", { className: "broadcast-table-wrapper", children: [
              /* @__PURE__ */ jsx("style", { children: `
              .broadcast-table-wrapper .Polaris-IndexTable__Table th:nth-child(2),
              .broadcast-table-wrapper .Polaris-IndexTable__Table td:nth-child(2) {
                padding-left: 8px !important;
              }
              .broadcast-table-wrapper .Polaris-IndexTable__CheckboxWrapper {
                margin-right: 4px !important;
              }
            ` }),
              /* @__PURE__ */ jsx(
                IndexTable,
                {
                  resourceName,
                  itemCount: paginatedBroadcasts.length,
                  selectedItemsCount: allResourcesSelected ? "All" : selectedResources.length,
                  onSelectionChange: handleSelectionChange,
                  headings: [
                    { title: "Broadcast name" },
                    { title: "Campaign id" },
                    { title: "Target Audience" },
                    { title: "Status" },
                    { title: "Scheduled On" },
                    { title: "Executed" },
                    { title: "Sent" },
                    { title: "Failed" },
                    { title: "Preview Template & report", alignment: "end" }
                  ],
                  emptyState: /* @__PURE__ */ jsxs("div", { style: { textAlign: "center", padding: "60px 20px" }, children: [
                    /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: "No broadcasts found" }),
                    /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: filteredBroadcasts.length === 0 && broadcasts.length > 0 ? "Try adjusting your filters to see more results." : "Create your first broadcast campaign to get started." })
                  ] }),
                  children: rowMarkup
                }
              )
            ] }),
            paginationData.total > paginationData.per_page && /* @__PURE__ */ jsx(
              "div",
              {
                style: {
                  maxWidth: "700px",
                  margin: "auto",
                  border: "1px solid var(--p-color-border)",
                  marginTop: "16px"
                },
                children: /* @__PURE__ */ jsx(
                  Pagination,
                  {
                    onPrevious: hasPrevious ? handlePreviousPage : void 0,
                    onNext: hasNext ? handleNextPage : void 0,
                    type: "table",
                    hasNext,
                    hasPrevious,
                    label: `${startItem || 0}-${endItem || 0} of ${totalItems || 0} broadcasts`
                  }
                )
              }
            )
          ] })
        ]
      }
    ),
    selectedBroadcast && /* @__PURE__ */ jsx(
      Modal,
      {
        open: previewModalActive,
        onClose: handleModalClose,
        title: `Preview: ${selectedBroadcast.broadcastName}`,
        primaryAction: {
          content: "Close",
          onAction: handleModalClose
        },
        children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
            /* @__PURE__ */ jsx(InlineStack, { gap: "200", children: /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
              /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h3", children: selectedBroadcast.broadcastName }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodyLg", as: "p", children: [
                "Campaign ID: ",
                selectedBroadcast.campaignId
              ] })
            ] }) }),
            /* @__PURE__ */ jsx(InlineStack, { gap: "200", children: getStatusBadge(selectedBroadcast.status) })
          ] }),
          /* @__PURE__ */ jsxs(TextContainer, { children: [
            /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
              /* @__PURE__ */ jsx("strong", { children: "Template:" }),
              " ",
              selectedBroadcast.templateName
            ] }),
            /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
              /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                /* @__PURE__ */ jsx("strong", { children: "Total Executed:" }),
                " ",
                selectedBroadcast.executed
              ] }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                /* @__PURE__ */ jsx("strong", { children: "Total Sent:" }),
                " ",
                selectedBroadcast.totalsent + selectedBroadcast.totaldelivered + selectedBroadcast.totalread
              ] }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                /* @__PURE__ */ jsx("strong", { children: "Total Delivered:" }),
                " ",
                selectedBroadcast.totaldelivered + selectedBroadcast.totalread
              ] }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                /* @__PURE__ */ jsx("strong", { children: "Total Read:" }),
                " ",
                selectedBroadcast.totalread
              ] }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                /* @__PURE__ */ jsx("strong", { children: "Total Failed:" }),
                " ",
                selectedBroadcast.failed
              ] }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                /* @__PURE__ */ jsx("strong", { children: "Total Pending:" }),
                " ",
                selectedBroadcast.pending
              ] })
            ] }),
            /* @__PURE__ */ jsxs(InlineStack, { gap: "200", children: [
              /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                /* @__PURE__ */ jsx("strong", { children: "Execution Rate:" }),
                " ",
                selectedBroadcast.executed > 0 ? ((selectedBroadcast.failed + selectedBroadcast.pending + selectedBroadcast.totalsent + selectedBroadcast.totaldelivered + selectedBroadcast.totalread) / selectedBroadcast.executed * 100).toFixed(1) + "%" : "N/A"
              ] }),
              /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", children: [
                /* @__PURE__ */ jsx("strong", { children: "Delivery Rate:" }),
                " ",
                selectedBroadcast.targetAudience > 0 ? ((selectedBroadcast.totaldelivered + selectedBroadcast.totalread) / (selectedBroadcast.failed + selectedBroadcast.pending + selectedBroadcast.totalsent + selectedBroadcast.totaldelivered + selectedBroadcast.totalread) * 100).toFixed(1) + "%" : "N/A"
              ] })
            ] })
          ] }),
          templateError && /* @__PURE__ */ jsx(
            Banner,
            {
              title: "Template Loading Error",
              tone: "critical",
              onDismiss: () => setTemplateError(null),
              children: /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", children: templateError })
            }
          ),
          /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h4", children: "WhatsApp Template Preview" }),
            loadingTemplateDetails ? /* @__PURE__ */ jsxs("div", { style: { textAlign: "center", padding: "40px 20px" }, children: [
              /* @__PURE__ */ jsx(Spinner, { accessibilityLabel: "Loading template details", size: "large" }),
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", tone: "subdued", alignment: "center", children: "Loading template details..." })
            ] }) : selectedTemplateData ? /* @__PURE__ */ jsx(
              WhatsAppPreview,
              {
                template: selectedTemplateData,
                variant: "full",
                showWhatsAppHeader: true
              }
            ) : (() => {
              try {
                if (selectedBroadcast.message) {
                  const messageData = JSON.parse(selectedBroadcast.message);
                  if (messageData.template) {
                    return /* @__PURE__ */ jsx(
                      WhatsAppPreview,
                      {
                        template: messageData.template,
                        variant: "full",
                        showWhatsAppHeader: true
                      }
                    );
                  }
                }
                const templateData = getTemplateById(selectedBroadcast.templateId);
                if (templateData) {
                  const templateObject = JSON.parse(templateData.value);
                  return /* @__PURE__ */ jsx(
                    WhatsAppPreview,
                    {
                      template: templateObject.template,
                      variant: "full",
                      showWhatsAppHeader: true
                    }
                  );
                } else {
                  return /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: [
                    'Template preview not available for "',
                    selectedBroadcast.templateName,
                    '"'
                  ] });
                }
              } catch (error2) {
                console.error("Error parsing template data:", error2);
                return /* @__PURE__ */ jsxs(Text, { variant: "bodyMd", as: "p", tone: "subdued", children: [
                  'Unable to preview template "',
                  selectedBroadcast.templateName,
                  '"'
                ] });
              }
            })()
          ] })
        ] }) })
      }
    )
  ] });
}
const route34 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: BroadcastPage
}, Symbol.toStringTag, { value: "Module" }));
function TemplatesPage() {
  const navigate = useNavigate();
  const sleep = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
  const [selectedTemplate, setSelectedTemplate] = useState(null);
  const [selectedTemplateData, setSelectedTemplateData] = useState(null);
  const [loadingTemplateDetails, setLoadingTemplateDetails] = useState(false);
  const [templateDetailError, setTemplateDetailError] = useState(null);
  const [previewModalActive, setPreviewModalActive] = useState(false);
  const [templateSelectionModalActive, setTemplateSelectionModalActive] = useState(false);
  const [itemStrings, setItemStrings] = useState([
    "All",
    "Approved",
    "Rejected",
    "Pending",
    "Disabled",
    "Draft"
  ]);
  const [selected, setSelected] = useState(0);
  const [queryValue, setQueryValue] = useState("");
  const [sortSelected, setSortSelected] = useState(["name asc"]);
  const [statusFilter, setStatusFilter2] = useState([]);
  const [categoryFilter, setCategoryFilter] = useState("");
  const [qualityFilter, setQualityFilter] = useState([]);
  const [templates, setTemplates] = useState([]);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);
  const [apiPagination, setApiPagination] = useState(null);
  const { mode: mode2, setMode } = useSetIndexFiltersMode();
  const [currentPage, setCurrentPage] = useState(1);
  const itemsPerPage = 20;
  const fetchTemplatesData = useCallback(async (page = 1, status = "All") => {
    try {
      setLoading(true);
      setError(null);
      const result = await fetchApiTemplates({
        templateStatus: status,
        page,
        perPageData: itemsPerPage
      });
      setTemplates(result.templates);
      setApiPagination(result.pagination);
    } catch (err) {
      console.error("Error fetching templates:", err);
      setError(err.message);
      setTemplates([]);
      setApiPagination(null);
    } finally {
      setLoading(false);
    }
  }, [itemsPerPage]);
  useEffect(() => {
    const statusMap = {
      0: "All",
      1: "Approved",
      2: "Rejected",
      3: "Pending",
      4: "Disabled",
      5: "Draft"
    };
    const selectedStatus = statusMap[selected] || "All";
    fetchTemplatesData(1, selectedStatus);
    setCurrentPage(1);
  }, [selected, fetchTemplatesData]);
  const handleRefresh = useCallback(() => {
    const statusMap = {
      0: "All",
      1: "Approved",
      2: "Rejected",
      3: "Pending",
      4: "Disabled",
      5: "Draft"
    };
    const selectedStatus = statusMap[selected] || "All";
    fetchTemplatesData(currentPage, selectedStatus);
  }, [selected, currentPage, fetchTemplatesData]);
  const deleteView = (index2) => {
    const newItemStrings = [...itemStrings];
    newItemStrings.splice(index2, 1);
    setItemStrings(newItemStrings);
    setSelected(0);
  };
  const duplicateView = async (name) => {
    setItemStrings([...itemStrings, name]);
    setSelected(itemStrings.length);
    await sleep(1);
    return true;
  };
  const onCreateNewView = async (value) => {
    await sleep(500);
    setItemStrings([...itemStrings, value]);
    setSelected(itemStrings.length);
    return true;
  };
  const tabs = itemStrings.map((item, index2) => ({
    content: item,
    index: index2,
    onAction: () => {
    },
    id: `${item}-${index2}`,
    isLocked: index2 === 0,
    actions: index2 === 0 ? [] : [
      {
        type: "rename",
        onAction: () => {
        },
        onPrimaryAction: async (value) => {
          const newItemsStrings = tabs.map((item2, idx) => {
            if (idx === index2) {
              return value;
            }
            return item2.content;
          });
          await sleep(1);
          setItemStrings(newItemsStrings);
          return true;
        }
      },
      {
        type: "duplicate",
        onPrimaryAction: async (value) => {
          await sleep(1);
          duplicateView(value);
          return true;
        }
      },
      {
        type: "edit"
      },
      {
        type: "delete",
        onPrimaryAction: async () => {
          await sleep(1);
          deleteView(index2);
          return true;
        }
      }
    ]
  }));
  const filteredTemplates = useMemo(() => {
    let filtered = [...templates];
    if (queryValue) {
      filtered = searchTemplates(filtered, queryValue);
    }
    filtered = filtered.filter((template) => {
      const matchesStatus = statusFilter.length === 0 || statusFilter.includes(template.status.toLowerCase());
      const matchesCategory = categoryFilter === "" || template.category.toLowerCase().includes(categoryFilter.toLowerCase());
      const matchesQuality = qualityFilter.length === 0 || qualityFilter.includes(template.qualityRating.toLowerCase());
      return matchesStatus && matchesCategory && matchesQuality;
    });
    return filtered;
  }, [templates, queryValue, statusFilter, categoryFilter, qualityFilter]);
  const sortedTemplates = useMemo(() => {
    const sorted = [...filteredTemplates];
    const [sortKey, sortDirection] = sortSelected[0].split(" ");
    sorted.sort((a, b) => {
      let aValue, bValue;
      switch (sortKey) {
        case "label":
          aValue = a.label.toLowerCase();
          bValue = b.label.toLowerCase();
          break;
        case "status":
          aValue = a.status.toLowerCase();
          bValue = b.status.toLowerCase();
          break;
        case "category":
          aValue = a.category.toLowerCase();
          bValue = b.category.toLowerCase();
          break;
        case "quality":
          const qualityOrder = { "green": 3, "yellow": 2, "red": 1, "grey": 0 };
          aValue = qualityOrder[a.qualityRating.toLowerCase()] || 0;
          bValue = qualityOrder[b.qualityRating.toLowerCase()] || 0;
          break;
        case "language":
          aValue = a.language.toLowerCase();
          bValue = b.language.toLowerCase();
          break;
        case "updated":
          aValue = new Date(a.updatedOn);
          bValue = new Date(b.updatedOn);
          break;
        default:
          return 0;
      }
      if (aValue < bValue) return sortDirection === "asc" ? -1 : 1;
      if (aValue > bValue) return sortDirection === "asc" ? 1 : -1;
      return 0;
    });
    return sorted;
  }, [filteredTemplates, sortSelected]);
  const paginatedTemplates = sortedTemplates;
  const handlePreviousPage = useCallback(() => {
    if (apiPagination && apiPagination.hasPrevPage) {
      const newPage = Math.max(1, currentPage - 1);
      setCurrentPage(newPage);
      const statusMap = {
        0: "All",
        1: "Approved",
        2: "Rejected",
        3: "Pending",
        4: "Disabled",
        5: "Draft"
      };
      const selectedStatus = statusMap[selected] || "All";
      fetchTemplatesData(newPage, selectedStatus);
    }
  }, [apiPagination, currentPage, selected, fetchTemplatesData]);
  const handleNextPage = useCallback(() => {
    if (apiPagination && apiPagination.hasNextPage) {
      const newPage = currentPage + 1;
      setCurrentPage(newPage);
      const statusMap = {
        0: "All",
        1: "Approved",
        2: "Rejected",
        3: "Pending",
        4: "Disabled",
        5: "Draft"
      };
      const selectedStatus = statusMap[selected] || "All";
      fetchTemplatesData(newPage, selectedStatus);
    }
  }, [apiPagination, currentPage, selected, fetchTemplatesData]);
  const totalItems = (apiPagination == null ? void 0 : apiPagination.total) || 0;
  (apiPagination == null ? void 0 : apiPagination.lastPage) || 1;
  const startItem = (apiPagination == null ? void 0 : apiPagination.from) || 0;
  const endItem = (apiPagination == null ? void 0 : apiPagination.to) || 0;
  const hasNext = (apiPagination == null ? void 0 : apiPagination.hasNextPage) || false;
  const hasPrevious = (apiPagination == null ? void 0 : apiPagination.hasPrevPage) || false;
  const sortOptions = [
    { label: "Template Name", value: "name asc", directionLabel: "A-Z" },
    { label: "Template Name", value: "name desc", directionLabel: "Z-A" },
    { label: "Category", value: "category asc", directionLabel: "A-Z" },
    { label: "Category", value: "category desc", directionLabel: "Z-A" },
    { label: "Status", value: "status asc", directionLabel: "A-Z" },
    { label: "Status", value: "status desc", directionLabel: "Z-A" },
    { label: "Quality Rating", value: "quality asc", directionLabel: "Low to High" },
    { label: "Quality Rating", value: "quality desc", directionLabel: "High to Low" },
    { label: "Language", value: "language asc", directionLabel: "A-Z" },
    { label: "Language", value: "language desc", directionLabel: "Z-A" },
    { label: "Updated On", value: "updated asc", directionLabel: "Oldest First" },
    { label: "Updated On", value: "updated desc", directionLabel: "Newest First" }
  ];
  const fetchTemplateDetails = useCallback(async (templateName) => {
    try {
      setLoadingTemplateDetails(true);
      setTemplateDetailError(null);
      const templateData = await getSelectedTemplatebyName(templateName);
      setSelectedTemplateData(templateData);
      return templateData;
    } catch (error2) {
      console.error("Error fetching template details:", error2);
      setTemplateDetailError(error2.message || "Failed to fetch template details");
      return null;
    } finally {
      setLoadingTemplateDetails(false);
    }
  }, []);
  const handlePreviewClick = useCallback(async (template) => {
    setSelectedTemplate(template);
    setSelectedTemplateData(null);
    setPreviewModalActive(true);
    await fetchTemplateDetails(template.label);
  }, [fetchTemplateDetails]);
  const handleModalClose = useCallback(() => {
    setPreviewModalActive(false);
    setSelectedTemplate(null);
    setSelectedTemplateData(null);
    setTemplateDetailError(null);
  }, []);
  const handleTemplateSelectionModalClose = useCallback(() => {
    setTemplateSelectionModalActive(false);
  }, []);
  const handleTemplateSelectionModalOpen = useCallback(() => {
    setTemplateSelectionModalActive(true);
  }, []);
  const handleAbandonedCartTemplateSelect = useCallback(() => {
    setTemplateSelectionModalActive(false);
    navigate("/app/create-template/abandoned-cart");
  }, [navigate]);
  const handleOrderConfirmationTemplateSelect = useCallback(() => {
    setTemplateSelectionModalActive(false);
    navigate("/app/create-template/order-confirmation");
  }, [navigate]);
  const handleCustomTemplateSelect = useCallback(() => {
    setTemplateSelectionModalActive(false);
    navigate("/app/create-template/custom");
  }, [navigate]);
  const handleCarouselTemplateSelect = useCallback(() => {
    setTemplateSelectionModalActive(false);
    navigate("/app/create-template/carousel");
  }, [navigate]);
  const handleCatalogueTemplateSelect = useCallback(() => {
    setTemplateSelectionModalActive(false);
    navigate("/app/create-catalog-template");
  }, [navigate]);
  const handleFiltersQueryChange = useCallback((value) => {
    setQueryValue(value);
  }, []);
  const handleQueryValueRemove = useCallback(() => setQueryValue(""), []);
  const handleStatusChange = useCallback((value) => {
    setStatusFilter2(value);
  }, []);
  const handleCategoryChange = useCallback((value) => {
    setCategoryFilter(value);
  }, []);
  const handleQualityChange = useCallback((value) => {
    setQualityFilter(value);
  }, []);
  const handleStatusRemove = useCallback(() => setStatusFilter2([]), []);
  const handleCategoryRemove = useCallback(() => setCategoryFilter(""), []);
  const handleQualityRemove = useCallback(() => setQualityFilter([]), []);
  const handleFiltersClearAll = useCallback(() => {
    handleStatusRemove();
    handleCategoryRemove();
    handleQualityRemove();
    handleQueryValueRemove();
  }, [handleStatusRemove, handleCategoryRemove, handleQualityRemove, handleQueryValueRemove]);
  const onHandleCancel = () => {
  };
  const onHandleSave = async () => {
    await sleep(1);
    return true;
  };
  const primaryAction = selected === 0 ? {
    type: "save-as",
    onAction: onCreateNewView,
    disabled: false,
    loading: false
  } : {
    type: "save",
    onAction: onHandleSave,
    disabled: false,
    loading: false
  };
  const getStatusBadge = (status) => {
    var _a2;
    const statusConfig = {
      "Approved": { tone: "success" },
      "Pending": { tone: "warning" },
      "Rejected": { tone: "critical" },
      "Disabled": { tone: "critical" },
      "Draft": { tone: "subdued" }
    };
    return /* @__PURE__ */ jsx(Badge, { tone: ((_a2 = statusConfig[status]) == null ? void 0 : _a2.tone) || "info", children: status });
  };
  const getQualityRating = (rating) => {
    let dotColor, dotLabel;
    switch (rating.toLowerCase()) {
      case "green":
        dotColor = "var(--p-color-bg-fill-success)";
        dotLabel = "Green";
        break;
      case "yellow":
        dotColor = "var(--p-color-bg-fill-warning)";
        dotLabel = "Yellow";
        break;
      case "red":
        dotColor = "var(--p-color-bg-fill-critical)";
        dotLabel = "Red";
        break;
      case "grey":
        dotColor = "#9ca3af";
        dotLabel = "Grey";
        break;
      default:
        dotColor = "var(--p-color-bg-fill-subdued)";
        dotLabel = "Unknown";
    }
    return /* @__PURE__ */ jsxs(InlineStack, { gap: "200", align: "start", children: [
      /* @__PURE__ */ jsx(
        "div",
        {
          style: {
            width: "12px",
            height: "12px",
            borderRadius: "50%",
            backgroundColor: dotColor,
            marginTop: "2px"
          }
        }
      ),
      /* @__PURE__ */ jsx(Text, { as: "span", tone: "subdued", children: dotLabel })
    ] });
  };
  const filters = [
    {
      key: "status",
      label: "Template Status",
      filter: /* @__PURE__ */ jsx(
        ChoiceList,
        {
          title: "Template Status",
          titleHidden: true,
          choices: [
            { label: "Approved", value: "approved" },
            { label: "Rejected", value: "rejected" },
            { label: "Pending", value: "pending" },
            { label: "Disabled", value: "disabled" },
            { label: "Draft", value: "draft" }
          ],
          selected: statusFilter || [],
          onChange: handleStatusChange,
          allowMultiple: true
        }
      ),
      shortcut: true
    },
    {
      key: "category",
      label: "Category",
      filter: /* @__PURE__ */ jsx(
        TextField,
        {
          label: "Category",
          value: categoryFilter,
          onChange: handleCategoryChange,
          autoComplete: "off",
          labelHidden: true
        }
      ),
      shortcut: true
    },
    {
      key: "quality",
      label: "Quality Rating",
      filter: /* @__PURE__ */ jsx(
        ChoiceList,
        {
          title: "Quality Rating",
          titleHidden: true,
          choices: [
            { label: "Green", value: "green" },
            { label: "Yellow", value: "yellow" },
            { label: "Red", value: "red" },
            { label: "Grey", value: "grey" }
          ],
          selected: qualityFilter || [],
          onChange: handleQualityChange,
          allowMultiple: true
        }
      ),
      shortcut: true
    }
  ];
  const appliedFilters = [];
  if (statusFilter && !isEmpty(statusFilter)) {
    appliedFilters.push({
      key: "status",
      label: disambiguateLabel("status", statusFilter),
      onRemove: handleStatusRemove
    });
  }
  if (qualityFilter && !isEmpty(qualityFilter)) {
    appliedFilters.push({
      key: "quality",
      label: disambiguateLabel("quality", qualityFilter),
      onRemove: handleQualityRemove
    });
  }
  if (!isEmpty(categoryFilter)) {
    appliedFilters.push({
      key: "category",
      label: disambiguateLabel("category", categoryFilter),
      onRemove: handleCategoryRemove
    });
  }
  const resourceName = {
    singular: "template",
    plural: "templates"
  };
  const { selectedResources, allResourcesSelected, handleSelectionChange } = useIndexResourceState(paginatedTemplates);
  function disambiguateLabel(key, value) {
    switch (key) {
  